/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl.pool;

import com.yandex.ydb.core.utils.Async;
import com.yandex.ydb.table.impl.pool.FixedAsyncPool;
import com.yandex.ydb.table.impl.pool.PooledObjectHandler;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SettlersPool<T> {
    private static final Logger logger = Logger.getLogger(SettlersPool.class.getName());
    private final PooledObjectHandler<T> handler;
    private final FixedAsyncPool<T> mainPool;
    private final int maxKeepAliveCount;
    private final long keepAliveTimeMillis;
    private final ConcurrentLinkedDeque<PooledObject<T>> pool = new ConcurrentLinkedDeque();
    private final KeepAliveTask keepAliveTask = new KeepAliveTask();
    private final AtomicInteger size = new AtomicInteger(0);

    public SettlersPool(PooledObjectHandler<T> handler, FixedAsyncPool<T> mainPool, int maxKeepAliveCount, int keepAliveTimeMillis) {
        this.handler = handler;
        this.mainPool = mainPool;
        this.maxKeepAliveCount = maxKeepAliveCount;
        this.keepAliveTimeMillis = keepAliveTimeMillis;
        Async.runAfter((TimerTask)this.keepAliveTask, (long)keepAliveTimeMillis, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public boolean offerIfHaveSpace(T object) {
        int s = this.size.incrementAndGet();
        if (s > this.mainPool.getMaxSize()) {
            this.size.decrementAndGet();
            return false;
        }
        this.pool.offerLast(new PooledObject<T>(object));
        this.mainPool.fakeRelease();
        return true;
    }

    public void close() {
        this.keepAliveTask.stop();
        for (PooledObject<T> po : this.pool) {
            logger.log(Level.FINE, "Destroy {0} because pool closed", ((PooledObject)po).object);
            this.handler.destroy(((PooledObject)po).object).join();
        }
    }

    public int size() {
        return this.size.get();
    }

    private final class KeepAliveTask
    implements TimerTask {
        private volatile boolean stopped = false;

        private KeepAliveTask() {
        }

        void stop() {
            this.stopped = true;
        }

        public void run(Timeout timeout) {
            this.checkNextObject(SettlersPool.this.pool.iterator());
        }

        private void checkNextObject(Iterator<PooledObject<T>> it) {
            if (this.stopped) {
                return;
            }
            if (!it.hasNext()) {
                Async.runAfter((TimerTask)SettlersPool.this.keepAliveTask, (long)SettlersPool.this.keepAliveTimeMillis, (TimeUnit)TimeUnit.MILLISECONDS);
                return;
            }
            PooledObject po = it.next();
            if (po.incKeepAliveCount() > SettlersPool.this.maxKeepAliveCount) {
                try {
                    it.remove();
                    SettlersPool.this.size.decrementAndGet();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Destroy {0} because {1} keep alive iterations in settlers pool, max {2}", new Object[]{po.object, po.keepAliveCount, SettlersPool.this.maxKeepAliveCount});
                    }
                    SettlersPool.this.handler.destroy(po.object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.checkNextObject(it);
                return;
            }
            SettlersPool.this.handler.keepAlive(po.object).whenCompleteAsync((ready, throwable) -> {
                try {
                    if (throwable != null) {
                        logger.log(Level.WARNING, "Keep alive for " + po.object + " failed", (Throwable)throwable);
                    } else if (ready.booleanValue()) {
                        it.remove();
                        SettlersPool.this.size.decrementAndGet();
                        SettlersPool.this.mainPool.offerOrDestroy(po.object);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.checkNextObject(it);
            });
        }
    }

    private static final class PooledObject<U> {
        private static final AtomicIntegerFieldUpdater<PooledObject> keepAliveCountUpdater = AtomicIntegerFieldUpdater.newUpdater(PooledObject.class, "keepAliveCount");
        private final U object;
        private volatile int keepAliveCount = 0;

        PooledObject(U object) {
            this.object = object;
        }

        int incKeepAliveCount() {
            return keepAliveCountUpdater.incrementAndGet(this);
        }
    }
}

