/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.values;

import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.utils.Arrays2;
import com.yandex.ydb.table.values.StructType;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.Value;
import java.util.Arrays;
import java.util.Map;

public class StructValue
implements Value<StructType> {
    private final StructType type;
    private final Value[] members;

    StructValue(StructType type, Value ... members) {
        this.type = type;
        this.members = members;
    }

    public static StructValue of(String memberName, Value memberValue) {
        StructType type = StructType.of(memberName, memberValue.getType());
        return new StructValue(type, memberValue);
    }

    public static StructValue of(String member1Name, Value member1Value, String member2Name, Value member2Value) {
        String[] names = new String[]{member1Name, member2Name};
        Value[] values = new Value[]{member1Value, member2Value};
        return StructValue.newStruct(names, values);
    }

    public static StructValue of(String member1Name, Value member1Value, String member2Name, Value member2Value, String member3Name, Value member3Value) {
        String[] names = new String[]{member1Name, member2Name, member3Name};
        Value[] values = new Value[]{member1Value, member2Value, member3Value};
        return StructValue.newStruct(names, values);
    }

    public static StructValue of(String member1Name, Value member1Value, String member2Name, Value member2Value, String member3Name, Value member3Value, String member4Name, Value member4Value) {
        String[] names = new String[]{member1Name, member2Name, member3Name, member4Name};
        Value[] values = new Value[]{member1Value, member2Value, member3Value, member4Value};
        return StructValue.newStruct(names, values);
    }

    public static StructValue of(String member1Name, Value member1Value, String member2Name, Value member2Value, String member3Name, Value member3Value, String member4Name, Value member4Value, String member5Name, Value member5Value) {
        String[] names = new String[]{member1Name, member2Name, member3Name, member4Name, member5Name};
        Value[] values = new Value[]{member1Value, member2Value, member3Value, member4Value, member5Value};
        return StructValue.newStruct(names, values);
    }

    public static StructValue of(Map<String, Value> members) {
        int size = members.size();
        String[] names = new String[size];
        Value[] values = new Value[size];
        int i = 0;
        for (Map.Entry<String, Value> e : members.entrySet()) {
            names[i] = e.getKey();
            values[i] = e.getValue();
            ++i;
        }
        return StructValue.newStruct(names, values);
    }

    public int getMembersCount() {
        return this.members.length;
    }

    public Value getMemberValue(int index) {
        return this.members[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructValue that = (StructValue)o;
        return Arrays.equals(this.members, that.members);
    }

    public int hashCode() {
        return 31 * Type.Kind.STRUCT.hashCode() + Arrays.hashCode(this.members);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Struct[");
        for (Value member : this.members) {
            sb.append(member).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public StructType getType() {
        return this.type;
    }

    @Override
    public ValueProtos.Value toPb() {
        ValueProtos.Value.Builder builder = ValueProtos.Value.newBuilder();
        for (Value member : this.members) {
            builder.addItems(member.toPb());
        }
        return builder.build();
    }

    private static StructValue newStruct(String[] names, Value[] values) {
        Arrays2.sortBothByFirst((Comparable[])names, (Object[])values);
        Type[] types = new Type[values.length];
        for (int i = 0; i < values.length; ++i) {
            types[i] = values[i].getType();
        }
        return new StructValue(new StructType(names, types), values);
    }
}

