/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.yandex.ydb.table.impl.DataQueryImpl;
import javax.annotation.Nullable;

final class QueryCache {
    private final Cache<String, DataQueryImpl> cache;

    QueryCache(int maxSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).build();
    }

    @Nullable
    DataQueryImpl find(String text) {
        String key = DataQueryImpl.makeHash(text);
        return (DataQueryImpl)this.cache.getIfPresent((Object)key);
    }

    void put(DataQueryImpl query) {
        this.cache.put((Object)query.getTextHash(), (Object)query);
    }

    void remove(DataQueryImpl query) {
        this.cache.invalidate((Object)query.getTextHash());
    }

    void clear() {
        this.cache.asMap().clear();
    }
}

