/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import com.yandex.ydb.StatusCodesProtos;
import com.yandex.ydb.common.CommonProtos;
import com.yandex.ydb.core.Issue;
import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.Status;
import com.yandex.ydb.core.StatusCode;
import com.yandex.ydb.core.rpc.OperationTray;
import com.yandex.ydb.core.rpc.StreamObserver;
import com.yandex.ydb.table.Session;
import com.yandex.ydb.table.SessionStatus;
import com.yandex.ydb.table.YdbTable;
import com.yandex.ydb.table.description.TableColumn;
import com.yandex.ydb.table.description.TableDescription;
import com.yandex.ydb.table.description.TableIndex;
import com.yandex.ydb.table.impl.DataQueryImpl;
import com.yandex.ydb.table.impl.QueryCache;
import com.yandex.ydb.table.impl.SessionPool;
import com.yandex.ydb.table.impl.TransactionImpl;
import com.yandex.ydb.table.query.DataQuery;
import com.yandex.ydb.table.query.DataQueryResult;
import com.yandex.ydb.table.query.ExplainDataQueryResult;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.result.ResultSetReader;
import com.yandex.ydb.table.result.impl.ProtoValueReaders;
import com.yandex.ydb.table.rpc.TableRpc;
import com.yandex.ydb.table.settings.AlterTableSettings;
import com.yandex.ydb.table.settings.AutoPartitioningPolicy;
import com.yandex.ydb.table.settings.BeginTxSettings;
import com.yandex.ydb.table.settings.CloseSessionSettings;
import com.yandex.ydb.table.settings.CommitTxSettings;
import com.yandex.ydb.table.settings.CopyTableSettings;
import com.yandex.ydb.table.settings.CreateTableSettings;
import com.yandex.ydb.table.settings.DescribeTableSettings;
import com.yandex.ydb.table.settings.DropTableSettings;
import com.yandex.ydb.table.settings.ExecuteDataQuerySettings;
import com.yandex.ydb.table.settings.ExecuteSchemeQuerySettings;
import com.yandex.ydb.table.settings.ExplainDataQuerySettings;
import com.yandex.ydb.table.settings.KeepAliveSessionSettings;
import com.yandex.ydb.table.settings.PartitioningPolicy;
import com.yandex.ydb.table.settings.PrepareDataQuerySettings;
import com.yandex.ydb.table.settings.ReadTableSettings;
import com.yandex.ydb.table.settings.ReplicationPolicy;
import com.yandex.ydb.table.settings.RollbackTxSettings;
import com.yandex.ydb.table.settings.StoragePolicy;
import com.yandex.ydb.table.transaction.Transaction;
import com.yandex.ydb.table.transaction.TransactionMode;
import com.yandex.ydb.table.transaction.TxControl;
import com.yandex.ydb.table.values.TupleValue;
import com.yandex.ydb.table.values.Value;
import com.yandex.ydb.table.values.proto.ProtoType;
import com.yandex.ydb.table.values.proto.ProtoValue;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import javax.annotation.Nullable;

class SessionImpl
implements Session {
    private static final AtomicReferenceFieldUpdater<SessionImpl, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(SessionImpl.class, State.class, "state");
    private final String id;
    private final TableRpc tableRpc;
    private final OperationTray operationTray;
    @Nullable
    private final SessionPool sessionPool;
    @Nullable
    private final QueryCache queryCache;
    private final boolean keepQueryText;
    private volatile State state = State.ACTIVE;

    SessionImpl(String id, TableRpc tableRpc, SessionPool sessionPool, int queryCacheSize, boolean keepQueryText) {
        this.id = id;
        this.tableRpc = tableRpc;
        this.operationTray = tableRpc.getOperationTray();
        this.sessionPool = sessionPool;
        this.queryCache = queryCacheSize > 0 ? new QueryCache(queryCacheSize) : null;
        this.keepQueryText = keepQueryText;
    }

    @Override
    public String getId() {
        return this.id;
    }

    State getState() {
        return stateUpdater.get(this);
    }

    void setState(State state) {
        stateUpdater.set(this, state);
    }

    boolean switchState(State from, State to) {
        return stateUpdater.compareAndSet(this, from, to);
    }

    @Override
    public CompletableFuture<Status> createTable(String path, TableDescription tableDescriptions, CreateTableSettings settings) {
        YdbTable.PartitioningPolicy.Builder policyProto;
        Object policy;
        YdbTable.TableIndex.Builder b;
        YdbTable.CreateTableRequest.Builder request = YdbTable.CreateTableRequest.newBuilder().setSessionId(this.id).setPath(path).addAllPrimaryKey(tableDescriptions.getPrimaryKeys());
        for (TableColumn column : tableDescriptions.getColumns()) {
            request.addColumns(YdbTable.ColumnMeta.newBuilder().setName(column.getName()).setType(column.getType().toPb()).build());
        }
        for (TableIndex index : tableDescriptions.getIndexes()) {
            b = request.addIndexesBuilder();
            b.setName(index.getName());
            b.addAllIndexColumns(index.getColumns());
            if (index.getType() != TableIndex.Type.GLOBAL) continue;
            b.setGlobalIndex(YdbTable.GlobalIndex.getDefaultInstance());
        }
        if (settings.getPresetName() != null) {
            request.getProfileBuilder().setPresetName(settings.getPresetName());
        }
        if (settings.getExecutionPolicy() != null) {
            request.getProfileBuilder().getExecutionPolicyBuilder().setPresetName(settings.getExecutionPolicy());
        }
        if (settings.getCompactionPolicy() != null) {
            request.getProfileBuilder().getCompactionPolicyBuilder().setPresetName(settings.getExecutionPolicy());
        }
        if ((policy = settings.getPartitioningPolicy()) != null) {
            policyProto = request.getProfileBuilder().getPartitioningPolicyBuilder();
            if (((PartitioningPolicy)policy).getPresetName() != null) {
                policyProto.setPresetName(((PartitioningPolicy)policy).getPresetName());
            }
            if (((PartitioningPolicy)policy).getAutoPartitioning() != null) {
                policyProto.setAutoPartitioning(SessionImpl.toPb(((PartitioningPolicy)policy).getAutoPartitioning()));
            }
            if (((PartitioningPolicy)policy).getUniformPartitions() > 0L) {
                policyProto.setUniformPartitions(((PartitioningPolicy)policy).getUniformPartitions());
            } else if (((PartitioningPolicy)policy).getExplicitPartitioningPoints() != null) {
                b = policyProto.getExplicitPartitionsBuilder();
                for (Value value : ((PartitioningPolicy)policy).getExplicitPartitioningPoints()) {
                    b.addSplitPoints(ProtoValue.toTypedValue(value));
                }
            }
        }
        if ((policy = settings.getStoragePolicy()) != null) {
            policyProto = request.getProfileBuilder().getStoragePolicyBuilder();
            if (((StoragePolicy)policy).getPresetName() != null) {
                policyProto.setPresetName(((StoragePolicy)policy).getPresetName());
            }
            if (((StoragePolicy)policy).getSysLog() != null) {
                policyProto.getSyslogBuilder().setMedia(((StoragePolicy)policy).getSysLog());
            }
            if (((StoragePolicy)policy).getLog() != null) {
                policyProto.getLogBuilder().setMedia(((StoragePolicy)policy).getLog());
            }
            if (((StoragePolicy)policy).getData() != null) {
                policyProto.getDataBuilder().setMedia(((StoragePolicy)policy).getData());
            }
            if (((StoragePolicy)policy).getExternal() != null) {
                policyProto.getExternalBuilder().setMedia(((StoragePolicy)policy).getExternal());
            }
        }
        if ((policy = settings.getReplicationPolicy()) != null) {
            YdbTable.ReplicationPolicy.Builder replicationPolicyProto = request.getProfileBuilder().getReplicationPolicyBuilder();
            if (((ReplicationPolicy)policy).getPresetName() != null) {
                replicationPolicyProto.setPresetName(((ReplicationPolicy)policy).getPresetName());
            }
            replicationPolicyProto.setReplicasCount(((ReplicationPolicy)policy).getReplicasCount());
            replicationPolicyProto.setCreatePerAvailabilityZone(((ReplicationPolicy)policy).isCreatePerAvailabilityZone() ? CommonProtos.FeatureFlag.Status.ENABLED : CommonProtos.FeatureFlag.Status.DISABLED);
            replicationPolicyProto.setAllowPromotion(((ReplicationPolicy)policy).isAllowPromotion() ? CommonProtos.FeatureFlag.Status.ENABLED : CommonProtos.FeatureFlag.Status.DISABLED);
        }
        long deadlineAfter = settings.getDeadlineAfter();
        return this.tableRpc.createTable(request.build(), deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.CreateTableResponse)response.expect("createTable()")).getOperation(), deadlineAfter);
        });
    }

    private static YdbTable.PartitioningPolicy.AutoPartitioningPolicy toPb(AutoPartitioningPolicy policy) {
        switch (policy) {
            case AUTO_SPLIT: {
                return YdbTable.PartitioningPolicy.AutoPartitioningPolicy.AUTO_SPLIT;
            }
            case AUTO_SPLIT_MERGE: {
                return YdbTable.PartitioningPolicy.AutoPartitioningPolicy.AUTO_SPLIT_MERGE;
            }
            case DISABLED: {
                return YdbTable.PartitioningPolicy.AutoPartitioningPolicy.DISABLED;
            }
        }
        throw new IllegalArgumentException("unknown AutoPartitioningPolicy: " + (Object)((Object)policy));
    }

    @Override
    public CompletableFuture<Status> dropTable(String path, DropTableSettings settings) {
        YdbTable.DropTableRequest request = YdbTable.DropTableRequest.newBuilder().setSessionId(this.id).setPath(path).build();
        long deadlineAfter = settings.getDeadlineAfter();
        return this.tableRpc.dropTable(request, deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.DropTableResponse)response.expect("dropTable()")).getOperation(), deadlineAfter);
        });
    }

    @Override
    public CompletableFuture<Status> alterTable(String path, AlterTableSettings settings) {
        YdbTable.AlterTableRequest.Builder builder = YdbTable.AlterTableRequest.newBuilder().setSessionId(this.id).setPath(path);
        settings.forEachAddColumn((name, type) -> builder.addAddColumns(YdbTable.ColumnMeta.newBuilder().setName(name).setType(type.toPb()).build()));
        settings.forEachDropColumn(arg_0 -> ((YdbTable.AlterTableRequest.Builder)builder).addDropColumns(arg_0));
        long deadlineAfter = settings.getDeadlineAfter();
        return this.tableRpc.alterTable(builder.build(), deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.AlterTableResponse)response.expect("alterTable()")).getOperation(), deadlineAfter);
        });
    }

    @Override
    public CompletableFuture<Status> copyTable(String src, String dst, CopyTableSettings settings) {
        YdbTable.CopyTableRequest request = YdbTable.CopyTableRequest.newBuilder().setSessionId(this.id).setSourcePath(src).setDestinationPath(dst).build();
        long deadlineAfter = settings.getDeadlineAfter();
        return this.tableRpc.copyTable(request, deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.CopyTableResponse)response.expect("copyTable()")).getOperation(), deadlineAfter);
        });
    }

    @Override
    public CompletableFuture<Result<TableDescription>> describeTable(String path, DescribeTableSettings settings) {
        YdbTable.DescribeTableRequest request = YdbTable.DescribeTableRequest.newBuilder().setSessionId(this.id).setPath(path).build();
        long deadlineAfter = settings.getDeadlineAfter();
        return this.tableRpc.describeTable(request, deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.DescribeTableResponse)response.expect("describeTable()")).getOperation(), YdbTable.DescribeTableResult.class, SessionImpl::mapDescribeTable, deadlineAfter);
        });
    }

    private static TableDescription mapDescribeTable(YdbTable.DescribeTableResult result) {
        int i;
        TableDescription.Builder description = TableDescription.newBuilder();
        for (i = 0; i < result.getColumnsCount(); ++i) {
            YdbTable.ColumnMeta column = result.getColumns(i);
            description.addNonnullColumn(column.getName(), ProtoType.fromPb(column.getType()));
        }
        description.setPrimaryKeys((List<String>)result.getPrimaryKeyList());
        for (i = 0; i < result.getIndexesCount(); ++i) {
            YdbTable.TableIndexDescription index = result.getIndexes(i);
            description.addGlobalIndex(index.getName(), (List<String>)index.getIndexColumnsList());
        }
        return description.build();
    }

    private static YdbTable.TransactionSettings txSettings(TransactionMode transactionMode) {
        YdbTable.TransactionSettings.Builder settings = YdbTable.TransactionSettings.newBuilder();
        if (transactionMode == TransactionMode.SERIALIZABLE_READ_WRITE) {
            settings.setSerializableReadWrite(YdbTable.SerializableModeSettings.getDefaultInstance());
        } else if (transactionMode == TransactionMode.ONLINE_READ_ONLY) {
            settings.setOnlineReadOnly(YdbTable.OnlineModeSettings.getDefaultInstance());
        } else if (transactionMode == TransactionMode.STALE_READ_ONLY) {
            settings.setStaleReadOnly(YdbTable.StaleModeSettings.getDefaultInstance());
        }
        return settings.build();
    }

    @Override
    public CompletableFuture<Result<DataQueryResult>> executeDataQuery(String query, TxControl txControl, Params params, ExecuteDataQuerySettings settings) {
        DataQueryImpl dataQuery;
        if (this.queryCache != null && (dataQuery = this.queryCache.find(query)) != null) {
            return dataQuery.execute(txControl, params, settings).whenComplete((r, t) -> {
                if (r.getCode() == StatusCode.NOT_FOUND) {
                    this.queryCache.remove(dataQuery);
                }
            });
        }
        YdbTable.ExecuteDataQueryRequest.Builder request = YdbTable.ExecuteDataQueryRequest.newBuilder().setSessionId(this.id).setTxControl(txControl.toPb()).setQuery(YdbTable.Query.newBuilder().setYqlText(query)).putAllParameters(params.toPb());
        boolean keepInQueryCache = settings.isKeepInQueryCache();
        if (this.queryCache != null && keepInQueryCache) {
            request.getQueryCachePolicyBuilder().setKeepInCache(true);
        }
        long deadlineAfter = settings.getDeadlineAfter();
        return this.interceptResult((CompletableFuture)this.tableRpc.executeDataQuery(request.build(), deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.ExecuteDataQueryResponse)response.expect("executeDataQuery()")).getOperation(), YdbTable.ExecuteQueryResult.class, result -> this.mapExecuteDataQuery((YdbTable.ExecuteQueryResult)result, query, keepInQueryCache), deadlineAfter);
        }));
    }

    private DataQueryResult mapExecuteDataQuery(YdbTable.ExecuteQueryResult result, @Nullable String queryText, boolean keepInQueryCache) {
        if (keepInQueryCache && result.hasQueryMeta() && queryText != null) {
            assert (this.queryCache != null);
            String queryId = result.getQueryMeta().getId();
            Map types = result.getQueryMeta().getParametersTypesMap();
            this.queryCache.put(new DataQueryImpl(this, queryId, queryText, this.keepQueryText, types));
        }
        YdbTable.TransactionMeta txMeta = result.getTxMeta();
        return new DataQueryResult(txMeta.getId(), result.getResultSetsList());
    }

    CompletableFuture<Result<DataQueryResult>> executePreparedDataQuery(String queryId, @Nullable String queryText, TxControl txControl, Params params, ExecuteDataQuerySettings settings) {
        boolean keepInQueryCache;
        YdbTable.ExecuteDataQueryRequest.Builder request = YdbTable.ExecuteDataQueryRequest.newBuilder().setSessionId(this.id).setTxControl(txControl.toPb());
        request.getQueryBuilder().setId(queryId);
        request.putAllParameters(params.toPb());
        boolean bl = keepInQueryCache = this.queryCache != null && settings.isKeepInQueryCache();
        if (keepInQueryCache) {
            request.getQueryCachePolicyBuilder().setKeepInCache(true);
        }
        long deadlineAfter = settings.getDeadlineAfter();
        return this.interceptResult((CompletableFuture)this.tableRpc.executeDataQuery(request.build(), deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.tableRpc.getOperationTray().waitResult(((YdbTable.ExecuteDataQueryResponse)response.expect("executeDataQuery()")).getOperation(), YdbTable.ExecuteQueryResult.class, result -> this.mapExecuteDataQuery((YdbTable.ExecuteQueryResult)result, queryText, keepInQueryCache), deadlineAfter);
        }));
    }

    @Override
    public CompletableFuture<Result<DataQuery>> prepareDataQuery(String query, PrepareDataQuerySettings settings) {
        YdbTable.PrepareDataQueryRequest.Builder request = YdbTable.PrepareDataQueryRequest.newBuilder().setSessionId(this.id).setYqlText(query);
        boolean keepInQueryCache = this.queryCache != null && settings.isKeepInQueryCache();
        long deadlineAfter = settings.getDeadlineAfter();
        return this.interceptResult((CompletableFuture)this.tableRpc.prepareDataQuery(request.build(), deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.PrepareDataQueryResponse)response.expect("prepareDataQuery()")).getOperation(), YdbTable.PrepareQueryResult.class, result -> {
                String queryId = result.getQueryId();
                Map types = result.getParametersTypesMap();
                DataQueryImpl dataQuery = new DataQueryImpl(this, queryId, query, this.keepQueryText, types);
                if (keepInQueryCache) {
                    this.queryCache.put(dataQuery);
                }
                return dataQuery;
            }, deadlineAfter);
        }));
    }

    @Override
    public CompletableFuture<Status> executeSchemeQuery(String query, ExecuteSchemeQuerySettings settings) {
        YdbTable.ExecuteSchemeQueryRequest request = YdbTable.ExecuteSchemeQueryRequest.newBuilder().setSessionId(this.id).setYqlText(query).build();
        long deadlineAfter = settings.getDeadlineAfter();
        return this.interceptStatus((CompletableFuture<Status>)this.tableRpc.executeSchemeQuery(request, deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.ExecuteSchemeQueryResponse)response.expect("executeSchemaQuery()")).getOperation(), deadlineAfter);
        }));
    }

    @Override
    public CompletableFuture<Result<ExplainDataQueryResult>> explainDataQuery(String query, ExplainDataQuerySettings settings) {
        YdbTable.ExplainDataQueryRequest request = YdbTable.ExplainDataQueryRequest.newBuilder().setSessionId(this.id).setYqlText(query).build();
        long deadlineAfter = settings.getDeadlineAfter();
        return this.interceptResult((CompletableFuture)this.tableRpc.explainDataQuery(request, deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.ExplainDataQueryResponse)response.expect("explainDataQuery()")).getOperation(), YdbTable.ExplainQueryResult.class, result -> new ExplainDataQueryResult(result.getQueryAst(), result.getQueryPlan()), deadlineAfter);
        }));
    }

    @Override
    public CompletableFuture<Result<Transaction>> beginTransaction(TransactionMode transactionMode, BeginTxSettings settings) {
        YdbTable.BeginTransactionRequest request = YdbTable.BeginTransactionRequest.newBuilder().setSessionId(this.id).setTxSettings(SessionImpl.txSettings(transactionMode)).build();
        long deadlineAfter = settings.getDeadlineAfter();
        return this.interceptResult((CompletableFuture)this.tableRpc.beginTransaction(request, deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.BeginTransactionResponse)response.expect("beginTransaction()")).getOperation(), YdbTable.BeginTransactionResult.class, result -> new TransactionImpl(this, result.getTxMeta().getId()), deadlineAfter);
        }));
    }

    @Override
    public CompletableFuture<Status> readTable(String tablePath, ReadTableSettings settings, final Consumer<ResultSetReader> fn) {
        TupleValue toKey;
        YdbTable.ReadTableRequest.Builder request = YdbTable.ReadTableRequest.newBuilder().setSessionId(this.id).setPath(tablePath).setOrdered(settings.isOrdered()).setRowLimit((long)settings.getRowLimit());
        TupleValue fromKey = settings.getFromKey();
        if (fromKey != null) {
            YdbTable.KeyRange.Builder range = request.getKeyRangeBuilder();
            if (settings.isFromInclusive()) {
                range.setGreaterOrEqual(ProtoValue.toTypedValue(fromKey));
            } else {
                range.setGreater(ProtoValue.toTypedValue(fromKey));
            }
        }
        if ((toKey = settings.getToKey()) != null) {
            YdbTable.KeyRange.Builder range = request.getKeyRangeBuilder();
            if (settings.isToInclusive()) {
                range.setLessOrEqual(ProtoValue.toTypedValue(toKey));
            } else {
                range.setLess(ProtoValue.toTypedValue(toKey));
            }
        }
        if (!settings.getColumns().isEmpty()) {
            request.addAllColumns(settings.getColumns());
        }
        long deadlineAfter = settings.getDeadlineAfter();
        final CompletableFuture<Status> promise = new CompletableFuture<Status>();
        this.tableRpc.streamReadTable(request.build(), new StreamObserver<YdbTable.ReadTableResponse>(){

            public void onNext(YdbTable.ReadTableResponse response) {
                StatusCodesProtos.StatusIds.StatusCode statusCode = response.getStatus();
                if (statusCode == StatusCodesProtos.StatusIds.StatusCode.SUCCESS) {
                    try {
                        fn.accept(ProtoValueReaders.forResultSet(response.getResult().getResultSet()));
                    }
                    catch (Throwable t) {
                        promise.completeExceptionally(t);
                    }
                } else {
                    Issue[] issues = Issue.fromPb((List)response.getIssuesList());
                    StatusCode code = StatusCode.fromProto((StatusCodesProtos.StatusIds.StatusCode)statusCode);
                    promise.complete(Status.of((StatusCode)code, (Issue[])issues));
                }
            }

            public void onError(Status status) {
                assert (!status.isSuccess());
                promise.complete(status);
            }

            public void onCompleted() {
                promise.complete(Status.SUCCESS);
            }
        }, deadlineAfter);
        return promise;
    }

    @Override
    public CompletableFuture<Status> commitTransaction(String txId, CommitTxSettings settings) {
        YdbTable.CommitTransactionRequest request = YdbTable.CommitTransactionRequest.newBuilder().setSessionId(this.id).setTxId(txId).build();
        long deadlineAfter = settings.getDeadlineAfter();
        return this.interceptStatus((CompletableFuture<Status>)this.tableRpc.commitTransaction(request, deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.tableRpc.getOperationTray().waitStatus(((YdbTable.CommitTransactionResponse)response.expect("commitTransaction()")).getOperation(), deadlineAfter);
        }));
    }

    @Override
    public CompletableFuture<Status> rollbackTransaction(String txId, RollbackTxSettings settings) {
        YdbTable.RollbackTransactionRequest request = YdbTable.RollbackTransactionRequest.newBuilder().setSessionId(this.id).setTxId(txId).build();
        long deadlineAfter = settings.getDeadlineAfter();
        return this.interceptStatus((CompletableFuture<Status>)this.tableRpc.rollbackTransaction(request, deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.tableRpc.getOperationTray().waitStatus(((YdbTable.RollbackTransactionResponse)response.expect("rollbackTransaction()")).getOperation(), deadlineAfter);
        }));
    }

    @Override
    public CompletableFuture<Result<SessionStatus>> keepAlive(KeepAliveSessionSettings settings) {
        YdbTable.KeepAliveRequest request = YdbTable.KeepAliveRequest.newBuilder().setSessionId(this.id).build();
        long deadlineAfter = settings.getDeadlineAfter();
        return this.interceptResult((CompletableFuture)this.tableRpc.keepAlive(request, deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.KeepAliveResponse)response.expect("keepAlive()")).getOperation(), YdbTable.KeepAliveResult.class, SessionImpl::mapSessionStatus, deadlineAfter);
        }));
    }

    private static SessionStatus mapSessionStatus(YdbTable.KeepAliveResult result) {
        switch (result.getSessionStatus()) {
            case UNRECOGNIZED: 
            case SESSION_STATUS_UNSPECIFIED: {
                return SessionStatus.UNSPECIFIED;
            }
            case SESSION_STATUS_BUSY: {
                return SessionStatus.BUSY;
            }
            case SESSION_STATUS_READY: {
                return SessionStatus.READY;
            }
        }
        throw new IllegalStateException("unknown session status: " + result.getSessionStatus());
    }

    @Override
    public void invalidateQueryCache() {
        if (this.queryCache != null) {
            this.queryCache.clear();
        }
    }

    @Override
    public boolean release() {
        if (this.sessionPool != null) {
            this.sessionPool.release(this);
            return true;
        }
        return false;
    }

    @Override
    public CompletableFuture<Status> close(CloseSessionSettings settings) {
        YdbTable.DeleteSessionRequest request = YdbTable.DeleteSessionRequest.newBuilder().setSessionId(this.id).build();
        long deadlineAfter = settings.getDeadlineAfter();
        return this.interceptStatus((CompletableFuture<Status>)this.tableRpc.deleteSession(request, deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.DeleteSessionResponse)response.expect("deleteSession()")).getOperation(), deadlineAfter);
        }));
    }

    private <T> CompletableFuture<Result<T>> interceptResult(CompletableFuture<Result<T>> future) {
        return future.whenComplete((r, t) -> this.changeSessionState((Throwable)t, r.getCode()));
    }

    private CompletableFuture<Status> interceptStatus(CompletableFuture<Status> future) {
        return future.whenComplete((r, t) -> this.changeSessionState((Throwable)t, r.getCode()));
    }

    private void changeSessionState(Throwable t, StatusCode code) {
        State oldState = this.getState();
        if (t != null) {
            this.switchState(oldState, State.BROKEN);
            return;
        }
        if (code.isTransportError() && code != StatusCode.CLIENT_RESOURCE_EXHAUSTED) {
            this.switchState(oldState, State.DISCONNECTED);
        } else if (code == StatusCode.BAD_SESSION) {
            this.switchState(oldState, State.BROKEN);
        } else if (code == StatusCode.SESSION_BUSY) {
            this.switchState(oldState, State.BROKEN);
        } else if (code == StatusCode.INTERNAL_ERROR) {
            this.switchState(oldState, State.BROKEN);
        }
    }

    public String toString() {
        return "Session{id='" + this.id + '\'' + ", state=" + (Object)((Object)this.state) + '}';
    }

    static enum State {
        IDLE,
        BROKEN,
        ACTIVE,
        DISCONNECTED;

    }
}

