/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.core.Result;
import com.yandex.ydb.table.impl.SessionImpl;
import com.yandex.ydb.table.query.DataQuery;
import com.yandex.ydb.table.query.DataQueryResult;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.settings.ExecuteDataQuerySettings;
import com.yandex.ydb.table.transaction.TxControl;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.Value;
import com.yandex.ydb.table.values.proto.ProtoType;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

final class DataQueryImpl
implements DataQuery {
    private final SessionImpl session;
    private final String queryId;
    private final ImmutableMap<String, Type> types;
    private final ImmutableMap<String, ValueProtos.Type> typesPb;
    @Nullable
    private final String text;
    private final String textHash;

    DataQueryImpl(SessionImpl session, String queryId, String text, boolean keepText, Map<String, ValueProtos.Type> parametersTypes) {
        this.session = session;
        this.queryId = queryId;
        this.types = DataQueryImpl.buildTypes(parametersTypes);
        this.typesPb = ImmutableMap.copyOf(parametersTypes);
        this.text = keepText ? text : null;
        this.textHash = DataQueryImpl.makeHash(text);
    }

    static String makeHash(String text) {
        return Hashing.sha256().hashString((CharSequence)text, StandardCharsets.UTF_8).toString();
    }

    private static ImmutableMap<String, Type> buildTypes(Map<String, ValueProtos.Type> parametersTypes) {
        ImmutableMap.Builder types = new ImmutableMap.Builder();
        for (Map.Entry<String, ValueProtos.Type> e : parametersTypes.entrySet()) {
            types.put((Object)e.getKey(), (Object)ProtoType.fromPb(e.getValue()));
        }
        return types.build();
    }

    @Override
    public String getId() {
        return this.queryId;
    }

    @Override
    public Params newParams() {
        return new DataQueryParams(this.types, this.typesPb);
    }

    @Override
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    String getTextHash() {
        return this.textHash;
    }

    @Override
    public CompletableFuture<Result<DataQueryResult>> execute(TxControl txControl, Params params, ExecuteDataQuerySettings settings) {
        return this.session.executePreparedDataQuery(this.queryId, this.text, txControl, params, settings);
    }

    @ParametersAreNonnullByDefault
    static final class DataQueryParams
    implements Params {
        private final ImmutableMap<String, Type> types;
        private final ImmutableMap<String, ValueProtos.Type> typesPb;
        private final HashMap<String, Value<?>> params;

        DataQueryParams(ImmutableMap<String, Type> types, ImmutableMap<String, ValueProtos.Type> typesPb) {
            this.types = types;
            this.typesPb = typesPb;
            this.params = new HashMap(types.size());
        }

        @Override
        public boolean isEmpty() {
            return this.params.isEmpty();
        }

        @Override
        public <T extends Type> Params put(String name, Value<T> value) {
            Type type = (Type)this.types.get((Object)name);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"unknown parameter: %s", (Object)name);
            Preconditions.checkArgument((boolean)type.equals(value.getType()), (String)"types mismatch: expected %s, got %s", (Object)type, value.getType());
            Value<T> prev = this.params.putIfAbsent(name, value);
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"duplicate parameter: %s", (Object)name);
            return this;
        }

        @Override
        public Map<String, ValueProtos.TypedValue> toPb() {
            HashMap<String, ValueProtos.TypedValue> result = new HashMap<String, ValueProtos.TypedValue>(this.params.size());
            for (Map.Entry<String, Value<?>> entry : this.params.entrySet()) {
                Value<?> value = entry.getValue();
                String name = entry.getKey();
                ValueProtos.Type typePb = (ValueProtos.Type)Objects.requireNonNull(this.typesPb.get((Object)name));
                ValueProtos.TypedValue valuePb = ValueProtos.TypedValue.newBuilder().setType(typePb).setValue(value.toPb()).build();
                result.put(name, valuePb);
            }
            return Collections.unmodifiableMap(result);
        }

        @Override
        public Map<String, Value<?>> values() {
            return Collections.unmodifiableMap(this.params);
        }
    }
}

