/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.values;

import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.proto.ProtoType;

public final class PrimitiveType
implements Type {
    private static final PrimitiveType BOOL = new PrimitiveType(Id.Bool, ProtoType.bool());
    private static final PrimitiveType INT_8 = new PrimitiveType(Id.Int8, ProtoType.int8());
    private static final PrimitiveType UINT_8 = new PrimitiveType(Id.Uint8, ProtoType.uint8());
    private static final PrimitiveType INT_16 = new PrimitiveType(Id.Int16, ProtoType.int16());
    private static final PrimitiveType UINT_16 = new PrimitiveType(Id.Uint16, ProtoType.uint16());
    private static final PrimitiveType INT_32 = new PrimitiveType(Id.Int32, ProtoType.int32());
    private static final PrimitiveType UINT_32 = new PrimitiveType(Id.Uint32, ProtoType.uint32());
    private static final PrimitiveType INT_64 = new PrimitiveType(Id.Int64, ProtoType.int64());
    private static final PrimitiveType UINT_64 = new PrimitiveType(Id.Uint64, ProtoType.uint64());
    private static final PrimitiveType FLOAT32 = new PrimitiveType(Id.Float32, ProtoType.float32());
    private static final PrimitiveType FLOAT64 = new PrimitiveType(Id.Float64, ProtoType.float64());
    private static final PrimitiveType STRING = new PrimitiveType(Id.String, ProtoType.string());
    private static final PrimitiveType UTF_8 = new PrimitiveType(Id.Utf8, ProtoType.utf8());
    private static final PrimitiveType YSON = new PrimitiveType(Id.Yson, ProtoType.yson());
    private static final PrimitiveType JSON = new PrimitiveType(Id.Json, ProtoType.json());
    private static final PrimitiveType UUID = new PrimitiveType(Id.Uuid, ProtoType.uuid());
    private static final PrimitiveType DATE = new PrimitiveType(Id.Date, ProtoType.date());
    private static final PrimitiveType DATETIME = new PrimitiveType(Id.Datetime, ProtoType.datetime());
    private static final PrimitiveType TIMESTAMP = new PrimitiveType(Id.Timestamp, ProtoType.timestamp());
    private static final PrimitiveType INTERVAL = new PrimitiveType(Id.Interval, ProtoType.interval());
    private static final PrimitiveType TZ_DATE = new PrimitiveType(Id.TzDate, ProtoType.tzDate());
    private static final PrimitiveType TZ_DATETIME = new PrimitiveType(Id.TzDatetime, ProtoType.tzDatetime());
    private static final PrimitiveType TZ_TIMESTAMP = new PrimitiveType(Id.TzTimestamp, ProtoType.tzTimestamp());
    private static final PrimitiveType JSON_DOCUMENT = new PrimitiveType(Id.JsonDocument, ProtoType.jsonDocument());
    private static final PrimitiveType DYNUMBER = new PrimitiveType(Id.DyNumber, ProtoType.tzTimestamp());
    private static final PrimitiveType[] BY_IDS;
    private final Id id;
    private final ValueProtos.Type pbType;

    public static PrimitiveType of(Id id) {
        return BY_IDS[id.ordinal()];
    }

    public static PrimitiveType bool() {
        return BOOL;
    }

    public static PrimitiveType int8() {
        return INT_8;
    }

    public static PrimitiveType uint8() {
        return UINT_8;
    }

    public static PrimitiveType int16() {
        return INT_16;
    }

    public static PrimitiveType uint16() {
        return UINT_16;
    }

    public static PrimitiveType int32() {
        return INT_32;
    }

    public static PrimitiveType uint32() {
        return UINT_32;
    }

    public static PrimitiveType int64() {
        return INT_64;
    }

    public static PrimitiveType uint64() {
        return UINT_64;
    }

    public static PrimitiveType float32() {
        return FLOAT32;
    }

    public static PrimitiveType float64() {
        return FLOAT64;
    }

    public static PrimitiveType string() {
        return STRING;
    }

    public static PrimitiveType utf8() {
        return UTF_8;
    }

    public static PrimitiveType yson() {
        return YSON;
    }

    public static PrimitiveType json() {
        return JSON;
    }

    public static PrimitiveType uuid() {
        return UUID;
    }

    public static PrimitiveType date() {
        return DATE;
    }

    public static PrimitiveType datetime() {
        return DATETIME;
    }

    public static PrimitiveType timestamp() {
        return TIMESTAMP;
    }

    public static PrimitiveType interval() {
        return INTERVAL;
    }

    public static PrimitiveType tzDate() {
        return TZ_DATE;
    }

    public static PrimitiveType tzDatetime() {
        return TZ_DATETIME;
    }

    public static PrimitiveType tzTimestamp() {
        return TZ_TIMESTAMP;
    }

    public static PrimitiveType jsonDocument() {
        return JSON_DOCUMENT;
    }

    public static PrimitiveType dyNumber() {
        return DYNUMBER;
    }

    private PrimitiveType(Id id, ValueProtos.Type pbType) {
        this.id = id;
        this.pbType = pbType;
    }

    @Override
    public Type.Kind getKind() {
        return Type.Kind.PRIMITIVE;
    }

    public Id getId() {
        return this.id;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return 31 * Type.Kind.PRIMITIVE.hashCode() + this.id.hashCode();
    }

    @Override
    public String toString() {
        switch (this.id) {
            case Float32: {
                return "Float";
            }
            case Float64: {
                return "Double";
            }
        }
        return this.id.name();
    }

    @Override
    public ValueProtos.Type toPb() {
        return this.pbType;
    }

    private static PrimitiveType byId(Id id) {
        switch (id) {
            case Bool: {
                return BOOL;
            }
            case Int8: {
                return INT_8;
            }
            case Uint8: {
                return UINT_8;
            }
            case Int16: {
                return INT_16;
            }
            case Uint16: {
                return UINT_16;
            }
            case Int32: {
                return INT_32;
            }
            case Uint32: {
                return UINT_32;
            }
            case Int64: {
                return INT_64;
            }
            case Uint64: {
                return UINT_64;
            }
            case Float32: {
                return FLOAT32;
            }
            case Float64: {
                return FLOAT64;
            }
            case String: {
                return STRING;
            }
            case Utf8: {
                return UTF_8;
            }
            case Yson: {
                return YSON;
            }
            case Json: {
                return JSON;
            }
            case Uuid: {
                return UUID;
            }
            case Date: {
                return DATE;
            }
            case Datetime: {
                return DATETIME;
            }
            case Timestamp: {
                return TIMESTAMP;
            }
            case Interval: {
                return INTERVAL;
            }
            case TzDate: {
                return TZ_DATE;
            }
            case TzDatetime: {
                return TZ_DATETIME;
            }
            case TzTimestamp: {
                return TZ_TIMESTAMP;
            }
            case JsonDocument: {
                return JSON_DOCUMENT;
            }
            case DyNumber: {
                return DYNUMBER;
            }
        }
        throw new IllegalArgumentException("unknown PrimitiveType: " + (Object)((Object)id));
    }

    static {
        Id[] ids = Id.values();
        BY_IDS = new PrimitiveType[ids.length];
        for (Id id : ids) {
            PrimitiveType.BY_IDS[id.ordinal()] = PrimitiveType.byId(id);
        }
    }

    public static enum Id {
        Bool(6),
        Int8(7),
        Uint8(5),
        Int16(8),
        Uint16(9),
        Int32(1),
        Uint32(2),
        Int64(3),
        Uint64(4),
        Float32(33),
        Float64(32),
        String(4097),
        Utf8(4608),
        Yson(4609),
        Json(4610),
        Uuid(4611),
        Date(48),
        Datetime(49),
        Timestamp(50),
        Interval(51),
        TzDate(52),
        TzDatetime(53),
        TzTimestamp(54),
        JsonDocument(4612),
        DyNumber(4866);

        private final short numId;

        private Id(int numId) {
            this.numId = (short)numId;
        }

        public short getNumId() {
            return this.numId;
        }
    }
}

