/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.Status;
import com.yandex.ydb.table.SessionStatus;
import com.yandex.ydb.table.description.TableDescription;
import com.yandex.ydb.table.query.DataQuery;
import com.yandex.ydb.table.query.DataQueryResult;
import com.yandex.ydb.table.query.ExplainDataQueryResult;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.result.ResultSetReader;
import com.yandex.ydb.table.settings.AlterTableSettings;
import com.yandex.ydb.table.settings.BeginTxSettings;
import com.yandex.ydb.table.settings.CloseSessionSettings;
import com.yandex.ydb.table.settings.CommitTxSettings;
import com.yandex.ydb.table.settings.CopyTableSettings;
import com.yandex.ydb.table.settings.CreateTableSettings;
import com.yandex.ydb.table.settings.DescribeTableSettings;
import com.yandex.ydb.table.settings.DropTableSettings;
import com.yandex.ydb.table.settings.ExecuteDataQuerySettings;
import com.yandex.ydb.table.settings.ExecuteScanQuerySettings;
import com.yandex.ydb.table.settings.ExecuteSchemeQuerySettings;
import com.yandex.ydb.table.settings.ExplainDataQuerySettings;
import com.yandex.ydb.table.settings.KeepAliveSessionSettings;
import com.yandex.ydb.table.settings.PrepareDataQuerySettings;
import com.yandex.ydb.table.settings.ReadTableSettings;
import com.yandex.ydb.table.settings.RollbackTxSettings;
import com.yandex.ydb.table.transaction.Transaction;
import com.yandex.ydb.table.transaction.TransactionMode;
import com.yandex.ydb.table.transaction.TxControl;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public interface Session {
    public String getId();

    public CompletableFuture<Status> createTable(String var1, TableDescription var2, CreateTableSettings var3);

    default public CompletableFuture<Status> createTable(String path, TableDescription tableDescriptions) {
        return this.createTable(path, tableDescriptions, new CreateTableSettings());
    }

    public CompletableFuture<Status> dropTable(String var1, DropTableSettings var2);

    default public CompletableFuture<Status> dropTable(String path) {
        return this.dropTable(path, new DropTableSettings());
    }

    public CompletableFuture<Status> alterTable(String var1, AlterTableSettings var2);

    default public CompletableFuture<Status> alterTable(String path) {
        return this.alterTable(path, new AlterTableSettings());
    }

    public CompletableFuture<Status> copyTable(String var1, String var2, CopyTableSettings var3);

    default public CompletableFuture<Status> copyTable(String src, String dst) {
        return this.copyTable(src, dst, new CopyTableSettings());
    }

    public CompletableFuture<Result<TableDescription>> describeTable(String var1, DescribeTableSettings var2);

    default public CompletableFuture<Result<TableDescription>> describeTable(String path) {
        return this.describeTable(path, new DescribeTableSettings());
    }

    public CompletableFuture<Result<DataQueryResult>> executeDataQuery(String var1, TxControl var2, Params var3, ExecuteDataQuerySettings var4);

    default public CompletableFuture<Result<DataQueryResult>> executeDataQuery(String query, TxControl txControl, Params params) {
        return this.executeDataQuery(query, txControl, params, new ExecuteDataQuerySettings());
    }

    default public CompletableFuture<Result<DataQueryResult>> executeDataQuery(String query, TxControl txControl) {
        return this.executeDataQuery(query, txControl, Params.empty(), new ExecuteDataQuerySettings());
    }

    public CompletableFuture<Result<DataQuery>> prepareDataQuery(String var1, PrepareDataQuerySettings var2);

    default public CompletableFuture<Result<DataQuery>> prepareDataQuery(String query) {
        return this.prepareDataQuery(query, new PrepareDataQuerySettings());
    }

    public CompletableFuture<Status> executeSchemeQuery(String var1, ExecuteSchemeQuerySettings var2);

    default public CompletableFuture<Status> executeSchemeQuery(String query) {
        return this.executeSchemeQuery(query, new ExecuteSchemeQuerySettings());
    }

    public CompletableFuture<Result<ExplainDataQueryResult>> explainDataQuery(String var1, ExplainDataQuerySettings var2);

    default public CompletableFuture<Result<ExplainDataQueryResult>> explainDataQuery(String query) {
        return this.explainDataQuery(query, new ExplainDataQuerySettings());
    }

    public CompletableFuture<Result<Transaction>> beginTransaction(TransactionMode var1, BeginTxSettings var2);

    default public CompletableFuture<Result<Transaction>> beginTransaction(TransactionMode transactionMode) {
        return this.beginTransaction(transactionMode, new BeginTxSettings());
    }

    public CompletableFuture<Status> commitTransaction(String var1, CommitTxSettings var2);

    public CompletableFuture<Status> rollbackTransaction(String var1, RollbackTxSettings var2);

    public CompletableFuture<Status> readTable(String var1, ReadTableSettings var2, Consumer<ResultSetReader> var3);

    public CompletableFuture<Status> executeScanQuery(String var1, Params var2, ExecuteScanQuerySettings var3, Consumer<ResultSetReader> var4);

    public CompletableFuture<Result<SessionStatus>> keepAlive(KeepAliveSessionSettings var1);

    default public CompletableFuture<Result<SessionStatus>> keepAlive() {
        return this.keepAlive(new KeepAliveSessionSettings());
    }

    public void invalidateQueryCache();

    public boolean release();

    public CompletableFuture<Status> close(CloseSessionSettings var1);

    default public CompletableFuture<Status> close() {
        return this.close(new CloseSessionSettings());
    }
}

