/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.settings;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class RequestSettings<Self extends RequestSettings> {
    private String traceId;
    private long deadlineAfter;
    private Duration operationTimeout;
    private Duration cancelAfter;

    public String getTraceId() {
        return this.traceId;
    }

    public Self setTraceId(String traceId) {
        this.traceId = traceId;
        return this.self();
    }

    public long getDeadlineAfter() {
        return this.deadlineAfter;
    }

    public Self setTimeout(Duration duration) {
        if (duration.compareTo(Duration.ZERO) > 0) {
            this.deadlineAfter = System.nanoTime() + duration.toNanos();
        }
        return this.self();
    }

    public Self setTimeout(long duration, TimeUnit unit) {
        if (duration > 0L) {
            this.deadlineAfter = System.nanoTime() + unit.toNanos(duration);
        }
        return this.self();
    }

    public Self setDeadlineAfter(long deadlineAfter) {
        this.deadlineAfter = Math.max(0L, deadlineAfter);
        return this.self();
    }

    private Self self() {
        return (Self)this;
    }

    public Optional<Duration> getOperationTimeout() {
        return Optional.ofNullable(this.operationTimeout);
    }

    public Self setOperationTimeout(Duration operationTimeout) {
        this.operationTimeout = operationTimeout;
        return this.self();
    }

    public Optional<Duration> getCancelAfter() {
        return Optional.ofNullable(this.cancelAfter);
    }

    public Self setCancelAfter(Duration cancelAfter) {
        this.cancelAfter = cancelAfter;
        return this.self();
    }
}

