/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.table.SessionStatus;
import com.yandex.ydb.table.impl.SessionImpl;
import com.yandex.ydb.table.impl.SessionPoolOptions;
import com.yandex.ydb.table.impl.TableClientImpl;
import com.yandex.ydb.table.impl.pool.FixedAsyncPool;
import com.yandex.ydb.table.impl.pool.PooledObjectHandler;
import com.yandex.ydb.table.impl.pool.SettlersPool;
import com.yandex.ydb.table.settings.CreateSessionSettings;
import com.yandex.ydb.table.stats.SessionPoolStats;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SessionPool
implements PooledObjectHandler<SessionImpl> {
    private static final Logger logger = LoggerFactory.getLogger(SessionPool.class);
    private final TableClientImpl tableClient;
    private final FixedAsyncPool<SessionImpl> idlePool;
    private final SettlersPool<SessionImpl> settlersPool;
    private final int minSize;
    private final int maxSize;

    SessionPool(TableClientImpl tableClient, SessionPoolOptions options) {
        this.tableClient = tableClient;
        this.minSize = options.getMinSize();
        this.maxSize = options.getMaxSize();
        this.idlePool = new FixedAsyncPool<SessionImpl>(this, this.minSize, this.maxSize, this.maxSize * 2, options.getKeepAliveTimeMillis(), options.getMaxIdleTimeMillis());
        this.settlersPool = new SettlersPool<SessionImpl>(this, this.idlePool, 10, 5000);
    }

    @Override
    public CompletableFuture<SessionImpl> create(long deadlineAfter) {
        return this.tableClient.createSessionImpl((CreateSessionSettings)new CreateSessionSettings().setDeadlineAfter(deadlineAfter), this).thenApply(r -> {
            SessionImpl session = (SessionImpl)r.expect("cannot create session");
            session.setState(SessionImpl.State.IDLE);
            return session;
        });
    }

    @Override
    public CompletableFuture<Void> destroy(SessionImpl s) {
        return s.close().thenAccept(r -> r.expect("cannot close session: " + s.getId()));
    }

    @Override
    public boolean isValid(SessionImpl s) {
        return s.switchState(SessionImpl.State.ACTIVE, SessionImpl.State.IDLE);
    }

    @Override
    public CompletableFuture<Result<SessionStatus>> keepAlive(SessionImpl s) {
        return s.keepAlive();
    }

    CompletableFuture<SessionImpl> acquire(Duration timeout) {
        Instant startTime = Instant.now();
        return this.idlePool.acquire(timeout).thenCompose(s -> {
            if (s.switchState(SessionImpl.State.IDLE, SessionImpl.State.ACTIVE)) {
                logger.debug("session `{}' acquired", s);
                return CompletableFuture.completedFuture(s);
            }
            this.release((SessionImpl)s);
            Duration duration = Duration.between(startTime, Instant.now());
            return this.acquire(timeout.minus(Duration.ZERO.compareTo(duration) < 0 ? duration : Duration.ZERO));
        });
    }

    void release(SessionImpl session) {
        if (session.switchState(SessionImpl.State.DISCONNECTED, SessionImpl.State.IDLE)) {
            if (!this.settlersPool.offerIfHaveSpace(session)) {
                logger.debug("Destroy {} because settlers pool overflow", (Object)session);
                session.close();
                this.idlePool.release(session);
            }
        } else {
            this.idlePool.release(session);
            logger.debug("session `{}' released", (Object)session);
        }
    }

    void close() {
        this.idlePool.close();
        this.settlersPool.close();
    }

    public SessionPoolStats getStats() {
        return new SessionPoolStats(this.minSize, this.maxSize, this.idlePool.getIdleCount(), this.settlersPool.size(), this.idlePool.getAcquiredCount(), this.idlePool.getPendingAcquireCount());
    }
}

