/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.values;

import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.Value;
import com.yandex.ydb.table.values.VariantType;
import java.util.Objects;

public class VariantValue
implements Value<VariantType> {
    private final VariantType type;
    private final Value item;
    private final int typeIndex;

    VariantValue(VariantType type, Value item, int typeIndex) {
        this.type = type;
        this.item = Objects.requireNonNull(item, "item");
        this.typeIndex = typeIndex;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public Value getItem() {
        return this.item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariantValue that = (VariantValue)o;
        if (this.typeIndex != that.typeIndex) {
            return false;
        }
        return this.item.equals(that.item);
    }

    public int hashCode() {
        int h = Type.Kind.VARIANT.hashCode();
        h = 31 * h + this.typeIndex;
        return 31 * h + this.item.hashCode();
    }

    public String toString() {
        return "Variant[" + this.typeIndex + "; " + this.item.toString() + ']';
    }

    @Override
    public VariantType getType() {
        return this.type;
    }

    @Override
    public ValueProtos.Value toPb() {
        ValueProtos.Value.Builder builder = ValueProtos.Value.newBuilder();
        builder.setNestedValue(this.item.toPb());
        builder.setVariantIndex(this.typeIndex);
        return builder.build();
    }
}

