/*
 * Decompiled with CFR 0.152.
 */
package com.yannbriancon.interceptor;

import com.yannbriancon.exception.NPlusOneQueriesException;
import com.yannbriancon.interceptor.EmptyMapSupplier;
import com.yannbriancon.interceptor.EmptySetSupplier;
import com.yannbriancon.interceptor.HibernateQueryInterceptorProperties;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={HibernateQueryInterceptorProperties.class})
public class HibernateQueryInterceptor
extends EmptyInterceptor {
    private transient ThreadLocal<Long> threadQueryCount = new ThreadLocal();
    private transient ThreadLocal<Set<String>> threadPreviouslyLoadedEntities = ThreadLocal.withInitial(new EmptySetSupplier());
    private transient ThreadLocal<Map<String, String>> threadProxyMethodEntityMapping = ThreadLocal.withInitial(new EmptyMapSupplier());
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateQueryInterceptor.class);
    private final HibernateQueryInterceptorProperties hibernateQueryInterceptorProperties;
    private final String HIBERNATE_PROXY_PREFIX = "org.hibernate.proxy";
    private final String PROXY_METHOD_PREFIX = "com.sun.proxy";

    public HibernateQueryInterceptor(HibernateQueryInterceptorProperties hibernateQueryInterceptorProperties) {
        this.hibernateQueryInterceptorProperties = hibernateQueryInterceptorProperties;
    }

    public void startQueryCount() {
        this.threadQueryCount.set(0L);
    }

    public Long getQueryCount() {
        return this.threadQueryCount.get();
    }

    public String onPrepareStatement(String sql) {
        Long count = this.threadQueryCount.get();
        if (count != null) {
            this.threadQueryCount.set(count + 1L);
        }
        return super.onPrepareStatement(sql);
    }

    public void afterTransactionCompletion(Transaction tx) {
        this.threadPreviouslyLoadedEntities.set(new HashSet());
        this.threadProxyMethodEntityMapping.set(new HashMap());
    }

    public Object getEntity(String entityName, Serializable id) {
        this.detectNPlusOneQueriesOfMissingQueryEagerFetching(entityName, id);
        this.detectNPlusOneQueriesOfMissingEntityFieldLazyFetching(entityName, id);
        Set<String> previouslyLoadedEntities = this.threadPreviouslyLoadedEntities.get();
        if (previouslyLoadedEntities.contains(entityName + id)) {
            previouslyLoadedEntities.remove(entityName + id);
            this.threadPreviouslyLoadedEntities.set(previouslyLoadedEntities);
        } else {
            previouslyLoadedEntities.add(entityName + id);
            this.threadPreviouslyLoadedEntities.set(previouslyLoadedEntities);
        }
        return null;
    }

    private boolean detectNPlusOneQueriesOfMissingQueryEagerFetching(String entityName, Serializable id) {
        Set<String> previouslyLoadedEntities = this.threadPreviouslyLoadedEntities.get();
        if (!previouslyLoadedEntities.contains(entityName + id)) {
            return false;
        }
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement originStackTraceElement = null;
        for (int i = 0; i < stackTraceElements.length - 3; ++i) {
            if (stackTraceElements[i].getClassName().indexOf("org.hibernate.proxy") != 0 || stackTraceElements[i + 1].getClassName().indexOf(entityName) != 0) continue;
            originStackTraceElement = stackTraceElements[i + 2];
            break;
        }
        if (originStackTraceElement == null) {
            return false;
        }
        String errorMessage = "N+1 queries detected on a getter of the entity " + entityName + "\n    at " + originStackTraceElement.toString() + "\n    Hint: Missing Eager fetching configuration on the query that fetched the object of type " + entityName + "\n";
        this.logDetectedNPlusOneQueries(errorMessage);
        return true;
    }

    private boolean detectNPlusOneQueriesOfMissingEntityFieldLazyFetching(String entityName, Serializable id) {
        Optional<String> optionalProxyMethodName = this.getProxyMethodName();
        if (!optionalProxyMethodName.isPresent()) {
            return false;
        }
        String proxyMethodName = optionalProxyMethodName.get();
        Set<String> previouslyLoadedEntities = this.threadPreviouslyLoadedEntities.get();
        Map<String, String> proxyMethodEntityMapping = this.threadProxyMethodEntityMapping.get();
        boolean nPlusOneQueriesDetected = false;
        if (previouslyLoadedEntities.contains(entityName + id) && proxyMethodEntityMapping.containsKey(proxyMethodName) && !proxyMethodEntityMapping.get(proxyMethodName).equals(entityName)) {
            nPlusOneQueriesDetected = true;
            String errorMessage = "N+1 queries detected on a query for the entity " + entityName;
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            for (int i = stackTraceElements.length - 1; i >= 1; --i) {
                if (stackTraceElements[i - 1].getClassName().indexOf("com.sun.proxy") != 0) continue;
                errorMessage = errorMessage + "\n    at " + stackTraceElements[i].toString();
                break;
            }
            errorMessage = errorMessage + "\n    Hint: Missing Lazy fetching configuration on a field of one of the entities fetched in the query\n";
            this.logDetectedNPlusOneQueries(errorMessage);
        }
        proxyMethodEntityMapping.putIfAbsent(proxyMethodName, entityName);
        return nPlusOneQueriesDetected;
    }

    private Optional<String> getProxyMethodName() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        for (int i = stackTraceElements.length - 1; i >= 0; --i) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            if (stackTraceElement.getClassName().indexOf("com.sun.proxy") != 0) continue;
            return Optional.of(stackTraceElement.getClassName() + stackTraceElement.getMethodName());
        }
        return Optional.empty();
    }

    private void logDetectedNPlusOneQueries(String errorMessage) {
        switch (this.hibernateQueryInterceptorProperties.getErrorLevel()) {
            case INFO: {
                LOGGER.info(errorMessage);
                break;
            }
            case WARN: {
                LOGGER.warn(errorMessage);
                break;
            }
            case ERROR: {
                LOGGER.error(errorMessage);
                break;
            }
            default: {
                throw new NPlusOneQueriesException(errorMessage, new Exception(new Throwable()));
            }
        }
    }
}

