/*
 * Decompiled with CFR 0.152.
 */
package com.yannbriancon.interceptor;

import com.yannbriancon.config.NPlusOneQueriesDetectionProperties;
import com.yannbriancon.exception.NPlusOneQueriesException;
import com.yannbriancon.interceptor.EmptyMapSupplier;
import com.yannbriancon.interceptor.EmptySetSupplier;
import com.yannbriancon.interceptor.SelectQueriesInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.persistence.EntityManager;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={NPlusOneQueriesDetectionProperties.class})
public class HibernateQueryInterceptor
extends EmptyInterceptor {
    private transient ThreadLocal<Long> threadQueryCount = new ThreadLocal();
    private transient ThreadLocal<Set<String>> threadPreviouslyLoadedEntities = ThreadLocal.withInitial(new EmptySetSupplier());
    private transient ThreadLocal<Map<String, SelectQueriesInfo>> threadSelectQueriesInfoPerProxyMethod = ThreadLocal.withInitial(new EmptyMapSupplier());
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateQueryInterceptor.class);
    private final NPlusOneQueriesDetectionProperties NPlusOneQueriesDetectionProperties;
    private static final String HIBERNATE_PROXY_PREFIX = "org.hibernate.proxy";
    private static final String PROXY_METHOD_PREFIX = "com.sun.proxy";

    public HibernateQueryInterceptor(NPlusOneQueriesDetectionProperties NPlusOneQueriesDetectionProperties2) {
        this.NPlusOneQueriesDetectionProperties = NPlusOneQueriesDetectionProperties2;
    }

    private void resetNPlusOneQueryDetectionState() {
        this.threadPreviouslyLoadedEntities.set(new HashSet());
        this.threadSelectQueriesInfoPerProxyMethod.set(new HashMap());
    }

    public void clearNPlusOneQuerySession(EntityManager entityManager) {
        entityManager.clear();
        this.resetNPlusOneQueryDetectionState();
    }

    public void startQueryCount() {
        this.threadQueryCount.set(0L);
    }

    public Long getQueryCount() {
        return this.threadQueryCount.get();
    }

    public String onPrepareStatement(String sql) {
        Long count;
        if (this.NPlusOneQueriesDetectionProperties.isEnabled()) {
            this.updateSelectQueriesInfoPerProxyMethod(sql);
        }
        if ((count = this.threadQueryCount.get()) != null) {
            this.threadQueryCount.set(count + 1L);
        }
        return super.onPrepareStatement(sql);
    }

    public void afterTransactionCompletion(Transaction tx) {
        this.resetNPlusOneQueryDetectionState();
    }

    public Object getEntity(String entityName, Serializable id) {
        if (this.NPlusOneQueriesDetectionProperties.isEnabled()) {
            this.detectNPlusOneQueriesFromMissingEagerFetchingOnAQuery(entityName, id);
            this.detectNPlusOneQueriesFromClassFieldEagerFetching(entityName);
        }
        return null;
    }

    private void detectNPlusOneQueriesFromMissingEagerFetchingOnAQuery(String entityName, Serializable id) {
        Set<String> previouslyLoadedEntities = this.threadPreviouslyLoadedEntities.get();
        if (!previouslyLoadedEntities.contains(entityName + id)) {
            previouslyLoadedEntities.add(entityName + id);
            this.threadPreviouslyLoadedEntities.set(previouslyLoadedEntities);
            return;
        }
        previouslyLoadedEntities.remove(entityName + id);
        this.threadPreviouslyLoadedEntities.set(previouslyLoadedEntities);
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement originStackTraceElement = null;
        for (int i = 0; i < stackTraceElements.length - 3; ++i) {
            if (stackTraceElements[i].getClassName().indexOf(HIBERNATE_PROXY_PREFIX) != 0 || stackTraceElements[i + 1].getClassName().indexOf(entityName) != 0) continue;
            originStackTraceElement = stackTraceElements[i + 2];
            break;
        }
        if (originStackTraceElement == null) {
            return;
        }
        String errorMessage = "N+1 queries detected on a getter of the entity " + entityName + "\n    at " + originStackTraceElement.toString() + "\n    Hint: Missing Eager fetching configuration on the query that fetched the object of type " + entityName + "\n";
        this.logDetectedNPlusOneQueries(errorMessage);
    }

    private void updateSelectQueriesInfoPerProxyMethod(String sql) {
        Optional<String> optionalProxyMethodName = this.getProxyMethodName();
        if (!optionalProxyMethodName.isPresent()) {
            return;
        }
        String proxyMethodName = optionalProxyMethodName.get();
        boolean isSelectQuery = sql.toLowerCase().startsWith("select");
        Map<String, SelectQueriesInfo> selectQueriesInfoPerProxyMethod = this.threadSelectQueriesInfoPerProxyMethod.get();
        if (!isSelectQuery) {
            selectQueriesInfoPerProxyMethod.remove(proxyMethodName);
            this.threadSelectQueriesInfoPerProxyMethod.set(selectQueriesInfoPerProxyMethod);
            return;
        }
        SelectQueriesInfo selectQueriesInfo = selectQueriesInfoPerProxyMethod.get(proxyMethodName);
        if (selectQueriesInfo == null || selectQueriesInfo.getInitialSelectQuery().equals(sql)) {
            selectQueriesInfoPerProxyMethod.put(proxyMethodName, new SelectQueriesInfo(sql));
            this.threadSelectQueriesInfoPerProxyMethod.set(selectQueriesInfoPerProxyMethod);
            return;
        }
        selectQueriesInfoPerProxyMethod.put(proxyMethodName, selectQueriesInfo.incrementSelectQueriesCount());
        this.threadSelectQueriesInfoPerProxyMethod.set(selectQueriesInfoPerProxyMethod);
    }

    private void detectNPlusOneQueriesFromClassFieldEagerFetching(String entityName) {
        Optional<String> optionalProxyMethodName = this.getProxyMethodName();
        if (!optionalProxyMethodName.isPresent()) {
            return;
        }
        String proxyMethodName = optionalProxyMethodName.get();
        Map<String, SelectQueriesInfo> selectQueriesInfoPerProxyMethod = this.threadSelectQueriesInfoPerProxyMethod.get();
        SelectQueriesInfo selectQueriesInfo = selectQueriesInfoPerProxyMethod.get(proxyMethodName);
        if (selectQueriesInfo == null || selectQueriesInfo.getSelectQueriesCount() < 2) {
            return;
        }
        selectQueriesInfoPerProxyMethod.put(proxyMethodName, selectQueriesInfo.resetSelectQueriesCount());
        this.threadSelectQueriesInfoPerProxyMethod.set(selectQueriesInfoPerProxyMethod);
        String errorMessage = "N+1 queries detected with eager fetching on the entity " + entityName;
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        for (int i = stackTraceElements.length - 1; i >= 1; --i) {
            if (stackTraceElements[i - 1].getClassName().indexOf(PROXY_METHOD_PREFIX) != 0) continue;
            errorMessage = errorMessage + "\n    at " + stackTraceElements[i].toString();
            break;
        }
        errorMessage = errorMessage + "\n    Hint: Missing Lazy fetching configuration on a field of type " + entityName + " of one of the entities fetched in the query\n";
        this.logDetectedNPlusOneQueries(errorMessage);
    }

    private Optional<String> getProxyMethodName() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        for (int i = stackTraceElements.length - 1; i >= 0; --i) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            if (stackTraceElement.getClassName().indexOf(PROXY_METHOD_PREFIX) != 0) continue;
            return Optional.of(stackTraceElement.getClassName() + stackTraceElement.getMethodName());
        }
        return Optional.empty();
    }

    private void logDetectedNPlusOneQueries(String errorMessage) {
        switch (this.NPlusOneQueriesDetectionProperties.getErrorLevel()) {
            case INFO: {
                LOGGER.info(errorMessage);
                break;
            }
            case WARN: {
                LOGGER.warn(errorMessage);
                break;
            }
            case ERROR: {
                LOGGER.error(errorMessage);
                break;
            }
            case EXCEPTION: {
                throw new NPlusOneQueriesException(errorMessage);
            }
        }
    }
}

