/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb;

import com.yashandb.Session;
import com.yashandb.SessionImpl;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.ConnectionImpl;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.Utils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class ConnectionMonitor {
    private Map observedSessions = new HashMap();
    private Map monitorTimers = new HashMap();
    private Map daemonConnections = new HashMap();
    private Timer timer = new Timer(true);
    private static final int TIMER_DELAY = 2;

    private boolean a(Statement statement) {
        boolean bl = false;
        try {
            ResultSet resultSet = statement.executeQuery("select 1 from dual");
            if (resultSet.next()) {
                bl = true;
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    private boolean a(Session session) {
        boolean bl = false;
        try {
            session.detectHeartbeat();
            bl = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    private TimerTask a(final String string) throws SQLException {
        final Statement statement = ((Connection)this.daemonConnections.get(string)).createStatement();
        return new TimerTask(){
            private final String taskLink;
            private final Statement taskStmt;
            {
                this.taskLink = string;
                this.taskStmt = statement;
            }

            @Override
            public void run() {
                if (ConnectionMonitor.this.a(this.taskStmt)) {
                    ConnectionMonitor.this.d(this.taskLink);
                    return;
                }
                ConnectionMonitor.this.e(this.taskLink);
                try {
                    this.taskStmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
    }

    private TimerTask b(final String string) throws SQLException {
        final Session session = ((ConnectionImpl)this.daemonConnections.get(string)).getSession();
        return new TimerTask(){
            private final String taskLink;
            private final Session taskSession;
            {
                this.taskLink = string;
                this.taskSession = session;
            }

            @Override
            public void run() {
                if (ConnectionMonitor.this.a(this.taskSession)) {
                    ConnectionMonitor.this.d(this.taskLink);
                    return;
                }
                ConnectionMonitor.this.e(this.taskLink);
            }
        };
    }

    public synchronized void register(SessionImpl sessionImpl) throws SQLException {
        int n;
        Object object;
        String string = sessionImpl.getHostSpec().getIp() + sessionImpl.getHostSpec().getPort();
        if (!this.observedSessions.containsKey(string)) {
            this.observedSessions.put(string, new HashSet());
        }
        ((Set)this.observedSessions.get(string)).add(sessionImpl);
        if (!this.daemonConnections.containsKey(string)) {
            try {
                object = (Connection)((ConnectionImpl)sessionImpl.getConnection()).cloneForMonitor();
                n = sessionImpl.getHeartbeatSocketTimeout();
                object.setNetworkTimeout(null, Utils.toMillisecond(n));
                this.daemonConnections.put(string, object);
            }
            catch (Exception exception) {
                throw SQLError.createSQLException(exception.getMessage(), YasState.DATA_ERROR);
            }
        }
        if (!this.monitorTimers.containsKey(string)) {
            n = sessionImpl.getHeartbeatSchedulePeriod();
            object = sessionImpl.getConnectVersion().getValue() < ConnectVersion.VER5.getValue() ? this.a(string) : this.b(string);
            this.timer.schedule((TimerTask)object, Utils.toMillisecond(2), (long)Utils.toMillisecond(n));
            this.monitorTimers.put(string, object);
        }
    }

    private void c(String string) {
        if (this.monitorTimers.containsKey(string)) {
            ((TimerTask)this.monitorTimers.remove(string)).cancel();
        }
        if (this.daemonConnections.containsKey(string)) {
            Connection connection = (Connection)this.daemonConnections.get(string);
            this.daemonConnections.remove(string);
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public synchronized void unRegister(SessionImpl sessionImpl) {
        String string = sessionImpl.getHostSpec().getIp() + sessionImpl.getHostSpec().getPort();
        if (!this.observedSessions.containsKey(string)) {
            return;
        }
        Set set = (Set)this.observedSessions.get(string);
        set.remove(sessionImpl);
        if (!set.isEmpty()) {
            return;
        }
        this.c(string);
    }

    private synchronized void d(String string) {
        Set set = (Set)this.observedSessions.get(string);
        if (set.isEmpty()) {
            return;
        }
        for (SessionImpl sessionImpl : set) {
            sessionImpl.processHeartBeat();
        }
    }

    private synchronized void e(String string) {
        Set set = (Set)this.observedSessions.get(string);
        if (set.isEmpty()) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            SessionImpl sessionImpl = (SessionImpl)iterator.next();
            if (!sessionImpl.processInvalid()) continue;
            iterator.remove();
        }
        if (!set.isEmpty()) {
            this.f(string);
            return;
        }
        this.observedSessions.remove(string);
        this.c(string);
    }

    private void f(String string) {
        Set set = (Set)this.observedSessions.get(string);
        if (set.isEmpty()) {
            return;
        }
        this.daemonConnections.remove(string);
        if (this.monitorTimers.containsKey(string)) {
            ((TimerTask)this.monitorTimers.remove(string)).cancel();
        }
        Iterator iterator = set.iterator();
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        int n = 20;
        while (iterator.hasNext()) {
            SessionImpl sessionImpl = (SessionImpl)iterator.next();
            if (bl2) {
                bl2 = false;
                int n2 = sessionImpl.getHeartbeatSocketTimeout();
                n = sessionImpl.getHeartbeatSocketTimeout();
                try {
                    Connection connection = (Connection)((ConnectionImpl)sessionImpl.getConnection()).cloneForMonitor();
                    connection.setNetworkTimeout(null, Utils.toMillisecond(n2));
                    this.daemonConnections.put(string, connection);
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (sessionImpl.getConnectVersion().getValue() < ConnectVersion.VER5.getValue()) {
                    bl3 = false;
                }
            }
            sessionImpl.processHeartBeat();
            if (bl) continue;
            sessionImpl.processInvalid();
        }
        this.a(string, set, bl, bl3, n);
    }

    private void a(String string, Set set, boolean bl, boolean bl2, int n) {
        if (bl) {
            TimerTask timerTask = null;
            try {
                timerTask = !bl2 ? this.a(string) : this.b(string);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (timerTask != null) {
                this.timer.schedule(timerTask, Utils.toMillisecond(2), (long)Utils.toMillisecond(n));
                this.monitorTimers.put(string, timerTask);
                return;
            }
        }
        set.clear();
        this.observedSessions.remove(string);
        this.c(string);
    }
}

