/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb;

import com.yashandb.conf.HostSpec;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DownHostsCache {
    static DownHostsCache downHostsCache;
    int refreshCacheTime = Integer.MAX_VALUE;
    int refreshInterval = 120;
    LocalDateTime lastRefreshTime = LocalDateTime.now();
    Map downHostsCacheMap = new ConcurrentHashMap();

    public static DownHostsCache getInstance() {
        if (downHostsCache == null) {
            downHostsCache = new DownHostsCache();
        }
        return downHostsCache;
    }

    private DownHostsCache() {
    }

    public boolean isDownHost(HostSpec hostSpec) {
        return this.downHostsCacheMap.containsKey(hostSpec);
    }

    public void markDownHost(HostSpec hostSpec) {
        if (!this.downHostsCacheMap.containsKey(hostSpec)) {
            this.downHostsCacheMap.put(hostSpec, LocalDateTime.now());
        }
    }

    void a() {
        if (this.refreshCacheTime < Integer.MAX_VALUE && LocalDateTime.now().minus(this.refreshInterval, ChronoUnit.SECONDS).isAfter(this.lastRefreshTime)) {
            for (HostSpec hostSpec : this.downHostsCacheMap.keySet()) {
                if (LocalDateTime.now().minus(this.refreshCacheTime, ChronoUnit.SECONDS).compareTo((ChronoLocalDateTime)this.downHostsCacheMap.get(hostSpec)) <= 0) continue;
                this.downHostsCacheMap.remove(hostSpec);
            }
            this.lastRefreshTime = LocalDateTime.now();
        }
    }

    public void reorderHosts(HostSpec[] hostSpecArray) {
        if (this.downHostsCacheMap.isEmpty()) {
            return;
        }
        this.a();
        int n = 0;
        int n2 = hostSpecArray.length - 1;
        while (n < n2) {
            while (n <= n2 && !this.isDownHost(hostSpecArray[n])) {
                ++n;
            }
            while (n <= n2 && this.isDownHost(hostSpecArray[n2])) {
                --n2;
            }
            if (n >= n2) continue;
            HostSpec hostSpec = hostSpecArray[n];
            hostSpecArray[n] = hostSpecArray[n2];
            hostSpecArray[n2] = hostSpec;
        }
    }

    public int getRefreshCacheTime() {
        return this.refreshCacheTime;
    }

    public void setRefreshCacheTime(int n) {
        this.refreshCacheTime = n;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int n) {
        this.refreshInterval = n;
    }
}

