/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb;

import com.yashandb.ConnectionManager;
import com.yashandb.ParameterList;
import com.yashandb.Session;
import com.yashandb.SimpleParameterList;
import com.yashandb.YasResultSet;
import com.yashandb.conf.HostSpec;
import com.yashandb.conf.YasProperty;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.ConnectionImpl;
import com.yashandb.jdbc.DebugBreakpoint;
import com.yashandb.jdbc.PreparedStatementImpl;
import com.yashandb.jdbc.ResultSetImpl;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.TransactionState;
import com.yashandb.jdbc.YasBlob;
import com.yashandb.jdbc.YasClob;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasDebugCallableStatement;
import com.yashandb.jdbc.YasFailover;
import com.yashandb.jdbc.YasLargeObject;
import com.yashandb.jdbc.YasLobProcessor;
import com.yashandb.jdbc.YasNClob;
import com.yashandb.jdbc.YasSavepoint;
import com.yashandb.jdbc.YasStatement;
import com.yashandb.jdbc.exception.BatchError;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasBatchUpdateException;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.jdbc.failover.YasFailoverProcessor;
import com.yashandb.jdbc.failover.YasLinkInfo;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.parameter.BlobParameter;
import com.yashandb.parameter.ClobParameter;
import com.yashandb.parameter.YasParameter;
import com.yashandb.protocol.ConnectionServerMode;
import com.yashandb.protocol.ExecuteResult;
import com.yashandb.protocol.LobOperation;
import com.yashandb.protocol.MsgType;
import com.yashandb.protocol.NativeProtocol;
import com.yashandb.protocol.Packet;
import com.yashandb.protocol.PacketProcessor;
import com.yashandb.protocol.Protocol;
import com.yashandb.protocol.YasSocketConnection;
import com.yashandb.protocol.debug.DebugOperation;
import com.yashandb.udt.YasArray;
import com.yashandb.udt.YasStruct;
import com.yashandb.udt.YasTypeDescriptor;
import com.yashandb.util.CharacterSet;
import com.yashandb.util.ConnectorFactory;
import com.yashandb.util.HostConnector;
import com.yashandb.util.Messages;
import com.yashandb.util.StreamWrapper;
import com.yashandb.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class SessionImpl
implements Session {
    private static final Pattern SHUTDOWN_PATTERN = Pattern.compile("^\\s*SHUTDOWN\\s*(NORMAL)*\\s*$", 2);
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionImpl.class.getName());
    private static final ConnectionManager connectionManager = new ConnectionManager();
    protected YasSocketConnection yasSocketConnection;
    private ConcurrentHashMap typeShapeCache = new ConcurrentHashMap();
    private final String user;
    private String schema;
    private String yasdbVersion;
    private final int cancelSignalTimeout;
    private YasConnection connection;
    private Statement statement = null;
    private boolean closed = false;
    private TransactionState transactionState = TransactionState.XACT_END;
    protected final boolean logServerErrorDetail;
    private boolean standardConformingStrings = false;
    private SQLWarning warnings;
    private Map typeMap;
    private final TreeMap parameterStatuses = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private boolean autoCommit = false;
    private NativeProtocol protocol;
    private HostSpec[] hostSpecs;
    private HostSpec hostSpec;
    private Properties info;
    private int sessionID;
    private short charset;
    private short nCharset;
    private int sessionKey;
    private boolean debugExecute = false;
    private boolean debugOn = false;
    private final boolean userCaseSensitive;
    private boolean heartbeatNotified = false;
    private ConnectVersion connectVersion = ConnectVersion.getMaxConnectVersion();
    private List tempLobList = new ArrayList();
    private Set updatedKnlLobs = Collections.synchronizedSet(new HashSet());
    private YasDebugCallableStatement runningDebugStatement = null;
    private YasFailoverProcessor yasFailoverProcessor = null;
    private Set allStatements = null;
    private boolean failoverInTransaction = false;
    private boolean failoverSuccess = false;
    private boolean ioError = false;
    private boolean isMonitorSession = false;
    private short lobChunkSize = 0;
    private boolean heartbeatOn = true;
    private int heartbeatSocketTimeout = 60;
    private int heartbeatSchedulePeriod = 20;
    private int serverSendTimeout = 600;
    private boolean fetchingStreamRs = false;
    private int streamRsStmtId = -1;
    private boolean mapDateToTimestamp;

    public SessionImpl(YasConnection yasConnection, HostSpec[] hostSpecArray, String string, Properties properties) throws SQLException {
        this.connection = yasConnection;
        this.yasSocketConnection = null;
        if (!string.contains("\"")) {
            string = string.toUpperCase();
            this.userCaseSensitive = false;
        } else {
            string = string.substring(1, string.length() - 1);
            this.userCaseSensitive = true;
        }
        this.user = string;
        this.schema = string;
        this.cancelSignalTimeout = YasProperty.CANCEL_SIGNAL_TIMEOUT.getInt(properties) * 1000;
        this.logServerErrorDetail = YasProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(properties);
        this.mapDateToTimestamp = YasProperty.MAP_DATE_TO_TIMESTAMP.getBoolean(properties);
        this.hostSpecs = hostSpecArray;
        this.info = properties;
        this.protocol = null;
        this.a(properties);
    }

    private void a(Properties properties) throws SQLException {
        String string = YasProperty.HEARTBEAT_SWITCH.get(properties);
        int n = YasProperty.HEARTBEAT_SOCKET_TIMEOUT.getInt(properties);
        int n2 = YasProperty.HEARTBEAT_SCHEDULE_PERIOD.getInt(properties);
        if (string == null || !string.equalsIgnoreCase("on") && !string.equalsIgnoreCase("off")) {
            throw SQLError.createSQLException("HeartbeatSwitch only support ON or OFF.", YasState.DATA_ERROR);
        }
        if (n < 5) {
            throw SQLError.createSQLException("The minimum value of heartbeatSocketTimeout is 5.", YasState.DATA_ERROR);
        }
        if (n2 < 5) {
            throw SQLError.createSQLException("The minimum value of heartbeatSchedulePeriod is 5.", YasState.DATA_ERROR);
        }
        if (!string.equalsIgnoreCase("on")) {
            this.heartbeatOn = false;
        }
        this.heartbeatSocketTimeout = n;
        this.heartbeatSchedulePeriod = n2;
    }

    public Object cloneForMonitor() throws CloneNotSupportedException {
        SessionImpl sessionImpl = (SessionImpl)super.clone();
        sessionImpl.yasFailoverProcessor = null;
        sessionImpl.statement = null;
        sessionImpl.isMonitorSession = true;
        try {
            int n = Utils.toMillisecond(YasProperty.CONNECT_TIMEOUT.getInt(this.info));
            sessionImpl.yasSocketConnection = new YasSocketConnection(this.yasSocketConnection, n, true);
            sessionImpl.protocol = new NativeProtocol(sessionImpl, sessionImpl.yasSocketConnection);
            sessionImpl.protocol.setServerMode(ConnectionServerMode.DEDICATE_MODE);
            sessionImpl.protocol.setHeartbeatLink();
            String string = YasProperty.PASSWORD.get(this.info);
            sessionImpl.protocol.connect(this.user, string, this.info);
        }
        catch (IOException | SQLException exception) {
            throw new CloneNotSupportedException(Messages.get("clone session attempt failed {0}", exception.getMessage()));
        }
        return sessionImpl;
    }

    @Override
    public void setConnection(YasConnection yasConnection) {
        this.connection = yasConnection;
    }

    @Override
    public YasConnection getConnection() {
        return this.connection;
    }

    @Override
    public short getCharset() {
        return this.charset;
    }

    @Override
    public short getNCharset() {
        return this.nCharset;
    }

    @Override
    public String getYasdbVersion() {
        return this.yasdbVersion;
    }

    @Override
    public void setYasdbVersion(String string) {
        this.yasdbVersion = string;
    }

    @Override
    public void setNCharset(short s) {
        this.nCharset = s;
    }

    private void a() throws SQLException {
        this.b();
    }

    private void b() throws SQLException {
        if (this.fetchingStreamRs) {
            throw SQLError.streamingResultFetchingException();
        }
    }

    @Override
    public synchronized long getLobLength(YasLobProcessor yasLobProcessor) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        byte by = PacketProcessor.getReqLobFlag(false, false, false);
        PacketProcessor.writeReqLob(packet, LobOperation.LOB_GET_LEN, yasLobProcessor, 0, 0L, by);
        Packet packet2 = this.a(packet, MsgType.CMD_LOB, 0);
        return PacketProcessor.processLobMetaDataAck(yasLobProcessor, packet2, LobOperation.LOB_GET_LEN);
    }

    @Override
    public synchronized short getLobChunkSize(YasLobProcessor yasLobProcessor) throws SQLException {
        if (this.lobChunkSize != 0) {
            return this.lobChunkSize;
        }
        Packet packet = this.protocol.getSendPacket();
        byte by = PacketProcessor.getReqLobFlag(false, false, false);
        PacketProcessor.writeReqLob(packet, LobOperation.LOB_GET_CHUNK_SIZE, yasLobProcessor, 0, 0L, by);
        Packet packet2 = this.a(packet, MsgType.CMD_LOB, 0);
        this.lobChunkSize = (short)PacketProcessor.processLobMetaDataAck(yasLobProcessor, packet2, LobOperation.LOB_GET_CHUNK_SIZE);
        return this.lobChunkSize;
    }

    @Override
    public synchronized int getLobData(YasLobProcessor yasLobProcessor, int n, long l, byte[] byArray) throws SQLException {
        byte[] byArray2 = yasLobProcessor.getLobLocator();
        if (byArray.length < n) {
            throw new YasException("lob cache buffer size too small: " + byArray.length, YasState.OUT_OF_MEMORY);
        }
        Packet packet = this.protocol.getSendPacket();
        byte by = PacketProcessor.getReqLobFlag(false, false, false);
        PacketProcessor.writeReqLob(packet, LobOperation.LOB_READ, yasLobProcessor, n, l, by);
        Packet packet2 = this.a(packet, MsgType.CMD_LOB, 0);
        return PacketProcessor.processLobDataAck(byArray2, packet2, byArray);
    }

    @Override
    public synchronized YasClob createClob() throws SQLException {
        YasClob yasClob = new YasClob(true);
        this.a(yasClob);
        return yasClob;
    }

    @Override
    public synchronized YasNClob createNClob() throws SQLException {
        YasNClob yasNClob = new YasNClob(true);
        this.a(yasNClob);
        return yasNClob;
    }

    private void a(YasClob yasClob) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        YasLobProcessor yasLobProcessor = new YasLobProcessor();
        yasLobProcessor.setLobLocator(null);
        yasLobProcessor.setLobType(29);
        yasLobProcessor.setSession(this);
        byte by = PacketProcessor.getReqLobFlag(false, false, false);
        PacketProcessor.writeReqLob(packet, LobOperation.LOB_TMP_CREATE, yasLobProcessor, 0, 0L, by);
        Packet packet2 = this.a(packet, MsgType.CMD_LOB, 0);
        byte[] byArray = PacketProcessor.processLobCreateAck(packet2);
        yasLobProcessor.setLobLocator(byArray);
        int n = byArray[0] & 0xFF;
        yasLobProcessor.setInnerLobType(n);
        yasLobProcessor.setLobLength(0L);
        yasClob.setLobProcessor(yasLobProcessor);
        yasClob.setConnection(this.getConnection());
    }

    @Override
    public synchronized YasBlob createBlob() throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        YasLobProcessor yasLobProcessor = new YasLobProcessor();
        yasLobProcessor.setLobLocator(null);
        yasLobProcessor.setLobType(30);
        yasLobProcessor.setSession(this);
        byte by = PacketProcessor.getReqLobFlag(false, false, false);
        PacketProcessor.writeReqLob(packet, LobOperation.LOB_TMP_CREATE, yasLobProcessor, 0, 0L, by);
        Packet packet2 = this.a(packet, MsgType.CMD_LOB, 0);
        YasBlob yasBlob = new YasBlob(true);
        byte[] byArray = PacketProcessor.processLobCreateAck(packet2);
        yasLobProcessor.setLobLocator(byArray);
        int n = byArray[0] & 0xFF;
        yasLobProcessor.setInnerLobType(n);
        yasLobProcessor.setLobLength(0L);
        yasBlob.setLobProcessor(yasLobProcessor);
        yasBlob.setConnection(this.getConnection());
        return yasBlob;
    }

    @Override
    public synchronized long writeLob(YasLobProcessor yasLobProcessor, long l, byte[] byArray, int n, int n2) throws SQLException {
        int n3;
        int n4 = 16 + yasLobProcessor.getLobLocator().length;
        long l2 = l;
        long l3 = 0L;
        Packet packet = this.protocol.getSendPacket();
        for (int i = n2; i > 0; i -= n3) {
            packet.clean();
            n3 = Math.min(i, packet.getRemainSize() - n4);
            byte by = PacketProcessor.getReqLobFlag(false, false, false);
            PacketProcessor.writeReqLob(packet, LobOperation.LOB_WRITE, yasLobProcessor, n3, l2, by);
            packet.writeBytes(byArray, n, n3);
            Packet packet2 = this.a(packet, MsgType.CMD_LOB, 0);
            l3 = PacketProcessor.processLobMetaDataAck(yasLobProcessor, packet2, LobOperation.LOB_WRITE);
            l2 += (long)n3;
            n += n3;
        }
        return l3;
    }

    @Override
    public synchronized long writeLobByLobLocator(YasLobProcessor yasLobProcessor, long l, byte[] byArray) throws SQLException {
        int n = byArray.length;
        if (n != 80) {
            throw new YasException("tempLob locator length is error", YasState.DATA_ERROR);
        }
        Packet packet = this.protocol.getSendPacket();
        packet.clean();
        byte by = PacketProcessor.getReqLobFlag(true, false, false);
        PacketProcessor.writeReqLob(packet, LobOperation.LOB_WRITE, yasLobProcessor, n, l, by);
        packet.writeBytes(byArray, 0, n);
        Packet packet2 = this.a(packet, MsgType.CMD_LOB, 0);
        return PacketProcessor.processLobMetaDataAck(yasLobProcessor, packet2, LobOperation.LOB_WRITE);
    }

    @Override
    public synchronized long writeLobByStream(YasLobProcessor yasLobProcessor, long l, Reader reader, int n) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        packet.clean();
        byte by = PacketProcessor.getReqLobFlag(false, true, false);
        PacketProcessor.writeReqLob(packet, LobOperation.LOB_WRITE, yasLobProcessor, n, l, by);
        boolean bl = this.a(reader, n, packet, MsgType.CMD_LOB, false);
        Packet packet2 = this.a(packet, MsgType.CMD_LOB, bl);
        return PacketProcessor.processLobMetaDataAck(yasLobProcessor, packet2, LobOperation.LOB_WRITE);
    }

    @Override
    public synchronized long writeLobByStream(YasLobProcessor yasLobProcessor, long l, InputStream inputStream, int n) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        packet.clean();
        byte by = PacketProcessor.getReqLobFlag(false, true, false);
        PacketProcessor.writeReqLob(packet, LobOperation.LOB_WRITE, yasLobProcessor, n, l, by);
        boolean bl = this.a(inputStream, n, packet, MsgType.CMD_LOB, false);
        Packet packet2 = this.a(packet, MsgType.CMD_LOB, bl);
        return PacketProcessor.processLobMetaDataAck(yasLobProcessor, packet2, LobOperation.LOB_WRITE);
    }

    @Override
    public synchronized void closeLob(YasLobProcessor yasLobProcessor) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        byte by = PacketProcessor.getReqLobFlag(false, false, false);
        PacketProcessor.writeReqLob(packet, LobOperation.LOB_CLOSE, yasLobProcessor, 0, 0L, by);
        Packet packet2 = this.a(packet, MsgType.CMD_LOB, 0);
        PacketProcessor.processLobMetaDataAck(yasLobProcessor, packet2, LobOperation.LOB_CLOSE);
    }

    @Override
    public synchronized YasResultSet directExecute(StatementImpl statementImpl, String string) throws SQLException {
        this.autoCommit = this.connection.getAutoCommit();
        this.b(string);
        Packet packet = this.protocol.getSendPacket();
        PacketProcessor.writeReqExecute(statementImpl, packet, this.autoCommit);
        Packet packet2 = this.a(packet, string, MsgType.CMD_DIRECT_EXECUTE);
        packet2 = PacketProcessor.processInteractPacket(statementImpl, packet2, this);
        YasResultSet yasResultSet = PacketProcessor.processDirectExecuteAck(statementImpl, packet2, this);
        if (this.autoCommit) {
            this.setTransactionState(TransactionState.XACT_END);
        }
        return yasResultSet;
    }

    @Override
    public synchronized YasResultSet directExecute(StatementImpl statementImpl, String string, ParameterList[] parameterListArray, boolean bl) throws SQLException {
        this.autoCommit = this.connection.getAutoCommit();
        if (parameterListArray == null) {
            return this.directExecute(statementImpl, string);
        }
        YasResultSet yasResultSet = this.a(statementImpl, string, parameterListArray, bl);
        if (this.autoCommit) {
            this.setTransactionState(TransactionState.XACT_END);
        }
        return yasResultSet;
    }

    @Override
    public synchronized YasResultSet fetchCursor(StatementImpl statementImpl) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        PacketProcessor.writeFetchCursor((short)statementImpl.getID(), packet, statementImpl.getFetchSize());
        Packet packet2 = this.a(packet, MsgType.CMD_FETCH_CURSOR, 0);
        YasResultSet yasResultSet = PacketProcessor.processDirectExecuteAck(statementImpl, packet2, this);
        yasResultSet.setStmtQueryResult(true);
        if (this.autoCommit) {
            this.setTransactionState(TransactionState.XACT_END);
        }
        return yasResultSet;
    }

    @Override
    public YasResultSet fetchReturnResultSet(short s) throws SQLException {
        StatementImpl statementImpl = (StatementImpl)this.connection.createStatement();
        statementImpl.setStmtID(s, (byte)0);
        statementImpl.closeOnCompletion();
        if (statementImpl.getFetchSize() == Integer.MIN_VALUE) {
            statementImpl.setFetchSize(Integer.MAX_VALUE);
        }
        Packet packet = this.protocol.getSendPacket();
        PacketProcessor.writeFetchCursor(s, packet, statementImpl.getFetchSize());
        Packet packet2 = this.a(packet, MsgType.CMD_FETCH_CURSOR, 0);
        YasResultSet yasResultSet = PacketProcessor.processFetchImplicitResultAck(statementImpl, packet2, this);
        if (this.autoCommit) {
            this.setTransactionState(TransactionState.XACT_END);
        }
        return yasResultSet;
    }

    private byte[] a(String string) {
        Charset charset;
        Charset charset2 = Charset.defaultCharset();
        byte[] byArray = charset2 == (charset = CharacterSet.getCharSet(this.charset)) ? string.getBytes() : string.getBytes(charset);
        return byArray;
    }

    private Packet a(Packet packet, String string, MsgType msgType) throws SQLException {
        byte[] byArray = this.a(string);
        int n = 0;
        int n2 = 0;
        if (byArray.length > 0x200000) {
            throw SQLError.createSQLException("the length of sql text exceed limit", YasState.PROTOCOL_VIOLATION);
        }
        boolean bl = true;
        for (int i = byArray.length; i > 0; i -= n) {
            n = packet.getCapacity() - packet.getPostion() - 4;
            if (i < n) {
                PacketProcessor.writeReqSql(packet, byArray, n2, i, false);
                break;
            }
            PacketProcessor.writeReqSql(packet, byArray, n2, n, true);
            packet.setHasMore(true);
            if (bl) {
                this.a(packet, msgType);
                bl = false;
            } else {
                this.a(packet, MsgType.CMD_MORE_DATA);
            }
            packet.clean();
            n2 += n;
        }
        if (bl) {
            return this.a(packet, msgType, 0);
        }
        return this.a(packet, MsgType.CMD_MORE_DATA, 0);
    }

    private boolean a(Packet packet, String string) throws SQLException {
        byte[] byArray = this.a(string);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        if (byArray.length > 0x200000) {
            throw SQLError.createSQLException("the length of sql text exceed limit", YasState.PROTOCOL_VIOLATION);
        }
        boolean bl2 = true;
        for (int i = byArray.length; i > 0; i -= n) {
            n = packet.getCapacity() - packet.getPostion() - 4;
            if (i < n) {
                PacketProcessor.writeReqSql(packet, byArray, n2, i, false);
                break;
            }
            PacketProcessor.writeReqSql(packet, byArray, n2, n, true);
            packet.setHasMore(true);
            bl = true;
            if (bl2) {
                this.a(packet, MsgType.CMD_DIRECT_EXECUTE);
                bl2 = false;
            } else {
                this.a(packet, MsgType.CMD_MORE_DATA);
            }
            packet.clean();
            n2 += n;
        }
        return bl;
    }

    @Override
    public synchronized void prepare(StatementImpl statementImpl, String string) throws SQLException {
        this.autoCommit = this.connection.getAutoCommit();
        Packet packet = this.protocol.getSendPacket();
        PacketProcessor.writeReqPrepare(statementImpl, packet);
        Packet packet2 = this.a(packet, string, MsgType.CMD_PREPARE);
        PacketProcessor.processPrepareAck(statementImpl, packet2);
    }

    private YasResultSet a(StatementImpl statementImpl, ParameterList[] parameterListArray, boolean bl, boolean bl2) throws SQLException {
        this.autoCommit = this.connection.getAutoCommit();
        if (bl2) {
            this.debugExecute = true;
        }
        YasResultSet yasResultSet = parameterListArray == null ? this.a(statementImpl) : this.a(statementImpl, parameterListArray, bl);
        if (this.autoCommit) {
            this.setTransactionState(TransactionState.XACT_END);
        }
        this.debugExecute = false;
        return yasResultSet;
    }

    @Override
    public synchronized YasResultSet execute(StatementImpl statementImpl, ParameterList[] parameterListArray, int n, int n2, int n3, boolean bl) throws SQLException {
        return this.a(statementImpl, parameterListArray, bl, false);
    }

    private void a(ParameterList[] parameterListArray) throws SQLException {
        for (ParameterList parameterList : parameterListArray) {
            YasParameter[] yasParameterArray = parameterList.getParameters();
            for (int i = 0; i < yasParameterArray.length; ++i) {
                if (yasParameterArray[i] == null || yasParameterArray[i].isOutParameter() || yasParameterArray[i].getLength() <= 32000) continue;
                parameterList.replace(i, this.a(yasParameterArray[i]));
            }
        }
    }

    private void a(Blob blob, StreamWrapper streamWrapper) throws SQLException, IOException {
        InputStream inputStream = streamWrapper.getStream();
        OutputStream outputStream = blob.setBinaryStream(1L);
        int n = inputStream.read();
        for (int i = streamWrapper.getLength(); n != -1 && i > 0; --i) {
            outputStream.write(n);
            n = inputStream.read();
        }
        outputStream.flush();
    }

    private YasParameter a(YasParameter yasParameter) throws SQLException {
        if (yasParameter.getType() == 28) {
            YasBlob yasBlob = this.createBlob();
            StreamWrapper streamWrapper = (StreamWrapper)yasParameter.getValue();
            try {
                this.a(yasBlob, streamWrapper);
            }
            catch (Exception exception) {
                throw SQLError.createSQLException(exception.getMessage(), YasState.DATA_ERROR);
            }
            BlobParameter blobParameter = new BlobParameter(30);
            blobParameter.setValue(yasBlob);
            blobParameter.setInDirection();
            this.tempLobList.add(yasBlob);
            return blobParameter;
        }
        YasClob yasClob = this.createClob();
        yasClob.setString(1L, (String)yasParameter.getValue());
        ClobParameter clobParameter = new ClobParameter();
        clobParameter.setValue(yasClob);
        clobParameter.setInDirection();
        this.tempLobList.add(yasClob);
        return clobParameter;
    }

    private void c() throws SQLException {
        if (!this.tempLobList.isEmpty()) {
            for (YasLargeObject yasLargeObject : this.tempLobList) {
                yasLargeObject.freeTemp();
            }
            this.tempLobList.clear();
        }
    }

    private void d() {
        try {
            this.c();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private Packet a(StatementImpl statementImpl, ParameterList[] parameterListArray, YasResultSet yasResultSet) throws SQLException {
        Packet packet;
        try {
            packet = this.b(statementImpl, parameterListArray);
        }
        catch (SQLException sQLException) {
            String string = BatchError.converMsgToBatchMsg(sQLException.getMessage());
            if (string == null) {
                throw sQLException;
            }
            BatchError batchError = new BatchError(sQLException.getErrorCode(), string);
            if (yasResultSet == null) {
                int[] nArray = new int[]{};
                throw new YasBatchUpdateException(0, batchError, nArray);
            }
            int[] nArray = yasResultSet.getBatchUpdateCounts();
            throw new YasBatchUpdateException(nArray.length, batchError, nArray);
        }
        return packet;
    }

    private YasResultSet a(StatementImpl statementImpl, ParameterList[] parameterListArray) throws SQLException {
        int n = parameterListArray.length;
        int n2 = 0;
        YasResultSet yasResultSet = null;
        while (n > 0) {
            Packet packet;
            int n3 = Math.min(Math.min(2000, this.a(n2, parameterListArray)), n);
            ParameterList[] parameterListArray2 = Arrays.copyOfRange(parameterListArray, n2, n2 + n3);
            try {
                packet = this.a(statementImpl, parameterListArray2, yasResultSet);
            }
            catch (SQLException sQLException) {
                if (sQLException instanceof YasBatchUpdateException && statementImpl.getIsBatchError()) {
                    YasBatchUpdateException yasBatchUpdateException = (YasBatchUpdateException)sQLException;
                    BatchError batchError = yasBatchUpdateException.getBatchError();
                    int[] nArray = new int[]{-3};
                    HashMap<Integer, BatchError> hashMap = new HashMap<Integer, BatchError>(Collections.singletonMap(0, batchError));
                    if (yasResultSet == null) {
                        yasResultSet = new ResultSetImpl(0L, this.connection, statementImpl, nArray, hashMap);
                    } else {
                        yasResultSet.appendResults(0L, nArray, hashMap);
                    }
                    n -= parameterListArray2.length;
                    n2 += parameterListArray2.length;
                    continue;
                }
                throw sQLException;
            }
            yasResultSet = this.a(statementImpl, yasResultSet, packet);
            n -= parameterListArray2.length;
            n2 += parameterListArray2.length;
        }
        return yasResultSet;
    }

    private YasResultSet a(StatementImpl statementImpl, YasResultSet yasResultSet, Packet packet) throws SQLException {
        try {
            YasResultSet yasResultSet2 = PacketProcessor.processExecuteAckInBatchMode(statementImpl, packet, this);
            if (yasResultSet == null) {
                yasResultSet = yasResultSet2;
            } else {
                yasResultSet.appendResults(yasResultSet2.getUpdateCount(), yasResultSet2.getBatchUpdateCounts(), yasResultSet2.getBatchErrors());
            }
        }
        catch (YasBatchUpdateException yasBatchUpdateException) {
            if (yasResultSet == null) {
                throw yasBatchUpdateException;
            }
            int[] nArray = yasResultSet.getBatchUpdateCounts();
            int[] nArray2 = yasBatchUpdateException.getUpdateCounts();
            int[] nArray3 = new int[nArray.length + nArray2.length];
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
            System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
            throw new YasBatchUpdateException(nArray.length + yasBatchUpdateException.getRowNum(), yasBatchUpdateException.getBatchError(), nArray3);
        }
        return yasResultSet;
    }

    private Packet b(StatementImpl statementImpl, ParameterList[] parameterListArray) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        PacketProcessor.writeReqExecute(statementImpl, packet, parameterListArray, this.autoCommit, this.debugExecute);
        boolean bl = false;
        LinkedList<StreamWrapper> linkedList = new LinkedList<StreamWrapper>();
        for (ParameterList parameterList : parameterListArray) {
            SimpleParameterList simpleParameterList = (SimpleParameterList)parameterList;
            for (int i = 1; i <= simpleParameterList.getParameterCount(); ++i) {
                if (packet.getRemainSize() > simpleParameterList.getLength(i)) {
                    simpleParameterList.a(i, packet);
                } else {
                    packet.setHasMore(true);
                    this.a(packet, bl);
                    packet.clean();
                    packet.setHasMore(false);
                    simpleParameterList.a(i, packet);
                    bl = true;
                }
                if (!simpleParameterList.isStream(i)) continue;
                linkedList.add((StreamWrapper)simpleParameterList.getParameters()[i - 1].getValue());
            }
            bl = this.a(packet, MsgType.CMD_EXECUTE, bl, linkedList);
        }
        return this.a(statementImpl, packet, bl);
    }

    private boolean a(Packet packet, MsgType msgType, boolean bl, List list) throws SQLException {
        for (StreamWrapper streamWrapper : list) {
            int n = streamWrapper.getLength();
            Reader reader = streamWrapper.getReader();
            if (reader != null) {
                bl = this.a(reader, n, packet, msgType, bl);
                continue;
            }
            bl = this.a(streamWrapper.getStream(), n, packet, msgType, bl);
        }
        list.clear();
        return bl;
    }

    private boolean a(InputStream inputStream, int n, Packet packet, MsgType msgType, boolean bl) throws SQLException {
        try {
            byte[] byArray = new byte[Short.MAX_VALUE];
            while (n > 0) {
                boolean bl2 = false;
                if (packet.getRemainSize() > 3) {
                    int n2 = Math.min(Math.min(packet.getRemainSize() - 3, Short.MAX_VALUE), n);
                    if (packet.getRemainSize() - 3 == n2) {
                        bl2 = true;
                    }
                    if ((n2 = inputStream.read(byArray, 0, n2)) == -1) break;
                    if (n2 > 0) {
                        this.a(n2, packet);
                        n -= n2;
                        packet.writeBytes(byArray, 0, n2);
                    }
                } else {
                    bl2 = true;
                }
                bl = this.a(packet, msgType, bl, bl2);
            }
            packet.writeByte((byte)0);
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException("stream closed", YasState.IO_ERROR, (Throwable)iOException);
        }
        return bl;
    }

    private boolean a(Packet packet, MsgType msgType, boolean bl, boolean bl2) throws SQLException {
        if (bl2) {
            packet.setHasMore(true);
            this.b(packet, msgType, bl);
            packet.clean();
            packet.setHasMore(false);
            bl = true;
        }
        return bl;
    }

    private void a(int n, Packet packet) {
        if (n < 253) {
            packet.writeByte((byte)n);
        } else {
            packet.writeByte((byte)-3);
            packet.writeShort(n);
        }
    }

    private boolean a(Reader reader, int n, Packet packet, MsgType msgType, boolean bl) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(Short.MAX_VALUE);
        try {
            int n2;
            char[] cArray = new char[Short.MAX_VALUE];
            while (n > 0 && (n2 = reader.read(cArray)) != -1) {
                int n3 = 0;
                stringBuilder.setLength(0);
                stringBuilder.append(cArray);
                stringBuilder.setLength(Math.min(n, n2));
                byte[] byArray = stringBuilder.toString().getBytes(CharacterSet.getCharSet(this.charset));
                n -= n2;
                while (byArray.length - n3 > 0) {
                    if (packet.getRemainSize() > 3) {
                        int n4 = Math.min(Math.min(packet.getRemainSize() - 3, Short.MAX_VALUE), byArray.length - n3);
                        this.a(n4, packet);
                        packet.writeBytes(byArray, n3, n4);
                        n3 += n4;
                    }
                    if (packet.getRemainSize() > 3) continue;
                    packet.setHasMore(true);
                    this.b(packet, msgType, bl);
                    packet.clean();
                    packet.setHasMore(false);
                    bl = true;
                }
            }
            packet.writeByte((byte)0);
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException("stream closed", YasState.IO_ERROR, (Throwable)iOException);
        }
        return bl;
    }

    private Packet a(StatementImpl statementImpl, String string, ParameterList[] parameterListArray) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        PacketProcessor.writeReqDirectExecute(statementImpl, packet, parameterListArray, this.autoCommit, this.debugExecute);
        boolean bl = this.a(packet, string);
        LinkedList<StreamWrapper> linkedList = new LinkedList<StreamWrapper>();
        PacketProcessor.writeReqExecuteParamType(packet, parameterListArray);
        for (ParameterList parameterList : parameterListArray) {
            SimpleParameterList simpleParameterList = (SimpleParameterList)parameterList;
            for (int i = 1; i <= simpleParameterList.getParameterCount(); ++i) {
                if (packet.getRemainSize() > simpleParameterList.getLength(i)) {
                    simpleParameterList.a(i, packet);
                } else {
                    packet.setHasMore(true);
                    this.b(packet, bl);
                    packet.clean();
                    packet.setHasMore(false);
                    simpleParameterList.a(i, packet);
                    bl = true;
                }
                if (!simpleParameterList.isStream(i)) continue;
                linkedList.add((StreamWrapper)simpleParameterList.getParameters()[i - 1].getValue());
            }
            bl = this.a(packet, MsgType.CMD_DIRECT_EXECUTE, bl, linkedList);
        }
        return this.b(statementImpl, packet, bl);
    }

    private YasResultSet a(StatementImpl statementImpl, ParameterList[] parameterListArray, boolean bl) throws SQLException {
        try {
            this.a(parameterListArray);
            if (parameterListArray.length > 2000 || this.a(0, parameterListArray) != parameterListArray.length) {
                YasResultSet yasResultSet = this.a(statementImpl, parameterListArray);
                return yasResultSet;
            }
            Packet packet = this.b(statementImpl, parameterListArray);
            if (this.debugExecute) {
                YasResultSet yasResultSet = PacketProcessor.processExecuteAck(statementImpl, packet, this, DebugOperation.DBG_START);
                return yasResultSet;
            }
            YasResultSet yasResultSet = PacketProcessor.processExecuteAck(statementImpl, packet, this);
            return yasResultSet;
        }
        catch (SQLException sQLException) {
            if (bl && statementImpl.getIsBatchError()) {
                int[] nArray = new int[]{-3};
                BatchError batchError = new BatchError(sQLException.getErrorCode(), BatchError.converMsgToBatchMsg(sQLException.getMessage()));
                HashMap<Integer, BatchError> hashMap = new HashMap<Integer, BatchError>(Collections.singletonMap(0, batchError));
                ResultSetImpl resultSetImpl = new ResultSetImpl(0L, this.connection, statementImpl, nArray, hashMap);
                return resultSetImpl;
            }
            throw sQLException;
        }
        finally {
            this.d();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YasResultSet a(StatementImpl statementImpl, String string, ParameterList[] parameterListArray, boolean bl) throws SQLException {
        try {
            this.a(parameterListArray);
            if (parameterListArray.length > 2000 || this.a(0, parameterListArray) != parameterListArray.length) {
                YasResultSet yasResultSet = this.b(statementImpl, string, parameterListArray, bl);
                return yasResultSet;
            }
            Packet packet = this.a(statementImpl, string, parameterListArray);
            YasResultSet yasResultSet = PacketProcessor.processDirectExecuteAck(statementImpl, packet, this);
            return yasResultSet;
        }
        finally {
            this.d();
        }
    }

    private YasResultSet b(StatementImpl statementImpl, String string, ParameterList[] parameterListArray, boolean bl) throws SQLException {
        this.prepare(statementImpl, string);
        return this.execute(statementImpl, parameterListArray, 0, 0, 0, bl);
    }

    private int a(int n, ParameterList[] parameterListArray) {
        ParameterList parameterList = parameterListArray[n];
        for (int i = n + 1; i < parameterListArray.length; ++i) {
            ParameterList parameterList2 = parameterListArray[i];
            for (int j = 0; j < parameterList2.getParameterCount(); ++j) {
                if (parameterList.getParameters()[j].getType() == parameterList2.getParameters()[j].getType()) continue;
                return i - n;
            }
        }
        return parameterListArray.length;
    }

    private Packet a(StatementImpl statementImpl, Packet packet, boolean bl) throws SQLException {
        Packet packet2 = this.a(packet, MsgType.CMD_EXECUTE, bl);
        return PacketProcessor.processInteractPacket(statementImpl, packet2, this);
    }

    private Packet b(StatementImpl statementImpl, Packet packet, boolean bl) throws SQLException {
        Packet packet2 = this.a(packet, MsgType.CMD_DIRECT_EXECUTE, bl);
        return PacketProcessor.processInteractPacket(statementImpl, packet2, this);
    }

    private void a(Packet packet, boolean bl) throws SQLException {
        this.b(packet, MsgType.CMD_EXECUTE, bl);
    }

    private void b(Packet packet, boolean bl) throws SQLException {
        this.b(packet, MsgType.CMD_DIRECT_EXECUTE, bl);
    }

    private YasResultSet a(StatementImpl statementImpl) throws SQLException {
        if (statementImpl instanceof PreparedStatementImpl) {
            this.b(((PreparedStatementImpl)statementImpl).getSql());
        }
        Packet packet = this.protocol.getSendPacket();
        PacketProcessor.writeReqExecute(statementImpl, packet, this.autoCommit, this.debugExecute);
        Packet packet2 = this.a(packet, MsgType.CMD_EXECUTE, 0);
        packet2 = PacketProcessor.processInteractPacket(statementImpl, packet2, this);
        if (this.debugExecute) {
            return PacketProcessor.processExecuteAck(statementImpl, packet2, this, DebugOperation.DBG_START);
        }
        return PacketProcessor.processExecuteAck(statementImpl, packet2, this);
    }

    @Override
    public synchronized Packet fetch(YasStatement yasStatement, int n) throws SQLException {
        if (this.fetchingStreamRs) {
            if (yasStatement.getID() != this.streamRsStmtId) {
                throw SQLError.streamingResultFetchingException();
            }
            Packet packet = this.protocol.receivePacket();
            if (!PacketProcessor.hasMoreRows(packet)) {
                this.setFetchingStreamRs(false);
                this.setStreamRsStmtId(-1);
            }
            return packet;
        }
        Packet packet = this.protocol.getSendPacket();
        PacketProcessor.writeReqFetch(yasStatement, packet);
        return this.a(packet, MsgType.CMD_FETCH, 0);
    }

    @Override
    public synchronized Packet moreData() throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        try {
            return this.a(packet, MsgType.CMD_MORE_DATA, 0);
        }
        catch (SQLException sQLException) {
            if (YasState.IO_ERROR.getState().equals(sQLException.getSQLState())) {
                this.a(MsgType.CMD_MORE_DATA);
            }
            throw sQLException;
        }
    }

    public synchronized Packet moreData2() throws SQLException {
        try {
            this.j();
            return this.protocol.receivePacket();
        }
        catch (SQLException sQLException) {
            if (YasState.IO_ERROR.getState().equals(sQLException.getSQLState())) {
                this.a(MsgType.CMD_MORE_DATA);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        this.a(packet, MsgType.CMD_COMMIT, 0);
        this.setTransactionState(TransactionState.XACT_END);
        for (YasLargeObject yasLargeObject : this.updatedKnlLobs) {
            yasLargeObject.commit();
        }
        this.updatedKnlLobs.clear();
    }

    @Override
    public synchronized Packet continueExecute() throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        return this.a(packet, MsgType.CMD_MORE_DATA, 0);
    }

    private void e() throws SQLException {
        if (this.statement == null || this.statement.isClosed()) {
            this.statement = this.connection.createStatement();
        }
        if (this.statement.getFetchSize() == Integer.MIN_VALUE) {
            this.statement.setFetchSize(Integer.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKeyHost(String string) throws SQLException {
        boolean bl = false;
        ResultSet resultSet = null;
        try {
            String string2;
            this.statement = this.connection.createStatement();
            resultSet = this.statement.executeQuery("select DATABASE_ROLE from v$database");
            if (resultSet.next() && (string2 = resultSet.getString(1)).trim().equalsIgnoreCase(string)) {
                bl = true;
            }
            resultSet.close();
            this.statement.close();
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (this.statement != null) {
                this.statement.close();
            }
        }
        return bl;
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.failoverInTransaction = false;
        if (this.getTransactionState() == TransactionState.XACT_END) {
            LOGGER.debug("Rollback requested but no transaction in progress");
            return;
        }
        Packet packet = this.protocol.getSendPacket();
        this.a(packet, MsgType.CMD_ROLLBACK, 0);
        this.setTransactionState(TransactionState.XACT_END);
        for (YasLargeObject yasLargeObject : this.updatedKnlLobs) {
            yasLargeObject.rollback();
        }
        this.updatedKnlLobs.clear();
    }

    @Override
    public HostSpec getHostSpec() {
        return this.hostSpec;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public synchronized void setSchema(String string) throws SQLException {
        this.e();
        String string2 = "alter session set current_schema = " + string;
        this.statement.execute(string2);
        string = !string.contains("\"") ? string.toUpperCase() : string.substring(1, string.length() - 1);
        this.schema = string;
    }

    @Override
    public synchronized String getSchema() throws SQLException {
        return this.schema;
    }

    @Override
    public void setSID(int n) {
        this.sessionID = n;
    }

    @Override
    public void setCharset(short s) {
        this.charset = s;
    }

    @Override
    public void setSessionKey(int n) {
        this.sessionKey = n;
    }

    @Override
    public int getSessionKey() {
        return this.sessionKey;
    }

    @Override
    public String getDatabase() {
        return "";
    }

    @Override
    public void setNetworkTimeout(int n) throws IOException {
        this.yasSocketConnection.setNetworkTimeout(n);
    }

    @Override
    public int getNetworkTimeout() throws IOException {
        return this.yasSocketConnection.getNetworkTimeout();
    }

    @Override
    public void abort(Executor executor) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        executor.execute(() -> {
            int n = 3;
            this.closed = true;
            while (n-- > 0) {
                try {
                    this.yasSocketConnection.close();
                    break;
                }
                catch (Exception exception) {
                }
            }
            this.tempLobList.clear();
            this.updatedKnlLobs.clear();
            if (this.heartbeatOn) {
                connectionManager.unRegister(this);
            }
        });
    }

    public void setProtocol(NativeProtocol nativeProtocol) {
        this.protocol = nativeProtocol;
    }

    public void setYasSocketConnection(YasSocketConnection yasSocketConnection) {
        this.yasSocketConnection = yasSocketConnection;
    }

    private void f() throws SQLException {
        if (!this.fetchingStreamRs) {
            return;
        }
        this.fetchingStreamRs = false;
        ExecuteResult executeResult = new ExecuteResult(this.protocol.receivePacket());
        while (executeResult.hasMoreRows()) {
            executeResult = new ExecuteResult(this.protocol.receivePacket());
        }
    }

    private void g() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
            this.f();
            this.c();
        }
        catch (SQLException sQLException) {
            LOGGER.warn("Discarding SQLException on close: {}", (Object)sQLException.getMessage());
        }
        try {
            this.sendCloseMessage();
        }
        catch (SQLException sQLException) {
            LOGGER.warn("Discarding SQLException on close: {}", (Object)sQLException.getMessage());
        }
        try {
            this.yasSocketConnection.flush();
            this.yasSocketConnection.close();
        }
        catch (IOException iOException) {
            LOGGER.warn("Discarding IOException on close: {}", (Object)iOException.getMessage());
        }
        this.updatedKnlLobs.clear();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        LOGGER.debug(" FE=> Terminate");
        this.g();
        this.closed = true;
        if (this.heartbeatOn) {
            connectionManager.unRegister(this);
        }
    }

    @Override
    public boolean processInvalid() {
        if (!this.heartbeatNotified) {
            return false;
        }
        LOGGER.error("The heartbeat check failed, will force close socket.");
        if (this.ioError) {
            return true;
        }
        this.ioError = true;
        this.closeStream(this.yasSocketConnection);
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void closeStmt(int n) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        packet.writeShort(n);
        packet.writeShort(0);
        this.a(packet, MsgType.CMD_FREE_STMT, 0);
    }

    @Override
    public synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() {
        SQLWarning sQLWarning = this.warnings;
        this.warnings = null;
        return sQLWarning;
    }

    @Override
    public synchronized void setTransactionState(TransactionState transactionState) {
        this.transactionState = transactionState;
    }

    @Override
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        String string;
        this.e();
        switch (n) {
            case 8: {
                string = "SERIALIZABLE";
                break;
            }
            case 3: {
                string = "CURRENT COMMITTED";
                break;
            }
            default: {
                string = "READ COMMITTED";
            }
        }
        String string2 = "alter session set isolation_level = " + string;
        this.statement.execute(string2);
    }

    @Override
    public int getSID() {
        return this.sessionID;
    }

    public synchronized void setStandardConformingStrings(boolean bl) {
        this.standardConformingStrings = bl;
    }

    @Override
    public synchronized boolean getStandardConformingStrings() {
        return this.standardConformingStrings;
    }

    @Override
    public synchronized TransactionState getTransactionState() {
        return this.transactionState;
    }

    @Override
    public final Map getParameterStatuses() {
        return Collections.unmodifiableMap(this.parameterStatuses);
    }

    @Override
    public final String getParameterStatus(String string) {
        return (String)this.parameterStatuses.get(string);
    }

    protected synchronized void sendCloseMessage() throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        this.a(packet, MsgType.CMD_LOGOUT, 0);
    }

    @Override
    public void cancel() throws SQLException {
        int n = Utils.toMillisecond(YasProperty.CONNECT_TIMEOUT.getInt(this.info));
        try {
            YasSocketConnection yasSocketConnection = new YasSocketConnection(this.yasSocketConnection, n, true);
            NativeProtocol nativeProtocol = new NativeProtocol(this, yasSocketConnection);
            nativeProtocol.cancel(this.info, this.cancelSignalTimeout);
            this.closeStream(yasSocketConnection);
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException(Messages.get("The connection attempt failed.", new Object[0]), YasState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)iOException);
        }
    }

    @Override
    public void connect() throws SQLException {
        String string = this.connection.getServerType();
        HostConnector hostConnector = ConnectorFactory.generateConnector(this, this.hostSpecs, string);
        hostConnector.checkConfigurations(this.info);
        hostConnector.connect(this.getUser(), this.info);
        this.hostSpec = this.yasSocketConnection.getHostSpec();
        if (this.heartbeatOn) {
            connectionManager.register(this);
        }
    }

    protected void closeStream(YasSocketConnection yasSocketConnection) {
        if (yasSocketConnection != null) {
            try {
                yasSocketConnection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        YasSavepoint yasSavepoint = new YasSavepoint();
        this.e();
        String string = "savepoint yas_autosvpt_" + yasSavepoint.getSavepointId();
        this.statement.execute(string);
        return yasSavepoint;
    }

    @Override
    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        YasSavepoint yasSavepoint = new YasSavepoint(string);
        this.e();
        String string2 = "savepoint " + yasSavepoint.getSavepointName();
        this.statement.execute(string2);
        return yasSavepoint;
    }

    @Override
    public synchronized Savepoint releaseSavepoint(Savepoint savepoint) throws SQLException {
        String string = "RELEASE SAVEPOINT " + ((YasSavepoint)savepoint).getTypeInsensitiveName();
        this.statement.execute(string);
        return savepoint;
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.failoverInTransaction = false;
        if (savepoint == null) {
            return;
        }
        this.e();
        String string = ((YasSavepoint)savepoint).getTypeInsensitiveName();
        this.statement.execute("rollback to " + string);
        for (YasLargeObject yasLargeObject : this.updatedKnlLobs) {
            yasLargeObject.rollback();
        }
        this.updatedKnlLobs.clear();
    }

    @Override
    public boolean isUserCaseSensitive() {
        return this.userCaseSensitive;
    }

    @Override
    public ConnectVersion getConnectVersion() {
        return this.connectVersion;
    }

    @Override
    public void setConnectVersion(ConnectVersion connectVersion) {
        this.connectVersion = connectVersion;
    }

    @Override
    public long trimLob(YasLobProcessor yasLobProcessor, long l) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        byte by = PacketProcessor.getReqLobFlag(false, false, false);
        PacketProcessor.writeReqLob(packet, LobOperation.LOB_TRIM, yasLobProcessor, 0, l, by);
        Packet packet2 = this.a(packet, MsgType.CMD_LOB, 0);
        return PacketProcessor.processLobMetaDataAck(yasLobProcessor, packet2, LobOperation.LOB_TRIM);
    }

    @Override
    public void addUpdatedKnlLob(YasLargeObject yasLargeObject) {
        this.updatedKnlLobs.add(yasLargeObject);
    }

    @Override
    public void removeUpdatedKnlLob(YasLargeObject yasLargeObject) {
        this.updatedKnlLobs.remove(yasLargeObject);
    }

    @Override
    public YasClob preProcessReaderBinding(Reader reader, char[] cArray, long l) throws SQLException {
        YasClob yasClob = (YasClob)this.connection.createClob();
        StringBuilder stringBuilder = new StringBuilder(cArray.length);
        stringBuilder.append(cArray, 0, cArray.length);
        int n = Math.min(cArray.length, 2048);
        try {
            int n2;
            long l2 = l - (long)cArray.length;
            while (l2 > 0L && (n2 = reader.read(cArray, 0, (int)Math.min((long)n, l2))) >= 0) {
                if (n2 <= 0) continue;
                stringBuilder.append(cArray, 0, n2);
                l2 -= (long)n2;
                if (stringBuilder.length() < 40000 - n) continue;
                yasClob.setString(yasClob.length() + 1L, stringBuilder.toString());
                stringBuilder.setLength(0);
            }
            if (stringBuilder.length() > 0) {
                yasClob.setString(yasClob.length() + 1L, stringBuilder.toString());
                stringBuilder.setLength(0);
            }
        }
        catch (IOException iOException) {
            yasClob.free();
            throw SQLError.createSQLException(Messages.get("Access Provided Reader failed.", new Object[0]), YasState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
        this.tempLobList.add(yasClob);
        return yasClob;
    }

    @Override
    public synchronized YasResultSet pdbgExecute(YasDebugCallableStatement yasDebugCallableStatement, ParameterList[] parameterListArray) throws SQLException {
        return this.a((StatementImpl)yasDebugCallableStatement, parameterListArray, false, true);
    }

    private boolean h() {
        return this.connectVersion.getValue() < ConnectVersion.VER8.getValue();
    }

    @Override
    public synchronized void pdbgAbort(YasDebugCallableStatement yasDebugCallableStatement) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        if (this.h()) {
            PacketProcessor.writeReqDebug(yasDebugCallableStatement, packet, DebugOperation.DBG_ABORT, 0);
        } else {
            PacketProcessor.writeReqDebug2(yasDebugCallableStatement, packet, DebugOperation.DBG_ABORT, 0);
        }
        Packet packet2 = this.a(packet);
        packet2 = PacketProcessor.processInteractPacket(yasDebugCallableStatement, packet2, this);
        PacketProcessor.processExecuteAck(yasDebugCallableStatement, packet2, this, DebugOperation.DBG_ABORT);
    }

    @Override
    public synchronized void pdbgAddBreakpoint(YasDebugCallableStatement yasDebugCallableStatement, List list) throws SQLException {
        for (DebugBreakpoint debugBreakpoint : list) {
            Packet packet = this.protocol.getSendPacket();
            if (this.h()) {
                PacketProcessor.writeReqDebug(yasDebugCallableStatement, packet, DebugOperation.DBG_ADD_BP, 14);
                packet.writeLong(debugBreakpoint.getObjectId());
                packet.writeShort(debugBreakpoint.getSubprogramId());
                packet.writeInt(debugBreakpoint.getLineNum());
            } else {
                PacketProcessor.writeReqDebug2(yasDebugCallableStatement, packet, DebugOperation.DBG_ADD_BP, 1);
                packet.writeLong(debugBreakpoint.getObjectId());
                packet.writeShort(debugBreakpoint.getSubprogramId());
                packet.writeShort(0);
                packet.writeInt(debugBreakpoint.getLineNum());
            }
            Packet packet2 = this.a(packet);
            int n = (Integer)PacketProcessor.processDebugAck(this, yasDebugCallableStatement, packet2, DebugOperation.DBG_ADD_BP);
            debugBreakpoint.setId(n);
        }
    }

    @Override
    public synchronized void pdbgDeleteBreakpoint(YasDebugCallableStatement yasDebugCallableStatement, List list) throws SQLException {
        for (DebugBreakpoint debugBreakpoint : list) {
            Packet packet = this.protocol.getSendPacket();
            if (this.h()) {
                PacketProcessor.writeReqDebug(yasDebugCallableStatement, packet, DebugOperation.DBG_DEL_BP, 4);
            } else {
                PacketProcessor.writeReqDebug2(yasDebugCallableStatement, packet, DebugOperation.DBG_DEL_BP, 1);
            }
            packet.writeInt(debugBreakpoint.getId());
            Packet packet2 = this.a(packet);
            PacketProcessor.processDebugAck(this, yasDebugCallableStatement, packet2, DebugOperation.DBG_DEL_BP);
        }
    }

    @Override
    public synchronized void pdbgCheckVersion(YasDebugCallableStatement yasDebugCallableStatement, long l, int n, int n2) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        if (this.h()) {
            PacketProcessor.writeReqDebug(yasDebugCallableStatement, packet, DebugOperation.DBG_CHECK_VERSION, 14);
            packet.writeLong(l);
            packet.writeShort(n);
            packet.writeInt(n2);
        } else {
            PacketProcessor.writeReqDebug2(yasDebugCallableStatement, packet, DebugOperation.DBG_CHECK_VERSION, 0);
            packet.writeLong(l);
            packet.writeShort(n);
            packet.writeShort(0);
            packet.writeInt(n2);
        }
        Packet packet2 = this.a(packet);
        PacketProcessor.processDebugAck(this, yasDebugCallableStatement, packet2, DebugOperation.DBG_CHECK_VERSION);
    }

    @Override
    public synchronized YasResultSet pdbgStepDebug(YasDebugCallableStatement yasDebugCallableStatement, DebugOperation debugOperation) throws SQLException {
        try {
            Packet packet = this.protocol.getSendPacket();
            if (this.h()) {
                PacketProcessor.writeReqDebug(yasDebugCallableStatement, packet, debugOperation, 0);
            } else {
                PacketProcessor.writeReqDebug2(yasDebugCallableStatement, packet, debugOperation, 0);
            }
            Packet packet2 = this.a(packet);
            packet2 = PacketProcessor.processInteractPacket(yasDebugCallableStatement, packet2, this);
            return PacketProcessor.processExecuteAck(yasDebugCallableStatement, packet2, this, debugOperation);
        }
        catch (SQLException sQLException) {
            this.d();
            throw sQLException;
        }
    }

    private Packet a(Packet packet) throws SQLException {
        try {
            return this.a(packet, MsgType.CMD_DEBUG, 0);
        }
        catch (SQLException sQLException) {
            this.setDebugOff();
            throw sQLException;
        }
    }

    @Override
    public synchronized List pdbgShowVars(YasDebugCallableStatement yasDebugCallableStatement) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        if (this.h()) {
            PacketProcessor.writeReqDebug(yasDebugCallableStatement, packet, DebugOperation.DBG_SHOW_VARS, 0);
        } else {
            PacketProcessor.writeReqDebug2(yasDebugCallableStatement, packet, DebugOperation.DBG_SHOW_VARS, 0);
            packet.writeInt(0);
        }
        Packet packet2 = this.a(packet);
        return (List)PacketProcessor.processDebugAck(this, yasDebugCallableStatement, packet2, DebugOperation.DBG_SHOW_VARS);
    }

    @Override
    public synchronized List pdbgShowFrames(YasDebugCallableStatement yasDebugCallableStatement) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        if (this.h()) {
            PacketProcessor.writeReqDebug(yasDebugCallableStatement, packet, DebugOperation.DBG_SHOW_FRAMES, 0);
        } else {
            PacketProcessor.writeReqDebug2(yasDebugCallableStatement, packet, DebugOperation.DBG_SHOW_FRAMES, 0);
        }
        Packet packet2 = this.a(packet);
        return (List)PacketProcessor.processDebugAck(this, yasDebugCallableStatement, packet2, DebugOperation.DBG_SHOW_FRAMES);
    }

    @Override
    public void abortDebug() throws SQLException {
        if (this.debugOn) {
            this.pdbgAbort(this.runningDebugStatement);
        }
    }

    public void updateDebugStatus(YasDebugCallableStatement yasDebugCallableStatement, long l, int n, int n2) {
        if (!this.debugOn) {
            this.debugOn = true;
            this.runningDebugStatement = yasDebugCallableStatement;
        }
        this.runningDebugStatement.setDebugStatus(1, l, n, n2);
    }

    public void setDebugOff() {
        this.d();
        if (!this.debugOn) {
            return;
        }
        this.runningDebugStatement.setDebugStatus(0, -1L, -1, -1);
        this.debugOn = false;
        this.runningDebugStatement = null;
    }

    @Override
    public void addTempLob(YasLargeObject yasLargeObject) throws SQLException {
        this.tempLobList.add(yasLargeObject);
    }

    public void processHeartBeat() {
        this.heartbeatNotified = true;
    }

    @Override
    public void initFailoverProcessor() throws SQLException {
        String string = YasProperty.FAILOVER.get(this.info);
        String string2 = YasProperty.FAILOVER_TYPE.get(this.info);
        if (string != null && string.equalsIgnoreCase("on") && string2 != null && !string2.equalsIgnoreCase("none")) {
            this.yasFailoverProcessor = new YasFailoverProcessor(this, this.info, this.hostSpecs);
        }
    }

    private void a(MsgType msgType) throws SQLException {
        if (this.isMonitorSession || msgType == MsgType.CMD_LOGIN || msgType == MsgType.CMD_LOGOUT) {
            return;
        }
        this.closeStream(this.yasSocketConnection);
        if (this.heartbeatOn) {
            connectionManager.unRegister(this);
        }
        if (this.yasFailoverProcessor == null) {
            this.ioError = true;
            return;
        }
        this.ioError = false;
        this.failoverSuccess = false;
        SQLException sQLException = null;
        try {
            this.yasFailoverProcessor.doTransparentAppFailover();
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        if (!this.failoverSuccess) {
            this.ioError = true;
            this.connection.close();
        }
        if (sQLException != null) {
            throw sQLException;
        }
        if (this.yasFailoverProcessor.getFailoverType() != 2 || msgType == MsgType.CMD_MORE_DATA || msgType == MsgType.CMD_LOB) {
            throw SQLError.createSQLException("Cannot be safely called repeatedly.", YasState.QUERY_CANCELED);
        }
    }

    @Override
    public void addStatement(YasStatement yasStatement) {
        if (this.yasFailoverProcessor == null) {
            return;
        }
        if (this.allStatements == null) {
            this.allStatements = new HashSet();
        }
        this.allStatements.add(yasStatement);
    }

    @Override
    public void removeStatement(YasStatement yasStatement) {
        if (this.allStatements == null) {
            return;
        }
        this.allStatements.remove(yasStatement);
    }

    private void i() throws SQLException {
        try {
            this.connection.setTransactionIsolation(this.connection.getTransactionIsolation());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setSchema(this.schema);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.initSessionConfig();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.allStatements == null) {
            return;
        }
        for (YasStatement yasStatement : this.allStatements) {
            yasStatement.reset();
        }
    }

    private void j() throws SQLException {
        if (this.ioError) {
            throw SQLError.createSQLException(Messages.get("This socket has been closed.", new Object[0]), YasState.IO_ERROR);
        }
        if (this.failoverInTransaction) {
            throw SQLError.createSQLException(Messages.get("The transaction must be rerun.", new Object[0]), YasState.INVALID_TRANSACTION_TERMINATION);
        }
        this.a();
    }

    @Override
    public void refreshAfterFailover(YasLinkInfo yasLinkInfo) throws SQLException {
        this.setProtocol(yasLinkInfo.getProtocol());
        this.setYasSocketConnection(yasLinkInfo.getYasSocketConnection());
        this.ioError = false;
        this.hostSpec = this.yasSocketConnection.getHostSpec();
        if (this.heartbeatOn) {
            connectionManager.register(this);
        }
        this.failoverSuccess = true;
        boolean bl = this.getTransactionState() != TransactionState.XACT_END;
        try {
            this.i();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.failoverInTransaction = bl;
    }

    @Override
    public synchronized void detectHeartbeat() throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        this.protocol.sendCommand(packet, MsgType.CMD_PING, 0);
    }

    private Packet a(Packet packet, MsgType msgType, int n) throws SQLException {
        try {
            this.j();
            return this.protocol.sendCommand(packet, msgType, n);
        }
        catch (SQLException sQLException) {
            if (YasState.IO_ERROR.getState().equals(sQLException.getSQLState())) {
                this.a(msgType);
            }
            throw sQLException;
        }
    }

    private void a(Packet packet, MsgType msgType) throws SQLException {
        try {
            this.j();
            this.protocol.sendCommandOnly(packet, msgType);
        }
        catch (SQLException sQLException) {
            if (YasState.IO_ERROR.getState().equals(sQLException.getSQLState())) {
                this.a(msgType);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void registerTAFCallback(YasFailover yasFailover, Object object) throws SQLException {
        if (this.yasFailoverProcessor == null) {
            throw SQLError.createSQLException(Messages.get("Failover is not open.", new Object[0]), YasState.CHECK_VIOLATION);
        }
        this.yasFailoverProcessor.registerTAFCallback(yasFailover, object);
    }

    private Packet a(Packet packet, MsgType msgType, boolean bl) throws SQLException {
        Packet packet2 = bl ? this.a(packet, MsgType.CMD_MORE_DATA, 0) : this.a(packet, msgType, 0);
        return packet2;
    }

    private void b(Packet packet, MsgType msgType, boolean bl) throws SQLException {
        if (bl) {
            this.a(packet, MsgType.CMD_MORE_DATA);
        } else {
            this.a(packet, msgType);
        }
    }

    @Override
    public synchronized long getLobCharLength(YasLobProcessor yasLobProcessor) throws SQLException {
        Packet packet = this.protocol.getSendPacket();
        byte by = PacketProcessor.getReqLobFlag(false, false, true);
        PacketProcessor.writeReqLob(packet, LobOperation.LOB_GET_LEN, yasLobProcessor, 0, 0L, by);
        Packet packet2 = this.a(packet, MsgType.CMD_LOB, 0);
        return PacketProcessor.processLobMetaDataAck(yasLobProcessor, packet2, LobOperation.LOB_GET_LEN);
    }

    private void b(String string) {
        if (!SHUTDOWN_PATTERN.matcher(string).find()) {
            return;
        }
        if (this.heartbeatOn) {
            connectionManager.unRegister(this);
        }
    }

    public int getHeartbeatSocketTimeout() {
        return this.heartbeatSocketTimeout;
    }

    public int getHeartbeatSchedulePeriod() {
        return this.heartbeatSchedulePeriod;
    }

    public void setFetchingStreamRs(boolean bl) {
        this.fetchingStreamRs = bl;
    }

    public void setStreamRsStmtId(int n) {
        this.streamRsStmtId = n;
    }

    @Override
    public void setServerSendTimeout(int n) {
        this.serverSendTimeout = n;
    }

    @Override
    public int getServerSendTimeout() {
        return this.serverSendTimeout;
    }

    @Override
    public void initSessionConfig() throws SQLException {
        int n = ((ConnectionImpl)this.connection).getStreamRsNetTimeout();
        if (this.serverSendTimeout != n) {
            this.e();
            this.statement.execute("alter session set PACKET_SEND_TIMEOUT = " + n);
            this.serverSendTimeout = n;
        }
    }

    @Override
    public Class getMappedClass(String string) throws SQLException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        Map<String, Class<?>> map = this.getConnection().getTypeMap();
        Class<?> clazz = map.get(string.toUpperCase());
        if (clazz != null) {
            return clazz;
        }
        string = this.getSchema().toUpperCase() + "." + string.toUpperCase();
        return map.get(string);
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        if (string == null) {
            throw SQLError.createSQLException("typeName cannot be null.", YasState.DATA_ERROR);
        }
        YasTypeDescriptor yasTypeDescriptor = YasTypeDescriptor.getInstance(this, string.toUpperCase());
        int n = yasTypeDescriptor.getAttrTypes().size();
        YasStruct yasStruct = new YasStruct(string);
        yasStruct.setTypeDescriptor(yasTypeDescriptor);
        yasStruct.setToid(yasTypeDescriptor.getToid());
        Object[] objectArray2 = new Object[n];
        if (objectArray != null) {
            if (objectArray.length > n) {
                throw SQLError.createSQLException("Too much data.", YasState.DATA_ERROR);
            }
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        }
        yasStruct.setAttributes(objectArray2);
        return yasStruct;
    }

    @Override
    public Array createArray(String string, Object[] objectArray) throws SQLException {
        YasTypeDescriptor yasTypeDescriptor = YasTypeDescriptor.getInstance(this, string.toUpperCase());
        YasArray yasArray = new YasArray(this);
        yasArray.setYasTypeDescriptor(yasTypeDescriptor);
        yasArray.setToid(yasTypeDescriptor.getToid());
        yasArray.setElementTypeCode(yasTypeDescriptor.getElementType());
        if (objectArray == null) {
            objectArray = YasArray.createElementArray(0, yasTypeDescriptor.getElementType());
        }
        yasArray.setElements(objectArray);
        return yasArray;
    }

    @Override
    public Map getTypeMap() {
        if (this.typeMap == null) {
            this.typeMap = new HashMap();
        }
        return this.typeMap;
    }

    @Override
    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    @Override
    public Class getTypeClass(String string) {
        if (this.typeMap == null || !this.typeMap.containsKey(string)) {
            return null;
        }
        return (Class)this.typeMap.get(string);
    }

    @Override
    public YasTypeDescriptor getTypeShapeCache(String string) {
        return this.typeShapeCache.getOrDefault(string, null);
    }

    @Override
    public void setTypeShapeCache(String string, YasTypeDescriptor yasTypeDescriptor) {
        this.typeShapeCache.put(string, yasTypeDescriptor);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public boolean getMapDateToTimestamp() {
        return this.mapDateToTimestamp;
    }

    @Override
    public void xaCommit(Xid xid, int n, int n2) throws SQLException, XAException {
        Packet packet = PacketProcessor.getXAReqPacket(this.protocol.getSendPacket(), (byte)5, xid, n, n2);
        this.a(packet, MsgType.CMD_XA, 0);
    }

    @Override
    public void xaEnd(Xid xid, int n, int n2) throws SQLException, XAException {
        Packet packet = PacketProcessor.getXAReqPacket(this.protocol.getSendPacket(), (byte)2, xid, n, n2);
        this.a(packet, MsgType.CMD_XA, 0);
    }

    @Override
    public void xaForget(Xid xid, int n) throws SQLException, XAException {
        Packet packet = PacketProcessor.getXAReqPacket(this.protocol.getSendPacket(), (byte)3, xid, 0, n);
        this.a(packet, MsgType.CMD_XA, 0);
    }

    @Override
    public int xaPrepare(Xid xid, int n) throws SQLException, XAException {
        Packet packet = PacketProcessor.getXAReqPacket(this.protocol.getSendPacket(), (byte)4, xid, 0, n);
        Packet packet2 = this.a(packet, MsgType.CMD_XA, 0);
        byte by = packet2.getByte();
        return by == 0 ? 0 : 3;
    }

    @Override
    public void xaRollback(Xid xid, int n) throws SQLException, XAException {
        Packet packet = PacketProcessor.getXAReqPacket(this.protocol.getSendPacket(), (byte)6, xid, 0, n);
        this.a(packet, MsgType.CMD_XA, 0);
    }

    @Override
    public void xaStart(Xid xid, int n, int n2) throws SQLException, XAException {
        Packet packet = PacketProcessor.getXAReqPacket(this.protocol.getSendPacket(), (byte)1, xid, n, n2);
        this.a(packet, MsgType.CMD_XA, 0);
    }
}

