/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb;

import com.yashandb.ParameterList;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.parameter.ParameterFactory;
import com.yashandb.parameter.ParameterLittleEndianFactory;
import com.yashandb.parameter.StreamParameter;
import com.yashandb.parameter.YasParameter;
import com.yashandb.protocol.Packet;
import com.yashandb.util.Messages;
import com.yashandb.util.StreamWrapper;
import com.yashandb.util.Utils;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;

public class SimpleParameterList
implements ParameterList,
Cloneable {
    private ParameterFactory parameterFactory = new ParameterLittleEndianFactory();
    private YasParameter[] yasParameters;
    private boolean bindTypeChanged = false;
    private int pos = 0;
    private short charset = 0;
    private short nCharset = 0;

    public SimpleParameterList(int n) {
        this.yasParameters = new YasParameter[n];
    }

    @Override
    public void setCharset(short s) {
        this.charset = s;
    }

    @Override
    public void setNCharset(short s) {
        this.nCharset = s;
    }

    private boolean a(int n, Object object, int n2) {
        if (this.yasParameters[n] == null) {
            return false;
        }
        return n2 == 0 && object == ParameterFactory.getNullObject() && this.yasParameters[n].getType() != 0;
    }

    private void a(int n) throws SQLException {
        if (n < 1 || n > this.yasParameters.length) {
            throw SQLError.createSQLException(Messages.get("The column index is out of range: {0}, number of columns: {1}.", n, this.yasParameters.length), YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public boolean bindTypeChanged() {
        return this.bindTypeChanged;
    }

    @Override
    public void resetBindTypeFlag() {
        this.bindTypeChanged = false;
    }

    private void b(int n, Object object, int n2) throws SQLException {
        this.a(n);
        if (this.a(--n, object, n2)) {
            this.yasParameters[n].setValue(ParameterFactory.getNullObject());
            this.yasParameters[n].setInDirection();
            return;
        }
        if (this.yasParameters[n] == null || this.yasParameters[n].getType() != n2) {
            YasParameter yasParameter;
            this.bindTypeChanged = true;
            this.yasParameters[n] = yasParameter = this.parameterFactory.getParameter(n2);
        }
        this.yasParameters[n].setValue(object);
        this.yasParameters[n].setInDirection();
        if (this.yasParameters[n].getType() == 27) {
            this.yasParameters[n].setCharset(this.nCharset);
        } else {
            this.yasParameters[n].setCharset(this.charset);
        }
        this.pos = n + 1;
    }

    @Override
    public int getParameterCount() {
        return this.yasParameters.length;
    }

    @Override
    public int getInParameterCount() {
        int n = 0;
        for (YasParameter yasParameter : this.yasParameters) {
            if (yasParameter.isOutParameter()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void replace(int n, YasParameter yasParameter) throws SQLException {
        if (n < 0 || n >= this.yasParameters.length) {
            throw SQLError.createSQLException(Messages.get("Invalid parameter index", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        this.yasParameters[n] = yasParameter;
    }

    @Override
    public void setIntParameter(int n, long l, int n2) throws SQLException {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.b(n, (int)l, n2);
                break;
            }
            case 5: {
                this.b(n, l, n2);
                break;
            }
            default: {
                throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setIntParameter with type " + n2);
            }
        }
    }

    @Override
    public void setDoubleParameter(int n, double d, int n2) throws SQLException {
        this.b(n, d, n2);
    }

    @Override
    public void setFloatParameter(int n, float f, int n2) throws SQLException {
        this.b(n, Float.valueOf(f), n2);
    }

    @Override
    public void setNumberParameter(int n, Number number, int n2) throws SQLException {
        this.b(n, number, n2);
    }

    @Override
    public void setStringParameter(int n, String string) throws SQLException {
        this.b(n, string, 26);
    }

    @Override
    public void setNStringParameter(int n, String string) throws SQLException {
        this.b(n, string, 27);
    }

    @Override
    public void setDateParameter(int n, Date date, int n2) throws SQLException {
        this.b(n, date, n2);
    }

    @Override
    public void setTimeStampParameter(int n, Timestamp timestamp, int n2) throws SQLException {
        this.b(n, timestamp, n2);
    }

    @Override
    public void setTimeParameter(int n, Time time, int n2) throws SQLException {
        this.b(n, time, n2);
    }

    @Override
    public void setDsIntervalParameter(int n, long l, int n2) throws SQLException {
        this.b(n, l, n2);
    }

    @Override
    public void setYmIntervalParameter(int n, int n2, int n3) throws SQLException {
        this.b(n, n2, n3);
    }

    @Override
    public void setClobParameter(int n, Clob clob, int n2) throws SQLException {
        this.b(n, clob, n2);
    }

    @Override
    public void setBlobParameter(int n, Blob blob, int n2) throws SQLException {
        this.b(n, blob, n2);
    }

    @Override
    public void setUdtParameter(int n, byte[] byArray, int n2) throws SQLException {
        this.b(n, new StreamWrapper(byArray, 0, byArray.length), n2);
    }

    @Override
    public void setBinaryParameter(int n, byte[] byArray, int n2) throws SQLException {
        this.b(n, byArray, n2);
    }

    @Override
    public void setBytea(int n, byte[] byArray, int n2, int n3) throws SQLException {
        if (n3 < 32000) {
            this.b(n, new StreamWrapper(byArray, n2, n3), 28);
            return;
        }
        this.b(n, new StreamWrapper(byArray, n2, n3), -1);
    }

    @Override
    public void setBytea(int n, InputStream inputStream, int n2) throws SQLException {
        this.b(n, new StreamWrapper(inputStream, n2), 28);
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.b(n, ParameterFactory.getNullObject(), 26);
    }

    @Override
    public void setRowIdParameter(int n, RowId rowId) throws SQLException {
        this.b(n, rowId, 32);
    }

    @Override
    public void registerOutParameter(int n, int n2) throws SQLException {
        this.a(n);
        if (this.yasParameters[--n] == null) {
            YasParameter yasParameter;
            this.yasParameters[n] = yasParameter = this.parameterFactory.getParameter(n2);
        }
        this.yasParameters[n].setType(n2);
        this.yasParameters[n].setOutDirection();
    }

    @Override
    public String toString(int n, boolean bl) {
        if (this.yasParameters[--n] == null) {
            return "?";
        }
        if (this.yasParameters[n].isValueNull()) {
            return "NULL";
        }
        String string = this.yasParameters[n].getValue().toString();
        StringBuilder stringBuilder = new StringBuilder(3 + (string.length() + 10) / 10 * 11);
        stringBuilder.append('\'');
        try {
            stringBuilder = Utils.escapeLiteral(stringBuilder, string, bl);
        }
        catch (SQLException sQLException) {
            stringBuilder.append(string);
        }
        stringBuilder.append('\'');
        int n2 = this.yasParameters[n].getType();
        if (n2 == 12) {
            stringBuilder.append("::numeric");
        } else if (n2 == 16) {
            stringBuilder.append("::timestamp");
        } else if (n2 == 17) {
            stringBuilder.append("::timestamp with time zone");
        } else if (n2 == 13) {
            stringBuilder.append("::date");
        }
        return stringBuilder.toString();
    }

    public int getLength(int n) throws SQLException {
        return this.yasParameters[--n].getLength();
    }

    int a(int n, Packet packet) throws SQLException {
        return this.yasParameters[--n].writeValue(packet);
    }

    public SimpleParameterList clone() throws CloneNotSupportedException {
        Object object = super.clone();
        SimpleParameterList simpleParameterList = (SimpleParameterList)object;
        if (this.yasParameters != null) {
            simpleParameterList.yasParameters = (YasParameter[])this.yasParameters.clone();
            for (int i = 0; i < this.yasParameters.length; ++i) {
                simpleParameterList.yasParameters[i] = this.yasParameters[i].getCloneInstance();
            }
        }
        return simpleParameterList;
    }

    private void a() throws SQLException {
        if (this.yasParameters == null) {
            return;
        }
        for (int i = 0; i < this.yasParameters.length; ++i) {
            if (this.yasParameters[i] != null) continue;
            throw SQLError.createSQLException(Messages.get("Parameter is missing,index: {0}", i + 1), YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public ParameterList copy() throws SQLException {
        this.a();
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SQLException(cloneNotSupportedException.getMessage());
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.yasParameters, null);
        this.pos = 0;
    }

    @Override
    public YasParameter[] getParameters() {
        return this.yasParameters;
    }

    @Override
    public void appendAll(ParameterList parameterList) throws SQLException {
        if (parameterList instanceof SimpleParameterList) {
            SimpleParameterList simpleParameterList = (SimpleParameterList)parameterList;
            int n = simpleParameterList.getInParameterCount();
            if (this.pos + n > this.yasParameters.length) {
                throw SQLError.createSQLException(Messages.get("Added parameters index out of range: {0}, number of columns: {1}.", this.pos + n, this.yasParameters.length), YasState.INVALID_PARAMETER_VALUE);
            }
            try {
                for (YasParameter yasParameter : parameterList.getParameters()) {
                    this.yasParameters[this.pos] = yasParameter.getCloneInstance();
                    ++this.pos;
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new SQLException(cloneNotSupportedException.getMessage());
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("<[");
        if (this.yasParameters.length > 0) {
            stringBuilder.append(this.toString(1, true));
            for (int i = 2; i <= this.yasParameters.length; ++i) {
                stringBuilder.append(" ,").append(this.toString(i, true));
            }
        }
        stringBuilder.append("]>");
        return stringBuilder.toString();
    }

    @Override
    public boolean isStream(int n) {
        return this.yasParameters[n - 1] instanceof StreamParameter && this.yasParameters[n - 1].getValue() instanceof StreamWrapper;
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.b(n, new StreamWrapper(inputStream, n2), -2);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.b(n, new StreamWrapper(inputStream, n2), -1);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.b(n, new StreamWrapper(reader, n2), -2);
    }

    @Override
    public void setJsonBytes(int n, byte[] byArray) throws SQLException {
        this.b(n, new StreamWrapper(byArray, 0, byArray.length), -3);
    }

    @Override
    public void setJsonStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.b(n, new StreamWrapper(inputStream, n2), -3);
    }
}

