/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.conf;

import com.yashandb.conf.HostSpec;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.util.Messages;
import com.yashandb.util.URLCoder;
import java.sql.SQLException;
import java.util.Properties;

public class ConnectionUrl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionUrl.class.getName());
    private final Properties props;
    private final String url;
    private HostSpec[] specs;
    private static final String DBNAME = "DBNAME";
    private static final String INVALID_PORT = "JDBC URL has invalid port number, url: {0}";

    public static boolean acceptsUrl(String string) throws SQLException {
        if (string == null) {
            throw new SQLException("url is null");
        }
        return ConnectionUrl.parseURL(string, null) != null;
    }

    public static Properties parseURL(String string, Properties properties) throws SQLException {
        Properties properties2 = new Properties(properties);
        String string2 = "";
        String string3 = string;
        if (string.contains("?")) {
            String[] stringArray = string.trim().split("\\?");
            string3 = stringArray[0];
            String string4 = string2 = stringArray.length > 1 ? stringArray[1] : "";
        }
        if (string3.indexOf("jdbc:yasdb:") != 0) {
            LOGGER.debug("JDBC URL must start with \"jdbc:yasdb:\" but was: {}", (Object)string);
            return null;
        }
        if ((string3 = string3.substring("jdbc:yasdb:".length())).contains("://")) {
            int n = string3.indexOf(58);
            String string5 = string3.substring(0, n);
            properties2.setProperty("SERVER_TYPE", string5);
            string3 = string3.substring(n + 1);
        }
        if (string3.startsWith("//")) {
            int n = (string3 = string3.substring(2)).indexOf(47);
            if (n == -1) {
                LOGGER.warn("JDBC URL must contain a / at the end of the host or port: {}", (Object)string);
                throw SQLError.createSQLException(Messages.get("JDBC URL must contain a / at the end of the host or port: {0}", string), YasState.INVALID_PARAMETER_VALUE);
            }
            properties2.setProperty(DBNAME, URLCoder.decode(string3.substring(n + 1)));
            properties2 = ConnectionUrl.a(string, properties2, string3, n);
            if (properties2 == null) {
                return null;
            }
        } else if (properties == null || !properties.containsKey(DBNAME)) {
            properties2.setProperty(DBNAME, URLCoder.decode(string3));
        }
        ConnectionUrl.a(properties2, string2);
        return properties2;
    }

    private static void a(Properties properties, String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("&")) {
            if (!string2.contains("=")) {
                properties.setProperty(string2, "");
                continue;
            }
            String[] stringArray2 = string2.trim().split("=");
            properties.setProperty(stringArray2[0], URLCoder.decode(stringArray2.length > 1 ? stringArray2[1] : ""));
        }
    }

    private static Properties a(String string, Properties properties, String string2, int n) throws YasException {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String[] stringArray = string2.substring(0, n).split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            String string3 = stringArray[i];
            if (i != 0) {
                stringBuilder2.append(',');
                stringBuilder.append(',');
            }
            if ((n2 = string3.lastIndexOf(58)) == -1 || string3.lastIndexOf(93) > n2) {
                LOGGER.error("JDBC URL port number is invalid");
                throw SQLError.createSQLException(Messages.get(INVALID_PORT, string), YasState.INVALID_PARAMETER_VALUE);
            }
            String string4 = string3.substring(n2 + 1);
            try {
                int n3 = Integer.parseInt(string4);
                if (n3 < 1 || n3 > 65535) {
                    LOGGER.warn("JDBC URL port: {0} must be in (1:65535)", (Object)string4);
                    throw SQLError.createSQLException(Messages.get(INVALID_PORT, string), YasState.INVALID_PARAMETER_VALUE);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.warn("JDBC URL port number: {0} is invalid", (Object)string4);
                throw SQLError.createSQLException(Messages.get(INVALID_PORT, string), YasState.INVALID_PARAMETER_VALUE);
            }
            stringBuilder2.append(string4);
            stringBuilder.append(string3.subSequence(0, n2));
        }
        properties.setProperty("HOST", stringBuilder.toString());
        properties.setProperty("PORT", stringBuilder2.toString());
        return properties;
    }

    public static ConnectionUrl getInstance(String string, Properties properties) throws SQLException {
        Properties properties2 = new Properties();
        if (properties != null) {
            for (String string2 : properties.stringPropertyNames()) {
                String string3 = properties.getProperty(string2);
                if (string3 == null) {
                    throw SQLError.createSQLException(Messages.get("Properties for the driver contains a non-string value for the key ", new Object[0]) + string2, YasState.UNEXPECTED_ERROR);
                }
                properties2.setProperty(string2, string3);
            }
        }
        if ((properties2 = ConnectionUrl.parseURL(string, properties2)) == null) {
            return null;
        }
        return new ConnectionUrl(string, properties2);
    }

    public Properties getProps() {
        return this.props;
    }

    public String getUrl() {
        return this.url;
    }

    public String getServerType() {
        String string = this.props.getProperty("SERVER_TYPE");
        if (string == null || string.isEmpty()) {
            string = this.getHostSpecs().length == 1 ? "StandAlone" : "primary";
        }
        return string;
    }

    private ConnectionUrl(String string, Properties properties) {
        this.props = properties;
        this.url = string;
    }

    public HostSpec[] getHostSpecs() {
        if (this.specs == null) {
            String string = this.props.getProperty("HOST");
            String string2 = this.props.getProperty("PORT");
            if (string == null || string2 == null) {
                return null;
            }
            String[] stringArray = string.split(",");
            String[] stringArray2 = string2.split(",");
            this.specs = new HostSpec[stringArray.length];
            for (int i = 0; i < this.specs.length; ++i) {
                this.specs[i] = new HostSpec(stringArray[i], Integer.parseInt(stringArray2[i]));
            }
        }
        return this.specs;
    }

    public String user() {
        return this.props.getProperty("user", "");
    }

    public String database() {
        return this.props.getProperty(DBNAME, "");
    }
}

