/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.conf;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.util.Messages;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public enum YasProperty {
    PASSWORD("password", null, "Password to use when authenticating.", false),
    USER("user", null, "Username to connect to the database as.", true),
    HOST("HOST", null, "Hostname of the YashanDB server (may be specified directly in the JDBC URL)", false),
    PORT("PORT", null, "Port of the YashanDB server (may be specified directly in the JDBC URL)"),
    PROGRAM_NAME("ProgramName", "YashanDB JDBC Driver", "The fully qualified path for the file that contains the specified module"),
    DEFAULT_ROW_FETCH_SIZE("defaultRowFetchSize", "10", "Positive number of rows that should be fetched from the database when more rows are needed for ResultSet by each fetch iteration"),
    LOGGER_FILE("loggerFile", null, "File name output of the Logger"),
    LOGGER_LEVEL("loggerLevel", null, "Logger level of the driver", false, new String[]{"OFF", "DEBUG", "TRACE"}),
    LOG_SERVER_ERROR_DETAIL("logServerErrorDetail", "true", "Include full server error detail in exception messages. If disabled then only the error itself will be included."),
    LOG_UNCLOSED_CONNECTIONS("logUnclosedConnections", "false", "When connections that are not explicitly closed are garbage collected, log the stacktrace from the opening of the connection to trace the leak source"),
    CANCEL_SIGNAL_TIMEOUT("cancelSignalTimeout", "10", "The timeout that is used for sending cancel command."),
    CONNECT_TIMEOUT("connectTimeout", "10", "The timeout value used for socket connect operations."),
    LOGIN_TIMEOUT("loginTimeout", "300", "Specify how long to wait for establishment of a database connection."),
    SOCKET_TIMEOUT("socketTimeout", "0", "The timeout value used for socket read operations."),
    SERVER_MODE("serverMode", "shared", "Dedicated or Shared server mode."),
    POOL_TIMEOUT("poolTimeout", "300", "The timeout value used for connect primary host using configured ips"),
    RECEIVE_BUFFER_SIZE("receiveBufferSize", "-1", "Socket read buffer size"),
    SEND_BUFFER_SIZE("sendBufferSize", "-1", "Socket write buffer size"),
    SSL_ROOT_CER("sslRootCer", "", "SSL Certificate Root Path", false),
    TLCP_CACERT_FILE("tlcpCacertFile", null, "TLCP Certificate Root Path", false),
    TLCP_CERT_FILE("tlcpCertFile", null, "TLCP client cert file path", false),
    TLCP_CLIENT_KEY_FILE("tlcpClientKeyFile", null, "TLCP client key file path", false),
    TLCP_CLIENT_KEY_PASS("tlcpClientKeyPass", null, "TLCP client key password", false),
    UKEY_NAME("UKeyName", "", "", false),
    UKEY_PIN("UKeyPin", "", "TLCP client key password", false),
    TCP_KEEP_ALIVE("tcpKeepAlive", "true", "Enable or disable TCP keep-alive. The default is {@code true}."),
    FAILOVER("failover", "OFF", "Enable or disable Transpant Application Failover", false, new String[]{"ON", "OFF"}),
    FAILOVER_TYPE("failoverType", "NONE", "Transparent Application Failover type", false, new String[]{"NONE", "SELECT", "SESSION"}),
    FAILOVER_METHOD("failoverMethod", "BASIC", "Transparent Application Failover method", false, new String[]{"BASIC", "PRECONNECT"}),
    FAILOVER_RETRIES("failoverRetries", "5", "Transparent Application Failover number of reconnect attempts"),
    FAILOVER_DELAY("failoverDelay", "1", "Transparent Application Failover try reconnect interval"),
    HEARTBEAT_SWITCH("heartbeatSwitch", "ON", "Specify whether heartbeat is turned on.", false, new String[]{"OFF", "ON"}),
    HEARTBEAT_SOCKET_TIMEOUT("heartbeatSocketTimeout", "60", "Specify how long to wait for heartbeat connection."),
    HEARTBEAT_SCHEDULE_PERIOD("heartbeatSchedulePeriod", "20", "Specifies the heartbeat interval."),
    CLIENT_PREPARE("clientPrepare", "false", "Enable or disable directExecute with bind parameters. The default is {@code false}.If disabled, the client will firstly send prepare sql, then send bind parameters, otherwise send them together to server."),
    NET_TIMEOUT_FOR_STREAMING_RESULTS("netTimeoutForStreamingResults", "600", ""),
    PRODUCT_NAME("productName", "YashanDB", ""),
    MAP_DATE_TO_TIMESTAMP("mapDateToTimestamp", "FALSE", "Enable or disable the interface getString getObject in date types to return timestamp", false, new String[]{"TRUE", "FALSE"});

    private final String name;
    private final String defaultValue;
    private final boolean required;
    private final String description;
    private final String[] choices;
    private boolean deprecated;
    private static final Map PROPS_BY_NAME;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private YasProperty(String string3) {
        this((String)var1_-1, (int)var2_-1, string3, (String)var4_2, (String)var5_3, false);
        void var5_3;
        void var4_2;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private YasProperty(String string3, boolean bl) {
        this((String)var1_-1, (int)var2_-1, string3, (String)bl, (String)var5_3, (boolean)var6_4, null);
        void var6_4;
        void var5_3;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private YasProperty(String string3, boolean bl, String[] stringArray) {
        void var7_5;
        void var6_4;
        this.defaultValue = (String)bl;
        this.description = stringArray;
        this.required = var6_4;
        this.choices = var7_5;
        this.name = string3;
        try {
            this.deprecated = YasProperty.class.getField(this.name()).getAnnotation(Deprecated.class) != null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.deprecated = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public String getString(Properties properties) {
        Object object = properties.get(this.name);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public String get(Properties properties) {
        return properties.getProperty(this.name, this.defaultValue);
    }

    public String checkExistAndGet(Properties properties) throws SQLException {
        String string = properties.getProperty(this.name);
        if (string == null || string.equals("")) {
            throw SQLError.createSQLException(this.name + " can not be null", YasState.UNKNOWN_STATE);
        }
        return string;
    }

    public boolean getBoolean(Properties properties) {
        return Boolean.valueOf(this.get(properties));
    }

    public int getInt(Properties properties) throws YasException {
        String string = this.get(properties);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw SQLError.createSQLException(Messages.get("{0} parameter value must be an integer but was: {1}", this.getName(), string), YasState.INVALID_PARAMETER_VALUE, (Throwable)numberFormatException);
        }
    }

    public void set(Properties properties, String string) {
        if (string != null) {
            properties.setProperty(this.name, string);
        } else {
            properties.remove(this.name);
        }
    }

    public void set(Properties properties, boolean bl) {
        properties.setProperty(this.name, String.valueOf(bl));
    }

    public void set(Properties properties, int n) {
        properties.setProperty(this.name, String.valueOf(n));
    }

    public boolean isPresent(Properties properties) {
        return this.getString(properties) != null;
    }

    public DriverPropertyInfo toDriverPropertyInfo(Properties properties) {
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(this.name, this.get(properties));
        driverPropertyInfo.required = this.required;
        driverPropertyInfo.description = this.description;
        driverPropertyInfo.choices = this.choices;
        return driverPropertyInfo;
    }

    static {
        PROPS_BY_NAME = new HashMap();
        for (YasProperty yasProperty : YasProperty.values()) {
            if (PROPS_BY_NAME.put(yasProperty.getName(), yasProperty) == null) continue;
            throw new IllegalStateException("Duplicate YasProperty name: " + yasProperty.getName());
        }
    }
}

