/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.core;

import com.yashandb.jdbc.YasTypes;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class DataType {
    public static final int RAW_STREAM = -1;
    public static final int VARCHAR_STREAM = -2;
    public static final int JSON_STREAM = -3;
    public static final int UNKNOWN = 0;
    public static final int BOOLEAN = 1;
    public static final int TINYINT = 2;
    public static final int SMALLINT = 3;
    public static final int INTEGER = 4;
    public static final int BIGINT = 5;
    public static final int UTINYINT = 6;
    public static final int USMALLINT = 7;
    public static final int UINTEGER = 8;
    public static final int UBIGINT = 9;
    public static final int FLOAT = 10;
    public static final int BINARY_FLOAT = 40;
    public static final int DOUBLE = 11;
    public static final int NUMBER = 12;
    public static final int DATE = 13;
    public static final int SHORTDATE = 14;
    public static final int SHORTTIME = 15;
    public static final int TIMESTAMP = 16;
    public static final int TIMESTAMP_TZ = 17;
    public static final int TIMESTAMP_LTZ = 18;
    public static final int YM_INTERVAL = 19;
    public static final int DS_INTERVAL = 20;
    public static final int CHAR = 24;
    public static final int NCHAR = 25;
    public static final int VARCHAR = 26;
    public static final int NVARCHAR = 27;
    public static final int RAW = 28;
    public static final int CLOB = 29;
    public static final int BLOB = 30;
    public static final int BIT = 31;
    public static final int ROWID = 32;
    public static final int NCLOB = 33;
    public static final int CURSOR = 34;
    public static final int JSON = 35;
    public static final int UDT_OBJECT = 36;
    public static final int UDT_ARRAY = 37;
    public static final int UDT_TABLE = 38;
    public static final int XMLTYPE = 39;
    public static final int RECORD = 247;
    private static final Map TYPE_TO_NAME = new HashMap(100);
    private static final Map NAME_TO_TYPE = new HashMap(100);

    public static String getTypeName(int n) {
        String string = (String)TYPE_TO_NAME.get(n);
        if (string == null) {
            string = "<unknown:" + n + ">";
        }
        return string;
    }

    public static boolean isUdtType(int n) {
        if (n == 36) {
            return true;
        }
        if (n == 37) {
            return true;
        }
        return n == 38;
    }

    private DataType() {
    }

    public static int getSQLType(int n) {
        return YasTypes.getSQLType(n);
    }

    static {
        for (Field field : DataType.class.getFields()) {
            try {
                int n = field.getInt(null);
                String string = field.getName().toUpperCase();
                TYPE_TO_NAME.put(n, string);
                NAME_TO_TYPE.put(string, n);
                TYPE_TO_NAME.put(40, "FLOAT");
                NAME_TO_TYPE.put("BINARY_FLOAT", 40);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        TYPE_TO_NAME.put(15, "TIME");
        NAME_TO_TYPE.put("TIME", 15);
    }
}

