/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.Session;
import com.yashandb.SessionImpl;
import com.yashandb.conf.ConnectionUrl;
import com.yashandb.conf.HostSpec;
import com.yashandb.conf.YasProperty;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.PreparedStatementImpl;
import com.yashandb.jdbc.ReturnColumnResultSetMetaData;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.TransactionState;
import com.yashandb.jdbc.YasCallableStatement;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasDatabaseMetaData;
import com.yashandb.jdbc.YasDebugCallableStatement;
import com.yashandb.jdbc.YasFailover;
import com.yashandb.jdbc.YasSQLXML;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.Protocol;
import com.yashandb.util.Messages;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.concurrent.Executor;

public class ConnectionImpl
implements YasConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionImpl.class);
    private Session session;
    private int rsHoldability = 1;
    private boolean autoCommit = true;
    private SQLWarning firstWarning = null;
    protected DatabaseMetaData metadata;
    protected int defaultFetchSize;
    private final String creatingURL;
    private String productName;
    private String serverType;
    private Timer timer;
    private static final SQLPermission SQL_PERMISSION_ABORT = new SQLPermission("callAbort");
    private static final SQLPermission SQL_PERMISSION_NETWORK_TIMEOUT = new SQLPermission("setNetworkTimeout");
    private static final String EMPTY_SQL_ERROR_MSG = "SQL String cannot be NULL or empty";
    private static final String CANNOT_SET_SAVEPOINT_ERROR_MSG = "Can not set savepoint when autoCommit is enabled.";
    private static final String INVALID_ARGUMENT_CALL_ERROR_MSG = "Invalid argument(s) in call.";
    private int isolationLevel = 2;
    private boolean readOnly = false;
    private boolean clientPrepare = false;
    private int streamRsNetTimeout = 600;

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.checkClosed();
        return string;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    @Override
    public synchronized Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer("YashanDB Connection Timer", true);
        }
        return this.timer;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkClosed();
        if (this.autoCommit == bl) {
            return;
        }
        if (!this.autoCommit) {
            this.commit();
        }
        this.autoCommit = bl;
        LOGGER.debug(" yas setAutoCommit = {}", (Object)this.autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw SQLError.createSQLException(Messages.get("Cannot commit when autoCommit is enabled.", new Object[0]), YasState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.session.getTransactionState() != TransactionState.XACT_END) {
            this.session.commit();
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw SQLError.createSQLException(Messages.get("Cannot rollback when autoCommit is enabled.", new Object[0]), YasState.NO_ACTIVE_SQL_TRANSACTION);
        }
        this.session.rollback();
    }

    @Override
    public YasDebugCallableStatement createDebugStatement(String string, long l, int n, int n2) throws SQLException {
        this.checkClosed();
        if (string == null || string.trim().isEmpty()) {
            throw new SQLException(EMPTY_SQL_ERROR_MSG);
        }
        string = string.trim();
        return new YasDebugCallableStatement(this, string, 1003, 1007, this.getHoldability(), l, n, n2);
    }

    @Override
    public YasDebugCallableStatement createDebugStatement(String string) throws SQLException {
        this.checkClosed();
        if (string == null || string.trim().isEmpty()) {
            throw new SQLException(EMPTY_SQL_ERROR_MSG);
        }
        string = string.trim();
        return new YasDebugCallableStatement(this, string, 1003, 1007, this.getHoldability());
    }

    @Override
    public void close() throws SQLException {
        if (this.session == null || this.session.isClosed()) {
            return;
        }
        LOGGER.trace("connect close start,timestamp:{},session id:{}", System.currentTimeMillis(), this.session.getSID());
        this.session.abortDebug();
        this.session.close();
        LOGGER.trace("connect close end,timestamp:{},session id:{}", System.currentTimeMillis(), this.session.getSID());
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.session.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.metadata == null) {
            this.metadata = new YasDatabaseMetaData(this);
        }
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.checkClosed();
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.getTransactionState() != TransactionState.IDLE && this.getTransactionState() != TransactionState.XACT_END) {
                throw SQLError.createSQLException(Messages.get("The readOnly cannot be changed during a transaction.", new Object[0]), YasState.ACTIVE_SQL_TRANSACTION);
            }
            this.readOnly = bl;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.session.getDatabase();
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.checkClosed();
        if (this.session.getTransactionState() != TransactionState.XACT_END) {
            throw SQLError.createSQLException(Messages.get("Cannot change transaction isolation level in the middle of a transaction.", new Object[0]), YasState.ACTIVE_SQL_TRANSACTION);
        }
        if (n != 2 && n != 8 && n != 3) {
            throw SQLError.createSQLException(Messages.get("Only READ_COMMITTED and SERIALIZABLE are valid transaction isolation level", new Object[0]), YasState.DATA_ERROR);
        }
        this.session.setTransactionIsolation(n);
        LOGGER.debug("setTransactionIsolation = {}", (Object)n);
        this.isolationLevel = n;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return this.isolationLevel;
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        SQLWarning sQLWarning = this.session.getWarnings();
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(sQLWarning);
        } else {
            this.firstWarning = sQLWarning;
        }
        return this.firstWarning;
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkClosed();
        return this.createStatement(n, n2, this.getHoldability());
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.session.getWarnings();
        this.firstWarning = null;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        return this.prepareCall(string, n, n2, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        return this.prepareStatement(string, n, n2, this.getHoldability());
    }

    public Map getTypeMap() throws SQLException {
        this.checkClosed();
        return this.session.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkClosed();
        this.session.setTypeMap(map);
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.checkClosed();
        if (n != 1) {
            throw SQLError.createSQLException(Messages.get("Unsupported ResultSet holdability setting: {0}.", n), YasState.INVALID_PARAMETER_VALUE);
        }
        this.rsHoldability = n;
        LOGGER.debug("setHoldability = {}", (Object)n);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            LOGGER.error(CANNOT_SET_SAVEPOINT_ERROR_MSG);
            throw SQLError.createSQLException(Messages.get(CANNOT_SET_SAVEPOINT_ERROR_MSG, new Object[0]), YasState.NO_ACTIVE_SQL_TRANSACTION);
        }
        return this.session.setSavepoint();
    }

    @Override
    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            LOGGER.error(CANNOT_SET_SAVEPOINT_ERROR_MSG);
            throw SQLError.createSQLException(Messages.get(CANNOT_SET_SAVEPOINT_ERROR_MSG, new Object[0]), YasState.NO_ACTIVE_SQL_TRANSACTION);
        }
        return this.session.setSavepoint(string);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            LOGGER.error("Can not rollback savepoint when autoCommit is enabled.");
            throw SQLError.createSQLException(Messages.get("Can not rollback savepoint when autoCommit is enabled.", new Object[0]), YasState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (savepoint == null) {
            return;
        }
        this.session.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        this.session.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        return new StatementImpl(this, n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        if (string == null || string.trim().isEmpty()) {
            throw new SQLException(EMPTY_SQL_ERROR_MSG);
        }
        string = string.trim();
        return new PreparedStatementImpl(this, string, n, n2, n3);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        if (string == null || string.trim().isEmpty()) {
            throw new SQLException(EMPTY_SQL_ERROR_MSG);
        }
        string = string.trim();
        return new YasCallableStatement(this, string, n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        ReturnColumnResultSetMetaData returnColumnResultSetMetaData = new ReturnColumnResultSetMetaData(string);
        if (n != 2 && returnColumnResultSetMetaData.isInsert()) {
            if (n == 1) {
                PreparedStatementImpl preparedStatementImpl = (PreparedStatementImpl)this.prepareStatement(returnColumnResultSetMetaData.getNewSql());
                preparedStatementImpl.returnColRsMetaData = returnColumnResultSetMetaData;
                preparedStatementImpl.autoGeneratedKeys = true;
                preparedStatementImpl.returnParamCount = 1;
                preparedStatementImpl.b();
                return preparedStatementImpl;
            }
            throw SQLError.createSQLException(Messages.get(INVALID_ARGUMENT_CALL_ERROR_MSG, new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        return this.prepareStatement(string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        ReturnColumnResultSetMetaData returnColumnResultSetMetaData = new ReturnColumnResultSetMetaData(string, nArray);
        if (!returnColumnResultSetMetaData.isInsert()) {
            return this.prepareStatement(string);
        }
        if (nArray != null && nArray.length != 0) {
            this.doDescribeTable(returnColumnResultSetMetaData);
            PreparedStatementImpl preparedStatementImpl = (PreparedStatementImpl)this.prepareStatement(returnColumnResultSetMetaData.getNewSql());
            preparedStatementImpl.returnColRsMetaData = returnColumnResultSetMetaData;
            preparedStatementImpl.autoGeneratedKeys = true;
            preparedStatementImpl.returnParamCount = nArray.length;
            preparedStatementImpl.b();
            return preparedStatementImpl;
        }
        throw SQLError.createSQLException(Messages.get(INVALID_ARGUMENT_CALL_ERROR_MSG, new Object[0]), YasState.INVALID_PARAMETER_TYPE);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        ReturnColumnResultSetMetaData returnColumnResultSetMetaData = new ReturnColumnResultSetMetaData(string, stringArray);
        if (!returnColumnResultSetMetaData.isInsert()) {
            return this.prepareStatement(string);
        }
        if (stringArray != null && stringArray.length != 0) {
            this.doDescribeTable(returnColumnResultSetMetaData);
            PreparedStatementImpl preparedStatementImpl = (PreparedStatementImpl)this.prepareStatement(returnColumnResultSetMetaData.getNewSql());
            preparedStatementImpl.returnColRsMetaData = returnColumnResultSetMetaData;
            preparedStatementImpl.autoGeneratedKeys = true;
            preparedStatementImpl.returnParamCount = stringArray.length;
            preparedStatementImpl.b();
            return preparedStatementImpl;
        }
        throw SQLError.createSQLException(Messages.get(INVALID_ARGUMENT_CALL_ERROR_MSG, new Object[0]), YasState.INVALID_PARAMETER_TYPE);
    }

    @Override
    public void doDescribeTable(ReturnColumnResultSetMetaData returnColumnResultSetMetaData) throws SQLException {
        String string = returnColumnResultSetMetaData.a().trim();
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 1 && stringArray.length != 2) {
            throw SQLError.createSQLException(Messages.get(INVALID_ARGUMENT_CALL_ERROR_MSG, new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        int n = 0;
        String string2 = "select * from " + string + " where 1=0";
        try (Statement statement = this.createStatement();){
            ResultSet resultSet = statement.executeQuery(string2);
            Field[] fieldArray = ((StatementImpl)statement).getFields();
            n = fieldArray.length;
            for (int i = 0; i < fieldArray.length; ++i) {
                arrayList.add(fieldArray[i].getName());
                arrayList2.add(fieldArray[i].getYasType());
                arrayList3.add(fieldArray[i].getSize());
                arrayList4.add(fieldArray[i].getNullable() == 1);
                arrayList5.add(fieldArray[i].getPrecision());
                arrayList6.add(fieldArray[i].getScale());
            }
            resultSet.close();
        }
        returnColumnResultSetMetaData.initDescribedData(n, arrayList, arrayList2, arrayList3, arrayList4, arrayList5, arrayList6);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        return this.session.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return this.session.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        return this.session.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return new YasSQLXML();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized int a(int n) {
        try (Statement statement = this.createStatement();){
            statement.setQueryTimeout(n);
            statement.executeQuery("select 'x' from dual");
            int n2 = 0;
            return n2;
        }
        catch (Throwable throwable6) {
            return -1;
        }
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("isValid timeout cannot be negative.");
        }
        if (this.isClosed()) {
            return false;
        }
        return this.a(n) == 0;
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getClientInfo()");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getClientInfo()");
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "createArrayOf(String, Object[])");
    }

    @Override
    public Array createArray(String string, Object[] objectArray) throws SQLException {
        this.checkClosed();
        return this.session.createArray(string, objectArray);
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.checkClosed();
        return this.session.createStruct(string, objectArray);
    }

    @Override
    public void setSchema(String string) throws SQLException {
        this.checkClosed();
        if (string == null || string.isEmpty()) {
            throw SQLError.createSQLException("invalid parameter", YasState.DATA_ERROR);
        }
        this.session.setSchema(string);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return this.session.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("executor is null");
        }
        if (this.isClosed()) {
            return;
        }
        SQL_PERMISSION_ABORT.checkGuard(this);
        this.session.abort(executor);
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw SQLError.createSQLException(Messages.get("Network timeout must be a value greater than or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SQL_PERMISSION_NETWORK_TIMEOUT);
        }
        try {
            this.session.setNetworkTimeout(n);
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException(Messages.get("Unable to set network timeout.", new Object[0]), YasState.COMMUNICATION_ERROR, (Throwable)iOException);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkClosed();
        try {
            return this.session.getNetworkTimeout();
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException(Messages.get("Unable to get network timeout.", new Object[0]), YasState.COMMUNICATION_ERROR, (Throwable)iOException);
        }
    }

    public Object unwrap(Class clazz) throws SQLException {
        this.checkClosed();
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        this.checkClosed();
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public void cancelQuery() throws SQLException {
        this.checkClosed();
        this.session.cancel();
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public TransactionState getTransactionState() {
        return this.session.getTransactionState();
    }

    @Override
    public String getServerType() {
        return this.serverType;
    }

    @Override
    public boolean getClientPrepare() {
        return this.clientPrepare;
    }

    @Override
    public void setClientPrepare(boolean bl) {
        this.clientPrepare = bl;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw SQLError.createSQLException(Messages.get("This connection has been closed.", new Object[0]), YasState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    @Override
    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    public String getURL() {
        return this.creatingURL;
    }

    public String getUserName() throws SQLException {
        return this.session.getUser();
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String string) {
        this.productName = string;
    }

    @Override
    public void setDefaultFetchSize(int n) throws SQLException {
        if (n < 0 && n != Integer.MIN_VALUE) {
            throw SQLError.createSQLException(Messages.get("Fetch size must be a value greater to or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        this.defaultFetchSize = n;
        LOGGER.debug("setDefaultFetchSize = {}", (Object)n);
    }

    public void setStreamRsNetTimeout(int n) {
        if (n > 0) {
            this.streamRsNetTimeout = n;
        }
    }

    public int getStreamRsNetTimeout() {
        return this.streamRsNetTimeout;
    }

    public void addWarning(SQLWarning sQLWarning) {
        if (this.firstWarning == null) {
            this.firstWarning = sQLWarning;
        } else {
            this.firstWarning.setNextWarning(sQLWarning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionImpl(ConnectionUrl connectionUrl) throws SQLException {
        HostSpec[] hostSpecArray = connectionUrl.getHostSpecs();
        if (hostSpecArray == null) {
            throw SQLError.createSQLException(Messages.get("Invalid JDBC URL: {0}", connectionUrl.getUrl()), YasState.INVALID_PARAMETER_VALUE);
        }
        String string = connectionUrl.user();
        Properties properties = connectionUrl.getProps();
        LOGGER.debug("YashanDB JDBC Driver 1.5-SNAPSHOT");
        this.creatingURL = connectionUrl.getUrl();
        this.serverType = connectionUrl.getServerType();
        this.setDefaultFetchSize(YasProperty.DEFAULT_ROW_FETCH_SIZE.getInt(properties));
        this.setStreamRsNetTimeout(YasProperty.NET_TIMEOUT_FOR_STREAMING_RESULTS.getInt(properties));
        this.setProductName(YasProperty.PRODUCT_NAME.get(properties));
        try {
            this.clientPrepare = YasProperty.CLIENT_PREPARE.getBoolean(properties);
        }
        catch (Exception exception) {
            LOGGER.debug("get YasProperty clientPrepare error.");
        }
        this.session = new SessionImpl(this, hostSpecArray, string, properties);
        this.session.initFailoverProcessor();
        try {
            LOGGER.trace("connect start,timestamp:{},ip/port:{},serverType:{}", System.currentTimeMillis(), hostSpecArray, this.serverType);
            this.session.connect();
        }
        catch (SQLException sQLException) {
            try {
                if (!sQLException.getMessage().contains("YAS-00410 protocol error, invalid login packet") || this.session.getConnectVersion() == ConnectVersion.VER1) {
                    throw sQLException;
                }
                this.session.setConnectVersion(ConnectVersion.VER1);
                this.session.connect();
            }
            catch (Throwable throwable) {
                LOGGER.trace("connect end,timestamp:{},session id:{},connectVersion:{}", new Object[]{System.currentTimeMillis(), this.session.getSID(), this.session.getConnectVersion()});
                throw throwable;
            }
            LOGGER.trace("connect end,timestamp:{},session id:{},connectVersion:{}", new Object[]{System.currentTimeMillis(), this.session.getSID(), this.session.getConnectVersion()});
        }
        LOGGER.trace("connect end,timestamp:{},session id:{},connectVersion:{}", new Object[]{System.currentTimeMillis(), this.session.getSID(), this.session.getConnectVersion()});
        this.session.initSessionConfig();
    }

    public Object cloneForMonitor() throws CloneNotSupportedException {
        ConnectionImpl connectionImpl = (ConnectionImpl)super.clone();
        connectionImpl.autoCommit = false;
        connectionImpl.session = (Session)((SessionImpl)this.session).cloneForMonitor();
        connectionImpl.session.setConnection(connectionImpl);
        return connectionImpl;
    }

    public static Connection getInstance(ConnectionUrl connectionUrl) throws SQLException {
        return new ConnectionImpl(connectionUrl);
    }

    @Override
    public synchronized void registerTAFCallback(YasFailover yasFailover, Object object) throws SQLException {
        this.session.registerTAFCallback(yasFailover, object);
    }

    public Protocol getProtocol() {
        return ((SessionImpl)this.session).getProtocol();
    }
}

