/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.jdbc.YasDriver;
import java.sql.DriverManager;
import java.sql.SQLException;

public class Driver
extends YasDriver
implements java.sql.Driver {
    private static Driver registeredDriver;

    public static void register() throws SQLException {
        if (Driver.isRegisteredDriver()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        Driver driver = new Driver();
        DriverManager.registerDriver(driver);
        registeredDriver = driver;
    }

    public static void deregister() throws SQLException {
        if (!Driver.isRegisteredDriver()) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegisteredDriver() {
        return registeredDriver != null;
    }

    static {
        try {
            Driver.register();
        }
        catch (SQLException sQLException) {
            throw new ExceptionInInitializerError(sQLException);
        }
    }
}

