/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.CancelQueryTask;
import com.yashandb.ParameterList;
import com.yashandb.SimpleParameterList;
import com.yashandb.YasConstants;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.ConnectionImpl;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.YasBlob;
import com.yashandb.jdbc.YasClob;
import com.yashandb.jdbc.YasClobReader;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasLobInputStream;
import com.yashandb.jdbc.YasParameterMetaData;
import com.yashandb.jdbc.YasTypes;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.json.YasonValue;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.TypeConverter;
import com.yashandb.udt.YasArray;
import com.yashandb.udt.YasStruct;
import com.yashandb.util.Messages;
import com.yashandb.util.Utils;
import com.yashandb.util.YasEscapeProcessor;
import com.yashandb.util.YasSQL;
import com.yashandb.util.YasTime;
import com.yashandb.util.YasTimestamp;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;

public class PreparedStatementImpl
extends StatementImpl
implements PreparedStatement {
    private YasParameterMetaData parameterMetaData;
    protected String preparedSQL;
    private static final Logger LOGGER = LoggerFactory.getLogger(PreparedStatementImpl.class);
    private boolean clientPrepare = false;

    PreparedStatementImpl(ConnectionImpl connectionImpl, String string, int n, int n2, int n3) throws SQLException {
        super(connectionImpl, n, n2, n3);
        this.setPoolable(true);
        this.preparedSQL = YasEscapeProcessor.process(string);
        if (this.resultsetConcurrency == 1008 || this.resultsetType == 1005) {
            this.yasSQL = this.buildYasSQL(this.preparedSQL);
            if (this.yasSQL.canUpdatable() || this.yasSQL.canScrollSensitive()) {
                this.preparedSQL = this.yasSQL.getRowIDAppendSQL();
            }
        }
        this.clientPrepare = this.connection.getClientPrepare();
        if (this.clientPrepare && !(this instanceof CallableStatement)) {
            this.hasPrepared = false;
            this.a();
            return;
        }
        this.serverPrepare(this.preparedSQL);
    }

    void a() throws SQLException {
        int n;
        if (this.yasSQL == null) {
            this.yasSQL = new YasSQL(this.preparedSQL);
        }
        if ((n = this.yasSQL.getParameterCount()) <= 0) {
            return;
        }
        if (n >= 32000) {
            throw SQLError.createSQLException("bind param count size exceeding limit 32000", YasState.UNKNOWN_STATE);
        }
        this.preparedParameters = new SimpleParameterList(n);
        this.preparedParameters.setCharset(this.getSession().getCharset());
        this.preparedParameters.setNCharset(this.getSession().getNCharset());
    }

    protected void serverPrepare(String string) throws SQLException {
        LOGGER.trace("prepare start,timestamp:{},session id:{}, sql:{}", System.currentTimeMillis(), this.connection.getSession().getSID(), string);
        this.connection.getSession().prepare(this, string);
        LOGGER.trace("prepare end,timestamp:{},session id:{},statement id:{}", System.currentTimeMillis(), this.connection.getSession().getSID(), this.getID());
        this.hasPrepared = true;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.f();
        return this.getQueryResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.f();
        return this.getExecuteUpdateResult();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.f();
        return this.getExecuteLargeUpdateResult();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.f();
    }

    private boolean e() {
        if (!this.hasPrepared) {
            return false;
        }
        if (this.yasSQL == null || !this.yasSQL.isSELECT()) {
            return false;
        }
        if (this.preparedParameters != null && this.preparedParameters.bindTypeChanged()) {
            this.preparedParameters.resetBindTypeFlag();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean f() throws SQLException {
        ParameterList[] parameterListArray = null;
        if (this.preparedParameters != null) {
            parameterListArray = new ParameterList[]{this.preparedParameters};
        }
        PreparedStatementImpl preparedStatementImpl = this;
        synchronized (preparedStatementImpl) {
            this.checkClosed();
            this.closeForNextExecution();
            if (this.e()) {
                this.hasPrepared = false;
            }
            LOGGER.trace("prepareStatement execute start,timestamp:{},session id:{}, Statement id:{}", System.currentTimeMillis(), this.connection.getSession().getSID(), this.getID());
            if (this.timeout > 0L) {
                CancelQueryTask cancelQueryTask = null;
                try {
                    cancelQueryTask = this.startTimer();
                    if (!this.hasPrepared) {
                        this.currentResultSet = this.connection.getSession().directExecute(this, this.preparedSQL, parameterListArray, false);
                        this.hasPrepared = true;
                    }
                    this.currentResultSet = this.connection.getSession().execute(this, parameterListArray, 0, 0, 0, false);
                }
                finally {
                    this.killTimerTask(cancelQueryTask);
                }
            } else if (!this.hasPrepared) {
                this.currentResultSet = this.connection.getSession().directExecute(this, this.preparedSQL, parameterListArray, false);
                this.hasPrepared = true;
            } else {
                this.currentResultSet = this.connection.getSession().execute(this, parameterListArray, 0, 0, 0, false);
            }
            LOGGER.trace("prepareStatement execute end,timestamp:{},session id:{}, Statement id:{}", System.currentTimeMillis(), this.connection.getSession().getSID(), this.getID());
            return this.currentResultSet.reallyResult();
        }
    }

    @Override
    protected void checkIfBatchExists() throws SQLException {
        if (this.getBatchSize() > 0) {
            throw SQLError.createSQLException("batch must be either executed or cleared", YasState.UNEXPECTED_ERROR);
        }
        super.checkIfBatchExists();
    }

    public int getBatchSize() {
        if (this.batchParameters == null) {
            return 0;
        }
        return this.batchParameters.size();
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.checkClosed();
        if (n < 1 || n > this.getParameters().getParameterCount()) {
            throw SQLError.createSQLException(Messages.get("The column index is out of range: {0}, number of columns: {1}.", n, this.getParameters().getParameterCount()), YasState.INVALID_PARAMETER_VALUE);
        }
        int n3 = YasTypes.getYasType(n2);
        this.getParameters().setNull(n, n3);
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkClosed();
        this.getParameters().setIntParameter(n, bl ? 1L : 0L, 4);
    }

    public void setBit(int n, Object object) throws SQLException {
        block7: {
            this.checkClosed();
            if (object == null) {
                this.setNull(n, -7);
                return;
            }
            try {
                if (object instanceof Boolean) {
                    byte[] byArray = new byte[]{(byte)((Boolean)object != false ? 1 : 0)};
                    this.getParameters().setBinaryParameter(n, byArray, 31);
                    break block7;
                }
                if (object instanceof byte[]) {
                    this.getParameters().setBinaryParameter(n, (byte[])object, 31);
                    break block7;
                }
                if (object instanceof String) {
                    this.setLong(n, Long.parseLong((String)object));
                    break block7;
                }
                if (object instanceof Number) {
                    this.setLong(n, ((Number)object).longValue());
                    break block7;
                }
                throw SQLError.transformException(object.getClass().getName(), "Bit");
            }
            catch (Exception exception) {
                throw SQLError.transformException(object.getClass().getName(), "Bit", exception);
            }
        }
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.checkClosed();
        this.getParameters().setIntParameter(n, by, 2);
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.checkClosed();
        this.getParameters().setIntParameter(n, s, 3);
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.checkClosed();
        this.getParameters().setIntParameter(n, n2, 4);
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.checkClosed();
        this.getParameters().setIntParameter(n, l, 5);
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.checkClosed();
        this.getParameters().setFloatParameter(n, f, 10);
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.checkClosed();
        this.getParameters().setDoubleParameter(n, d, 11);
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.a(n, bigDecimal);
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.checkClosed();
        if (string == null) {
            this.getParameters().setNull(n, 26);
            return;
        }
        if (string.length() < 32000) {
            this.a(n, string);
            return;
        }
        this.setCharacterStream(n, (Reader)new StringReader(string), string.length());
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkClosed();
        if (null == byArray || byArray.length == 0) {
            this.getParameters().setNull(n, 28);
            return;
        }
        if (!this.i()) {
            this.getParameters().setBytea(n, new ByteArrayInputStream(byArray), byArray.length);
            return;
        }
        this.getParameters().setBytea(n, byArray, 0, byArray.length);
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.a(date);
        this.getParameters().setDateParameter(n, date, 13);
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.getParameters().setTimeParameter(n, time, 15);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.a(timestamp);
        this.getParameters().setTimeStampParameter(n, timestamp, 16);
    }

    private void a(int n, long l) throws SQLException {
        this.getParameters().setDsIntervalParameter(n, l, 20);
    }

    private void b(int n, int n2) throws SQLException {
        this.getParameters().setYmIntervalParameter(n, n2, 19);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setAsciiStream(n, inputStream, (long)n2);
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setUnicodeStream()");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream, (long)n2);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClosed();
        if (this.preparedParameters != null) {
            this.preparedParameters.clear();
        }
        if (this.autoGeneratedKeys) {
            this.b();
        }
    }

    private void a(int n, Map map) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setMap");
    }

    private void a(int n, Number number) throws SQLException {
        this.checkClosed();
        if (number == null) {
            this.setNull(n, 3);
        } else {
            this.getParameters().setNumberParameter(n, number, 12);
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkClosed();
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        switch (n2) {
            case 7: {
                this.setFloat(n, TypeConverter.castToFloat(object, n2));
                break;
            }
            case -5: {
                this.setLong(n, TypeConverter.castToLong(object, n2));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                this.setInt(n, TypeConverter.castToInt(object, n2));
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(n, TypeConverter.castToBigDecimal(object, n3, n2));
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(n, TypeConverter.castToDouble(object, n2));
                break;
            }
            case 16: {
                this.setBoolean(n, TypeConverter.castToBoolean(object));
                break;
            }
            case -7: {
                this.setBit(n, object);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (object instanceof InputStream) {
                    if (n3 >= 0) {
                        this.setAsciiStream(n, (InputStream)object, n3);
                    } else {
                        this.setAsciiStream(n, (InputStream)object);
                    }
                    return;
                }
                this.setString(n, TypeConverter.castToString(object, n2));
                break;
            }
            case 3009: {
                this.a(n, object, n2, n3);
                break;
            }
            case 91: {
                this.setDate(n, TypeConverter.castToDate(object));
                break;
            }
            case 92: {
                this.setTime(n, TypeConverter.castToTime(object));
                break;
            }
            case 2013: {
                this.c(n, object);
                break;
            }
            case 93: {
                this.setTimestamp(n, TypeConverter.castToTimeStamp(object));
                break;
            }
            case 2014: {
                this.d(n, object);
                break;
            }
            case 3002: {
                this.a(n, TypeConverter.castToDsInterval(object));
                break;
            }
            case 3001: {
                this.b(n, TypeConverter.castToYmInterval(object));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.c(n, object, n2, n3);
                break;
            }
            case -16: 
            case -15: 
            case -9: {
                this.setNString(n, (String)object);
                break;
            }
            case 2004: {
                this.a(n, object);
                break;
            }
            case 2005: {
                this.b(n, object);
                break;
            }
            case 2003: {
                this.setArray(n, object);
                break;
            }
            case 2006: {
                this.setRef(n, object);
                break;
            }
            case 70: {
                this.setURL(n, object);
                break;
            }
            case 2011: {
                this.setNClob(n, object);
                break;
            }
            case 2009: {
                this.setSQLXML(n, object);
                break;
            }
            case 2001: {
                this.a(n, object.toString());
                break;
            }
            case -8: {
                this.setRowId(n, object);
                break;
            }
            case 1111: {
                if (object instanceof Map) {
                    this.a(n, (Map)object);
                    break;
                }
                this.a(n, object.toString());
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("Unsupported Types value: {0}", n2), YasState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, -1);
    }

    private void a(int n, Object object, int n2, int n3) throws SQLException {
        if (this.connection.getSession().getConnectVersion().getValue() < ConnectVersion.VER5.getValue()) {
            this.b(n, object, n2, n3);
            return;
        }
        if (object instanceof YasonValue) {
            this.getParameters().setJsonBytes(n, ((YasonValue)object).getBinaryData());
        } else if (object instanceof byte[]) {
            this.getParameters().setJsonBytes(n, (byte[])object);
        } else if (object instanceof InputStream) {
            this.getParameters().setJsonStream(n, (InputStream)object, n3 > 0 && n3 < 0x2000000 ? n3 : 0x2000000);
        } else {
            this.setString(n, TypeConverter.castToString(object, n2));
        }
    }

    private void b(int n, Object object, int n2, int n3) throws SQLException {
        if (object instanceof YasonValue) {
            this.setString(n, object.toString());
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof InputStream) {
            this.setBinaryStream(n, (InputStream)object, n3 > 0 && n3 < 0x2000000 ? n3 : 0x2000000);
        } else {
            this.setString(n, TypeConverter.castToString(object, n2));
        }
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.checkClosed();
        if (object == null) {
            this.setNull(n, 1111);
        } else if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof Short) {
            this.setShort(n, (Short)object);
        } else if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(n, (Double)object);
        } else if (object instanceof Long) {
            this.setLong(n, (Long)object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
        } else if (object instanceof Byte) {
            this.setByte(n, (Byte)object);
        } else if (object instanceof YasonValue) {
            if (this.connection.getSession().getConnectVersion().getValue() < ConnectVersion.VER5.getValue()) {
                this.setString(n, object.toString());
                return;
            }
            this.getParameters().setJsonBytes(n, ((YasonValue)object).getBinaryData());
        } else if (object instanceof Blob) {
            this.setBlob(n, (Blob)object);
        } else if (object instanceof Clob) {
            this.setClob(n, (Clob)object);
        } else if (object instanceof Array) {
            this.setArray(n, (Array)object);
        } else if (object instanceof Struct) {
            this.a(n, (Struct)object);
        } else if (object instanceof SQLData) {
            this.a(n, YasStruct.toYasStruct((SQLData)object, (YasConnection)this.getConnection()));
        } else if (object instanceof Character) {
            this.setString(n, ((Character)object).toString());
        } else if (object instanceof LocalDate) {
            this.a(n, (LocalDate)object);
        } else if (object instanceof LocalTime) {
            this.a(n, (LocalTime)object);
        } else if (object instanceof LocalDateTime) {
            this.a(n, (LocalDateTime)object);
        } else if (object instanceof OffsetDateTime) {
            this.a(n, (OffsetDateTime)object);
        } else if (object instanceof Map) {
            this.a(n, (Map)object);
        } else if (object instanceof Number) {
            this.a(n, (Number)object);
        } else if (object instanceof Reader) {
            this.setCharacterStream(n, (Reader)object);
        } else if (object instanceof InputStream) {
            this.setBinaryStream(n, (InputStream)object);
        } else if (object instanceof SQLXML) {
            this.setSQLXML(n, (SQLXML)object);
        } else if (object instanceof RowId) {
            this.setRowId(n, (RowId)object);
        } else if (object instanceof Ref) {
            this.setRef(n, (Ref)object);
        } else {
            throw SQLError.createSQLException(Messages.get("Can''t infer the SQL type to use for an instance of {0}. Use setObject() with an explicit Types value to specify the type to use.", object.getClass().getName()), YasState.INVALID_PARAMETER_TYPE);
        }
    }

    private void a(int n, Struct struct) throws SQLException {
        this.checkClosed();
        if (struct == null) {
            this.setNull(n, 2002);
            return;
        }
        byte[] byArray = ((YasStruct)struct).getSerialData();
        this.getParameters().setUdtParameter(n, byArray, 36);
    }

    public String toString() {
        return super.toString();
    }

    private void a(int n, String string) throws SQLException {
        this.getParameters().setStringParameter(n, string);
    }

    private void b(int n, String string) throws SQLException {
        this.getParameters().setNStringParameter(n, string);
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLException(Messages.get("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), YasState.WRONG_OBJECT_TYPE);
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        }
        if (this.preparedParameters != null) {
            this.batchParameters.add(this.getParameters().copy());
        } else {
            super.addBatch(this.preparedSQL);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getMetaData");
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.checkClosed();
        if (array == null) {
            this.setNull(n, 2003);
            return;
        }
        byte[] byArray = ((YasArray)array).getSerialData();
        this.getParameters().setUdtParameter(n, byArray, 37);
    }

    public void setArray(int n, Object object) throws SQLException {
        if (!(object instanceof Array)) {
            throw SQLError.transformException(object.getClass().getName(), "ARRAY");
        }
        this.setArray(n, (Array)object);
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkClosed();
        this.getParameters().setBlobParameter(n, blob, 30);
    }

    private void a(int n, Object object) throws SQLException {
        if (object instanceof Blob) {
            this.setBlob(n, (Blob)object);
        } else if (object instanceof InputStream) {
            this.setBlob(n, (InputStream)object);
        } else {
            throw SQLError.transformException(object.getClass().getName(), "BLOB");
        }
    }

    private String a(Reader reader, int n) throws SQLException {
        try {
            int n2 = Math.min(n, 1024);
            StringBuilder stringBuilder = new StringBuilder(n2);
            char[] cArray = new char[n2];
            int n3 = 0;
            while (n3 > -1 && stringBuilder.length() < n) {
                n3 = reader.read(cArray, 0, Math.min(n2, n - stringBuilder.length()));
                if (n3 <= 0) continue;
                stringBuilder.append(cArray, 0, n3);
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException(Messages.get("Provided Reader failed.", new Object[0]), YasState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setCharacterStream(n, reader, (long)n2);
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.checkClosed();
        this.getParameters().setClobParameter(n, clob, 29);
    }

    private void b(int n, Object object) throws SQLException {
        if (object instanceof Clob) {
            this.setClob(n, (Clob)object);
        } else if (object instanceof Reader) {
            this.setClob(n, (Reader)object);
        } else {
            throw SQLError.transformException(object.getClass().getName(), "CLOB");
        }
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNull()");
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setRef(int,Ref)");
    }

    public void setRef(int n, Object object) throws SQLException {
        if (!(object instanceof Ref)) {
            throw SQLError.transformException(object.getClass().getName(), "REF");
        }
        this.setRef(n, (Ref)object);
    }

    public void setURL(int n, Object object) throws SQLException {
        if (!(object instanceof Ref)) {
            throw SQLError.transformException(object.getClass().getName(), "DATALINK");
        }
        this.setURL(n, (URL)object);
    }

    public void setNClob(int n, Object object) throws SQLException {
        if (!(object instanceof NClob)) {
            throw SQLError.transformException(object.getClass().getName(), "NCLOB");
        }
        this.setNClob(n, (NClob)object);
    }

    public void setSQLXML(int n, Object object) throws SQLException {
        if (object instanceof SQLXML) {
            this.setSQLXML(n, (SQLXML)object);
        } else if (object instanceof Clob) {
            this.setClob(n, (Clob)object);
        } else if (object instanceof String) {
            this.setString(n, (String)object);
        } else {
            throw SQLError.transformException(object.getClass().getName(), "SQLXML");
        }
    }

    public void setRowId(int n, Object object) throws SQLException {
        if (!(object instanceof RowId)) {
            throw SQLError.transformException(object.getClass().getName(), "ROWID");
        }
        this.setRowId(n, (RowId)object);
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp);
    }

    private void a(int n, LocalDate localDate) throws SQLException {
        if (localDate == null) {
            this.getParameters().setNull(n, 13);
        } else {
            this.setDate(n, Date.valueOf(localDate));
        }
    }

    private void a(int n, LocalTime localTime) throws SQLException {
        if (localTime == null) {
            this.getParameters().setNull(n, 15);
        } else {
            this.setTime(n, YasTime.valueOf(localTime));
        }
    }

    private void a(int n, LocalDateTime localDateTime) throws SQLException {
        if (localDateTime == null) {
            this.getParameters().setNull(n, 16);
        } else {
            this.setTimestamp(n, Timestamp.valueOf(localDateTime));
        }
    }

    private void a(int n, OffsetDateTime offsetDateTime) throws SQLException {
        if (offsetDateTime == null) {
            this.getParameters().setNull(n, 16);
        } else {
            this.setTimestamp(n, Timestamp.valueOf(offsetDateTime.toLocalDateTime()));
        }
    }

    private YasParameterMetaData g() throws SQLException {
        return new YasParameterMetaData(this.parameterFields);
    }

    @Override
    public void setObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        this.setObject(n, object, sQLType.getVendorTypeNumber(), n2);
    }

    @Override
    public void setObject(int n, Object object, SQLType sQLType) throws SQLException {
        this.setObject(n, object, sQLType.getVendorTypeNumber());
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.checkClosed();
        if (rowId == null) {
            this.getParameters().setNull(n, 32);
            return;
        }
        this.getParameters().setRowIdParameter(n, rowId);
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.checkClosed();
        if (string == null) {
            this.getParameters().setNull(n, 27);
            return;
        }
        if (string.length() < 32000) {
            this.b(n, string);
            return;
        }
        this.setCharacterStream(n, (Reader)new StringReader(string), string.length());
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, l);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.a(l);
        if (reader == null || l == 0L) {
            this.getParameters().setNull(n, 26);
            return;
        }
        this.a((Object)reader, n);
        if (l < 32000L) {
            String string = this.a(reader, (int)l);
            this.setString(n, string);
            return;
        }
        if (l > Integer.MAX_VALUE || !this.i()) {
            this.setClob(n, reader, l);
            return;
        }
        this.b(reader, n);
        this.getParameters().setCharacterStream(n, reader, (int)l);
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNull(n, 2005);
        }
        this.a((Object)reader, n);
        this.setClob(n, reader);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.checkClosed();
        this.a(l);
        if (inputStream == null || l == 0L) {
            this.getParameters().setNull(n, 28);
            return;
        }
        this.a((Object)inputStream, n);
        if (l < 32000L) {
            this.getParameters().setBytea(n, inputStream, (int)l);
            return;
        }
        if (l >= Integer.MAX_VALUE || !this.i()) {
            this.setBlob(n, this.a(inputStream, l));
            return;
        }
        this.b((Object)inputStream, n);
        this.getParameters().setBinaryStream(n, inputStream, (int)l);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.checkClosed();
        if (inputStream == null) {
            this.getParameters().setNull(n, 28);
            return;
        }
        this.a((Object)inputStream, n);
        this.setBlob(n, this.a(inputStream, -1L));
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.checkClosed();
        this.a(l);
        if (inputStream == null || l == 0L) {
            this.getParameters().setNull(n, 26);
            return;
        }
        this.a((Object)inputStream, n);
        if (l < 32000L) {
            byte[] byArray = new byte[(int)l];
            char[] cArray = new char[byArray.length];
            try {
                int n2 = inputStream.read(byArray);
                this.a(byArray, cArray, n2);
                this.setString(n, new String(cArray));
                return;
            }
            catch (IOException iOException) {
                throw SQLError.createSQLException("stream closed", YasState.IO_ERROR, (Throwable)iOException);
            }
        }
        this.setClob(n, this.b(inputStream, l));
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.getParameters().setNull(n, 29);
            return;
        }
        this.a((Object)inputStream, n);
        this.setClob(n, this.b(inputStream, -1L));
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.setClob(n, nClob);
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        int n2;
        if (this.connection.getSession().getConnectVersion() == ConnectVersion.VER1) {
            throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setClob(int, Reader, long)");
        }
        this.checkClosed();
        this.a(l);
        if (reader == null || l == 0L) {
            this.getParameters().setNull(n, 29);
            return;
        }
        int n3 = (int)Math.min(2048L, l);
        char[] cArray = new char[n3];
        try {
            n2 = reader.read(cArray);
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException(Messages.get("Access Provided Reader failed.", new Object[0]), YasState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
        if (n2 == -1) {
            throw SQLError.createSQLException(l + " character of CLOB data can not be read", YasState.DATA_ERROR);
        }
        if (n2 == 2048) {
            YasClob yasClob = this.connection.getSession().preProcessReaderBinding(reader, cArray, l);
            long l2 = yasClob.length();
            if (l > l2) {
                yasClob.free();
                throw SQLError.createSQLException(l - l2 + " character of CLOB data can not be read", YasState.DATA_ERROR);
            }
            this.setClob(n, yasClob);
            return;
        }
        if (l > (long)n2) {
            throw SQLError.createSQLException(l - (long)n2 + " character of CLOB data can not be read", YasState.DATA_ERROR);
        }
        this.setString(n, String.valueOf(cArray, 0, n2));
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        int n2;
        if (this.connection.getSession().getConnectVersion() == ConnectVersion.VER1) {
            throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setClob(int, Reader)");
        }
        this.checkClosed();
        if (reader == null) {
            this.getParameters().setNull(n, 29);
            return;
        }
        char[] cArray = new char[2048];
        try {
            n2 = reader.read(cArray);
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException(Messages.get("Access Provided Reader failed.", new Object[0]), YasState.UNEXPECTED_ERROR, (Throwable)iOException);
        }
        if (n2 == -1) {
            this.getParameters().setNull(n, 29);
            return;
        }
        if (n2 == 2048) {
            YasClob yasClob = this.connection.getSession().preProcessReaderBinding(reader, cArray, Long.MAX_VALUE);
            this.setClob(n, yasClob);
            return;
        }
        this.setString(n, String.valueOf(cArray, 0, n2));
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.checkClosed();
        this.a(l);
        if (inputStream == null || l == 0L) {
            this.setNull(n, 2004);
            return;
        }
        this.setBlob(n, this.a(inputStream, l));
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.checkClosed();
        if (inputStream == null) {
            this.setNull(n, 2004);
            return;
        }
        this.setBlob(n, this.a(inputStream, -1L));
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.setClob(n, reader, l);
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.setClob(n, reader);
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.checkClosed();
        this.setString(n, sQLXML == null ? null : sQLXML.getString());
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setURL(int,URL)");
    }

    private long[] h() throws SQLException {
        this.generatedKeysResults = null;
        this.returnColRsMetaData.withBatchInsert = true;
        ParameterList[] parameterListArray = this.batchParameters.toArray(new ParameterList[0]);
        long[] lArray = new long[parameterListArray.length];
        for (int i = 0; i < parameterListArray.length; ++i) {
            this.getParameters().clear();
            this.getParameters().appendAll(parameterListArray[i].copy());
            this.f();
            lArray[i] = this.getExecuteLargeUpdateResult();
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long[] executeLargeBatch() throws SQLException {
        this.checkClosed();
        this.closeForNextExecution();
        if (this.preparedParameters != null) {
            if (this.batchParameters == null || this.batchParameters.isEmpty()) {
                return new long[0];
            }
            if (this.batchParameters.size() > 1 && this.autoGeneratedKeys) {
                try {
                    long[] lArray = this.h();
                    return lArray;
                }
                finally {
                    this.clearBatch();
                }
            }
            try {
                ParameterList[] parameterListArray = this.batchParameters.toArray(new ParameterList[0]);
                this.executeInternal(parameterListArray, true);
                int[] nArray = this.currentResultSet.getBatchUpdateCounts();
                long[] lArray = nArray != null ? Utils.toLongArray(nArray) : new long[]{this.currentResultSet.getUpdateCount()};
                long[] lArray2 = lArray;
                return lArray2;
            }
            finally {
                this.clearBatch();
            }
        }
        return super.executeLargeBatch();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (!this.hasPrepared) {
            this.serverPrepare(this.preparedSQL);
        }
        if (this.parameterMetaData == null) {
            this.parameterMetaData = this.g();
        }
        if (this.autoGeneratedKeys) {
            this.parameterMetaData.setThrowUnsupported(true);
        }
        return this.parameterMetaData;
    }

    @Override
    public void setParameters(Field[] fieldArray) throws SQLException {
        this.parameterFields = fieldArray;
        if (this.preparedParameters == null || this.preparedParameters.getParameterCount() != fieldArray.length) {
            this.preparedParameters = new SimpleParameterList(fieldArray.length);
            this.preparedParameters.setCharset(this.getSession().getCharset());
            this.preparedParameters.setNCharset(this.getSession().getNCharset());
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        if (this.batchParameters != null) {
            this.batchParameters.clear();
        }
        super.clearBatch();
    }

    protected ParameterList getParameters() throws SQLException {
        if (this.preparedParameters == null) {
            throw SQLError.createSQLException("Invalid column index.", YasState.INVALID_PARAMETER_VALUE);
        }
        return this.preparedParameters;
    }

    void b() throws SQLException {
        if (!this.hasPrepared) {
            this.preparedParameters = null;
            this.serverPrepare(this.preparedSQL);
        }
        int[] nArray = this.returnColRsMetaData.returnTypes;
        int n = nArray.length;
        int n2 = this.preparedParameters.getParameterCount() - n;
        n2 = n2 < 0 ? 0 : n2;
        for (int i = 0; i < n; ++i) {
            int n3 = n2 + i;
            this.a(n3, nArray[i]);
        }
    }

    private void c(int n, Object object, int n2, int n3) throws SQLException {
        if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof InputStream) {
            if (n3 >= 0) {
                this.setBinaryStream(n, (InputStream)object, n3);
            } else {
                this.setBinaryStream(n, (InputStream)object);
            }
        } else {
            throw SQLError.transformException(object.getClass().getName(), JDBCType.valueOf(n2).getName());
        }
    }

    private void c(int n, Object object) throws SQLException {
        if (object instanceof OffsetDateTime) {
            this.setTime(n, Time.valueOf(((OffsetDateTime)object).toLocalDateTime().toLocalTime()));
        } else if (object instanceof OffsetTime) {
            this.setTime(n, Time.valueOf(((OffsetTime)object).toLocalTime()));
        } else {
            throw SQLError.transformException(object.getClass().getName(), "TIME_WITH_TIMEZONE");
        }
    }

    private void d(int n, Object object) throws SQLException {
        if (object instanceof OffsetDateTime) {
            this.a(n, (OffsetDateTime)object);
        } else if (object instanceof YasTimestamp) {
            this.setObject(n, object);
        } else {
            throw SQLError.transformException(object.getClass().getName(), "TIMESTAMP_WITH_TIMEZONE");
        }
    }

    private Blob a(InputStream inputStream, long l) throws SQLException {
        YasBlob yasBlob = null;
        try {
            int n;
            byte[] byArray = new byte[32000];
            long l2 = 1L;
            boolean bl = true;
            if (l == -1L) {
                l = Long.MAX_VALUE;
                bl = false;
            }
            while (l > 0L && (n = inputStream.read(byArray, 0, l < (long)byArray.length ? (int)l : byArray.length)) != -1) {
                if (yasBlob == null) {
                    yasBlob = (YasBlob)this.connection.createBlob();
                    this.getSession().addTempLob(yasBlob);
                }
                yasBlob.setBytes(l2, byArray, 0, n);
                l2 += (long)((int)Math.min((long)n, l));
                l -= (long)n;
            }
            if (l > 0L && bl) {
                throw SQLError.createSQLException(l + " byte of Blob data can not be read", YasState.NO_DATA);
            }
        }
        catch (IOException iOException) {
            if (yasBlob != null) {
                yasBlob.free();
            }
            throw SQLError.createSQLException("stream closed", YasState.IO_ERROR, (Throwable)iOException);
        }
        return yasBlob;
    }

    private Clob b(InputStream inputStream, long l) throws SQLException {
        YasClob yasClob = (YasClob)this.connection.createClob();
        this.getSession().addTempLob(yasClob);
        try {
            int n;
            byte[] byArray = new byte[32000];
            char[] cArray = new char[32000];
            long l2 = 1L;
            boolean bl = true;
            if (l == -1L) {
                l = Long.MAX_VALUE;
                bl = false;
            }
            while (l > 0L && (n = inputStream.read(byArray, 0, l < (long)byArray.length ? (int)l : byArray.length)) != -1) {
                this.a(byArray, cArray, n);
                yasClob.setString(l2, new String(cArray), 0, n);
                l2 += (long)n;
                l -= (long)n;
            }
            if (l > 0L && bl) {
                throw SQLError.createSQLException(l + " char of CLOB data cannot be read", YasState.NO_DATA);
            }
        }
        catch (IOException iOException) {
            yasClob.free();
            throw SQLError.createSQLException("stream closed", YasState.IO_ERROR, (Throwable)iOException);
        }
        return yasClob;
    }

    private void a(byte[] byArray, char[] cArray, int n) {
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
    }

    private boolean i() {
        return this.connection.getSession().getConnectVersion().getValue() >= ConnectVersion.VER5.getValue();
    }

    private void a(Object object, int n) throws SQLException {
        if (object == null) {
            return;
        }
        if (this.streamParameters == null) {
            this.streamParameters = new HashSet();
            this.streamParameters.add(object);
            return;
        }
        if (this.streamParameters.contains(object)) {
            throw SQLError.createSQLException("Duplicate stream parameter: " + n, YasState.DATA_ERROR);
        }
        this.streamParameters.add(object);
    }

    private void b(Object object, int n) throws SQLException {
        Closeable closeable;
        if (object == null) {
            return;
        }
        if (object instanceof YasLobInputStream && ((YasLobInputStream)(closeable = (YasLobInputStream)object)).a(this.connection)) {
            throw SQLError.createSQLException("Can not bind stream from lob of current connection: " + n, YasState.DATA_ERROR);
        }
        if (object instanceof YasClobReader && ((YasClobReader)(closeable = (YasClobReader)object)).a(this.connection)) {
            throw SQLError.createSQLException("Can not bind stream from lob of current connection: " + n, YasState.DATA_ERROR);
        }
    }

    private void a(long l) throws SQLException {
        if (l < 0L) {
            throw SQLError.createSQLException(Messages.get("Invalid stream length {0}.", l), YasState.INVALID_PARAMETER_VALUE);
        }
    }

    private void a(java.util.Date date) throws SQLException {
        if (date == null) {
            return;
        }
        long l = date.getTime();
        if (l > YasConstants.MAX_TIMESTAMP_VALUE || l < YasConstants.MIN_TIMESTAMP_VALUE) {
            throw SQLError.createSQLException("date/timestamp value overflow", YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public void setIsBatchError(boolean bl) {
        this.isBatchError = bl;
    }

    @Override
    public void reset() throws SQLException {
        super.reset();
        this.serverPrepare(this.preparedSQL);
    }

    @Override
    public String getSql() {
        return this.preparedSQL;
    }
}

