/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.YasResultSet;
import com.yashandb.jdbc.CachedResultSet;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.ResultSetImpl;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.ScrollableSensitiveResultSet;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.UpdatableResultSet;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.util.YasSQL;
import java.sql.SQLException;

public interface ResultSetFactory {
    public static final Logger LOGGER = LoggerFactory.getLogger(ResultSetFactory.class);

    public static YasResultSet createCachedResultSet(StatementImpl statementImpl, Field[] fieldArray, RowData rowData) throws SQLException {
        int n = statementImpl.getResultSetType();
        int n2 = statementImpl.getResultSetConcurrency();
        int n3 = statementImpl.getMaxRows();
        int n4 = statementImpl.getMaxFieldSize();
        int n5 = statementImpl.getResultSetHoldability();
        return new CachedResultSet(statementImpl, fieldArray, rowData, n3, n4, n, n2, n5);
    }

    public static YasResultSet createResultSet(StatementImpl statementImpl, Field[] fieldArray, RowData rowData, int n, int n2, int n3, int n4, int n5) throws SQLException {
        ResultSetImpl resultSetImpl = null;
        int n6 = n3;
        int n7 = n4;
        if (statementImpl.yasSQL != null && (n3 == 1005 || n4 == 1008)) {
            YasSQL yasSQL = statementImpl.yasSQL;
            statementImpl.yasSQL = null;
            n6 = ResultSetFactory.resetResultSetType(n3, n6, yasSQL);
            if (!yasSQL.canUpdatable() && n4 == 1008) {
                n7 = 1007;
                LOGGER.debug("Downgrade the ResultSet to CONCUR_READ_ONLY:" + yasSQL.getSQL());
            }
            if (yasSQL.canRowID() && yasSQL.canScrollSensitive() && n6 == 1005) {
                resultSetImpl = new ScrollableSensitiveResultSet(statementImpl, fieldArray, rowData, n, n2, n6, n7, n5, yasSQL);
            } else if (yasSQL.canRowID() && yasSQL.canUpdatable() && n7 == 1008) {
                resultSetImpl = new UpdatableResultSet(statementImpl, fieldArray, rowData, n, n2, n6, n7, n5, yasSQL);
            }
        }
        if (resultSetImpl == null) {
            resultSetImpl = new ResultSetImpl(statementImpl, fieldArray, rowData, n, n2, n6, n7, n5);
            resultSetImpl.setFetchSize(statementImpl.getFetchSize());
            resultSetImpl.setFetchDirection(statementImpl.getFetchDirection());
        }
        return resultSetImpl;
    }

    public static int resetResultSetType(int n, int n2, YasSQL yasSQL) {
        if (!yasSQL.canScrollSensitive() && n == 1005) {
            if (!yasSQL.canScrollInSensitive()) {
                n2 = 1003;
                LOGGER.debug("Downgrade the ResultSet to TYPE_FORWARD_ONLY:" + yasSQL.getSQL());
            } else {
                n2 = 1004;
                LOGGER.debug("Downgrade the ResultSet to TYPE_SCROLL_INSENSITIVE:" + yasSQL.getSQL());
            }
        }
        return n2;
    }
}

