/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.YasResultSet;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.NotUpdatable;
import com.yashandb.jdbc.ResultSetMetaDataImpl;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasStatement;
import com.yashandb.jdbc.YasType;
import com.yashandb.jdbc.exception.BatchError;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.json.YasonValue;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.protocol.accessor.AccessorFactory;
import com.yashandb.util.Messages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ResultSetImpl
implements YasResultSet {
    protected final YasConnection connection;
    protected final YasStatement owningStatement;
    private long updateCount;
    private final boolean reallyResult;
    private boolean stmtQueryResult = false;
    private boolean isClosed;
    protected boolean updatable = false;
    protected boolean doingUpdates = false;
    protected HashMap updateValues = null;
    protected HashMap updateSQLTypes = null;
    protected HashMap updateScales = null;
    private final int resultsetType;
    private final int resultsetConcurrency;
    private int fetchDirection = 1000;
    protected Field[] fields;
    protected Accessor[] accessors;
    protected long maxRows;
    protected final int maxFieldSize;
    protected long currentRow = -1L;
    protected Row thisRow;
    protected SQLWarning warnings = null;
    protected boolean nullFlag;
    protected boolean onInsertRow = false;
    protected int fetchSize;
    private Map columnNameIndexMap;
    private ResultSetMetaData resultSetMetaData;
    protected RowData rowData;
    private int[] dmlRows = null;
    private Map batchErrors = null;
    private ArrayList dmlRowList = null;
    private boolean isStreamRs = false;
    protected boolean fromYasArray = false;

    protected ResultSetMetaData createMetaData() {
        return new ResultSetMetaDataImpl(this.connection, this.fields);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.resultSetMetaData == null) {
            this.resultSetMetaData = this.createMetaData();
        }
        return this.resultSetMetaData;
    }

    public ResultSetImpl(YasConnection yasConnection, Field[] fieldArray, RowData rowData) throws SQLException {
        if (rowData == null) {
            throw new NullPointerException("packet must be non-null");
        }
        if (fieldArray == null) {
            throw new NullPointerException("fields must be non-null");
        }
        this.owningStatement = (YasStatement)yasConnection.createStatement();
        this.connection = yasConnection;
        this.fields = fieldArray;
        this.rowData = rowData;
        this.isClosed = false;
        this.accessors = AccessorFactory.generateAccessors(fieldArray, this.connection.getSession());
        this.maxRows = 0L;
        this.maxFieldSize = 0;
        this.resultsetType = 1003;
        this.resultsetConcurrency = 1007;
        this.updateCount = 0L;
        this.reallyResult = true;
    }

    ResultSetImpl(StatementImpl statementImpl, Field[] fieldArray, RowData rowData, int n, int n2, int n3, int n4, int n5) throws SQLException {
        if (rowData == null) {
            throw new NullPointerException("packet must be non-null");
        }
        if (fieldArray == null) {
            throw new NullPointerException("fields must be non-null");
        }
        this.owningStatement = statementImpl;
        this.connection = (YasConnection)statementImpl.getConnection();
        this.fields = fieldArray;
        this.rowData = rowData;
        this.isClosed = false;
        this.accessors = AccessorFactory.generateAccessors(fieldArray, this.connection.getSession());
        this.maxRows = n;
        this.maxFieldSize = n2;
        this.resultsetType = n3;
        this.resultsetConcurrency = n4;
        this.updateCount = 0L;
        this.reallyResult = true;
    }

    public ResultSetImpl(YasConnection yasConnection, YasStatement yasStatement) {
        this.updateCount = 0L;
        this.reallyResult = true;
        this.owningStatement = yasStatement;
        this.resultsetType = 1003;
        this.resultsetConcurrency = 1007;
        this.connection = yasConnection;
        this.rowData = null;
        this.isClosed = false;
        this.fields = null;
        this.accessors = null;
        this.maxRows = 0L;
        this.maxFieldSize = 0;
    }

    public ResultSetImpl(long l, YasConnection yasConnection, YasStatement yasStatement) {
        this.updateCount = l;
        this.reallyResult = false;
        this.owningStatement = yasStatement;
        this.resultsetType = 1003;
        this.resultsetConcurrency = 1007;
        this.connection = yasConnection;
        this.rowData = null;
        this.isClosed = false;
        this.fields = null;
        this.accessors = null;
        this.maxRows = 0L;
        this.maxFieldSize = 0;
    }

    public ResultSetImpl(long l, YasConnection yasConnection, YasStatement yasStatement, int[] nArray, Map map) {
        this.updateCount = l;
        this.reallyResult = false;
        this.owningStatement = yasStatement;
        this.resultsetType = 1003;
        this.resultsetConcurrency = 1007;
        this.connection = yasConnection;
        this.rowData = null;
        this.isClosed = false;
        this.fields = null;
        this.accessors = null;
        this.maxRows = 0L;
        this.maxFieldSize = 0;
        this.dmlRows = nArray;
        this.batchErrors = map;
    }

    @Override
    public URL getURL(int n) throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getURL(int)");
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    protected Object getStruct(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        String string = this.fields[n2].getTypeName();
        byte[] byArray = this.thisRow.get(n2);
        return this.accessors[n2].getStruct(string, byArray, this.fromYasArray);
    }

    protected Object internalGetObject(int n, Field field) throws SQLException {
        switch (this.getSQLType(n)) {
            case 16: {
                return this.getBoolean(n);
            }
            case -7: {
                if (field.getSize() == 1) {
                    return this.getBoolean(n);
                }
                return this.getBytes(n);
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getInt(n);
            }
            case 2009: {
                return this.getSQLXML(n);
            }
            case -5: {
                return this.getLong(n);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(n, field.getScale());
            }
            case 6: 
            case 8: {
                return this.getDouble(n);
            }
            case 7: {
                return Float.valueOf(this.getFloat(n));
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 3009: {
                return this.getObject(n, (Class)YasonValue.class);
            }
            case 92: {
                return this.getTime(n);
            }
            case 91: {
                if (this.connection.getSession().getMapDateToTimestamp()) {
                    return this.getTimestamp(n);
                }
                return this.getDate(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case 3001: 
            case 3002: {
                return this.getString(n);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case 2011: {
                return this.getNClob(n);
            }
            case 2003: {
                return this.getArray(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
            case -8: {
                return this.getRowId(n);
            }
            case 3008: {
                return this.d(n);
            }
            case 2002: {
                return this.getStruct(n);
            }
        }
        return null;
    }

    protected void checkScrollable() throws SQLException {
        this.checkClosed();
        if (this.resultsetType == 1003) {
            throw SQLError.createSQLException(Messages.get("Operation requires a scrollable ResultSet, but this ResultSet is FORWARD_ONLY.", new Object[0]), YasState.INVALID_CURSOR_STATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int n) throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkScrollable();
            this.prepareMove();
            if (n == 0) {
                this.rowData.beforeFirst();
                this.thisRow = null;
                this.currentRow = this.rowData.getPosition();
                return false;
            }
            if (n < 0) {
                if (this.a(n)) {
                    return false;
                }
            } else {
                if (this.maxRows > 0L && this.maxRows < (long)n) {
                    n = (int)this.maxRows;
                }
                this.rowData.setCurrentRow(n - 1);
                long l = this.rowData.getPosition();
                if ((long)(n - 1) > l || (long)(n - 1) == l && !this.rowData.hasNext()) {
                    this.thisRow = null;
                    this.currentRow = this.rowData.getPosition();
                    return false;
                }
                this.currentRow = this.rowData.getPosition();
                this.thisRow = this.rowData.getAt(this.currentRow);
            }
            return true;
        }
    }

    private boolean a(int n) throws SQLException {
        this.rowData.afterLast();
        long l = this.rowData.getPosition();
        l = this.maxRows > 0L && l > this.maxRows ? this.maxRows + (long)n : (l += (long)n);
        if (l < 0L) {
            this.rowData.beforeFirst();
            this.thisRow = null;
            this.currentRow = this.rowData.getPosition();
            return true;
        }
        this.rowData.setCurrentRow(l);
        this.currentRow = this.rowData.getPosition();
        this.thisRow = this.rowData.getAt(this.currentRow);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkScrollable();
            this.rowData.afterLast();
            this.thisRow = null;
            this.currentRow = this.rowData.getPosition();
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public Array getArray(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        String string = this.fields[n2].getTypeName();
        byte[] byArray = this.thisRow.get(n2);
        return this.accessors[n2].getArray(string, byArray, this.fromYasArray);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        this.owningStatement.closeStream(n);
        int n2 = n - 1;
        return this.accessors[n2].getBigDecimal(this.thisRow.get(n2));
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        return this.accessors[n2].getBlob(this.thisRow.get(n2), this.connection.getSession());
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        StringReader stringReader;
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        int n3 = this.fields[n2].getYasType();
        switch (n3) {
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                stringReader = new StringReader(this.getString(n));
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("getCharacterStream not implemented for type {0}", this.fields[n2].getTypeName()), YasState.WRONG_OBJECT_TYPE);
            }
        }
        return stringReader;
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        return this.accessors[n2].getClob(this.thisRow.get(n2), this.connection.getSession());
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultsetConcurrency;
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        return this.accessors[n2].getDate(this.thisRow.get(n2), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        return this.accessors[n2].getTime(this.thisRow.get(n2), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        return this.accessors[n2].getTimestamp(this.thisRow.get(n2), calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchDirection;
    }

    public Object getObjectImpl(String string, Map map) throws SQLException {
        return this.getObjectImpl(this.findColumn(string), map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectImpl(int n, Map map) throws SQLException {
        this.checkClosed();
        if (map != null) {
            this.accessors[n - 1].setTypeMap(map);
        }
        try {
            Object object = this.getObject(n);
            return object;
        }
        finally {
            this.accessors[n - 1].setTypeMap(null);
        }
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        this.checkClosed();
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getRef(int)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            if (this.currentRow == this.rowData.getFetchedRowCount() || this.maxRows > 0L && this.currentRow == this.maxRows) {
                return 0;
            }
            return (int)(this.currentRow + 1L);
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.owningStatement;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return this.resultsetType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            return this.rowData.isAfterLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            return this.rowData.isBeforeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            return this.currentRow == 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkScrollable();
            return this.rowData.isLast();
        }
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.currentRow == -1L) {
            return false;
        }
        return this.absolute((int)this.currentRow);
    }

    @Override
    public boolean relative(int n) throws SQLException {
        if (this.currentRow + 1L + (long)n < 0L) {
            this.beforeFirst();
            return false;
        }
        return this.absolute((int)this.currentRow + 1 + n);
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkClosed();
        switch (n) {
            case 1001: 
            case 1002: {
                this.checkScrollable();
                break;
            }
            case 1000: {
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("Invalid fetch direction constant: {0}.", n), YasState.INVALID_PARAMETER_VALUE);
            }
        }
        this.fetchDirection = n;
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        throw new NotUpdatable();
    }

    protected synchronized void clearRowBuffer() {
        if (this.updateValues != null) {
            this.updateValues.clear();
            this.updateSQLTypes.clear();
            this.updateScales.clear();
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public synchronized void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateAsciiStream()");
    }

    @Override
    public synchronized void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateBinaryStream()");
    }

    @Override
    public synchronized void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateValue(n, bigDecimal, YasType.DECIMAL, 0);
    }

    @Override
    public synchronized void updateByte(int n, byte by) throws SQLException {
        this.updateValue(n, String.valueOf(by), YasType.TINYINT, 0);
    }

    @Override
    public synchronized void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateValue(n, bl, YasType.BOOLEAN, 0);
    }

    @Override
    public synchronized void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateValue(n, byArray, YasType.BINARY, 0);
    }

    @Override
    public synchronized void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateCharacterStream()");
    }

    @Override
    public synchronized void updateDouble(int n, double d) throws SQLException {
        this.updateValue(n, d, YasType.DOUBLE, 0);
    }

    @Override
    public synchronized void updateDate(int n, Date date) throws SQLException {
        this.updateValue(n, date, YasType.DATE, 0);
    }

    @Override
    public synchronized void updateFloat(int n, float f) throws SQLException {
        this.updateValue(n, Float.valueOf(f), YasType.FLOAT, 0);
    }

    @Override
    public synchronized void updateLong(int n, long l) throws SQLException {
        this.updateValue(n, l, YasType.BIGINT, 0);
    }

    @Override
    public synchronized void updateInt(int n, int n2) throws SQLException {
        this.updateValue(n, n2, YasType.INTEGER, 0);
    }

    @Override
    public synchronized void updateNull(int n) throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public synchronized void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public synchronized void updateObject(int n, Object object) throws SQLException {
        this.updateObject(n, object, 0);
    }

    @Override
    public synchronized void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateValue(n, object, n2);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "refreshRow");
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public synchronized void updateShort(int n, short s) throws SQLException {
        this.updateValue(n, s, YasType.SMALLINT, 0);
    }

    @Override
    public synchronized void updateString(int n, String string) throws SQLException {
        this.updateValue(n, string, YasType.VARCHAR, 0);
    }

    @Override
    public synchronized void updateTime(int n, Time time) throws SQLException {
        this.updateValue(n, time, YasType.TIME, 0);
    }

    @Override
    public synchronized void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateValue(n, timestamp, YasType.TIMESTAMP, 0);
    }

    @Override
    public synchronized void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public synchronized void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public synchronized void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public synchronized void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public synchronized void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public synchronized void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public synchronized void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public synchronized void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public synchronized void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public synchronized void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public synchronized void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public synchronized void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public synchronized void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public synchronized void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public synchronized void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public synchronized void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public synchronized void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public synchronized void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    boolean a() throws SQLException {
        this.checkClosed();
        return this.updatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int n) throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            if (n < 0 && n != Integer.MIN_VALUE) {
                throw SQLError.createSQLException(Messages.get("Fetch size must be a value greater to or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
            }
            this.fetchSize = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            return this.fetchSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            boolean bl;
            this.checkClosed();
            if (this.onInsertRow) {
                this.onInsertRow = false;
            }
            if (this.doingUpdates) {
                this.doingUpdates = false;
            }
            if (!this.reallyResult()) {
                throw SQLError.createSQLException("ResultSet is from update", YasState.NO_DATA);
            }
            if (!this.owningStatement.isClosed()) {
                this.owningStatement.drainStream();
            }
            if (this.maxRows > 0L && this.currentRow >= this.maxRows - 1L) {
                this.currentRow = this.maxRows;
                return false;
            }
            if (this.rowData == null) {
                return false;
            }
            if (!this.rowData.hasNext()) {
                bl = false;
            } else {
                this.thisRow = this.rowData.next();
                ++this.currentRow;
                if (this.thisRow == null) {
                    bl = false;
                } else {
                    this.clearWarnings();
                    bl = true;
                }
            }
            if (!bl) {
                this.currentRow = this.rowData.getFetchedRowCount();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        ResultSetImpl resultSetImpl = this;
        synchronized (resultSetImpl) {
            if (!this.isClosed) {
                this.closeInternally();
            }
        }
    }

    protected void closeInternally() throws SQLException {
        this.b();
        this.rowData = null;
        this.isClosed = true;
        if (this.stmtQueryResult && !this.owningStatement.isClosed() && this.owningStatement.isCloseOnCompletion()) {
            this.owningStatement.close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.nullFlag;
    }

    private boolean b(int n) {
        return n == 2005 || n == 2004 || n == 2011;
    }

    @Override
    public String getString(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        if (this.b(this.fields[n2].getSQLType())) {
            return this.accessors[n2].getString(this.thisRow.get(n2));
        }
        return this.accessors[n2].getString(this.a(n, this.thisRow.get(n2)));
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return false;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        return this.accessors[n2].getBoolean(this.thisRow.get(n2));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return 0;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        return this.accessors[n2].getByte(this.thisRow.get(n2));
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return 0;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        return this.accessors[n2].getShort(this.thisRow.get(n2));
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return 0;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        return this.accessors[n2].getInt(this.thisRow.get(n2));
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return 0L;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        return this.accessors[n2].getLong(this.thisRow.get(n2));
    }

    @Override
    public float getFloat(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return 0.0f;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        return this.accessors[n2].getFloat(this.thisRow.get(n2));
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return 0.0;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        return this.accessors[n2].getDouble(this.thisRow.get(n2));
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n3 = n - 1;
        this.owningStatement.closeStream(n3);
        return this.accessors[n3].getBigDecimal(this.thisRow.get(n3));
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        if (this.b(this.fields[n2].getSQLType())) {
            return this.accessors[n2].getBytes(this.thisRow.get(n2));
        }
        return this.accessors[n2].getBytes(this.a(n, this.thisRow.get(n2)));
    }

    protected byte[] getInnerBytes(int n) throws SQLException {
        this.checkResultSet(n);
        return this.thisRow.get(n - 1);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return this.getDate(n, null);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return this.getTime(n, null);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, null);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        ByteArrayInputStream byteArrayInputStream;
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        int n3 = this.fields[n2].getYasType();
        switch (n3) {
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                byteArrayInputStream = new ByteArrayInputStream(this.getString(n).getBytes(StandardCharsets.US_ASCII));
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("getAsciiStream not implemented for type {0}", this.fields[n2].getTypeName()), YasState.WRONG_OBJECT_TYPE);
            }
        }
        return byteArrayInputStream;
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getUnicodeStream(int)");
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream;
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        int n3 = this.fields[n2].getYasType();
        switch (n3) {
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                inputStream = new ByteArrayInputStream(this.getBytes(n));
                break;
            }
            case 30: {
                inputStream = this.getBlob(n).getBinaryStream();
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("getBinaryStream not implemented for type {0}", this.fields[n2].getTypeName()), YasState.WRONG_OBJECT_TYPE);
            }
        }
        return inputStream;
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string), null);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    protected void addWarning(SQLWarning sQLWarning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(sQLWarning);
        } else {
            this.warnings = sQLWarning;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        Field field = this.fields[n - 1];
        if (field == null) {
            this.nullFlag = true;
            return null;
        }
        Map<String, Class<?>> map = this.connection.getTypeMap();
        boolean bl = false;
        if (map != null && !map.isEmpty() && this.accessors[n - 1].getTypeMap() == null) {
            this.accessors[n - 1].setTypeMap(map);
            bl = true;
        }
        Object object = this.internalGetObject(n, field);
        if (bl) {
            this.accessors[n - 1].setTypeMap(null);
        }
        if (object != null) {
            return object;
        }
        return null;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public int findColumn(String string) throws SQLException {
        this.checkClosed();
        int n = this.a(string);
        if (n == 0) {
            throw SQLError.createSQLException(Messages.get("The column name {0} was not found in this ResultSet.", string), YasState.UNDEFINED_COLUMN);
        }
        return n;
    }

    public static Map createColumnNameIndexMap(Field[] fieldArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(fieldArray.length * 2);
        for (int i = fieldArray.length - 1; i >= 0; --i) {
            String string = fieldArray[i].getName();
            hashMap.put(string.toLowerCase(Locale.US), i + 1);
        }
        return hashMap;
    }

    private int a(String string) {
        Integer n;
        if (this.columnNameIndexMap == null) {
            if (this.owningStatement != null) {
                this.columnNameIndexMap = this.owningStatement.getResultSetColumnNameToIndexMap();
            }
            if (this.columnNameIndexMap == null) {
                this.columnNameIndexMap = ResultSetImpl.createColumnNameIndexMap(this.fields);
            }
        }
        if ((n = (Integer)this.columnNameIndexMap.get(string)) != null) {
            return n;
        }
        n = (Integer)this.columnNameIndexMap.get(string.toLowerCase(Locale.US));
        if (n != null) {
            this.columnNameIndexMap.put(string, n);
            return n;
        }
        n = (Integer)this.columnNameIndexMap.get(string.toUpperCase(Locale.US));
        if (n != null) {
            this.columnNameIndexMap.put(string, n);
            return n;
        }
        return 0;
    }

    protected int getSQLType(int n) throws SQLException {
        Field field = this.fields[n - 1];
        return field.getSQLType();
    }

    protected void checkUpdatable() throws SQLException {
        this.checkClosed();
        if (!this.a()) {
            throw SQLError.createSQLException(Messages.get("ResultSet is not updatable. The query that generated this result set must select only one table, and not have aggregate function. See the JDBC 2.1 API Specification, section 5.6 for more details.", new Object[0]), YasState.INVALID_CURSOR_STATE);
        }
        if (this.updateValues == null) {
            this.updateValues = new HashMap((int)((double)this.fields.length / 0.75), 0.75f);
            this.updateSQLTypes = new HashMap((int)((double)this.fields.length / 0.75), 0.75f);
            this.updateScales = new HashMap((int)((double)this.fields.length / 0.75), 0.75f);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw SQLError.createSQLException(Messages.get("This ResultSet is closed.", new Object[0]), YasState.OBJECT_NOT_IN_STATE);
        }
    }

    protected void checkColumnIndex(int n) throws SQLException {
        if (n < 1 || n > this.fields.length) {
            throw SQLError.createSQLException(Messages.get("The column index is out of range: {0}, number of columns: {1}.", n, this.fields.length), YasState.INVALID_PARAMETER_VALUE);
        }
    }

    protected void checkResultSet(int n) throws SQLException {
        this.checkClosed();
        if (this.thisRow == null) {
            throw SQLError.createSQLException(Messages.get("ResultSet not positioned properly, perhaps you need to call next.", new Object[0]), YasState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(n);
        this.nullFlag = this.thisRow.get(n - 1) == null;
    }

    private boolean c(int n) throws SQLException {
        switch (this.getSQLType(n)) {
            case -16: 
            case -15: 
            case -9: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private byte[] a(int n, byte[] byArray) throws SQLException {
        int n2 = byArray.length;
        if (this.maxFieldSize > 0 && n2 > this.maxFieldSize && this.c(n)) {
            n2 = this.maxFieldSize;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    protected void updateValue(int n, Object object) throws SQLException {
        this.updateValue(n, object, 0);
    }

    protected void updateValue(int n, Object object, int n2) throws SQLException {
        this.updateValue(n, object, null, n2);
    }

    protected void updateValue(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateRef(int,Ref)");
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateRef(String,Ref)");
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateBlob(int,Blob)");
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateBlob(String,Blob)");
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateClob(int,Clob)");
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateClob(String,Clob)");
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateArray(int, Array)");
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    public Object getObject(int n, Class clazz) throws SQLException {
        if (clazz == null) {
            throw new SQLException("Invalid Parameter, Class Type is null");
        }
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        return this.accessors[n2].getObject(this.thisRow.get(n2), clazz, this.connection);
    }

    public Object getObject(String string, Class clazz) throws SQLException {
        return this.getObject(this.findColumn(string), clazz);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObjectImpl(string, map);
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObjectImpl(n, map);
    }

    @Override
    public void updateObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        this.updateValue(n, object, sQLType, n2);
    }

    @Override
    public void updateObject(String string, Object object, SQLType sQLType, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, sQLType, n);
    }

    @Override
    public void updateObject(int n, Object object, SQLType sQLType) throws SQLException {
        this.updateObject(n, object, sQLType, 0);
    }

    @Override
    public void updateObject(String string, Object object, SQLType sQLType) throws SQLException {
        this.updateObject(this.findColumn(string), object, sQLType);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n);
        return this.accessors[n2].getRowId(this.thisRow.get(n2));
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return this.getRowId(this.findColumn(string));
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        this.updateValue(n, rowId);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.updateRowId(this.findColumn(string), rowId);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getHoldability()");
    }

    @Override
    public boolean reallyResult() {
        if (this.rowData != null) {
            return true;
        }
        return this.reallyResult;
    }

    @Override
    public void setStmtQueryResult(boolean bl) {
        this.stmtQueryResult = bl;
    }

    @Override
    public String getServerInfo() {
        return null;
    }

    @Override
    public long getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public long getUpdateID() {
        return 0L;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.owningStatement.isClosed()) {
            this.isClosed = true;
        }
        return this.isClosed;
    }

    @Override
    public char getFirstCharOfQuery() {
        return '\u0000';
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNString(String, String)");
    }

    @Override
    public void appendResults(long l, int[] nArray, Map map) {
        this.updateCount += l;
        if (this.dmlRowList == null) {
            this.dmlRowList = new ArrayList();
            if (this.dmlRows != null) {
                for (int n3 : this.dmlRows) {
                    this.dmlRowList.add(n3);
                }
            }
        }
        int n = this.dmlRowList.size();
        if (nArray != null) {
            for (int n2 : nArray) {
                this.dmlRowList.add(n2);
            }
        } else {
            this.dmlRowList.add((int)l);
        }
        if (map == null) {
            return;
        }
        if (this.batchErrors == null) {
            this.batchErrors = new HashMap();
        }
        for (Map.Entry entry : map.entrySet()) {
            int n3;
            n3 = (Integer)entry.getKey() + n;
            BatchError batchError = (BatchError)entry.getValue();
            this.batchErrors.put(n3, batchError);
        }
    }

    @Override
    public YasResultSet getNextResultSet() {
        return null;
    }

    @Override
    public int getBytesSize() throws SQLException {
        return 0;
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNString(int, String)");
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNClob(int, NClob)");
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNClob(int, Reader)");
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNClob(String, Reader)");
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNClob(String, NClob)");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateBlob(int, InputStream, long)");
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.updateNClob(this.findColumn(string), reader, l);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        return this.accessors[n2].getNClob(this.thisRow.get(n2), this.connection.getSession());
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateBlob(int, InputStream)");
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNClob(int, Reader, long)");
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateClob(int, Reader, long)");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateClob(int, Reader)");
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(string), reader);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        this.owningStatement.closeStream(n2);
        return this.accessors[n2].getSQLXML(this.thisRow.get(n2));
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.updateClob(this.findColumn(string), reader, l);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.updateValue(n, sQLXML, YasType.SQLXML, 0);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.updateSQLXML(this.findColumn(string), sQLXML);
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.findColumn(string));
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.getCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNCharacterStream(String, Reader)");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNCharacterStream(int, Reader)");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateNCharacterStream(int, Reader, long)");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateCharacterStream(int, Reader, long)");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateNCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateBinaryStream(int, InputStream, long)");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateBinaryStream(int, InputStream)");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateCharaceterStream(int, Reader)");
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateAsciiStream(int, InputStream)");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "updateAsciiStream(int, InputStream, long)");
    }

    public Object unwrap(Class clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    protected void prepareMove() throws SQLException {
        if (this.onInsertRow) {
            this.onInsertRow = false;
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        this.owningStatement.drainStream();
        if (!this.reallyResult()) {
            throw SQLError.createSQLException("ResultSet is from update", YasState.NO_DATA);
        }
    }

    @Override
    public long getFetchedRowCount() throws SQLException {
        if (this.reallyResult && this.rowData != null) {
            return this.rowData.getFetchedRowCount();
        }
        return -1L;
    }

    @Override
    public int[] getBatchUpdateCounts() {
        if (this.dmlRowList == null) {
            return this.dmlRows;
        }
        int[] nArray = new int[this.dmlRowList.size()];
        for (int i = 0; i < this.dmlRowList.size(); ++i) {
            nArray[i] = (Integer)this.dmlRowList.get(i);
        }
        return nArray;
    }

    @Override
    public Map getBatchErrors() {
        return this.batchErrors;
    }

    @Override
    public String getBatchError(int n) {
        BatchError batchError;
        if (this.batchErrors != null && (batchError = (BatchError)this.batchErrors.get(n)) != null) {
            return batchError.toString();
        }
        return null;
    }

    private ResultSet d(int n) throws SQLException {
        this.checkResultSet(n);
        if (this.nullFlag) {
            return null;
        }
        int n2 = n - 1;
        return this.accessors[n2].getCursor(this.thisRow.get(n2), this.connection);
    }

    void b() throws SQLException {
        if (!this.isStreamRs || this.isClosed) {
            return;
        }
        boolean bl = this.next();
        while (bl) {
            bl = this.next();
        }
    }

    public void setStreamRs(boolean bl) {
        this.isStreamRs = bl;
    }
}

