/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.YasConstants;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasTypes;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.Messages;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;

public class ResultSetMetaDataImpl
implements ResultSetMetaData {
    YasConnection connection;
    Field[] fields;

    public ResultSetMetaDataImpl() {
    }

    public ResultSetMetaDataImpl(YasConnection yasConnection, Field[] fieldArray) {
        this.connection = yasConnection;
        this.fields = fieldArray;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        return n2 == 1 || n2 == 12 || n2 == -15 || n2 == -9 || n2 == 2005 || n2 == 2011 || n2 == 2009;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        return n2 != -4 && n2 != -1 && n2 != 2004 && n2 != 2005 && n2 != 2011 && n2 != 2002 && n2 != 2003 && n2 != 2006 && n2 != 2012 && n2 != 3009;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        return n2 == 2;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        Field field = this.getField(n);
        return field == null || field.getNullable() == 1 ? 1 : 0;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        Field field = this.getField(n);
        int n2 = field.getSQLType();
        int n3 = field.getPrecision();
        int n4 = field.getScale();
        switch (n2) {
            case 16: {
                return YasConstants.MAX_SIZE_BOOL;
            }
            case -6: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 4: {
                return 11;
            }
            case -5: {
                return 20;
            }
            case -8: {
                return 42;
            }
            case 7: {
                return 16;
            }
            case 8: {
                return 24;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2014: {
                return 64;
            }
            case -15: 
            case -9: 
            case -7: 
            case -2: 
            case 1: 
            case 12: {
                return field.getSize();
            }
            case 2: {
                if (n4 > 0) {
                    if (n3 > n4) {
                        return n3 + 2;
                    }
                    return n4 + 2;
                }
                if (n4 == -128) {
                    return 128;
                }
                return n3 - n4 + 1;
            }
            case 3002: {
                return n3 + 11 + n4;
            }
            case 3001: {
                return n3 + 4;
            }
            case 2004: 
            case 2005: 
            case 2009: 
            case 2011: 
            case 3009: {
                return 32000;
            }
        }
        return 20;
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        Field field = this.getField(n);
        return field.getName();
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return this.getColumnLabel(n);
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        Field field = this.getField(n);
        int n2 = field.getSQLType();
        switch (n2) {
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case -15: 
            case -9: 
            case -7: 
            case 1: 
            case 12: {
                return field.getSize();
            }
            case 2: 
            case 3001: 
            case 3002: {
                return field.getPrecision();
            }
            case 2004: 
            case 2005: 
            case 2011: 
            case 3009: {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public int getScale(int n) throws SQLException {
        Field field = this.getField(n);
        int n2 = field.getSQLType();
        int n3 = field.getScale();
        if (n2 == 2 || n3 > 0 && this.a(n2)) {
            return n3;
        }
        return 0;
    }

    private boolean a(int n) {
        return n == 8 || n == 7 || n == 6 || n == 2 || n == 3 || n == 91 || n == 92 || n == 93 || n == 3007 || n == 3001 || n == 3002 || n == 2014 || n == 2014;
    }

    @Override
    public String getTableName(int n) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        Field field = this.getField(n);
        if (field.getYasType() == 13 && this.connection.getSession().getMapDateToTimestamp()) {
            return 93;
        }
        return field.getSQLType();
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        Field field = this.getField(n);
        return field.getTypeName();
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    protected Field getField(int n) throws SQLException {
        if (n < 1 || n > this.fields.length) {
            throw SQLError.createSQLException(Messages.get("The column index is out of range: {0}, number of columns: {1}.", n, this.fields.length), YasState.INVALID_PARAMETER_VALUE);
        }
        return this.fields[n - 1];
    }

    protected int getSQLType(int n) throws SQLException {
        return this.fields[n - 1].getSQLType();
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        Field field = this.getField(n);
        if (field.getYasType() == 31 && field.getSize() == 1) {
            return Boolean.class.getName();
        }
        if (field.getYasType() == 13 && this.connection.getSession().getMapDateToTimestamp()) {
            return Timestamp.class.getName();
        }
        return YasTypes.getTypeClassName(field.getYasType());
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass());
    }

    public Object unwrap(Class clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }
}

