/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.core.SqlKind;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.ResultSetMetaDataImpl;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.util.Messages;
import com.yashandb.util.YasSQL;
import java.sql.SQLException;
import java.util.List;

public class ReturnColumnResultSetMetaData
extends ResultSetMetaDataImpl {
    int[] colIndexes;
    String[] colNames;
    String originalSql;
    String newSql;
    YasSQL parser = null;
    SqlKind sqlKind = SqlKind.UNINITIALIZED;
    int autoKeyType;
    int numColumns;
    String[] tableColumnNames;
    int[] tableColumnTypes;
    int[] tableMaxLengths;
    boolean[] tableNullables;
    int[] tablePrecisions;
    int[] tableScales;
    int[] returnTypes;
    String tableName;
    Field[] autoKeyFields;
    Boolean withBatchInsert = false;
    public static final int RETURN_ROW_ID = 0;
    public static final int RETURN_COLS_BY_INDEX = 1;
    public static final int RETURN_COLS_BY_NAME = 2;

    public ReturnColumnResultSetMetaData(String string) {
        this.originalSql = string;
        this.autoKeyType = 0;
    }

    public ReturnColumnResultSetMetaData(String string, int[] nArray) {
        this.originalSql = string;
        this.autoKeyType = 1;
        this.colIndexes = nArray;
    }

    public ReturnColumnResultSetMetaData(String string, String[] stringArray) {
        this.originalSql = string;
        this.colNames = this.a(stringArray);
        this.autoKeyType = 2;
    }

    private String[] a(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].contains("\"")) continue;
            stringArray[i] = String.format("\"%s\"", stringArray[i].toUpperCase());
        }
        return stringArray;
    }

    public String getNewSql() throws SQLException {
        if (this.newSql != null) {
            return this.newSql;
        }
        switch (this.autoKeyType) {
            case 0: {
                this.newSql = this.originalSql + " RETURNING ROWID INTO " + '?';
                this.returnTypes = new int[1];
                this.returnTypes[0] = 32;
                this.autoKeyFields = new Field[1];
                this.autoKeyFields[0] = new Field(0, "ROWID", 32, 20, 0, 0, 0);
                break;
            }
            case 1: {
                this.autoKeyFields = new Field[this.colIndexes.length];
                this.c();
                break;
            }
            case 2: {
                this.autoKeyFields = new Field[this.colNames.length];
                this.b();
                break;
            }
            default: {
                throw SQLError.createSQLException("invalid autokey type", YasState.DATA_ERROR);
            }
        }
        return this.newSql;
    }

    private int a(int n, String string, int[] nArray) throws SQLException {
        for (int i = 0; i < this.tableColumnNames.length; ++i) {
            if (!string.equals(String.format("\"%s\"", this.tableColumnNames[i]))) continue;
            nArray[n] = i + 1;
            return this.tableColumnTypes[i];
        }
        throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
    }

    private void b() throws SQLException {
        int n;
        if (this.tableColumnNames.length == 0) {
            throw SQLError.createSQLException(Messages.get("Table does not exist.", new Object[0]), YasState.UNDEFINED_TABLE);
        }
        this.returnTypes = new int[this.colNames.length];
        this.colIndexes = new int[this.colNames.length];
        StringBuilder stringBuilder = new StringBuilder(this.originalSql);
        stringBuilder.append(" RETURNING ");
        for (n = 0; n < this.colNames.length; ++n) {
            int n2;
            this.returnTypes[n] = n2 = this.a(n, this.colNames[n], this.colIndexes);
            stringBuilder.append(this.colNames[n]);
            if (n < this.colNames.length - 1) {
                stringBuilder.append(", ");
            }
            int n3 = this.colIndexes[n] - 1;
            this.autoKeyFields[n] = new Field(n, this.tableColumnNames[n3], this.tableColumnTypes[n3], this.tableMaxLengths[n3], this.tableNullables[n3] ? 1 : 0, this.tablePrecisions[n3], this.tableScales[n3]);
        }
        stringBuilder.append(" INTO ");
        for (n = 0; n < this.colNames.length - 1; ++n) {
            stringBuilder.append("?, ");
        }
        stringBuilder.append('?');
        this.newSql = new String(stringBuilder);
    }

    private void c() throws YasException {
        int n;
        if (this.tableColumnNames.length == 0) {
            throw SQLError.createSQLException(Messages.get("Table does not exist.", new Object[0]), YasState.UNDEFINED_TABLE);
        }
        this.returnTypes = new int[this.colIndexes.length];
        StringBuilder stringBuilder = new StringBuilder(this.originalSql);
        stringBuilder.append(" RETURNING ");
        for (n = 0; n < this.colIndexes.length; ++n) {
            int n2 = this.colIndexes[n] - 1;
            if (n2 < 0 || n2 >= this.tableColumnNames.length) {
                throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
            }
            int n3 = this.tableColumnTypes[n2];
            String string = this.tableColumnNames[n2];
            this.returnTypes[n] = n3;
            stringBuilder.append(String.format("\"%s\"", string));
            if (n < this.colIndexes.length - 1) {
                stringBuilder.append(", ");
            }
            this.autoKeyFields[n] = new Field(n, this.tableColumnNames[n2], this.tableColumnTypes[n2], this.tableMaxLengths[n2], this.tableNullables[n2] ? 1 : 0, this.tablePrecisions[n2], this.tableScales[n2]);
        }
        stringBuilder.append(" INTO ");
        for (n = 0; n < this.colIndexes.length - 1; ++n) {
            stringBuilder.append("?, ");
        }
        stringBuilder.append("?");
        this.newSql = new String(stringBuilder);
    }

    public boolean isInsert() throws YasException {
        if (this.sqlKind == SqlKind.UNINITIALIZED) {
            this.d();
        }
        return this.sqlKind == SqlKind.INSERT;
    }

    private void d() throws YasException {
        if (this.originalSql == null) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        if (this.parser == null) {
            this.parser = new YasSQL(this.originalSql);
        } else {
            this.parser.parseSQL(this.originalSql);
        }
        this.sqlKind = this.parser.getSqlKind();
    }

    public void initDescribedData(int n, List list, List list2, List list3, List list4, List list5, List list6) throws SQLException {
        this.a(n);
        for (int i = 0; i < n; ++i) {
            this.a(i, (String)list.get(i), (Integer)list2.get(i), (Integer)list3.get(i), (Boolean)list4.get(i), (Integer)list5.get(i), (Integer)list6.get(i));
        }
    }

    void a(int n) throws SQLException {
        this.numColumns = n;
        this.tableColumnNames = new String[n];
        this.tableColumnTypes = new int[n];
        this.tableMaxLengths = new int[n];
        this.tableNullables = new boolean[n];
        this.tablePrecisions = new int[n];
        this.tableScales = new int[n];
    }

    void a(int n, String string, int n2, int n3, boolean bl, int n4, int n5) throws SQLException {
        this.tableColumnNames[n] = string;
        this.tableColumnTypes[n] = n2;
        this.tableMaxLengths[n] = n3;
        this.tableNullables[n] = bl;
        this.tablePrecisions[n] = n4;
        this.tableScales[n] = n5;
    }

    String a() throws SQLException {
        int n;
        int n2;
        if (this.tableName != null) {
            return this.tableName;
        }
        String string = this.originalSql.trim().toUpperCase();
        int n3 = string.indexOf("INSERT");
        if ((n3 = string.indexOf("INTO", n3)) < 0) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        int n4 = string.length();
        for (n2 = n3 + 5; n2 < n4 && string.charAt(n2) == ' '; ++n2) {
        }
        if (n2 == n4) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        if (string.charAt(n2) == '\"') {
            int n5 = string.indexOf(34, n2 + 1);
            if (n2 == n5) {
                throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
            }
            return this.originalSql.trim().substring(n2, n5 + 1);
        }
        for (n = n2; n < n4 && string.charAt(n) != ' ' && string.charAt(n) != '('; ++n) {
        }
        if (n2 >= n) {
            throw SQLError.createSQLException(Messages.get("Invalid argument(s) in call.", new Object[0]), YasState.INVALID_PARAMETER_TYPE);
        }
        this.tableName = string.substring(n2, n);
        return this.tableName;
    }
}

