/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import java.util.Arrays;

public class Row {
    final boolean updatable;
    byte[][] data;

    public Row(int n) {
        this(new byte[n][], true);
    }

    public Row(byte[][] byArray) {
        this(byArray, false);
    }

    private Row(byte[][] byArray, boolean bl) {
        this.data = byArray;
        this.updatable = bl;
    }

    public byte[] get(int n) {
        return this.data[n];
    }

    public void set(int n, byte[] byArray) {
        if (!this.updatable) {
            throw new IllegalArgumentException("Attempted to write to readonly Row");
        }
        this.data[n] = byArray;
    }

    public void set(byte[][] byArray) {
        this.data = byArray;
    }

    public Row readOnlyCopy() {
        return new Row((byte[][])Arrays.copyOf(this.data, this.data.length), false);
    }

    public byte[][] get() {
        return this.data;
    }
}

