/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.SessionImpl;
import com.yashandb.jdbc.DynamicRowData;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.RowDataImpl;
import com.yashandb.jdbc.ScrollableRowDataImpl;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.StaticRowData;
import com.yashandb.protocol.ExecuteResult;
import com.yashandb.protocol.Packet;
import com.yashandb.util.YasSQL;
import java.sql.SQLException;

public class RowDataFactory {
    private RowDataFactory() {
    }

    public static RowData createRowDataImpl(SessionImpl sessionImpl, StatementImpl statementImpl, Packet packet, ExecuteResult executeResult) throws SQLException {
        YasSQL yasSQL = statementImpl.getYasSQL();
        RowDataImpl rowDataImpl = statementImpl.getResultSetType() == 1004 || statementImpl.getResultSetType() == 1005 ? new ScrollableRowDataImpl(sessionImpl, statementImpl, packet, executeResult) : new RowDataImpl(sessionImpl, statementImpl, packet, executeResult);
        if (RowDataFactory.rsNeedRowId(statementImpl) && yasSQL != null && yasSQL.canRowID()) {
            rowDataImpl.setHasRowID(true);
        }
        return rowDataImpl;
    }

    public static boolean rsNeedRowId(StatementImpl statementImpl) throws SQLException {
        int n = statementImpl.getResultSetType();
        if (n == 1005) {
            return true;
        }
        int n2 = statementImpl.getResultSetConcurrency();
        return n2 == 1008;
    }

    public static RowData createStaticRow(Row row) throws SQLException {
        return new StaticRowData(row);
    }

    public static RowData createDynamicRow(Row row) throws SQLException {
        return new DynamicRowData(row);
    }
}

