/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.Session;
import com.yashandb.SessionImpl;
import com.yashandb.YasResultSet;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.UpdatableRow;
import com.yashandb.jdbc.YasStatement;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.ExecuteResult;
import com.yashandb.protocol.Packet;
import java.sql.SQLException;
import java.util.ArrayList;

public class RowDataImpl
implements RowData {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementImpl.class);
    protected Session session;
    protected YasStatement stmt;
    protected Packet fromServer;
    protected long currRows;
    protected boolean hasMore;
    protected boolean hasRowID = false;
    protected long batchRows;
    protected int marginColumns;
    protected ArrayList rows;
    protected byte[][] marginRow;
    protected long fetchedRowCount = 0L;
    protected long maxRows = 0L;
    protected int arrayRowsSize = 0;
    protected boolean isReuse = false;

    public RowDataImpl(SessionImpl sessionImpl, YasStatement yasStatement, Packet packet, ExecuteResult executeResult) {
        this.session = sessionImpl;
        this.stmt = yasStatement;
        this.fromServer = packet;
        this.batchRows = executeResult.getBatchRows();
        this.marginColumns = executeResult.getMarginColumns();
        this.hasMore = executeResult.hasMoreRows();
        this.currRows = -1L;
        this.rows = new ArrayList();
        this.marginRow = null;
        this.fetchedRowCount = this.batchRows;
    }

    public RowDataImpl(Session session, int n) {
        this.session = session;
        this.rows = new ArrayList();
        this.batchRows = n;
        this.hasMore = false;
        this.currRows = -1L;
        this.marginRow = null;
        this.fetchedRowCount = this.batchRows;
    }

    @Override
    public void addRow(Row row) throws SQLException {
        this.rows.add(row);
        ++this.arrayRowsSize;
    }

    @Override
    public void addRow(Row row, long l) throws SQLException {
        this.rows.add((int)l, row);
        ++this.fetchedRowCount;
        ++this.arrayRowsSize;
        ++this.batchRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(byte[][] byArray) throws SQLException {
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            if (this.isReuse && this.rows.size() > this.arrayRowsSize) {
                ((Row)this.rows.get(this.arrayRowsSize)).set(byArray);
                ++this.arrayRowsSize;
            } else if (this.hasRowID) {
                this.addRow(new UpdatableRow(byArray));
            } else {
                this.addRow(new Row(byArray));
            }
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.a();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.a();
    }

    @Override
    public void beforeLast() throws SQLException {
        this.a();
    }

    @Override
    public void close() throws SQLException {
        this.session = null;
        this.stmt = null;
        this.fromServer = null;
    }

    @Override
    public Row getAt(long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw SQLError.createSQLException("Not support resultsize greater than 2147483647", YasState.INVALID_PARAMETER_VALUE);
        }
        return (Row)this.rows.get((int)l);
    }

    @Override
    public long getFetchedRowCount() throws SQLException {
        return this.fetchedRowCount;
    }

    @Override
    public YasResultSet getOwner() {
        return null;
    }

    @Override
    public boolean hasNext() throws SQLException {
        if (this.currRows < this.batchRows) {
            return true;
        }
        return this.currRows == this.batchRows && this.hasMore;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return false;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isDynamic() throws SQLException {
        return true;
    }

    @Override
    public boolean isEmpty() throws SQLException {
        return this.isBeforeFirst() && this.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        return false;
    }

    @Override
    public void moveRowRelative(long l) throws SQLException {
        this.a();
    }

    @Override
    public void absolute(long l) throws SQLException {
        this.a();
    }

    @Override
    public Row next() throws SQLException {
        if (this.currRows + 1L < this.batchRows) {
            return this.getAt(++this.currRows);
        }
        if (this.hasMore) {
            this.fetchMore();
            if (this.batchRows == 0L) {
                return null;
            }
            return this.getAt(++this.currRows);
        }
        return null;
    }

    protected void fetchMore() throws SQLException {
        this.currRows = -1L;
        this.arrayRowsSize = 0;
        this.isReuse = true;
        this.fetchMoreWithoutClear();
        this.isReuse = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchMoreWithoutClear() throws SQLException {
        Session session = this.session;
        synchronized (session) {
            boolean bl = false;
            while (!bl) {
                int n = this.marginColumns;
                LOGGER.trace("fetchMore start,timestamp:{},session id:{}, Statement id:{}", System.currentTimeMillis(), this.session.getSID(), this.stmt.getID());
                Packet packet = this.session.fetch(this.stmt, this.stmt.getFetchSize());
                LOGGER.trace("fetchMore end,timestamp:{},session id:{}, Statement id:{}", System.currentTimeMillis(), this.session.getSID(), this.stmt.getID());
                ExecuteResult executeResult = new ExecuteResult(packet);
                executeResult.getDMLError(packet);
                this.batchRows = executeResult.getBatchRows();
                this.marginColumns = executeResult.getMarginColumns();
                this.hasMore = executeResult.hasMoreRows();
                this.fromServer = packet;
                if (n > 0) {
                    if (this.batchRows == 0L) {
                        this.a(this.marginRow, packet, n, this.marginColumns);
                        continue;
                    }
                    this.a(this.marginRow, packet, n, this.stmt.getColumnCount());
                    this.addRow(this.marginRow);
                    this.marginRow = null;
                }
                this.decodeRows(n > 0 ? 1 : 0);
                this.fetchedRowCount += this.batchRows;
                bl = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRow(long l) throws SQLException {
        if (l >= 0L && l < (long)this.rows.size()) {
            ArrayList arrayList = this.rows;
            synchronized (arrayList) {
                this.rows.remove((int)l);
                --this.batchRows;
                --this.fetchedRowCount;
                --this.currRows;
                --this.arrayRowsSize;
            }
        }
    }

    @Override
    public void setCurrentRow(long l) throws SQLException {
        this.a();
    }

    @Override
    public long size() throws SQLException {
        return -1L;
    }

    @Override
    public void decodeRows(int n) throws SQLException {
        int n2 = n;
        while ((long)n2 < this.batchRows) {
            byte[][] byArray = this.getReuseRowData();
            this.a(byArray, this.fromServer, 0, this.stmt.getColumnCount());
            this.addRow(byArray);
            ++n2;
        }
        if (this.marginColumns > 0) {
            byte[][] byArrayArray = new byte[this.stmt.getColumnCount()][];
            this.a(byArrayArray, this.fromServer, 0, this.marginColumns);
            this.marginRow = byArrayArray;
        }
    }

    private void a() throws SQLException {
        throw new YasException("Operation not supported for streaming result sets", YasState.UNKNOWN_STATE);
    }

    private void a(byte[][] byArray, Packet packet, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            int n3 = packet.getRowSize();
            byArray[i] = (byte[])(n3 == 0 ? null : (this.isReuse && byArray[i] != null && byArray[i].length == n3 ? packet.getBytes(n3, byArray[i]) : packet.getBytes(n3)));
        }
    }

    @Override
    public long getPosition() {
        return this.currRows;
    }

    @Override
    public void setMaxRows(long l) throws SQLException {
        this.maxRows = l;
    }

    public void setHasRowID(boolean bl) {
        this.hasRowID = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow(Row row, long l) {
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            this.rows.set((int)l, row);
        }
    }

    @Override
    public void cacheAllRows() throws SQLException {
        while (this.hasMore) {
            this.fetchMoreWithoutClear();
        }
        this.batchRows = this.fetchedRowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] getReuseRowData() {
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            if (this.isReuse && this.rows.size() > this.arrayRowsSize) {
                return ((Row)this.rows.get(this.arrayRowsSize)).get();
            }
            return new byte[this.stmt.getColumnCount()][];
        }
    }
}

