/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.SessionImpl;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.RowDataImpl;
import com.yashandb.jdbc.YasStatement;
import com.yashandb.protocol.ExecuteResult;
import com.yashandb.protocol.Packet;
import java.sql.SQLException;

public class ScrollableRowDataImpl
extends RowDataImpl
implements RowData {
    public ScrollableRowDataImpl(SessionImpl sessionImpl, YasStatement yasStatement, Packet packet, ExecuteResult executeResult) {
        super(sessionImpl, yasStatement, packet, executeResult);
    }

    @Override
    public void afterLast() throws SQLException {
        while (this.hasMore) {
            this.fetchMoreWithoutClear();
        }
        if (this.rows.size() > 0) {
            this.currRows = this.rows.size();
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.rows.size() > 0) {
            this.currRows = -1L;
        }
    }

    @Override
    public void beforeLast() throws SQLException {
        while (this.hasMore) {
            this.fetchMoreWithoutClear();
        }
        if (this.rows.size() > 0) {
            this.currRows = this.rows.size() - 2;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.hasMore) {
            return false;
        }
        return this.currRows >= (long)this.rows.size() && this.rows.size() != 0;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.currRows == -1L && this.rows.size() != 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.currRows == 0L;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.hasMore) {
            return false;
        }
        return this.currRows == (long)(this.rows.size() - 1) && this.rows.size() != 0;
    }

    @Override
    public void moveRowRelative(long l) throws SQLException {
        long l2 = this.currRows + l;
        this.absolute(l2);
    }

    @Override
    public void setCurrentRow(long l) throws SQLException {
        this.absolute(l);
    }

    @Override
    public Row next() throws SQLException {
        if (this.currRows + 1L < this.fetchedRowCount) {
            return this.getAt(++this.currRows);
        }
        if (this.hasMore) {
            this.fetchMoreWithoutClear();
            if (this.batchRows == 0L) {
                return null;
            }
            return this.getAt(++this.currRows);
        }
        this.currRows = this.fetchedRowCount;
        return null;
    }

    @Override
    public void absolute(long l) throws SQLException {
        while (l >= this.fetchedRowCount && this.hasMore) {
            this.fetchMoreWithoutClear();
        }
        this.currRows = l >= (long)this.rows.size() ? (long)this.rows.size() : (l < 0L ? -1L : l);
    }

    @Override
    public boolean hasNext() throws SQLException {
        if (this.currRows < this.fetchedRowCount) {
            return true;
        }
        return this.currRows == this.fetchedRowCount && this.hasMore;
    }
}

