/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.UpdatableResultSet;
import com.yashandb.jdbc.UpdatableRow;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.util.YasSQL;
import java.sql.SQLException;

public class ScrollableSensitiveResultSet
extends UpdatableResultSet {
    int prefetchRowIDSize = 10;
    boolean hasMore = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScrollableSensitiveResultSet.class);

    public ScrollableSensitiveResultSet(StatementImpl statementImpl, Field[] fieldArray, RowData rowData, int n, int n2, int n3, int n4, int n5, YasSQL yasSQL) throws SQLException {
        super(statementImpl, fieldArray, rowData, n, n2, n3, n4, n5, yasSQL);
        this.updatable = n4 == 1008;
        if (this.fetchSize > 10) {
            this.prefetchRowIDSize = this.fetchSize;
        }
    }

    @Override
    public boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        boolean bl = super.absolute(n);
        if (this.thisRow != null) {
            try {
                this.refreshRow(((UpdatableRow)this.thisRow).getRowID());
            }
            catch (SQLException sQLException) {
                LOGGER.debug("absolute(" + n + ") failed:" + sQLException.getMessage(), sQLException);
            }
        }
        return bl;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            return this.currentRow == -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            return this.currentRow == 0L;
        }
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.currentRow == -1L) {
            return false;
        }
        return this.absolute((int)this.currentRow);
    }

    @Override
    public boolean relative(int n) throws SQLException {
        if (this.currentRow + 1L + (long)n < 0L) {
            this.beforeFirst();
            return false;
        }
        return this.absolute((int)this.currentRow + 1 + n);
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        this.doUpdate();
        if (this.updateCount > 0) {
            this.refreshRow(((UpdatableRow)this.thisRow).getRowID());
        }
    }
}

