/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.CancelQueryTask;
import com.yashandb.CancelQueryTaskImpl;
import com.yashandb.ParameterList;
import com.yashandb.Query;
import com.yashandb.Session;
import com.yashandb.SimpleParameterList;
import com.yashandb.YasResultSet;
import com.yashandb.core.SqlKind;
import com.yashandb.exception.DatabaseError;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectionImpl;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.ResultSetFactory;
import com.yashandb.jdbc.ResultSetImpl;
import com.yashandb.jdbc.ReturnColumnResultSetMetaData;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.RowDataFactory;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasInputStream;
import com.yashandb.jdbc.YasReturnColumnResultSet;
import com.yashandb.jdbc.YasStatement;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.protocol.accessor.AccessorFactory;
import com.yashandb.util.Messages;
import com.yashandb.util.Utils;
import com.yashandb.util.YasSQL;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;

public class StatementImpl
implements YasStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementImpl.class);
    private volatile boolean isClosed = false;
    protected int maxFieldSize = 0;
    protected long maxRows = 0L;
    protected boolean replaceProcessingEnabled = true;
    protected long timeout = 0L;
    protected DatabaseError warnings = null;
    protected int fetchSize = 0;
    protected ArrayList batchParameters = null;
    protected int resultsetType;
    protected int resultsetConcurrency;
    private final int rsHoldability;
    private boolean poolable;
    private boolean closeOnCompletion = false;
    protected int fetchdirection = 1000;
    protected final YasConnection connection;
    protected boolean autoGeneratedKeys = false;
    protected boolean hasPrepared = false;
    protected Set streamParameters;
    private final Object cancelLock = new Object();
    private short stmtID = (short)-1;
    private String nativeSql;
    protected YasResultSet currentResultSet = null;
    private ArrayList implicitResultSets = null;
    private int curImplicitResultPos = -1;
    protected YasResultSet generatedKeysResults = null;
    protected ReturnColumnResultSetMetaData returnColRsMetaData;
    protected long lastInsertId = -1L;
    protected short columnCount;
    private Field[] resultFields;
    private YasInputStream statementStream;
    protected YasSQL yasSQL = null;
    protected List batchSQLs;
    protected boolean isBatchError = false;
    protected Field[] parameterFields;
    protected ParameterList preparedParameters;
    protected Map outFieldsMap = null;
    protected Accessor[] accessors = null;
    protected Row outParameters = null;
    SqlKind sqlKind = SqlKind.UNINITIALIZED;
    int returnParamCount;
    private int originalFetchSize = 0;
    private int originalResultType = 1003;
    private int originalResultConcur = 1007;
    private static final String INVALID_ARGUMENT = Messages.get("Invalid argument(s) in call.", new Object[0]);

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.executeInternal(string);
        return this.getQueryResultSet();
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.b();
        this.executeInternal(string);
        return this.getExecuteUpdateResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            if (this.isClosed) {
                return;
            }
            if (this.currentResultSet != null && !this.currentResultSet.isClosed()) {
                ((ResultSetImpl)this.currentResultSet).b();
            }
            this.isClosed = true;
        }
        if (this.connection.isClosed()) {
            return;
        }
        this.connection.getSession().removeStatement(this);
        if (this.stmtID != -1) {
            this.connection.getSession().closeStmt(this.stmtID);
        }
        this.closeForNextExecution();
    }

    private void a() throws SQLException {
        try {
            this.statementStream.close();
        }
        catch (IOException iOException) {
            throw SQLError.createSQLException("close stream fail ", YasState.IO_ERROR, (Throwable)iOException);
        }
    }

    @Override
    public void addImplicitResultSet(YasResultSet yasResultSet) {
        if (this.implicitResultSets == null) {
            this.implicitResultSets = new ArrayList();
        }
        this.implicitResultSets.add(yasResultSet);
    }

    @Override
    public void reset() throws SQLException {
        this.stmtID = (short)-1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableStreamResultSet() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.originalFetchSize = this.fetchSize;
            this.originalResultType = this.resultsetType;
            this.originalResultConcur = this.resultsetConcurrency;
            this.setFetchSize(Integer.MIN_VALUE);
            this.resultsetType = 1003;
            this.resultsetConcurrency = 1007;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableStreamResultSet() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            if (this.streamResultSetEnabled()) {
                this.setFetchSize(this.originalFetchSize);
                this.resultsetType = this.originalResultType;
                this.resultsetConcurrency = this.originalResultConcur;
            }
        }
    }

    @Override
    public boolean streamResultSetEnabled() {
        return this.fetchSize == Integer.MIN_VALUE && this.resultsetType == 1003 && this.resultsetConcurrency == 1007;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStream(YasInputStream yasInputStream) throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (this.statementStream == null) {
                return;
            }
            this.a();
            this.statementStream = yasInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drainStream() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (this.statementStream == null) {
                return;
            }
            this.a();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeStream(int n) throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (this.statementStream == null || this.statementStream.getColumnIndex() >= n) {
                return;
            }
            this.a();
        }
    }

    @Override
    public int getID() {
        return this.stmtID;
    }

    @Override
    public Session getSession() {
        return this.connection.getSession();
    }

    @Override
    public void closeQuery() {
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkClosed();
        this.replaceProcessingEnabled = bl;
    }

    @Override
    public Map getResultSetColumnNameToIndexMap() {
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return this.maxFieldSize;
    }

    @Override
    public Query[] getSubQueries() {
        return new Query[0];
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw SQLError.createSQLException(Messages.get("The maximum field size must be a value greater than or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        this.maxFieldSize = n;
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.setLargeMaxRows(n);
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return (int)this.maxRows;
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        this.checkClosed();
        long l = this.timeout / 1000L;
        if (l >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public synchronized void setQueryTimeout(int n) throws SQLException {
        this.a((long)n * 1000L);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        DatabaseError databaseError = this.warnings;
        return databaseError != null ? databaseError.getFirstWarning() : null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.checkClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (this.currentResultSet != null && this.currentResultSet.reallyResult()) {
                return this.currentResultSet;
            }
            if (this.implicitResultSets != null) {
                throw SQLError.createSQLException("No ResultSet is Available", YasState.DATA_ERROR);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateCount() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            return (int)this.getLargeUpdateCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String string) throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            this.addBatchSQL(string);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.b();
        return this.executeInternal(string);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultsetConcurrency;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchdirection = n;
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.get("Invalid fetch direction constant: {0}.", n), YasState.INVALID_PARAMETER_VALUE);
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchdirection;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return this.resultsetType;
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        this.checkClosed();
        if (n < 0 && n != Integer.MIN_VALUE) {
            throw SQLError.createSQLException(Messages.get("Fetch size must be a value greater to or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        this.fetchSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            this.d();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return Utils.toIntArray(this.executeLargeBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int n) throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            this.b(n);
            if (this.implicitResultSets == null) {
                return false;
            }
            ++this.curImplicitResultPos;
            if (this.curImplicitResultPos >= this.implicitResultSets.size()) {
                return false;
            }
            this.currentResultSet = (YasResultSet)this.implicitResultSets.get(this.curImplicitResultPos);
            return this.currentResultSet != null && this.currentResultSet.reallyResult();
        }
    }

    private void b(int n) throws SQLException {
        switch (n) {
            case 1: {
                if (this.currentResultSet == null || this.currentResultSet.isClosed()) break;
                this.currentResultSet.close();
                break;
            }
            case 2: {
                if (this.currentResultSet == null || this.currentResultSet.isClosed()) break;
                this.currentResultSet.setKept(true);
                this.currentResultSet = null;
                break;
            }
            case 3: {
                if (this.implicitResultSets == null) break;
                for (int i = 0; i < this.curImplicitResultPos; ++i) {
                    YasResultSet yasResultSet = (YasResultSet)this.implicitResultSets.get(i);
                    if (yasResultSet.isClosed() || !yasResultSet.isKept()) continue;
                    yasResultSet.close();
                }
                break;
            }
            default: {
                throw SQLError.createSQLException("invalid parameter", YasState.DATA_ERROR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (this.generatedKeysResults != null) {
                return this.generatedKeysResults;
            }
            this.generatedKeysResults = new YasReturnColumnResultSet(this);
            return this.generatedKeysResults;
        }
    }

    private void b() {
        this.returnColRsMetaData = null;
        this.autoGeneratedKeys = false;
        this.returnParamCount = 0;
        this.generatedKeysResults = null;
        this.hasPrepared = false;
        this.preparedParameters = null;
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        return (int)this.executeLargeUpdate(string, n);
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        return (int)this.executeLargeUpdate(string, nArray);
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        return (int)this.executeLargeUpdate(string, stringArray);
    }

    @Override
    public void createParameterResult(Row row) throws SQLException {
        this.outParameters = row;
        this.accessors = AccessorFactory.generateAccessors(this.returnColRsMetaData.autoKeyFields, this.getSession());
        if (this.autoGeneratedKeys) {
            if (!this.returnColRsMetaData.withBatchInsert.booleanValue()) {
                RowData rowData = RowDataFactory.createStaticRow(row);
                this.generatedKeysResults = new YasReturnColumnResultSet(this, this.returnColRsMetaData.autoKeyFields, rowData);
            } else {
                RowData rowData = RowDataFactory.createDynamicRow(row);
                if (this.generatedKeysResults != null) {
                    YasReturnColumnResultSet yasReturnColumnResultSet = (YasReturnColumnResultSet)this.generatedKeysResults;
                    yasReturnColumnResultSet.addRow(row);
                    this.generatedKeysResults = yasReturnColumnResultSet;
                } else {
                    this.generatedKeysResults = new YasReturnColumnResultSet(this, this.returnColRsMetaData.autoKeyFields, rowData);
                }
            }
        }
    }

    void c() throws SQLException {
        for (int i = 0; i < this.returnParamCount; ++i) {
            int n = this.returnColRsMetaData.returnTypes[i];
            this.a(i, n);
        }
    }

    void a(int n, int n2) throws SQLException {
        this.preparedParameters.registerOutParameter(n + 1, n2);
    }

    private void e() throws SQLException {
        this.autoGeneratedKeys = true;
        this.connection.doDescribeTable(this.returnColRsMetaData);
        String string = this.returnColRsMetaData.getNewSql();
        switch (this.returnColRsMetaData.autoKeyType) {
            case 0: {
                this.returnParamCount = 1;
                break;
            }
            case 1: {
                this.returnParamCount = this.returnColRsMetaData.colIndexes.length;
                break;
            }
            case 2: {
                this.returnParamCount = this.returnColRsMetaData.colNames.length;
            }
        }
        this.connection.getSession().prepare(this, string);
        this.hasPrepared = true;
        this.c();
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        this.checkClosed();
        this.closeForNextExecution();
        this.b();
        if (n != 2 && n != 1) {
            throw SQLError.createSQLException(INVALID_ARGUMENT, YasState.INVALID_PARAMETER_TYPE);
        }
        this.returnColRsMetaData = new ReturnColumnResultSetMetaData(string);
        if (n == 2 || !this.returnColRsMetaData.isInsert()) {
            this.returnColRsMetaData = null;
            return this.execute(string);
        }
        this.e();
        ParameterList[] parameterListArray = new ParameterList[]{this.preparedParameters};
        this.executeInternal(parameterListArray);
        return this.currentResultSet != null && this.currentResultSet.reallyResult();
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        this.checkClosed();
        this.closeForNextExecution();
        this.b();
        if (nArray == null || nArray.length == 0) {
            throw SQLError.createSQLException(INVALID_ARGUMENT, YasState.INVALID_PARAMETER_TYPE);
        }
        this.returnColRsMetaData = new ReturnColumnResultSetMetaData(string, nArray);
        if (!this.returnColRsMetaData.isInsert()) {
            this.returnColRsMetaData = null;
            return this.execute(string);
        }
        this.e();
        ParameterList[] parameterListArray = new ParameterList[]{this.preparedParameters};
        this.executeInternal(parameterListArray);
        return this.currentResultSet != null && this.currentResultSet.reallyResult();
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.checkClosed();
        this.closeForNextExecution();
        this.b();
        if (stringArray == null || stringArray.length == 0) {
            throw SQLError.createSQLException(INVALID_ARGUMENT, YasState.INVALID_PARAMETER_TYPE);
        }
        this.returnColRsMetaData = new ReturnColumnResultSetMetaData(string, stringArray);
        if (!this.returnColRsMetaData.isInsert()) {
            this.returnColRsMetaData = null;
            return this.execute(string);
        }
        this.e();
        ParameterList[] parameterListArray = new ParameterList[]{this.preparedParameters};
        this.executeInternal(parameterListArray);
        return this.currentResultSet != null && this.currentResultSet.reallyResult();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        return this.closeOnCompletion;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.checkClosed();
        this.poolable = bl;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.connection.isClosed()) {
            this.isClosed = true;
        }
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
        this.closeOnCompletion = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLargeUpdateCount() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (this.currentResultSet == null) {
                return -1L;
            }
            if (this.currentResultSet.reallyResult() || this.currentResultSet.isClosed()) {
                return -1L;
            }
            return this.currentResultSet.getUpdateCount();
        }
    }

    @Override
    public synchronized void setLargeMaxRows(long l) throws SQLException {
        this.checkClosed();
        if (l < 0L) {
            throw SQLError.createSQLException(Messages.get("Maximum number of rows must be a value grater than or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        this.maxRows = l;
    }

    @Override
    public synchronized long getLargeMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            this.closeForNextExecution();
            int n = this.getBatchSQLSize();
            LOGGER.debug("batchItemSize is " + n);
            if (n <= 0) {
                return new long[0];
            }
            long[] lArray = new long[n];
            YasSQL yasSQL = null;
            long l = -1L;
            try {
                for (int i = 0; i < n; ++i) {
                    String string = this.a(i);
                    if (yasSQL == null) {
                        yasSQL = new YasSQL(string);
                    } else {
                        yasSQL.parseSQL(string);
                    }
                    if (yasSQL.isSELECT()) {
                        throw SQLError.createSQLException("invalid SELECT batch command " + i + ":" + string, YasState.UNKNOWN_STATE);
                    }
                    try {
                        this.executeInternal(string, true);
                        l = this.currentResultSet.getUpdateCount();
                    }
                    catch (SQLException sQLException) {
                        int[] nArray = new int[i];
                        for (int j = 0; j < i; ++j) {
                            nArray[j] = (int)lArray[j];
                        }
                        throw new BatchUpdateException("Execute failed at batch command " + i + ":" + string + " :" + sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
                    }
                    lArray[i] = l;
                }
            }
            finally {
                this.d();
            }
            return lArray;
        }
    }

    @Override
    public long executeLargeUpdate(String string) throws SQLException {
        this.b();
        this.executeInternal(string);
        return this.getExecuteLargeUpdateResult();
    }

    @Override
    public long executeLargeUpdate(String string, int n) throws SQLException {
        this.b();
        if (n != 2 && n != 1) {
            throw SQLError.createSQLException(INVALID_ARGUMENT, YasState.INVALID_PARAMETER_TYPE);
        }
        this.returnColRsMetaData = new ReturnColumnResultSetMetaData(string);
        if (n == 2 || !this.returnColRsMetaData.isInsert()) {
            this.returnColRsMetaData = null;
            this.executeInternal(string);
            return this.getExecuteLargeUpdateResult();
        }
        this.e();
        ParameterList[] parameterListArray = new ParameterList[]{this.preparedParameters};
        this.executeInternal(parameterListArray);
        return this.getExecuteLargeUpdateResult();
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        this.b();
        if (nArray == null || nArray.length == 0) {
            throw SQLError.createSQLException(INVALID_ARGUMENT, YasState.INVALID_PARAMETER_TYPE);
        }
        this.returnColRsMetaData = new ReturnColumnResultSetMetaData(string, nArray);
        if (!this.returnColRsMetaData.isInsert()) {
            this.returnColRsMetaData = null;
            this.executeInternal(string);
            return this.getExecuteLargeUpdateResult();
        }
        this.e();
        ParameterList[] parameterListArray = new ParameterList[]{this.preparedParameters};
        this.executeInternal(parameterListArray);
        return this.getExecuteLargeUpdateResult();
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        this.b();
        if (stringArray == null || stringArray.length == 0) {
            throw SQLError.createSQLException(INVALID_ARGUMENT, YasState.INVALID_PARAMETER_TYPE);
        }
        this.returnColRsMetaData = new ReturnColumnResultSetMetaData(string, stringArray);
        if (!this.returnColRsMetaData.isInsert()) {
            this.returnColRsMetaData = null;
            this.executeInternal(string);
            return this.getExecuteLargeUpdateResult();
        }
        this.e();
        ParameterList[] parameterListArray = new ParameterList[]{this.preparedParameters};
        this.executeInternal(parameterListArray);
        return this.getExecuteLargeUpdateResult();
    }

    public Object unwrap(Class clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean executeInternal(String string) throws SQLException {
        return this.executeInternal(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeInternal(String string, boolean bl) throws SQLException {
        if (string == null || string.trim().isEmpty()) {
            throw SQLError.createSQLException("SQL String cannot be NULL or empty", YasState.INVALID_PARAMETER_TYPE);
        }
        this.nativeSql = string = string.trim();
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            this.closeForNextExecution();
            if (!bl) {
                this.checkIfBatchExists();
            }
            string = this.a(string);
            LOGGER.trace("statement execute start,timestamp:{},session id:{},sql:{}", System.currentTimeMillis(), this.connection.getSession().getSID(), string);
            if (this.timeout > 0L) {
                this.a(string, bl);
            } else if (this.preparedParameters != null) {
                ParameterList[] parameterListArray = new ParameterList[]{this.preparedParameters};
                this.currentResultSet = this.connection.getSession().directExecute(this, string, parameterListArray, bl);
            } else {
                this.currentResultSet = this.connection.getSession().directExecute(this, string);
            }
            LOGGER.trace("statement execute end,timestamp:{},session id:{}, Statement id:{}", System.currentTimeMillis(), this.connection.getSession().getSID(), this.getID());
        }
        if (this.preparedParameters != null) {
            this.preparedParameters.clear();
            this.preparedParameters = null;
        }
        return this.currentResultSet != null && this.currentResultSet.reallyResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, boolean bl) throws SQLException {
        CancelQueryTask cancelQueryTask = null;
        try {
            cancelQueryTask = this.startTimer();
            if (this.preparedParameters != null) {
                ParameterList[] parameterListArray = new ParameterList[]{this.preparedParameters};
                this.currentResultSet = this.connection.getSession().directExecute(this, string, parameterListArray, bl);
            } else {
                this.currentResultSet = this.connection.getSession().directExecute(this, string);
            }
        }
        finally {
            this.killTimerTask(cancelQueryTask);
        }
    }

    private String a(String string) throws SQLException {
        if (this.resultsetConcurrency == 1008 || this.resultsetType == 1005) {
            this.yasSQL = this.buildYasSQL(string);
            if (this.yasSQL.canUpdatable() || this.yasSQL.canScrollSensitive()) {
                this.nativeSql = string = this.yasSQL.getRowIDAppendSQL();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        Object object = this.cancelLock;
        synchronized (object) {
            this.connection.cancelQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet getQueryResultSet() throws SQLException {
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.checkClosed();
            if (this.currentResultSet.getNextResultSet() != null) {
                throw SQLError.createSQLException(Messages.get("Multiple ResultSets were returned by the query.", new Object[0]), YasState.TOO_MANY_RESULTS);
            }
            this.currentResultSet.setStmtQueryResult(true);
            return this.currentResultSet;
        }
    }

    private void a(int n, int n2, int n3) throws YasException {
        if (n != 1003 && n != 1004 && n != 1005) {
            throw SQLError.createSQLException("Invalid parameter: type: " + n, YasState.INVALID_PARAMETER_VALUE);
        }
        if (n2 != 1007 && n2 != 1008) {
            throw SQLError.createSQLException("Invalid parameter: concurency: " + n2, YasState.INVALID_PARAMETER_VALUE);
        }
        if (n3 != 1) {
            throw SQLError.createSQLException("Invalid parameter: Holdability: " + n3, YasState.INVALID_PARAMETER_VALUE);
        }
    }

    StatementImpl(ConnectionImpl connectionImpl, int n, int n2, int n3) throws SQLException {
        this.a(n, n2, n3);
        this.connection = connectionImpl;
        this.resultsetType = n;
        this.resultsetConcurrency = n2;
        this.setFetchSize(connectionImpl.getDefaultFetchSize());
        this.rsHoldability = n3;
        this.connection.getSession().addStatement(this);
    }

    @Override
    public YasResultSet createResultSet(RowData rowData) throws SQLException {
        int n = this.getResultSetType();
        int n2 = this.getResultSetConcurrency();
        return ResultSetFactory.createResultSet(this, this.resultFields, rowData, this.getMaxRows(), this.getMaxFieldSize(), n, n2, this.getResultSetHoldability());
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw SQLError.createSQLException(Messages.get("This Statement has been closed.", new Object[0]), YasState.OBJECT_NOT_IN_STATE);
        }
        if (this.connection.isClosed()) {
            throw SQLError.createSQLException(Messages.get("The Connection of this Statement has been closed.", new Object[0]), YasState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeForNextExecution() throws SQLException {
        this.clearWarnings();
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            if (this.streamParameters != null) {
                this.streamParameters.clear();
            }
            if (this.currentResultSet != null && !this.currentResultSet.isClosed()) {
                boolean bl = this.currentResultSet.reallyResult();
                this.currentResultSet.close();
                if (this.closeOnCompletion && bl) {
                    throw SQLError.createSQLException(Messages.get("this statement has been closed", new Object[0]), YasState.OBJECT_NOT_IN_STATE);
                }
            }
            if (this.implicitResultSets != null) {
                for (YasResultSet yasResultSet : this.implicitResultSets) {
                    if (yasResultSet.isClosed()) continue;
                    yasResultSet.close();
                }
            }
            this.implicitResultSets = null;
            this.curImplicitResultPos = -1;
        }
    }

    private void a(long l) throws SQLException {
        this.checkClosed();
        if (l < 0L) {
            throw SQLError.createSQLException(Messages.get("Query timeout must be a value greater than or equals to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        this.timeout = l;
    }

    protected void executeInternal(ParameterList[] parameterListArray) throws SQLException {
        this.executeInternal(parameterListArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(ParameterList[] parameterListArray, boolean bl) throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.checkClosed();
            this.closeForNextExecution();
            if (!bl) {
                this.checkIfBatchExists();
            }
            LOGGER.trace("prepareStatement execute start,timestamp:{},session id:{}, Statement id:{}", System.currentTimeMillis(), this.connection.getSession().getSID(), this.getID());
            if (this.timeout > 0L) {
                CancelQueryTask cancelQueryTask = null;
                try {
                    cancelQueryTask = this.startTimer();
                    if (this.hasPrepared) {
                        this.currentResultSet = this.connection.getSession().execute(this, parameterListArray, 0, 0, 0, bl);
                    }
                    this.currentResultSet = this.connection.getSession().directExecute(this, this.getSql(), parameterListArray, bl);
                }
                finally {
                    this.killTimerTask(cancelQueryTask);
                }
            } else {
                this.currentResultSet = this.hasPrepared ? this.connection.getSession().execute(this, parameterListArray, 0, 0, 0, bl) : this.connection.getSession().directExecute(this, this.getSql(), parameterListArray, bl);
            }
            LOGGER.trace("prepareStatement execute end,timestamp:{},session id:{}, Statement id:{}", System.currentTimeMillis(), this.connection.getSession().getSID(), this.getID());
            this.hasPrepared = true;
        }
    }

    protected void checkIfBatchExists() throws SQLException {
        if (this.getBatchSQLSize() > 0) {
            throw SQLError.createSQLException("batch must be either executed or cleared", YasState.UNEXPECTED_ERROR);
        }
    }

    protected CancelQueryTask startTimer() {
        if (this.timeout == 0L) {
            return null;
        }
        CancelQueryTaskImpl cancelQueryTaskImpl = new CancelQueryTaskImpl(this);
        this.connection.getTimer().schedule((TimerTask)cancelQueryTaskImpl, this.timeout);
        return cancelQueryTaskImpl;
    }

    protected void killTimerTask(CancelQueryTask cancelQueryTask) {
        if (cancelQueryTask != null) {
            cancelQueryTask.cancel();
        }
    }

    public void setStmtID(short s, byte by) {
        this.stmtID = s;
        this.sqlKind = SqlKind.valueOf(by);
    }

    public void setFields(Field[] fieldArray) {
        this.columnCount = fieldArray == null ? (short)0 : (short)fieldArray.length;
        this.resultFields = fieldArray;
    }

    protected Field[] getFields() {
        return this.resultFields;
    }

    @Override
    public void setParameters(Field[] fieldArray) throws SQLException {
        this.parameterFields = fieldArray;
        if (this.preparedParameters == null || this.preparedParameters.getParameterCount() != fieldArray.length) {
            this.preparedParameters = new SimpleParameterList(fieldArray.length);
            this.preparedParameters.setCharset(this.getSession().getCharset());
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    protected YasSQL buildYasSQL(String string) {
        if (this.resultsetType == 1005 || this.resultsetConcurrency == 1008) {
            return new YasSQL(string);
        }
        return null;
    }

    protected YasSQL getYasSQL() {
        return this.yasSQL;
    }

    protected int getExecuteUpdateResult() throws SQLException {
        this.checkClosed();
        long l = this.getExecuteLargeUpdateResult();
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    protected long getExecuteLargeUpdateResult() throws SQLException {
        this.checkClosed();
        if (this.currentResultSet != null && this.currentResultSet.reallyResult()) {
            return this.currentResultSet.getFetchedRowCount();
        }
        return (int)this.getLargeUpdateCount();
    }

    protected void addBatchSQL(String string) {
        if (this.batchSQLs == null) {
            this.batchSQLs = new ArrayList();
        }
        this.batchSQLs.add(string);
    }

    protected int getBatchSQLSize() {
        if (this.batchSQLs == null) {
            return 0;
        }
        return this.batchSQLs.size();
    }

    String a(int n) {
        if (this.batchSQLs == null) {
            return null;
        }
        return (String)this.batchSQLs.get(n);
    }

    void d() {
        if (this.batchSQLs != null) {
            this.batchSQLs.clear();
        }
    }

    @Override
    public boolean getIsBatchError() {
        return this.isBatchError;
    }

    @Override
    public String getBatchError(int n) {
        if (this.currentResultSet != null) {
            return this.currentResultSet.getBatchError(n);
        }
        return null;
    }

    protected String getSql() {
        return this.nativeSql;
    }
}

