/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.ResultSetImpl;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.UpdatableRow;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasRowID;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.Messages;
import com.yashandb.util.YasSQL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;

public class UpdatableResultSet
extends ResultSetImpl {
    protected YasSQL yasSQL = null;
    protected PreparedStatement updatePreparedStatement = null;
    protected PreparedStatement insertPreparedStatement = null;
    protected PreparedStatement deletePreparedStatement = null;
    protected PreparedStatement refreshPreparedStatement = null;
    protected Field[] originalfields;
    protected Row savedCurrentRow;
    ResultSetMetaData resultSetmetaData = null;
    protected int updateCount = 0;
    protected int deleteCount = 0;
    protected int insertCount = 0;

    public UpdatableResultSet(StatementImpl statementImpl, Field[] fieldArray, RowData rowData, int n, int n2, int n3, int n4, int n5, YasSQL yasSQL) throws SQLException {
        super(statementImpl, fieldArray, rowData, n, n2, n3, n4, n5);
        this.yasSQL = yasSQL;
        this.updatable = true;
        this.originalfields = this.fields;
        this.fields = this.a(this.fields);
        this.accessors = this.a(this.accessors);
        this.resultSetmetaData = this.getMetaData();
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        this.checkUpdatable();
        this.onInsertRow = true;
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        this.savedCurrentRow = this.thisRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkClosed();
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            if (this.onInsertRow) {
                this.onInsertRow = false;
                this.thisRow = this.savedCurrentRow;
            }
            if (this.thisRow == null && this.currentRow > -1L) {
                this.thisRow = this.rowData.getAt(this.currentRow);
            }
        }
    }

    @Override
    protected void checkUpdatable() throws SQLException {
        super.checkUpdatable();
        if (!this.onInsertRow && !this.doingUpdates) {
            this.doingUpdates = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void insertRow() throws SQLException {
        this.checkUpdatable();
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            if (!this.onInsertRow) {
                throw SQLError.createSQLException("Please move to insert row first", YasState.UNKNOWN_STATE);
            }
            if (this.updateValues.size() == 0) {
                throw SQLError.createSQLException("No data to insert", YasState.UNKNOWN_STATE);
            }
            boolean[] blArray = this.c();
            if (this.insertPreparedStatement != null) {
                this.insertPreparedStatement.close();
            }
            String string = this.yasSQL.getInsertSQL(this.resultSetmetaData, blArray);
            this.insertPreparedStatement = this.connection.prepareStatement(string, 1);
            int n = 1;
            for (int i = 0; i < this.resultSetmetaData.getColumnCount(); ++i) {
                int n2;
                if (!blArray[i]) continue;
                String string2 = this.resultSetmetaData.getColumnName(i + 1);
                int n3 = n2 = this.updateScales.get(string2) == null ? -1 : (Integer)this.updateScales.get(string2);
                if (this.updateSQLTypes.containsKey(string2)) {
                    this.insertPreparedStatement.setObject(n++, this.updateValues.get(string2), (SQLType)this.updateSQLTypes.get(string2), n2);
                    continue;
                }
                this.insertPreparedStatement.setObject(n++, this.updateValues.get(string2), this.resultSetmetaData.getColumnType(i + 1), n2);
            }
            this.insertCount = this.insertPreparedStatement.executeUpdate();
            if (this.insertCount > 0) {
                ResultSet resultSet = this.insertPreparedStatement.getGeneratedKeys();
                resultSet.next();
                this.thisRow = this.getInsertedRow(resultSet.getBytes(1));
                this.rowData.addRow(this.thisRow, this.currentRow + 1L);
                this.rowData.next();
                ++this.currentRow;
            }
            this.insertPreparedStatement.close();
            this.insertPreparedStatement = null;
            this.clearRowBuffer();
            this.onInsertRow = false;
        }
    }

    private boolean[] c() throws SQLException {
        boolean[] blArray = new boolean[this.resultSetmetaData.getColumnCount()];
        for (int i = 0; i < this.resultSetmetaData.getColumnCount(); ++i) {
            blArray[i] = this.updateValues.containsKey(this.resultSetmetaData.getColumnName(i + 1));
        }
        return blArray;
    }

    @Override
    public void refreshRow() throws SQLException {
        this.refreshRow(((UpdatableRow)this.thisRow).getRowID());
        if (this.thisRow != null) {
            this.rowData.refreshRow(this.thisRow, this.currentRow);
        }
    }

    public void refreshRow(byte[] byArray) throws SQLException {
        Object object;
        if (this.refreshPreparedStatement == null) {
            object = this.yasSQL.getRefreshSQL(this.resultSetmetaData);
            this.refreshPreparedStatement = this.connection.prepareStatement((String)object);
        }
        this.refreshPreparedStatement.setString(1, new YasRowID(byArray).toString());
        object = this.refreshPreparedStatement.executeQuery();
        if (object.next()) {
            if (this.thisRow == null) {
                this.thisRow = this.savedCurrentRow;
            }
            for (int i = 1; i < this.thisRow.data.length; ++i) {
                this.thisRow.data[i] = ((ResultSetImpl)object).getInnerBytes(i + 1);
            }
        } else {
            throw SQLError.createSQLException("Can't refresh the row data,may be the row is deleted", YasState.UNKNOWN_STATE);
        }
        object.close();
    }

    public Row getInsertedRow(byte[] byArray) throws SQLException {
        Object object;
        if (this.refreshPreparedStatement == null) {
            object = this.yasSQL.getRefreshSQL(this.resultSetmetaData);
            this.refreshPreparedStatement = this.connection.prepareStatement((String)object);
        }
        this.refreshPreparedStatement.setString(1, new YasRowID(byArray).toString());
        object = this.refreshPreparedStatement.executeQuery();
        Throwable throwable = null;
        try {
            if (object.next()) {
                byte[][] byArrayArray = new byte[object.getMetaData().getColumnCount()][];
                for (int i = 0; i < byArrayArray.length; ++i) {
                    byArrayArray[i] = object.getBytes(i + 1);
                }
                UpdatableRow updatableRow = new UpdatableRow(byArrayArray);
                return updatableRow;
            }
            try {
                throw SQLError.createSQLException("Can't refresh the row data,may be the row is deleted", YasState.UNKNOWN_STATE);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            if (object != null) {
                if (throwable != null) {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    object.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateRow() throws SQLException {
        this.checkUpdatable();
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.doUpdate();
            if (this.updateCount > 0) {
                this.refreshRow();
            }
        }
    }

    public void doUpdate() throws SQLException {
        this.checkUpdatable();
        if (this.onInsertRow) {
            throw SQLError.createSQLException("On insert row", YasState.UNKNOWN_STATE);
        }
        if (!this.doingUpdates) {
            throw SQLError.createSQLException("No update data", YasState.UNKNOWN_STATE);
        }
        if (this.thisRow == null) {
            throw SQLError.createSQLException("Current row is invalid", YasState.UNKNOWN_STATE);
        }
        if (this.updateValues.size() == 0) {
            return;
        }
        boolean[] blArray = this.c();
        if (this.updatePreparedStatement != null) {
            this.updatePreparedStatement.close();
        }
        String string = this.yasSQL.getUpdateSQL(this.resultSetmetaData, blArray);
        this.updatePreparedStatement = this.connection.prepareStatement(string);
        int n = 1;
        for (int i = 0; i < this.resultSetmetaData.getColumnCount(); ++i) {
            n = this.a(blArray, n, i);
        }
        this.updatePreparedStatement.setString(n, new YasRowID(((UpdatableRow)this.thisRow).getRowID()).toString());
        this.updateCount = this.updatePreparedStatement.executeUpdate();
        if (this.updateCount < 1) {
            throw SQLError.createSQLException("Operation conflicts", YasState.DATA_ERROR);
        }
        this.updatePreparedStatement.close();
        this.updatePreparedStatement = null;
        this.doingUpdates = false;
        this.clearRowBuffer();
    }

    private int a(boolean[] blArray, int n, int n2) throws SQLException {
        if (blArray[n2]) {
            int n3;
            String string = this.resultSetmetaData.getColumnName(n2 + 1);
            int n4 = n3 = this.updateScales.get(string) == null ? -1 : (Integer)this.updateScales.get(string);
            if (this.updateSQLTypes.containsKey(string)) {
                this.updatePreparedStatement.setObject(n++, this.updateValues.get(string), (SQLType)this.updateSQLTypes.get(string), n3);
            } else if (!this.updateScales.containsKey(string)) {
                this.updatePreparedStatement.setObject(n++, this.updateValues.get(string));
            } else {
                this.updatePreparedStatement.setObject(n++, this.updateValues.get(string), this.resultSetmetaData.getColumnType(n2 + 1), n3);
            }
        }
        return n;
    }

    @Override
    public synchronized void updateNull(int n) throws SQLException {
        this.checkUpdatable();
        this.updateValues.put(this.resultSetmetaData.getColumnName(n), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteRow() throws SQLException {
        this.checkUpdatable();
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            this.doDelete();
            if (this.deleteCount > 0) {
                this.thisRow = null;
                this.rowData.removeRow(this.currentRow);
                --this.currentRow;
            }
        }
    }

    public void doDelete() throws SQLException {
        this.checkUpdatable();
        if (this.onInsertRow) {
            throw SQLError.createSQLException("On insert row", YasState.UNKNOWN_STATE);
        }
        if (this.rowDeleted() || this.thisRow == null) {
            throw SQLError.createSQLException("Current row is invalid", YasState.UNKNOWN_STATE);
        }
        if (this.deletePreparedStatement == null) {
            String string = this.yasSQL.getDeleteSQL();
            this.deletePreparedStatement = this.connection.prepareStatement(string);
        }
        this.deletePreparedStatement.setString(1, new YasRowID(((UpdatableRow)this.thisRow).getRowID()).toString());
        this.deleteCount = this.deletePreparedStatement.executeUpdate();
        if (this.deleteCount < 1) {
            throw SQLError.createSQLException("Operation conflicts", YasState.DATA_ERROR);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            throw SQLError.createSQLException(Messages.get("Cannot call cancelRowUpdates() when on the insert row.", new Object[0]), YasState.INVALID_CURSOR_STATE);
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.clearRowBuffer();
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return this.deleteCount > 0;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return this.insertCount > 0;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return this.updateCount > 0;
    }

    @Override
    protected void closeInternally() throws SQLException {
        super.closeInternally();
        if (this.updatePreparedStatement != null) {
            this.updatePreparedStatement.close();
        }
        if (this.insertPreparedStatement != null) {
            this.insertPreparedStatement.close();
        }
        if (this.deletePreparedStatement != null) {
            this.deletePreparedStatement.close();
        }
        if (this.refreshPreparedStatement != null) {
            this.refreshPreparedStatement.close();
        }
    }

    Field[] a(Field[] fieldArray) {
        Field[] fieldArray2 = new Field[fieldArray.length - 1];
        System.arraycopy(fieldArray, 1, fieldArray2, 0, fieldArray.length - 1);
        return fieldArray2;
    }

    Accessor[] a(Accessor[] accessorArray) {
        Accessor[] accessorArray2 = new Accessor[accessorArray.length - 1];
        System.arraycopy(accessorArray, 1, accessorArray2, 0, accessorArray.length - 1);
        return accessorArray2;
    }

    private void d() {
        this.updateCount = 0;
        this.insertCount = 0;
        this.deleteCount = 0;
    }

    @Override
    public boolean next() throws SQLException {
        this.d();
        this.clearRowBuffer();
        this.onInsertRow = false;
        this.doingUpdates = false;
        return super.next();
    }

    @Override
    protected void prepareMove() throws SQLException {
        super.prepareMove();
        this.d();
        this.clearRowBuffer();
        this.onInsertRow = false;
        this.doingUpdates = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() throws SQLException {
        YasConnection yasConnection = this.connection;
        synchronized (yasConnection) {
            boolean bl = this.rowDeleted();
            if (bl) {
                this.checkScrollable();
                this.prepareMove();
                this.currentRow = this.rowData.getPosition();
                if (this.currentRow <= -1L) {
                    return false;
                }
            } else {
                return super.previous();
            }
            this.thisRow = this.rowData.getAt(this.currentRow);
            return true;
        }
    }

    @Override
    protected void updateValue(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        this.checkUpdatable();
        if (!this.onInsertRow && (this.isBeforeFirst() || this.isAfterLast() || this.rowData.isEmpty())) {
            throw SQLError.createSQLException(Messages.get("Cannot update the ResultSet because it is either before the start or after the end of the results.", new Object[0]), YasState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(n);
        this.doingUpdates = !this.onInsertRow;
        ResultSetMetaData resultSetMetaData = this.resultSetmetaData;
        if (object == null) {
            this.updateNull(n);
        } else {
            this.updateValues.put(resultSetMetaData.getColumnName(n), object);
        }
        if (sQLType != null) {
            this.updateSQLTypes.put(resultSetMetaData.getColumnName(n), sQLType);
        } else {
            this.updateSQLTypes.remove(resultSetMetaData.getColumnName(n));
        }
        if (n2 != 0) {
            this.updateScales.put(resultSetMetaData.getColumnName(n), n2);
        } else {
            this.updateScales.remove(resultSetMetaData.getColumnName(n));
        }
    }
}

