/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.YasBlobOutputStream;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasLargeObject;
import com.yashandb.jdbc.YasLobInputStream;
import com.yashandb.jdbc.YasLobProcessor;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.Messages;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class YasBlob
implements YasLargeObject,
Blob {
    private YasLobProcessor lobProcessor = null;
    private YasConnection connection = null;
    private boolean isTempLob = false;
    private boolean isFree = false;
    private boolean inValid = false;

    public YasBlob(boolean bl) {
        this.isTempLob = bl;
    }

    public void setLobProcessor(YasLobProcessor yasLobProcessor) {
        this.lobProcessor = yasLobProcessor;
        this.lobProcessor.setLobType(30);
        this.lobProcessor.setYasLob(this);
    }

    public YasLobProcessor getLobProcessor() {
        return this.lobProcessor;
    }

    private void a() throws SQLException {
        if (this.connection.isClosed()) {
            throw SQLError.createSQLException(Messages.get("This connection has been closed.", new Object[0]), YasState.CONNECTION_DOES_NOT_EXIST);
        }
        if (this.isFree) {
            throw SQLError.createSQLException("the lob has been freed", YasState.DATA_ERROR);
        }
        if (this.inValid) {
            throw SQLError.createSQLException("the lob is inValid", YasState.DATA_ERROR);
        }
    }

    @Override
    public synchronized long length() throws SQLException {
        this.a();
        return this.lobProcessor.getLobLength();
    }

    @Override
    public synchronized byte[] getBytes(long l, int n) throws SQLException {
        this.a();
        return this.lobProcessor.getBytes(l, n);
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        this.a();
        return new YasLobInputStream(this);
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "position(byte[] pattern, long start)");
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "position(Blob pattern, long start)");
    }

    private void a(long l) throws SQLException {
        if (l < 1L) {
            throw SQLError.createSQLException("invalid parameter, ''pos'' should not be < 1", YasState.INVALID_PARAMETER_VALUE);
        }
        if (this.connection.getSession().getConnectVersion() == ConnectVersion.VER1) {
            if (l != this.length() + 1L) {
                throw SQLError.createSQLException("temp lob write only support append mode, ''pos'' should be lob length + 1", YasState.INVALID_PARAMETER_VALUE);
            }
        } else if (l > this.length() + 1L) {
            throw SQLError.createSQLException("invalid parameter, ''len'' should not be > lob length + 1", YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public synchronized int setBytes(long l, byte[] byArray) throws SQLException {
        this.a();
        this.a(l);
        if (byArray == null) {
            return 0;
        }
        this.b();
        return this.lobProcessor.setBytes(l, byArray, 0, byArray.length);
    }

    @Override
    public synchronized int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.a();
        this.a(l);
        if (byArray == null) {
            return 0;
        }
        if (n < 0 || n >= byArray.length || n2 <= 0 || n + n2 > byArray.length) {
            throw SQLError.createSQLException("parameter ''offset'' or ''len'' is invalid", YasState.INVALID_PARAMETER_VALUE);
        }
        if (!this.c()) {
            throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBytes(long pos, byte[] bytes, int offset, int len)");
        }
        this.b();
        return this.lobProcessor.setBytes(l, byArray, n, n2);
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        this.a();
        this.a(l);
        return new YasBlobOutputStream(this);
    }

    @Override
    public void truncate(long l) throws SQLException {
        if (this.connection.getSession().getConnectVersion() == ConnectVersion.VER1) {
            throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "truncate(long len)");
        }
        this.a();
        if (l < 0L || l > this.length()) {
            throw SQLError.createSQLException("invalid parameter, ''len'' should be between 0 and lob length", YasState.INVALID_PARAMETER_VALUE);
        }
        this.b();
        this.lobProcessor.truncate(l);
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.connection.isClosed()) {
            throw SQLError.createSQLException(Messages.get("This connection has been closed.", new Object[0]), YasState.CONNECTION_DOES_NOT_EXIST);
        }
        if (!this.isFree) {
            if (this.lobProcessor.needFree()) {
                this.lobProcessor.free();
            } else {
                this.connection.getSession().removeUpdatedKnlLob(this);
            }
            this.isFree = true;
        }
    }

    @Override
    public void setConnection(YasConnection yasConnection) {
        this.connection = yasConnection;
    }

    @Override
    public YasConnection getConnection() {
        return this.connection;
    }

    @Override
    public void freeTemp() throws SQLException {
        this.free();
    }

    @Override
    public int getStepSize() throws SQLException {
        this.a();
        return this.lobProcessor.getStepSize();
    }

    @Override
    public synchronized int getBytes(long l, byte[] byArray) throws SQLException {
        this.a();
        return this.lobProcessor.getBytes(l, byArray);
    }

    @Override
    public long getLobLength() throws SQLException {
        return this.length();
    }

    private void a(long l, long l2) throws SQLException {
        long l3 = this.getLobLength();
        if (l < 1L || l > l3 || l2 < 0L || l + l2 - 1L > l3) {
            throw SQLError.createSQLException("invalid parameter", YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public synchronized InputStream getBinaryStream(long l, long l2) throws SQLException {
        this.a();
        this.a(l, l2);
        return new YasLobInputStream(this, l, l2);
    }

    @Override
    public int writeBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        return this.setBytes(l, byArray, n, n2);
    }

    private void b() throws SQLException {
        if (this.lobProcessor.getInnerLobType() != 4) {
            return;
        }
        YasBlob yasBlob = (YasBlob)this.connection.createBlob();
        yasBlob.setBytes(1L, this.getBytes(1L, (int)this.length()));
        this.setLobProcessor(yasBlob.getLobProcessor());
        this.isTempLob = true;
    }

    @Override
    public void rollback() throws SQLException {
        if (this.lobProcessor.isUpdated()) {
            this.inValid = true;
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.lobProcessor.isUpdated()) {
            this.lobProcessor.setUpdated(false);
        }
    }

    public byte[] getLobLocator() {
        return this.lobProcessor.getLobLocator();
    }

    private boolean c() {
        return this.isTempLob || this.connection.getSession().getConnectVersion() != ConnectVersion.VER1;
    }
}

