/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.jdbc.YasLargeObject;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class YasBlobOutputStream
extends OutputStream {
    private YasLargeObject largeObject = null;
    private int cachePos = 0;
    private byte[] cacheData = null;
    private boolean isClosed = false;
    private final Object lock = new Object();

    YasBlobOutputStream(YasLargeObject yasLargeObject) throws SQLException {
        this.largeObject = yasLargeObject;
        this.cachePos = 0;
        int n = yasLargeObject.getStepSize();
        this.cacheData = n > 0 ? new byte[n] : new byte[32000];
    }

    private void a() throws IOException {
        if (this.isClosed) {
            throw new IOException("stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.a();
            if (this.cachePos > 0) {
                try {
                    this.largeObject.writeBytes(this.largeObject.getLobLength() + 1L, this.cacheData, 0, this.cachePos);
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
                this.cachePos = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.a();
            if (this.cachePos >= this.cacheData.length - 1) {
                this.flush();
            }
            this.cacheData[this.cachePos] = (byte)n;
            ++this.cachePos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.flush();
            super.close();
            this.isClosed = true;
        }
    }
}

