/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectionImpl;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.PreparedStatementImpl;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasTypes;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.json.YasonValue;
import com.yashandb.protocol.accessor.AccessorFactory;
import com.yashandb.protocol.accessor.LobAccessor;
import com.yashandb.util.Messages;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class YasCallableStatement
extends PreparedStatementImpl
implements CallableStatement {
    private boolean wasNullFlag = false;

    YasCallableStatement(ConnectionImpl connectionImpl, String string, int n, int n2, int n3) throws SQLException {
        super(connectionImpl, string, n, n2, n3);
        if (!this.hasPrepared) {
            this.serverPrepare(this.preparedSQL);
        }
        this.outFieldsMap = new TreeMap();
    }

    @Override
    public void createParameterResult(Row row) throws SQLException {
        if (this.autoGeneratedKeys) {
            super.createParameterResult(row);
            return;
        }
        Field[] fieldArray = new Field[this.outFieldsMap.size()];
        Iterator iterator = this.outFieldsMap.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ((Field)entry.getValue()).setId(n);
            fieldArray[n] = (Field)entry.getValue();
            ++n;
        }
        this.outParameters = row;
        this.accessors = AccessorFactory.generateAccessors(fieldArray, this.getSession());
    }

    private void b(int n) throws SQLException {
        if (this.outFieldsMap == null || !this.outFieldsMap.containsKey(n)) {
            throw SQLError.createSQLException("invalid parameter index", YasState.DATA_ERROR);
        }
    }

    private void c(int n) throws SQLException {
        if (this.parameterFields == null) {
            throw SQLError.createSQLException("no parameters", YasState.INVALID_PARAMETER_VALUE);
        }
        if (n < 1 || n > this.parameterFields.length) {
            throw SQLError.createSQLException(Messages.get("The column index is out of range: {0}, number of columns: {1}.", n, this.parameterFields.length), YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public void registerOutParameter(int n, int n2) throws SQLException {
        this.checkClosed();
        this.c(n);
        int n3 = YasTypes.getYasType(n2);
        int n4 = n - 1;
        this.parameterFields[n4].setYasType(n3);
        this.preparedParameters.registerOutParameter(n, n3);
        this.outFieldsMap.put(n, this.parameterFields[n4]);
    }

    @Override
    public void clearParameters() throws SQLException {
        super.clearParameters();
        this.outFieldsMap.clear();
    }

    @Override
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    @Override
    public boolean wasNull() {
        return this.wasNullFlag;
    }

    private void d(int n) throws SQLException {
        this.checkClosed();
        this.c(n);
        this.b(n);
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        if (this.outParameters == null) {
            throw SQLError.createSQLException("invalid parameter index", YasState.DATA_ERROR);
        }
        this.wasNullFlag = this.outParameters.get(n2) == null;
    }

    @Override
    public String getString(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        byte[] byArray = this.outParameters.get(n2);
        if (this.accessors[n2] instanceof LobAccessor) {
            return this.accessors[n2].getString(byArray);
        }
        return this.accessors[n2].getString(this.a(byArray));
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return false;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getBoolean(this.outParameters.get(n2));
    }

    private YasonValue e(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return (YasonValue)this.accessors[n2].getObject(this.outParameters.get(n2), YasonValue.class, this.connection);
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return 0;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getByte(this.outParameters.get(n2));
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return 0;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getShort(this.outParameters.get(n2));
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return 0;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getInt(this.outParameters.get(n2));
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return 0L;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getLong(this.outParameters.get(n2));
    }

    @Override
    public float getFloat(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return 0.0f;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getFloat(this.outParameters.get(n2));
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return 0.0;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getDouble(this.outParameters.get(n2));
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n3 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n3].getBigDecimal(this.outParameters.get(n3));
    }

    private byte[] a(byte[] byArray) {
        int n = byArray.length;
        if (this.maxFieldSize > 0 && n > this.maxFieldSize) {
            n = this.maxFieldSize;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getBytes(this.a(this.outParameters.get(n2)));
    }

    @Override
    public Date getDate(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getDate(this.outParameters.get(n2), null);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getTime(this.outParameters.get(n2), null);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getTimestamp(this.outParameters.get(n2), null);
    }

    private Object f(int n) throws SQLException {
        Field field = (Field)this.outFieldsMap.get(n);
        int n2 = field.getSQLType();
        switch (n2) {
            case -7: 
            case 16: {
                int n3 = ((Field)this.outFieldsMap.get(n)).getId();
                if (this.outParameters.get(n3).length > 1) {
                    return this.getBytes(n);
                }
                return this.getBoolean(n);
            }
            case 2009: {
                return this.getSQLXML(n);
            }
            case 7: {
                return Float.valueOf(this.getFloat(n));
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(n, field.getScale());
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getInt(n);
            }
            case -5: {
                return this.getLong(n);
            }
            case 6: 
            case 8: {
                return this.getDouble(n);
            }
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 3001: 
            case 3002: {
                return this.getString(n);
            }
            case 3009: {
                return this.e(n);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
            case 2002: {
                return this.getStruct(n);
            }
            case 2003: {
                return this.getArray(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case 2011: {
                return this.getNClob(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
            case -8: {
                return this.getRowId(n);
            }
            case 2012: 
            case 3008: {
                return this.g(n);
            }
        }
        return null;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        return this.f(n);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getBigDecimal(this.outParameters.get(n2));
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getObject(int parameterIndex, Map<String, Class<?>> map)");
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getRef(int parameterIndex)");
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getBlob(this.outParameters.get(n2), this.getSession());
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getClob(this.outParameters.get(n2), this.getSession());
    }

    public Object getStruct(int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getStruct(int parameterIndex)");
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getArray(int parameterIndex)");
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getDate(this.outParameters.get(n2), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getTime(this.outParameters.get(n2), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getTimestamp(this.outParameters.get(n2), calendar);
    }

    @Override
    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "registerOutParameter(int parameterIndex, int sqlType, String typeName)");
    }

    @Override
    public void registerOutParameter(String string, int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "registerOutParameter(String parameterName, int sqlType)");
    }

    @Override
    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "registerOutParameter(String parameterName, int sqlType, int scale)");
    }

    @Override
    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "registerOutParameter(String parameterName, int sqlType, String typeName)");
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getURL(int parameterIndex)");
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setURL(String parameterName, URL val)");
    }

    @Override
    public void setNull(String string, int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNull(String parameterName, int sqlType)");
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBoolean(String parameterName, boolean x)");
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setByte(String parameterName, byte x)");
    }

    @Override
    public void setShort(String string, short s) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setShort(String parameterName, short x)");
    }

    @Override
    public void setInt(String string, int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setInt(String parameterName, int x)");
    }

    @Override
    public void setLong(String string, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setLong(String parameterName, long x)");
    }

    @Override
    public void setFloat(String string, float f) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setFloat(String parameterName, float x)");
    }

    @Override
    public void setDouble(String string, double d) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setDouble(String parameterName, double x)");
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBigDecimal(String parameterName, BigDecimal x)");
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setString(String parameterName, String x)");
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBytes(String parameterName, byte[] x)");
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setDate(String parameterName, Date x)");
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setTime(String parameterName, Time x)");
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setTimestamp(String parameterName, Timestamp x)");
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setAsciiStream(String parameterName, InputStream x, int length)");
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBinaryStream(String parameterName, InputStream x, int length)");
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setObject(String parameterName, Object x, int targetSqlType, int scale)");
    }

    @Override
    public void setObject(String string, Object object, int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setObject(String parameterName, Object x, int targetSqlType)");
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setObject(String parameterName, Object x)");
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setCharacterStream(String parameterName, Reader reader, int length)");
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setDate(String parameterName, Date x, Calendar cal)");
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setTime(String parameterName, Time x, Calendar cal)");
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setTimestamp(String parameterName, Timestamp x, Calendar cal)");
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNull(String parameterName, int sqlType, String typeName)");
    }

    @Override
    public String getString(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getString(String parameterName)");
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getBoolean(String parameterName)");
    }

    @Override
    public byte getByte(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getByte(String parameterName)");
    }

    @Override
    public short getShort(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getShort(String parameterName)");
    }

    @Override
    public int getInt(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getInt(String parameterName)");
    }

    @Override
    public long getLong(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getLong(String parameterName)");
    }

    @Override
    public float getFloat(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getFloat(String parameterName)");
    }

    @Override
    public double getDouble(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getDouble(String parameterName)");
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getBytes(String parameterName)");
    }

    @Override
    public Date getDate(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getDate(String parameterName)");
    }

    @Override
    public Time getTime(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getTime(String parameterName)");
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getTimestamp(String parameterName)");
    }

    @Override
    public Object getObject(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getObject(String parameterName)");
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getBigDecimal(String parameterName)");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getObject(String parameterName, Map<String, Class<?>> map)");
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getRef(String parameterName) ");
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getBlob(String parameterName)");
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getClob(String parameterName)");
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getArray(String parameterName)");
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getDate(String parameterName, Calendar cal)");
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getTime(String parameterName, Calendar cal)");
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getTimestamp(String parameterName, Calendar cal)");
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getURL(String parameterName)");
    }

    private ResultSet g(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getCursor(this.outParameters.get(n2), (YasConnection)this.getConnection());
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getRowId(this.outParameters.get(n2));
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getRowId(String parameterName)");
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setRowId(String parameterName, RowId x)");
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNString(String parameterName, String value)");
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNCharacterStream(String parameterName, Reader value, long length)");
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNClob(String parameterName, NClob value)");
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setClob(String parameterName, Reader reader, long length)");
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBlob(String parameterName, InputStream inputStream, long length)");
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNClob(String parameterName, Reader reader, long length)");
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        return this.accessors[n2].getNClob(this.outParameters.get(n2), this.getSession());
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getNClob(String parameterName)");
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setSQLXML(String parameterName, SQLXML xmlObject)");
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = ((Field)this.outFieldsMap.get(n)).getId();
        byte[] byArray = this.outParameters.get(n2);
        return this.accessors[n2].getSQLXML(byArray);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getSQLXML(String parameterName)");
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getNString(int parameterIndex)");
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getNString(String parameterName)");
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getNCharacterStream(int parameterIndex)");
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getNCharacterStream(String parameterName)");
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getCharacterStream(int parameterIndex)");
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getCharacterStream(String parameterName)");
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBlob(String parameterName, Blob x)");
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setClob(String parameterName, Clob x)");
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setAsciiStream(String parameterName, InputStream x, long length)");
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBinaryStream(String parameterName, InputStream x, long length)");
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setCharacterStream(String parameterName, Reader reader, long length)");
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setAsciiStream(String parameterName, InputStream x)");
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBinaryStream(String parameterName, InputStream x)");
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setCharacterStream(String parameterName, Reader reader)");
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNCharacterStream(String parameterName, Reader value)");
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setClob(String parameterName, Reader reader)");
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBlob(String parameterName, InputStream inputStream)");
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setNClob(String parameterName, Reader reader)");
    }

    public Object getObject(int n, Class clazz) throws SQLException {
        if (clazz == null) {
            throw new SQLException("Invalid Parameter, Class Type is null");
        }
        this.d(n);
        if (this.wasNullFlag) {
            return null;
        }
        int n2 = n - 1;
        this.closeStream(n2);
        return this.accessors[n2].getObject(this.outParameters.get(n2), clazz, this.connection);
    }

    public Object getObject(String string, Class clazz) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "getObject(String parameterName, Class<T> type)");
    }
}

