/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.YasClobOutputStream;
import com.yashandb.jdbc.YasClobReader;
import com.yashandb.jdbc.YasClobWriter;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasLargeObject;
import com.yashandb.jdbc.YasLobInputStream;
import com.yashandb.jdbc.YasLobProcessor;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.Messages;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class YasClob
implements YasLargeObject,
Clob {
    private YasLobProcessor lobProcessor = null;
    private YasConnection connection = null;
    private boolean isTempLob = false;
    private boolean isFree = false;
    private boolean inValid = false;

    public YasClob(boolean bl) {
        this.isTempLob = bl;
    }

    public void setLobProcessor(YasLobProcessor yasLobProcessor) throws SQLException {
        this.lobProcessor = yasLobProcessor;
        this.lobProcessor.setYasLob(this);
        if (this.lobProcessor.getLobLength() > 0L) {
            this.lobProcessor.a();
        }
    }

    @Override
    public int getStepSize() throws SQLException {
        this.a();
        return this.lobProcessor.getStepSize();
    }

    @Override
    public synchronized int getBytes(long l, byte[] byArray) throws SQLException {
        this.a();
        return this.lobProcessor.getBytes(l, byArray);
    }

    public byte[] getLobLocator() {
        return this.lobProcessor.getLobLocator();
    }

    @Override
    public void setConnection(YasConnection yasConnection) {
        this.connection = yasConnection;
    }

    @Override
    public YasConnection getConnection() {
        return this.connection;
    }

    private void a() throws SQLException {
        if (this.connection.isClosed()) {
            throw SQLError.createSQLException(Messages.get("This connection has been closed.", new Object[0]), YasState.CONNECTION_DOES_NOT_EXIST);
        }
        if (this.isFree) {
            throw SQLError.createSQLException("the lob has been freed", YasState.DATA_ERROR);
        }
        if (this.inValid) {
            throw SQLError.createSQLException("the lob is inValid", YasState.DATA_ERROR);
        }
    }

    @Override
    public synchronized long length() throws SQLException {
        this.a();
        return this.lobProcessor.a();
    }

    @Override
    public synchronized String getSubString(long l, int n) throws SQLException {
        this.a();
        return this.lobProcessor.getSubString(l, n);
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        this.a();
        return new YasClobReader(this);
    }

    @Override
    public synchronized InputStream getAsciiStream() throws SQLException {
        this.a();
        return new YasLobInputStream(this);
    }

    @Override
    public long position(String string, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "position(String searchstr, long start)");
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "position(Clob searchstr, long start)");
    }

    private void a(long l) throws SQLException {
        if (l < 1L) {
            throw SQLError.createSQLException("invalid parameter, ''pos'' should not be < 1", YasState.INVALID_PARAMETER_VALUE);
        }
        if (this.connection.getSession().getConnectVersion() == ConnectVersion.VER1) {
            if (l != this.length() + 1L) {
                throw SQLError.createSQLException("temp lob write only support append mode, ''pos'' should be lob length + 1", YasState.INVALID_PARAMETER_VALUE);
            }
        } else if (l > this.length() + 1L) {
            throw SQLError.createSQLException("invalid parameter, ''len'' should not be > lob length + 1", YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public synchronized int setString(long l, String string) throws SQLException {
        this.a();
        this.a(l);
        if (string == null) {
            return 0;
        }
        if (!this.c()) {
            throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setString(long pos, String str)");
        }
        this.b();
        if (l == this.length() + 1L && this.isTempLob) {
            return this.lobProcessor.appendString(string);
        }
        return this.lobProcessor.setString(l, string);
    }

    @Override
    public synchronized int setString(long l, String string, int n, int n2) throws SQLException {
        this.a();
        this.a(l);
        if (string == null) {
            return 0;
        }
        if (n < 0 || n >= string.length() || n2 <= 0 || n + n2 > string.length()) {
            throw SQLError.createSQLException("parameter ''offset'' or ''len'' is invalid", YasState.INVALID_PARAMETER_VALUE);
        }
        return this.setString(l, string.substring(n, n + n2));
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        this.a();
        this.a(l);
        return new YasClobOutputStream(this);
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        this.a();
        this.a(l);
        return new YasClobWriter(this);
    }

    @Override
    public void truncate(long l) throws SQLException {
        if (this.connection.getSession().getConnectVersion() == ConnectVersion.VER1) {
            throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "truncate(long len)");
        }
        this.a();
        if (l < 0L) {
            throw SQLError.createSQLException("invalid parameter, ''len'' should not be < 0", YasState.INVALID_PARAMETER_VALUE);
        }
        if (l > this.length()) {
            throw SQLError.createSQLException("invalid parameter, ''len'' should not be > lob length", YasState.INVALID_PARAMETER_VALUE);
        }
        this.b();
        this.lobProcessor.truncate(l);
    }

    @Override
    public synchronized void free() throws SQLException {
        this.lobProcessor.freeCharToBytePosCache();
        if (this.connection.isClosed()) {
            throw SQLError.createSQLException(Messages.get("This connection has been closed.", new Object[0]), YasState.CONNECTION_DOES_NOT_EXIST);
        }
        if (!this.isFree) {
            if (this.lobProcessor.needFree()) {
                this.lobProcessor.free();
            } else {
                this.connection.getSession().removeUpdatedKnlLob(this);
            }
            this.isFree = true;
        }
    }

    private void a(long l, long l2) throws SQLException {
        long l3 = this.getLobLength();
        if (l < 1L || l > l3 || l2 < 0L || l + l2 - 1L > l3) {
            throw SQLError.createSQLException("invalid parameter", YasState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        this.a();
        this.a(l, l2);
        return new YasClobReader(this, l, l2);
    }

    @Override
    public void freeTemp() throws SQLException {
        this.free();
    }

    @Override
    public long getLobLength() throws SQLException {
        return this.length();
    }

    @Override
    public String getString(long l, int n) throws SQLException {
        return this.getSubString(l, n);
    }

    @Override
    public int writeString(long l, String string) throws SQLException {
        return this.setString(l, string);
    }

    public YasLobProcessor getLobProcessor() {
        return this.lobProcessor;
    }

    private void b() throws SQLException {
        if (this.lobProcessor.getInnerLobType() != 4) {
            return;
        }
        YasClob yasClob = (YasClob)this.connection.createClob();
        yasClob.setString(1L, this.getSubString(1L, (int)this.length()));
        this.setLobProcessor(yasClob.getLobProcessor());
        this.isTempLob = true;
    }

    @Override
    public void rollback() throws SQLException {
        if (this.lobProcessor.isUpdated()) {
            this.inValid = true;
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.lobProcessor.isUpdated()) {
            this.lobProcessor.setUpdated(false);
        }
    }

    private boolean c() {
        return this.isTempLob || this.connection.getSession().getConnectVersion() != ConnectVersion.VER1;
    }
}

