/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.YasClob;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.exception.SQLError;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class YasClobReader
extends Reader {
    private YasClob clob;
    private int charPos = 0;
    private int cacheCharacterLen = 0;
    private long lobOffset = 1L;
    private long steamLobRemainSize = 0L;
    private StringBuilder stringBuilder;
    private boolean isClosed = false;
    private int cacheSize;

    public YasClobReader(YasClob yasClob) throws SQLException {
        this.clob = yasClob;
        this.steamLobRemainSize = yasClob.getLobLength();
        this.cacheSize = yasClob.getStepSize();
        if (this.cacheSize <= 0) {
            this.cacheSize = (int)yasClob.getLobLength();
        }
        this.stringBuilder = new StringBuilder(this.cacheSize);
        String string = yasClob.getLobProcessor().getSubStringInternal(1L, this.cacheSize);
        this.stringBuilder.append(string);
        this.cacheCharacterLen = string.length();
    }

    public YasClobReader(YasClob yasClob, long l, long l2) throws SQLException {
        if (l < 1L || l2 < 0L) {
            throw SQLError.createSQLException("invalid parameter", YasState.INVALID_PARAMETER_VALUE);
        }
        long l3 = l - 1L;
        long l4 = yasClob.getLobLength();
        if (l2 == 0L || l4 == 0L || l3 >= l4) {
            return;
        }
        this.clob = yasClob;
        long l5 = Math.min(l2, l4);
        if (l3 + l5 > l4) {
            l5 = l4 - l3;
        }
        this.steamLobRemainSize = l5;
        this.cacheSize = yasClob.getStepSize();
        if (this.cacheSize <= 0) {
            this.cacheSize = (int)yasClob.getLobLength();
        }
        this.stringBuilder = new StringBuilder(this.cacheSize);
        this.lobOffset = l;
        String string = yasClob.getLobProcessor().getSubStringInternal(l, this.cacheSize);
        this.stringBuilder.append(string);
        this.cacheCharacterLen = string.length();
    }

    private void a() throws IOException {
        if (this.isClosed) {
            throw new IOException("reader closed");
        }
    }

    boolean a(YasConnection yasConnection) {
        return yasConnection.equals(this.clob.getConnection());
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        this.a();
        if (this.steamLobRemainSize <= 0L) {
            return -1;
        }
        int n3 = Math.min(n2, cArray.length - n);
        if (n3 <= 0) {
            throw new IOException("invalid parameter");
        }
        if ((long)(n3 = Math.min(n3, this.cacheCharacterLen - this.charPos)) > this.steamLobRemainSize) {
            n3 = (int)this.steamLobRemainSize;
        }
        this.stringBuilder.getChars(this.charPos, this.charPos + n3, cArray, n);
        this.charPos += n3;
        this.steamLobRemainSize -= (long)n3;
        if (this.charPos >= this.cacheCharacterLen && this.steamLobRemainSize > 0L) {
            this.lobOffset += (long)this.cacheCharacterLen;
            try {
                this.stringBuilder.delete(0, this.stringBuilder.length());
                String string = this.clob.getLobProcessor().getSubStringInternal(this.lobOffset, this.cacheSize);
                this.stringBuilder.append(string);
                this.charPos = 0;
                this.cacheCharacterLen = string.length();
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
        }
    }
}

