/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.jdbc.YasLargeObject;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

public class YasClobWriter
extends Writer {
    private YasLargeObject largeObject = null;
    private StringBuilder stringBuilder = null;
    private boolean isClosed = false;

    private void a() throws IOException {
        if (this.isClosed) {
            throw new IOException("writer closed");
        }
    }

    YasClobWriter(YasLargeObject yasLargeObject) throws SQLException {
        this.largeObject = yasLargeObject;
        int n = this.largeObject.getStepSize();
        this.stringBuilder = n > 0 ? new StringBuilder(n) : new StringBuilder(32000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.a();
            if (this.stringBuilder.length() >= this.stringBuilder.capacity()) {
                this.flush();
            }
            this.stringBuilder.append(cArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.a();
            if (this.stringBuilder.length() > 0) {
                try {
                    String string = this.stringBuilder.toString();
                    this.largeObject.writeString(this.largeObject.getLobLength() + 1L, string);
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
                this.stringBuilder.delete(0, this.stringBuilder.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.flush();
            this.isClosed = true;
        }
    }
}

