/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.conf.YasProperty;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.YasDriver;
import com.yashandb.jdbc.exception.SQLError;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class YasDataSource
implements Serializable,
Referenceable,
DataSource {
    private static final long serialVersionUID = 7624091928606233036L;
    private transient YasDriver yasDriver = new YasDriver();
    protected transient PrintWriter logWriter = null;
    protected int loginTimeout = 0;
    protected String databaseName = null;
    protected String serviceName = null;
    protected String dataSourceName = "YasDataSource";
    protected String description = "YashanDB Connector/J Data Source";
    protected String networkProtocol = "tcp";
    protected int portNumber = Integer.parseInt("1688");
    protected String user = null;
    protected String password = null;
    protected String serverName = null;
    protected String url = null;
    protected String sslRootCer = null;
    protected Properties connectionProperties = null;

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "com.yashandb.jdbc.YasDataSourceFactory", null);
        this.addRefProperties(reference);
        return reference;
    }

    protected void addRefProperties(Reference reference) {
        if (this.url != null) {
            reference.add(new StringRefAddr("url", this.url));
        }
        if (this.user != null) {
            reference.add(new StringRefAddr("user", this.user));
        }
        if (this.password != null) {
            reference.add(new StringRefAddr("password", this.password));
        }
        if (this.description != null) {
            reference.add(new StringRefAddr("description", this.description));
        }
        if (this.serverName != null) {
            reference.add(new StringRefAddr("serverName", this.serverName));
        }
        if (this.databaseName != null) {
            reference.add(new StringRefAddr("databasename", this.databaseName));
        }
        if (this.networkProtocol != null) {
            reference.add(new StringRefAddr("networkProtocol", this.networkProtocol));
        }
        if (this.portNumber != 0) {
            reference.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        }
        if (this.sslRootCer != null) {
            reference.add(new StringRefAddr("sslRootCer", this.sslRootCer));
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String string2, String string3) throws SQLException {
        Properties properties = new Properties();
        if (this.connectionProperties != null && !this.connectionProperties.isEmpty()) {
            this.connectionProperties.stringPropertyNames().stream().forEach(string -> properties.setProperty((String)string, this.connectionProperties.getProperty((String)string)));
        }
        if (string2 != null) {
            properties.setProperty("user", string2);
        } else if (this.user != null) {
            properties.setProperty("user", this.user);
        }
        if (string3 != null) {
            properties.setProperty("password", string3);
        } else if (this.password != null) {
            properties.setProperty("password", this.password);
        }
        if (this.loginTimeout != 0) {
            properties.setProperty(YasProperty.LOGIN_TIMEOUT.getName(), "" + this.loginTimeout);
        }
        if (this.sslRootCer != null) {
            properties.setProperty(YasProperty.SSL_ROOT_CER.getName(), this.sslRootCer);
        }
        return this.getConnection(properties);
    }

    protected Connection getConnection(Properties properties) throws SQLException {
        if (this.url == null && this.serverName != null && this.portNumber != 0 && this.databaseName != null) {
            StringBuilder stringBuilder = new StringBuilder("jdbc:yasdb:");
            stringBuilder.append("//").append(this.serverName).append(":").append(this.portNumber);
            stringBuilder.append("/").append(this.databaseName);
            this.url = stringBuilder.toString();
        }
        if (this.url == null) {
            this.url = properties.getProperty("url", "");
        }
        this.a(this.url, properties);
        return this.yasDriver.connect(this.url, properties);
    }

    void a(String string, Properties properties) throws SQLException {
        String string2 = properties.getProperty("user", "");
        String string3 = properties.getProperty("password", "");
        if ("".equalsIgnoreCase(string2)) {
            throw SQLError.createSQLException("No connection user!Please set user.", YasState.INVALID_PARAMETER_VALUE);
        }
        if ("".equalsIgnoreCase(string3)) {
            throw SQLError.createSQLException("No connection password!Please set password.", YasState.INVALID_PARAMETER_VALUE);
        }
        if ("".equalsIgnoreCase(string)) {
            throw SQLError.createSQLException("No connection URL!Please set URL.", YasState.INVALID_PARAMETER_VALUE);
        }
    }

    public Object unwrap(Class clazz) throws SQLException {
        return null;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return false;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logWriter = printWriter;
    }

    public String getSslRootCer() {
        return this.sslRootCer;
    }

    public void setSslRootCer(String string) {
        this.sslRootCer = string;
    }

    @Override
    public synchronized void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    @Override
    public synchronized int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public synchronized void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public synchronized String getDatabaseName() {
        return this.databaseName != null ? this.databaseName : "";
    }

    public synchronized void setPassword(String string) {
        this.password = string;
    }

    public synchronized void setPortNumber(int n) {
        this.portNumber = n;
    }

    public synchronized int getPortNumber() {
        return this.portNumber;
    }

    public synchronized void setServerName(String string) {
        this.serverName = string;
    }

    public synchronized String getServerName() {
        return this.serverName;
    }

    public synchronized void setURL(String string) {
        this.url = string;
    }

    public synchronized String getURL() {
        return this.url;
    }

    public synchronized void setUser(String string) {
        this.user = string;
    }

    public synchronized String getUser() {
        return this.user;
    }

    public synchronized Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public synchronized void setConnectionProperties(Properties properties) {
        this.connectionProperties = properties;
    }
}

