/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.YasConstants;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectionImpl;
import com.yashandb.jdbc.exception.SQLError;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YasDatabaseMetaData
implements DatabaseMetaData {
    private static final Set numberTypeSet = new HashSet();
    private static final Set charTypeSet = new HashSet();
    private static final Set canConvertToNumber = new HashSet();
    private static final Set canConvertToBoolean = new HashSet();
    private static final Set canConvertToBit = new HashSet();
    private static final Set canConvertToXML = new HashSet();
    private static final Set canConvertToString = new HashSet();
    private static final Set canConvertToNString = new HashSet();
    private static final Set canConvertToLongString = new HashSet();
    private static final Set canConvertToDate = new HashSet();
    private static final Set canConvertToBlob = new HashSet();
    private static final Set canConvertToClob = new HashSet();
    private static final Set canConvertToRaw = new HashSet();
    private static final Set canConvertToJson = new HashSet();
    private static final Set TABLE_TYPES = new HashSet();
    private static final String NULL_IN_SQL = "NULL,";
    private static final String LIKE_CLUSE = " AND OBJECT_NAME LIKE ? ESCAPE '/' ";
    private static final String AS_DATA_TYPE_CLUSE = " AS data_type,";
    private static final String NUMBER_LITERAL_CLUSE = "NULL as literal_prefix, NULL as literal_suffix, null as create_params,\n";
    private static final String VARCHAR_LITERAL_CLUSE = "'''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n";
    private static final String NULLABLE_CLUSE = "1 as nullable, 0 as case_sensitive, 3 as searchable,\n";
    private static final String UNSIGNED_ATTRIBUTE_CLUSE = "0 as unsigned_attribute, 1 as fixed_prec_scale, 1 as auto_increment,\n";
    private static final String UNSIGNED_ATTRIBUTE_CLUSE1 = "0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n";
    private static final String UNION_SELECT_CLUSE = "union select\n";
    private static final String NULL_DATA_TYPE_CLUSE = "NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix from dual\n";
    protected final ConnectionImpl connection;
    public static final Pattern VERSION_PATTERN;
    public static final Pattern sqlEscapePattern;
    public static final Pattern sqlWildcardPattern;

    public YasDatabaseMetaData(ConnectionImpl connectionImpl) {
        this.connection = connectionImpl;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return false;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public String getDatabaseProductName() {
        return this.connection.getProductName();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        String string;
        block26: {
            string = this.connection.getSession().getYasdbVersion();
            if (string == null || string.length() == 0) {
                String string2 = "select * from V$VERSION";
                try (Statement statement = this.connection.createStatement();
                     ResultSet resultSet = statement.executeQuery(string2);){
                    if (resultSet.next()) {
                        string = resultSet.getString("BANNER");
                        this.connection.getSession().setYasdbVersion(string);
                        break block26;
                    }
                    throw SQLError.createSQLException("System view error:V$VERSION", YasState.SYSTEM_ERROR);
                }
            }
        }
        return string;
    }

    @Override
    public String getDriverName() {
        return "YashanDB JDBC Driver";
    }

    @Override
    public String getDriverVersion() {
        return "1.5-SNAPSHOT";
    }

    @Override
    public int getDriverMajorVersion() {
        try {
            return Integer.parseInt(this.getDriverVersion().split("\\.")[0]);
        }
        catch (Exception exception) {
            return 1;
        }
    }

    @Override
    public int getDriverMinorVersion() {
        try {
            return Integer.parseInt(this.getDriverVersion().split("-")[0].split("\\.")[1]);
        }
        catch (Exception exception) {
            return 1;
        }
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        return "ACCESS, ADD, ALTER, AUDIT, CLUSTER, COLUMN, COMMENT, COMPRESS, CONNECT, DATE, DROP, EXCLUSIVE, FILE, IDENTIFIED, IMMEDIATE, INCREMENT, INDEX, INITIAL, INTERSECT, LEVEL, LOCK, LONG, MAXEXTENTS, MINUS, MODE, NOAUDIT, NOCOMPRESS, NOWAIT, NUMBER, OFFLINE, ONLINE, PCTFREE, PRIOR, all_PL_SQL_reserved_ words";
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        String string = "AND name IN ('ABS', 'ACOS', 'ASIN', 'ATAN', 'ATAN2', 'BIN_TO_NUM', 'BITAND', 'BITOR', 'BITXOR', 'CEIL', 'COS', 'COT', 'COUNT', 'DIV', 'EXP', 'FLOOR', 'LN', 'LOG', 'MAX', 'MEDIAN', 'MOD', 'MIN', 'PI', 'POW', 'POWER', 'RANDOM', 'ROUND', 'SIGN', 'SIN', 'SINH', 'SQRT', 'STDDEV', 'STDDEV_POP', 'STDDEV_SAMP', 'SUM', 'TAN', 'TANH', 'TRUNCATE', 'VARIANCE', 'VAR_POP', 'VAR_SAMP')";
        return this.a(string);
    }

    @Override
    public String getStringFunctions() throws SQLException {
        String string = "AND name IN ('ASCII', 'BIT_LENGTH', 'CHAR_LENGTH', 'CHARACTER_LENGTH', 'CHR', 'CONCAT', 'CONCAT_WS', 'FIND_IN_SET', 'GET_TYPE_NAME', 'GROUP_CONCAT', 'INITCAP', 'INSTR', 'INSTRB', 'LISTAGG', 'LEFT', 'LENGTH', 'LENGTH2', 'LENGTHB', 'LOWER', 'LPAD', 'LTRIM', 'MD5', 'NLSSORT', 'OCTET_LENGTH',  'POSITION', 'REGEXP_COUNT', 'REGEXP_INSTR', 'REGEXP_LIKE', 'REGEXP_REPLACE', 'REGEXP_SUBSTR',  'REPLACE', 'RIGHT', 'RLIKE_FILTER', 'ROWIDTOCHAR', 'RPAD', 'RTRIM', 'SOUNDEX', 'SPLIT', 'STRING_AGG', 'STRPOS', 'SUBSTR', 'SUBSTRB', 'SUBSTRING', 'SUBSTRING_INDEX', 'TO_BASE64', 'TO_CHAR', 'TRANSLATE', 'TREAT', 'TRIM', 'UNISTR', 'UPPER', 'WM_CONCAT', 'LABEL_TO_CHAR')";
        return this.a(string);
    }

    private String a(String string) throws SQLException {
        Statement statement = this.connection.createStatement();
        String string2 = "select name from v$function where 1=1 ";
        string2 = string2 + string;
        statement.closeOnCompletion();
        ResultSet resultSet = statement.executeQuery(string2);
        StringBuilder stringBuilder = new StringBuilder();
        while (resultSet.next()) {
            stringBuilder.append(resultSet.getString(1) + ",");
        }
        resultSet.close();
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return "";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        String string = "AND name IN ('USERENV', 'SYS_CONNECT_BY_PATH', 'SYS_CONTEXT', 'SYS_GUID')";
        return this.a(string);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        String string = "AND name IN ('ADD_MONTHS', 'AGE', 'CURRENT_TIMESTAMP', 'DATE', 'DATE_ADD', 'DATE_FORMAT', 'DATE_SUB', 'DAYOFWEEK', 'EXTRACT', 'LAST_DAY', 'LOCALTIME', 'LOCALTIMESTAMP', 'MONTHS_BETWEEN', 'NEXT_DAY', 'NOW', 'NUMTODSINTERVAL', 'NUMTOYMINTERVAL', 'SCN_TO_TIMESTAMP', 'SYSDATE', 'SYSTIMESTAMP', 'SYS_EXTRACT_UTC', 'TIME', 'TIMEDIFF', 'TIMESTAMPDIFF', 'TIMESTAMP_TO_SCN', 'TO_DATE', 'TO_DSINTERVAL', 'TO_TIMESTAMP', 'TO_YMINTERVAL', 'UTC_TIMESTAMP')";
        return this.a(string);
    }

    @Override
    public String getSearchStringEscape() {
        return "/";
    }

    @Override
    public String getExtraNameCharacters() {
        return "$#";
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int n, int n2) {
        if (n == n2) {
            return true;
        }
        switch (n2) {
            case 6: 
            case 7: 
            case 8: {
                return canConvertToNumber.contains(n) && n != 16;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return canConvertToNumber.contains(n) || n == -7;
            }
            case 16: {
                return canConvertToBoolean.contains(n);
            }
            case -7: {
                return canConvertToBit.contains(n);
            }
            case 1: 
            case 12: {
                return canConvertToString.contains(n);
            }
            case -15: {
                return canConvertToNString.contains(n) || n == 2004;
            }
            case -9: {
                return canConvertToNString.contains(n);
            }
            case -16: 
            case -1: {
                return canConvertToLongString.contains(n);
            }
            case 92: {
                return canConvertToDate.contains(n) || n == 3002;
            }
            case 91: 
            case 93: {
                return canConvertToDate.contains(n);
            }
            case 2009: {
                return canConvertToXML.contains(n);
            }
            case 3002: {
                return charTypeSet.contains(n) || n == 92;
            }
            case -8: 
            case 3001: {
                return charTypeSet.contains(n);
            }
            case -4: 
            case -3: {
                return n == 12;
            }
            case 2005: 
            case 2011: {
                return canConvertToClob.contains(n);
            }
            case 2004: {
                return canConvertToBlob.contains(n);
            }
            case -2: {
                return canConvertToRaw.contains(n);
            }
            case 3009: {
                return canConvertToJson.contains(n);
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() {
        return false;
    }

    @Override
    public String getCatalogSeparator() {
        return "";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 4000;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 8000;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    protected int getIdentifierLength() {
        return 64;
    }

    @Override
    public int getMaxColumnNameLength() {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 32;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 1024;
    }

    @Override
    public int getMaxConnections() {
        return 8192;
    }

    @Override
    public int getMaxCursorNameLength() {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxIndexLength() {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxSchemaNameLength() {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxProcedureNameLength() {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 65536;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return this.getIdentifierLength();
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 128;
    }

    @Override
    public int getMaxUserNameLength() {
        return this.getIdentifierLength();
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 2;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) {
        return n == 2 || n == 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        String string4 = "SELECT DECODE(PROCEDURE_NAME,\nNULL,NULL,        object_name) AS procedure_cat,\n        owner AS procedure_schem,\n         DECODE(PROCEDURE_NAME,\nNULL,        object_name,\n        PROCEDURE_NAME) AS procedure_name,\nNULL,NULL,NULL,        '' AS remarks, 1 AS procedure_type, DECODE(PROCEDURE_NAME,null,OBJECT_NAME,OBJECT_NAME||'.'||PROCEDURE_NAME) AS specific_name FROM all_procedures proc\nWHERE 1=1\n        AND owner LIKE ? escape '/'\n        AND NOT EXISTS\n    (SELECT *\n    FROM all_arguments arg1\n    WHERE (arg1.ARGUMENT_NAME is null\n            OR length(arg1.ARGUMENT_NAME) = 0)\n            AND arg1.IN_OUT = 'OUT'\n            AND arg1.OBJECT_ID = proc.OBJECT_ID\n            AND (arg1.SUBPROGRAM_ID = proc.SUBPROGRAM_ID\n            OR (arg1.SUBPROGRAM_ID is null)))\n        AND ( ( ? =1\n        AND ((OBJECT_NAME LIKE ? ESCAPE '/'\n        AND PROCEDURE_NAME is null)\n        OR PROCEDURE_NAME LIKE ? ESCAPE '/' ))\n        OR (? =2\n AND OBJECT_NAME LIKE ? ESCAPE '/'         AND PROCEDURE_NAME is NULL )\n        OR (? =3\n AND OBJECT_NAME LIKE ? ESCAPE '/'         AND PROCEDURE_NAME LIKE ? ESCAPE '/' ))order by procedure_cat, procedure_schem, procedure_name ";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string4);
        int n = YasDatabaseMetaData.b(string);
        preparedStatement.setString(1, this.c(string2));
        preparedStatement.setInt(2, n);
        preparedStatement.setString(3, this.a(string3, "procedureNamePattern"));
        preparedStatement.setString(4, this.a(string3, "procedureNamePattern"));
        preparedStatement.setInt(5, n);
        preparedStatement.setString(6, this.a(string3, "procedureNamePattern"));
        preparedStatement.setInt(7, n);
        preparedStatement.setString(8, string);
        preparedStatement.setString(9, this.a(string3, "procedureNamePattern"));
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    private static int b(String string) {
        if (string == null) {
            return 1;
        }
        if (string.equals("")) {
            return 2;
        }
        return 3;
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = " DECODE(arg.ARGUMENT_NAME, NULL, 5,\nDECODE(arg.in_out, 'IN', 1,\n'OUT', 4,\n'IN OUT', 2,\n0)) ";
        String string6 = YasDatabaseMetaData.d("arg.data_type");
        String string7 = "SELECT DECODE(arg.SUBPROGRAM_NAME,NULL,NULL,arg.object_name) AS procedure_cat,\n       arg.owner AS procedure_schem,\n       DECODE(arg.SUBPROGRAM_NAME,null,arg.object_name,arg.SUBPROGRAM_NAME) AS procedure_name,\n       arg.argument_name AS column_name,\n" + string5 + " AS column_type,\n" + string6 + AS_DATA_TYPE_CLUSE + "       arg.data_type AS type_name,\n       DECODE (arg.data_precision, NULL, arg.data_length,\n                               arg.data_precision) AS precision,\n       arg.data_length AS length,\n       arg.data_scale AS scale,\n       10 AS radix,\n" + 1 + " AS nullable,\n       NULL AS remarks,\n       arg.default_value AS column_def,\n       NULL as sql_data_type,\n       NULL AS sql_datetime_sub,\n       DECODE(arg.data_type,\n                         'CHAR', 32000,\n                         'NCHAR', 8000,\n                         'VARCHAR', 32000,\n                         'NVARCHAR', 32000,\n                         'RAW', 8000,\n                         NULL) AS char_octet_length,\n       arg.sequence AS ordinal_position,\n       'YES' AS is_nullable,\n DECODE(arg.SUBPROGRAM_NAME,null,arg.OBJECT_NAME,arg.OBJECT_NAME||'.'||arg.SUBPROGRAM_NAME)  AS specific_name FROM all_arguments arg, all_procedures proc\n WHERE arg.owner LIKE ? ESCAPE '/'\n AND (( ? =1 and ((proc.OBJECT_NAME LIKE ?  ESCAPE '/' and proc.PROCEDURE_NAME is null) or proc.PROCEDURE_NAME LIKE ?  ESCAPE '/' ))  OR (? =2 and proc.OBJECT_NAME LIKE ?  ESCAPE '/' and proc.PROCEDURE_NAME is null ) or (? =3 and proc.OBJECT_NAME LIKE ?  ESCAPE '/' and proc.PROCEDURE_NAME LIKE ?  ESCAPE '/' ))\n AND arg.owner = proc.owner\n AND (arg.SUBPROGRAM_ID = proc.SUBPROGRAM_ID OR arg.SUBPROGRAM_ID is null)\n AND arg.object_id = proc.object_id\n AND not EXISTS(select * from all_arguments arg1       where (arg1.ARGUMENT_NAME  is null or length(arg1.ARGUMENT_NAME) = 0)     and arg1.IN_OUT = 'OUT'      and arg1.OBJECT_ID = arg.OBJECT_ID        and (arg1.SUBPROGRAM_ID = arg.SUBPROGRAM_ID or (arg1.SUBPROGRAM_ID is null))) \nAND arg.argument_name LIKE ? ESCAPE '/' \nORDER BY PROCEDURE_CAT,procedure_schem, procedure_name, SPECIFIC_NAME, ORDINAL_POSITION";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string7);
        int n = YasDatabaseMetaData.b(string);
        preparedStatement.setString(1, this.c(string2));
        preparedStatement.setInt(2, n);
        preparedStatement.setString(3, this.a(string3, "procedureNamePattern"));
        preparedStatement.setString(4, this.a(string3, "procedureNamePattern"));
        preparedStatement.setInt(5, n);
        preparedStatement.setString(6, this.a(string3, "procedureNamePattern"));
        preparedStatement.setInt(7, n);
        preparedStatement.setString(8, string);
        preparedStatement.setString(9, this.a(string3, "procedureNamePattern"));
        preparedStatement.setString(10, this.a(string4, "columnNamePattern"));
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    private String a(String string, String string2) throws SQLException {
        if (string == null) {
            return "%";
        }
        if (string.equals("")) {
            throw SQLError.createSQLException("invalid parameter \"" + string2 + "\"", YasState.INVALID_PARAMETER_VALUE);
        }
        return string;
    }

    private String c(String string) throws SQLException {
        if (string == null) {
            return "%";
        }
        if (!string.equals("")) {
            return string;
        }
        if (this.connection.getSession().isUserCaseSensitive()) {
            return "\"" + this.connection.getUserName() + "\"";
        }
        return this.connection.getUserName().toUpperCase();
    }

    private Set a(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : stringArray) {
                if (!TABLE_TYPES.contains(string)) continue;
                hashSet.add(string);
            }
            return hashSet;
        }
        return Collections.emptySet();
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String string4 = "left join all_tab_comments";
        if (string3 != null) {
            if (this.hasSqlWildcard(string3)) {
                string4 = "inner join (select * from all_tab_comments c1 where c1.table_name like ? escape '/' selectivity 0.00001 )";
            } else {
                string3 = this.stripSqlEscapes(string3);
                string4 = "inner join (select * from all_tab_comments c1 where c1.table_name = ?)";
            }
        }
        StringBuilder stringBuilder = new StringBuilder("select null as table_cat,\no.owner as table_schem,\no.object_name as table_name,\no.object_type as table_type,\nc.comments as remarks,\nnull as type_cat,\nnull as type_schem,\nnull as type_name,\nnull as self_referencing_col_name,\nnull as ref_generation\nfrom all_objects o " + string4 + " c on o.owner = c.owner  and o.object_name = c.table_name  where 1=1 ");
        if (string2 != null) {
            if (this.hasSqlWildcard(string2)) {
                stringBuilder.append(" AND o.owner like ? escape '/' selectivity 0.00001 ");
            } else {
                string2 = this.stripSqlEscapes(string2);
                stringBuilder.append(" AND o.owner = ? ");
            }
        }
        Set set = this.a(stringArray);
        if (stringArray != null) {
            if (!set.isEmpty()) {
                stringBuilder.append(" and o.object_type in (?");
                for (int i = 1; i < set.size(); ++i) {
                    stringBuilder.append(",?");
                }
                stringBuilder.append(")");
            } else {
                stringBuilder.append(" and 1 = 2 ");
            }
        } else {
            stringBuilder.append(" and o.object_type in ('TABLE', 'VIEW', 'SYNONYM')");
        }
        stringBuilder.append(" ORDER BY table_type, table_schem, table_name\n");
        PreparedStatement preparedStatement = this.connection.prepareStatement(stringBuilder.toString());
        int n = 1;
        if (string3 != null) {
            preparedStatement.setString(n++, string3);
        }
        if (string2 != null) {
            preparedStatement.setString(n++, string2);
        }
        for (String string5 : set) {
            preparedStatement.setString(n++, string5);
        }
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        Statement statement = this.connection.createStatement();
        String string = "select 'nothing' as table_cat from dual where 1 = 2";
        statement.closeOnCompletion();
        return statement.executeQuery(string);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        Statement statement = this.connection.createStatement();
        String string = "select 'TABLE' as table_type from dual union select 'VIEW' as table_type from dual union select 'SYNONYM' as table_type from dual order by table_type";
        statement.closeOnCompletion();
        return statement.executeQuery(string);
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = YasDatabaseMetaData.d("c.data_type");
        String string6 = "";
        String string7 = string3;
        if (string3 != null) {
            if (this.hasSqlWildcard(string3)) {
                string6 = " where r1.table_name like ? escape '/' selectivity 0.00001 ";
            } else {
                string7 = this.stripSqlEscapes(string3);
                string6 = " where r1.table_name = ? ";
            }
        }
        String string8 = "decode(c.nullable, 'Y', 1, 'N', 0)";
        String string9 = "decode(c.data_precision, null, decode(c.data_type, 'NCHAR', c.char_length, 'NVARCHAR', c.char_length, 'VARCHAR', c.char_length, 'CHAR', c.char_length, c.data_length), decode(c.data_type,'NUMBER', decode(c.data_scale,null, 0 , c.data_precision),c.data_precision))";
        String string10 = "decode(c.data_type,'NUMBER',  decode(c.data_scale,null, -127, c.data_scale), c.data_scale)";
        String string11 = "decode(c.nullable, 'Y', 'YES', 'NO')";
        String string12 = "select null as table_cat,c.owner as table_schem,c.table_name as table_name,c.column_name as column_name," + string5 + AS_DATA_TYPE_CLUSE + "c.data_type as type_name," + string9 + " as column_size,0 as buffer_length," + string10 + " as decimal_digits,10 as num_prec_radix," + string8 + " as nullable,r.comments as remarks,data_default as column_def,0 as sql_data_type,0 as sql_datetime_sub,c.data_length as char_octet_length,c.column_id + 1 as ordinal_position," + string11 + " as is_nullable,null as scope_catalog,null as scope_schema,null as scope_table,null as source_data_type, 'NO' as is_autoincrement, 'NO' as is_generatedcolumn from all_tab_cols c left join  (select * from all_col_comments r1  " + string6 + ") r on  c.owner = r.owner and c.table_name = r.table_name  and c.column_name = r.column_name  where c.USER_GENERATED = 'Y' ";
        String string13 = string2;
        String string14 = string4;
        if (string2 != null) {
            if (this.hasSqlWildcard(string2)) {
                string12 = string12 + " AND c.owner like ? escape '/' selectivity 0.00001 ";
            } else {
                string13 = this.stripSqlEscapes(string2);
                string12 = string12 + "AND c.owner = ? ";
            }
        }
        if (string3 != null) {
            if (this.hasSqlWildcard(string3)) {
                string12 = string12 + " AND c.table_name like ? escape '/' selectivity 0.00001 ";
            } else {
                string7 = this.stripSqlEscapes(string3);
                string12 = string12 + " AND c.table_name = ? ";
            }
        }
        if (string4 != null) {
            if (this.hasSqlWildcard(string4)) {
                string12 = string12 + " AND c.column_name like ? escape '/' selectivity 0.00001 ";
            } else {
                string14 = this.stripSqlEscapes(string4);
                string12 = string12 + " AND c.column_name = ? ";
            }
        }
        string12 = string12 + " order by TABLE_CAT,TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string12);
        int n = 1;
        if (string3 != null) {
            preparedStatement.setString(n, string7);
            ++n;
        }
        if (string2 != null) {
            preparedStatement.setString(n, string13);
            ++n;
        }
        if (string3 != null) {
            preparedStatement.setString(n, string7);
            ++n;
        }
        if (string4 != null) {
            preparedStatement.setString(n, string14);
        }
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        return this.a();
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT NULL AS table_cat,\n       OWNER AS table_schem,\n       table_name,\ngrantor,\n       grantee,\n       privilege,\n       decode(grantable,'N','NO','Y','YES',NULL) AS is_grantable\nFROM ALL_TAB_PRIVS\nWHERE OWNER LIKE :1 ESCAPE '/'\n  AND table_name LIKE :2 ESCAPE '/'\nORDER BY OWNER,table_name, privilege");
        preparedStatement.setString(1, string2 == null ? "%" : string2);
        preparedStatement.setString(2, string3 == null ? "%" : string3);
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        String string4 = "DECODE (t.data_precision, null, DECODE (t.data_type, 'CHAR', t.char_length, 'VARCHAR', t.char_length, 'VARCHAR2', t.char_length, 'NVARCHAR2', t.char_length, 'NVARCHAR', t.char_length, 'NCHAR', t.char_length, t.data_length), t.data_precision)";
        String string5 = "SELECT 1 AS scope, 'ROWID' AS column_name, -8 AS data_type,\n 'ROWID' AS type_name, 0 AS column_size, 0 AS buffer_length,\n       0 AS decimal_digits, 2 AS pseudo_column\nFROM DUAL\nWHERE :1 = 1\nUNION\nSELECT 2 AS scope,\n t.column_name,\n" + YasDatabaseMetaData.d("t.data_type") + AS_DATA_TYPE_CLUSE + " t.data_type AS type_name,\n" + string4 + " AS column_size,\n  0 AS buffer_length,\n  t.data_scale AS decimal_digits,\n       1 AS pseudo_column\nFROM all_tab_columns t, all_ind_columns i\nWHERE :2 = 1\n  AND t.table_name = :3\n  AND t.owner like :4 escape '/'\n  AND t.nullable = :5\n  AND t.owner = i.table_owner\n  AND t.table_name = i.table_name\n  AND t.column_name = i.column_name\n";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string5);
        switch (n) {
            case 0: {
                preparedStatement.setInt(1, 0);
                preparedStatement.setInt(2, 0);
                break;
            }
            case 1: {
                preparedStatement.setInt(1, 1);
                preparedStatement.setInt(2, 1);
                break;
            }
            case 2: {
                preparedStatement.setInt(1, 0);
                preparedStatement.setInt(2, 1);
                break;
            }
            default: {
                throw SQLError.createSQLException("Invalid parameter,scope:" + n, YasState.INVALID_PARAMETER_VALUE);
            }
        }
        preparedStatement.setString(3, string3);
        preparedStatement.setString(4, string2 == null ? "%" : string2);
        preparedStatement.setString(5, bl ? "Y" : "N");
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        String string4 = "DECODE (c.data_precision, null, DECODE (c.data_type, 'CHAR', c.char_length, 'VARCHAR', c.char_length, 'NVARCHAR', c.char_length, 'NCHAR', c.char_length, c.data_length), c.data_precision)";
        String string5 = "  SELECT 0 AS scope,\n t.column_name,\n" + YasDatabaseMetaData.d("c.data_type") + AS_DATA_TYPE_CLUSE + " c.data_type AS type_name,\n" + string4 + " AS column_size,\n       0 as buffer_length,\n   c.data_scale as decimal_digits,\n   0 as pseudo_column\nFROM all_trigger_cols t, all_tab_columns c\nWHERE t.table_name = :1\n  AND c.owner like :2 escape '/'\n AND t.table_owner = c.owner\n  AND t.table_name = c.table_name\n AND t.column_name = c.column_name";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string5);
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string2 == null ? "%" : string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        preparedStatement.closeOnCompletion();
        return resultSet;
    }

    private static String d(String string) {
        return "decode(" + string + ",\n\t'BOOLEAN', " + 16 + ",\n\t'TINYINT', " + -6 + ",\n\t'BINARY_TINYINT', " + -6 + ",\n\t'SMALLINT', " + 5 + ",\n\t'BINARY_SMALLINT', " + 5 + ",\n\t'INTEGER', " + 4 + ",\n\t'BINARY_INTEGER', " + 4 + ",\n\t'BIGINT', " + -5 + ",\n\t'BINARY_BIGINT', " + -5 + ",\n\t'FLOAT', " + 7 + ",\n\t'BINARY_FLOAT', " + 100 + ",\n\t'DOUBLE', " + 8 + ",\n\t'NUMBER', " + 2 + ",\n\t'DATE', " + 91 + ",\n\t'TIME', " + 92 + ",\n\t'TIMESTAMP', " + 93 + ",\n\t'TIMESTAMP_TZ', " + 2014 + ",\n\t'TIMESTAMP_LTZ', " + 2014 + ",\n\t'INTERVAL YEAR TO MONTH', " + 3001 + ",\n\t'INTERVAL DAY TO SECOND', " + 3002 + ",\n\t'CHAR', " + 1 + ",\n\t'NCHAR', " + -15 + ",\n\t'VARCHAR', " + 12 + ",\n\t'NVARCHAR', " + -9 + ",\n\t'RAW', " + -2 + ",\n\t'CLOB', " + 2005 + ",\n\t'BLOB', " + 2004 + ",\n\t'BIT', " + -7 + ",\n\t'CURSOR', " + 2012 + ",\n\t'NCLOB', " + 2011 + ",\n\t'JSON', " + 3009 + ",\n\t'ROWID', " + -8 + ",\n\t'XMLTYPE', " + 2009 + ",\n\t decode((select TYPECODE from all_types where TYPE_NAME = " + string + "),'OBJECT'," + 2002 + ",'COLLECTION'," + 2003 + "," + 1111 + "))\n";
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        String string4 = "SELECT NULL AS table_cat, c.owner AS table_schem, c.table_name, c.column_name, c.position + 1 AS key_seq,\nc.constraint_name AS pk_name\nFROM all_cons_columns c  join\nall_constraints k on k.constraint_name = c.constraint_name AND k.owner = c.owner WHERE k.constraint_type in ('PRIMARY KEY','P')\nAND k.table_name = ? \nAND c.table_name = ?\n";
        if (string2 != null) {
            if (this.hasSqlWildcard(string2)) {
                string4 = string4 + " AND k.owner like ? escape '/' selectivity 0.00001 \n";
            } else {
                string4 = string4 + "AND k.owner = ? \n";
                string2 = this.stripSqlEscapes(string2);
            }
        }
        string4 = string4 + " ORDER BY column_name";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string4);
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string3);
        if (string2 != null) {
            preparedStatement.setString(3, string2);
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        preparedStatement.closeOnCompletion();
        return resultSet;
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return this.a(null, null, string2, string3, "ORDER BY pktable_schem, pktable_name, key_seq");
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return this.a(string2, string3, null, null, "ORDER BY fktable_schem, fktable_name, key_seq");
    }

    ResultSet a(String string, String string2, String string3, String string4, String string5) throws SQLException {
        String string6 = string2 != null ? " AND p.table_name = ? " : "";
        String string7 = string4 != null ? " AND f.table_name = ? " : "";
        String string8 = string != null ? " AND p.owner =  ? " : "";
        String string9 = string3 != null ? " AND f.owner = ? " : "";
        String string10 = "SELECT NULL AS pktable_cat,\n       p.owner as pktable_schem,\n       p.table_name as pktable_name,\n       pc.column_name as pkcolumn_name,\n       NULL as fktable_cat,\n       f.owner as fktable_schem,\n       f.table_name as fktable_name,\n       fc.column_name as fkcolumn_name,\n       fc.position as key_seq,\n       decode (f.update_rule, 'CASCADE', 0, 'SET NULL', 2, 3) as update_rule,\n       decode (f.delete_rule, 'CASCADE', 0, 'SET NULL', 2, 3) as delete_rule,\n       f.constraint_name as fk_name,\n       p.constraint_name as pk_name,\n       7 as deferrability \n      FROM all_cons_columns pc, all_constraints p,\n      all_cons_columns fc, all_constraints f\nWHERE 1 = 1" + string6 + string7 + string8 + string9 + " AND f.constraint_type in ('FOREIGN KEY','R')\n  AND p.owner = f.r_owner\n  AND p.constraint_name = f.r_constraint_name\n  AND p.constraint_type in ('PRIMARY KEY','P')\n  AND pc.owner = p.owner\n  AND pc.constraint_name = p.constraint_name\n  AND pc.table_name = p.table_name\n  AND fc.owner = f.owner\n  AND fc.constraint_name = f.constraint_name\n  AND fc.table_name = f.table_name\n  AND fc.position = pc.position\n" + string5;
        PreparedStatement preparedStatement = this.connection.prepareStatement(string10);
        int n = 1;
        if (string2 != null) {
            preparedStatement.setString(n++, string2);
        }
        if (string4 != null) {
            preparedStatement.setString(n++, string4);
        }
        if (string != null) {
            preparedStatement.setString(n++, string);
        }
        if (string3 != null) {
            preparedStatement.setString(n, string3);
        }
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        return this.a(string2, string3, string5, string6, "ORDER BY fktable_schem, fktable_name, key_seq");
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        Statement statement = this.connection.createStatement();
        String string = "select\n'TINYINT' as type_name, -6 as data_type, 3 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 1 as auto_increment,\n'TINYINT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix from dual\nunion select\n'BINARY_TINYINT' as type_name, -6 as data_type, 3 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 1 as auto_increment,\n'BINARY_TINYINT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix from dual\n";
        String string2 = "union select\n'SMALLINT' as type_name, 5 as data_type, 5 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 1 as auto_increment,\n'SMALLINT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix from dual\nunion select\n'BINARY_SMALLINT' as type_name, 5 as data_type, 5 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 1 as auto_increment,\n'BINARY_SMALLINT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix from dual\n";
        String string3 = "union select\n'INTEGER' as type_name, 4 as data_type, 10 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 1 as auto_increment,\n'INTEGER' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix from dual\nunion select\n'BINARY_INTEGER' as type_name, 4 as data_type, 10 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 1 as auto_increment,\n'BINARY_INTEGER' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix from dual\n";
        String string4 = "union select\n'BIGINT' as type_name, -5 as data_type, 19 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 1 as auto_increment,\n'BIGINT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix from dual\nunion select\n'BINARY_BIGINT' as type_name, -5 as data_type, 19 as precision,\nNULL as literal_prefix, NULL as literal_suffix, null as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 1 as auto_increment,\n'BINARY_BIGINT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix from dual\n";
        String string5 = "union select\n'CHAR' as type_name, 1 as data_type, 8000 as precision,\n'''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n1 as nullable, 1 as case_sensitive, 3 as searchable, 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'CHAR' as local_type_name, null as minimum_scale, null as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix from dual\n";
        String string6 = "union select\n'VARCHAR' as type_name, 12 as data_type, 32000 as precision,\n'''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n1 as nullable, 1 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'VARCHAR' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix from dual\n";
        String string7 = "union select\n'INTERVAL YEAR TO MONTH' as type_name, 3001 as data_type, 9 as precision,\n'''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'INTERVAL YEAR TO MONTH' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix from dual\n";
        String string8 = "union select\n'INTERVAL DAY TO SECOND' as type_name, 3002 as data_type, 9 as precision,\n'''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'INTERVAL DAY TO SECOND' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix from dual\n";
        String string9 = string + string2 + string3 + string4 + UNION_SELECT_CLUSE + "'FLOAT' as type_name, " + 7 + " as data_type,  63 as precision,\n" + NUMBER_LITERAL_CLUSE + NULLABLE_CLUSE + "0 as unsigned_attribute,1 as fixed_prec_scale, 0 as auto_increment,\n'FLOAT' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + "'BINARY_FLOAT' as type_name, " + 100 + " as data_type, 63 as precision, \n" + NUMBER_LITERAL_CLUSE + NULLABLE_CLUSE + "0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'BINARY_FLOAT' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + "'DOUBLE' as type_name, " + 8 + " as data_type, 63 as precision,\n" + NUMBER_LITERAL_CLUSE + NULLABLE_CLUSE + "0 as unsigned_attribute, 1 as fixed_prec_scale,  0 as auto_increment,\n'DOUBLE' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + "'NUMBER' as type_name, " + 2 + " as data_type, 38 as precision,\n" + NUMBER_LITERAL_CLUSE + NULLABLE_CLUSE + "0 as unsigned_attribute, 1 as fixed_prec_scale, 0  as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + "'DATE' as type_name, " + 91 + " as  data_type, 35 as precision,\n" + VARCHAR_LITERAL_CLUSE + NULLABLE_CLUSE + UNSIGNED_ATTRIBUTE_CLUSE1 + "'DATE' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + "'TIME' as type_name, " + 92 + " as data_type , 35 as precision,\n" + VARCHAR_LITERAL_CLUSE + NULLABLE_CLUSE + UNSIGNED_ATTRIBUTE_CLUSE1 + "'TIME' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + "'TIMESTAMP' as type_name, " + 93 + " as data_type, 35 as precision ,\n" + VARCHAR_LITERAL_CLUSE + NULLABLE_CLUSE + UNSIGNED_ATTRIBUTE_CLUSE1 + "'TIMESTAMP' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + "'TIMESTAMP WITH TIME ZONE' as type_name, " + 2014 + " as data_type, 35 as precision, \n" + VARCHAR_LITERAL_CLUSE + NULLABLE_CLUSE + UNSIGNED_ATTRIBUTE_CLUSE1 + "'TIMESTAMP WITH TIME ZONE' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + "'TIMESTAMP WITH LOCAL TIME ZONE' as type_name, " + 2014 + " as data_type, 35 as precision,\n " + VARCHAR_LITERAL_CLUSE + NULLABLE_CLUSE + UNSIGNED_ATTRIBUTE_CLUSE1 + "'TIMESTAMP WITH LOCAL TIME ZONE' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + string7 + string8 + string5 + "union select 'NCHAR' as type_name, " + -15 + " as data_type, 4000 as precision,\n" + VARCHAR_LITERAL_CLUSE + "1 as nullable, 1 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'NCHAR' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + string6 + UNION_SELECT_CLUSE + "'NVARCHAR' as type_name, " + -9 + " as data_type, 16000 as precision,\n" + VARCHAR_LITERAL_CLUSE + "1 as nullable, 1 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n'NVARCHAR' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + " 'RAW' as type_name, " + -2 + " as data_type, 8000 as precision,\n" + VARCHAR_LITERAL_CLUSE + "1 as nullable, 1 as case_sensitive,  0 as searchable,\n" + UNSIGNED_ATTRIBUTE_CLUSE1 + "'RAW' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + " 'CLOB' as type_name, " + 2005 + "  as data_type, -1 as precision,\n" + VARCHAR_LITERAL_CLUSE + "1 as nullable, 1 as case_sensitive, 0  as searchable,\n" + UNSIGNED_ATTRIBUTE_CLUSE1 + "'CLOB' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + " 'NCLOB' as type_name, " + 2011 + " as data_type , -1 as precision,\n" + VARCHAR_LITERAL_CLUSE + "1 as nullable, 1  as case_sensitive, 0 as searchable,\n" + UNSIGNED_ATTRIBUTE_CLUSE1 + "'NCLOB' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + " 'BLOB' as type_name, " + 2004 + " as data_type, -1  as precision,\n" + NUMBER_LITERAL_CLUSE + "1 as nullable, 0 as case_sensitive, 0 as searchable,\n" + UNSIGNED_ATTRIBUTE_CLUSE1 + "'BLOB' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + "'BIT' as type_name, " + -7 + " as data_type, 64 as precision,\n'b''' as literal_prefix, '''' as literal_suffix, null as create_params,\n" + NULLABLE_CLUSE + UNSIGNED_ATTRIBUTE_CLUSE1 + "'BIT' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + "'JSON' as type_name, " + 3009 + " as data_type, -1 as  precision,\n" + VARCHAR_LITERAL_CLUSE + NULLABLE_CLUSE + UNSIGNED_ATTRIBUTE_CLUSE1 + "'JSON' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + "'XMLTYPE' as type_name, " + 2009 + " as data_type, -1 as precision,\n" + VARCHAR_LITERAL_CLUSE + "1 as nullable, 1 as case_sensitive, 0 as searchable, \n" + UNSIGNED_ATTRIBUTE_CLUSE1 + "'XMLTYPE' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + " 'BOOLEAN' as type_name, " + 16 + " as data_type, 1 as precision,\n" + NUMBER_LITERAL_CLUSE + NULLABLE_CLUSE + UNSIGNED_ATTRIBUTE_CLUSE1 + "'BOOLEAN' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE + UNION_SELECT_CLUSE + "'ROWID' as type_name, " + -8 + " as data_type, 42 as precision,\n" + VARCHAR_LITERAL_CLUSE + NULLABLE_CLUSE + UNSIGNED_ATTRIBUTE_CLUSE1 + "'ROWID' as local_type_name, null as minimum_scale, null as maximum_scale,\n" + NULL_DATA_TYPE_CLUSE;
        String string10 = "select * from (" + string9 + ") order by data_type";
        statement.closeOnCompletion();
        return statement.executeQuery(string10);
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        String string4 = "select null as table_cat, owner as table_schem, table_name, 0 as NON_UNIQUE, null as index_qualifier, null as index_name, 0 as type, 0 as ordinal_position, null as column_name, null as asc_or_desc, num_rows as cardinality, blocks as pages, null as filter_condition from all_tables where table_name = ? ";
        if (string2 != null && string2.length() > 0) {
            string4 = string4 + "  and owner = ? ";
        }
        string4 = string4 + " union\n";
        string4 = string4 + "select null as table_cat, i.owner as table_schem, i.table_name, decode (i.uniqueness, 'Y', 0, 1), null as index_qualifier, i.index_name, 1 as type, c.column_position + 1 as ordinal_position, c.column_name, decode (c.descend, 'ASC', 'A', 'D') as asc_or_desc, i.distinct_keys as cardinality, i.leaf_blocks as pages, null as filter_condition from all_indexes i, all_ind_columns c where i.table_name = ?";
        if (bl) {
            string4 = string4 + "  and i.uniqueness = 'Y' ";
        }
        if (string2 != null && string2.length() > 0) {
            string4 = string4 + " and i.owner = ? ";
        }
        string4 = string4 + " and i.index_name = c.index_name and i.table_owner = c.table_owner and i.table_name = c.table_name and i.owner = c.index_owner ";
        string4 = string4 + " order by non_unique, type, index_name, ordinal_position";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string4);
        int n = 1;
        preparedStatement.setString(n++, string3);
        if (string2 != null && string2.length() > 0) {
            preparedStatement.setString(n++, string2);
        }
        preparedStatement.setString(n++, string3);
        if (string2 != null && string2.length() > 0) {
            preparedStatement.setString(n, string2);
        }
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    @Override
    public boolean supportsResultSetType(int n) {
        return n == 1003 || n == 1004 || n == 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) {
        return !(n != 1003 && n != 1004 && n != 1005 || n2 != 1007 && n2 != 1008);
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) {
        return n != 1003;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) {
        return n != 1003;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) {
        return n == 1005;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int n) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int n) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int n) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select null as TYPE_CAT,owner as TYPE_SCHEM , TYPE_NAME, null as class_name,2002 as DATA_TYPE, null as REMARKS,null as BASE_TYPE  from all_types where TYPECODE='OBJECT' ");
        boolean bl = YasDatabaseMetaData.a(nArray);
        if (bl) {
            if (string2 != null) {
                if (this.hasSqlWildcard(string2)) {
                    stringBuilder.append("AND owner like ?  escape '/' selectivity 0.00001 ");
                } else {
                    string2 = this.stripSqlEscapes(string2);
                    stringBuilder.append("AND owner = ? ");
                }
            }
            if (string3 != null) {
                if (this.hasSqlWildcard(string3)) {
                    stringBuilder.append("AND TYPE_NAME like ?  escape '/' selectivity 0.00001 ");
                } else {
                    string3 = this.stripSqlEscapes(string3);
                    stringBuilder.append(" AND TYPE_NAME = ? ");
                }
            }
        } else {
            stringBuilder.append(" AND 1=2");
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement(stringBuilder.toString());
        YasDatabaseMetaData.a(string2, string3, bl, preparedStatement);
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    private static void a(String string, String string2, boolean bl, PreparedStatement preparedStatement) throws SQLException {
        if (bl) {
            int n = 1;
            if (string != null) {
                preparedStatement.setString(n++, string);
            }
            if (string2 != null) {
                preparedStatement.setString(n, string2);
            }
        }
    }

    private static boolean a(int[] nArray) {
        boolean bl = false;
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != 2002) continue;
                bl = true;
                break;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select null as TYPE_CAT,owner as TYPE_SCHEM , TYPE_NAME, null as SUPERTYPE_CAT, SUPERTYPE_OWNER as SUPERTYPE_SCHEM , SUPERTYPE_NAME from all_types where SUPERTYPE_NAME is not null ");
        if (string2 != null) {
            if (this.hasSqlWildcard(string2)) {
                stringBuilder.append("AND owner like ?  escape '/' selectivity 0.00001 ");
            } else {
                string2 = this.stripSqlEscapes(string2);
                stringBuilder.append("AND owner = ? ");
            }
        }
        if (string3 != null) {
            if (this.hasSqlWildcard(string3)) {
                stringBuilder.append("AND TYPE_NAME like ?  escape '/' selectivity 0.00001 ");
            } else {
                string3 = this.stripSqlEscapes(string3);
                stringBuilder.append(" AND TYPE_NAME = ? ");
            }
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement(stringBuilder.toString());
        int n = 1;
        if (string2 != null) {
            preparedStatement.setString(n++, string2);
        }
        if (string3 != null) {
            preparedStatement.setString(n, string3);
        }
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        return this.a();
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = YasDatabaseMetaData.d("c.ATTR_TYPE_NAME");
        String string6 = string3;
        String string7 = "decode(c1.NULLS_STORED, 'NO',0, 1)";
        String string8 = "decode(c.PRECISION, null, c.LENGTH, decode(c.ATTR_TYPE_NAME,'NUMBER', decode(c.SCALE,null, 0 , c.PRECISION),c.PRECISION))";
        String string9 = "decode(c.ATTR_TYPE_NAME,'NUMBER',  decode(c.scale,null, -127, c.scale), c.scale)";
        String string10 = "decode(c1.NULLS_STORED, 'NO','NO','YES')";
        String string11 = "select null as TYPE_CAT,c.owner as TYPE_SCHEM,c.TYPE_NAME as TYPE_NAME,c.ATTR_NAME as ATTR_NAME," + string5 + AS_DATA_TYPE_CLUSE + "c.ATTR_TYPE_NAME as ATTR_TYPE_NAME," + string8 + " as ATTR_SIZE," + string9 + " as decimal_digits,10 as num_prec_radix," + string7 + " as nullable,null as remarks,null as ATTR_DEF,0 as sql_data_type,0 as sql_datetime_sub,c.length as char_octet_length,c.ATTR_NO as ordinal_position," + string10 + " as is_nullable,null as scope_catalog,null as scope_schema,null as scope_table,null as source_data_type from DBA_TYPE_ATTRS c left join dba_COLL_TYPES c1 on c.TYPE_NAME=c1.TYPE_NAME and c.OWNER=c1.OWNER where 1=1 ";
        String string12 = string2;
        String string13 = string4;
        if (string2 != null) {
            if (this.hasSqlWildcard(string2)) {
                string11 = string11 + "AND c.owner like ? escape '/' selectivity 0.00001 ";
            } else {
                string12 = this.stripSqlEscapes(string2);
                string11 = string11 + "AND c.owner = ? ";
            }
        }
        if (string3 != null) {
            if (this.hasSqlWildcard(string3)) {
                string11 = string11 + " AND c.TYPE_NAME like ? escape '/' selectivity 0.00001 ";
            } else {
                string6 = this.stripSqlEscapes(string3);
                string11 = string11 + " AND c.TYPE_NAME = ? ";
            }
        }
        if (string4 != null) {
            if (this.hasSqlWildcard(string4)) {
                string11 = string11 + " AND c.ATTR_NAME like ? escape '/' selectivity 0.00001 ";
            } else {
                string13 = this.stripSqlEscapes(string4);
                string11 = string11 + " AND c.ATTR_NAME = ? ";
            }
        }
        string11 = string11 + " order by TYPE_CAT, TYPE_SCHEM, TYPE_NAME , ORDINAL_POSITION";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string11);
        int n = 1;
        if (string2 != null) {
            preparedStatement.setString(n, string12);
            ++n;
        }
        if (string3 != null) {
            preparedStatement.setString(n, string6);
            ++n;
        }
        if (string4 != null) {
            preparedStatement.setString(n, string13);
        }
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    @Override
    public boolean supportsResultSetHoldability(int n) {
        return n == 1;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    private String e(String string) throws SQLException {
        Matcher matcher = VERSION_PATTERN.matcher(string);
        if (!matcher.find()) {
            throw SQLError.createSQLException("Incorrect version format: " + string, YasState.UNKNOWN_STATE);
        }
        return matcher.group();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return Integer.parseInt(this.e(this.getDatabaseProductVersion()).split("\\.")[0]);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return Integer.parseInt(this.e(this.getDatabaseProductVersion()).split("\\.")[1]);
    }

    @Override
    public int getJDBCMajorVersion() {
        return YasConstants.JDBC_MAJOR_VERSION;
    }

    @Override
    public int getJDBCMinorVersion() {
        return YasConstants.JDBC_MINOR_VERSION;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() {
        return true;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_VALID_FOREVER;
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        String string3 = "select username as table_schem, null as table_catalog from all_users where  username like ?  order by table_schem";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string3);
        if (string2 != null) {
            preparedStatement.setString(1, string2);
        } else {
            preparedStatement.setString(1, "%");
        }
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.a();
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        String string4 = "SELECT DECODE(PROCEDURE_NAME,\nNULL,NULL,        object_name) AS FUNCTION_CAT,\n        owner AS FUNCTION_SCHEM,\n         DECODE(PROCEDURE_NAME,\nNULL,        object_name,\n        PROCEDURE_NAME) AS FUNCTION_NAME,\n        DECODE(PROCEDURE_NAME,null,'Standalone function','Packaged function') AS remarks, 0 AS FUNCTION_TYPE,   DECODE(PROCEDURE_NAME,null,OBJECT_NAME,OBJECT_NAME||'.'||PROCEDURE_NAME) AS specific_name FROM all_procedures proc\nWHERE owner LIKE ? escape '/'\n        AND EXISTS\n    (SELECT *\n    FROM all_arguments arg1\n    WHERE (arg1.ARGUMENT_NAME is null\n            OR length(arg1.ARGUMENT_NAME) = 0)\n            AND arg1.IN_OUT = 'OUT'\n            AND arg1.OBJECT_ID = proc.OBJECT_ID\n            AND (arg1.SUBPROGRAM_ID = proc.SUBPROGRAM_ID\n            OR (arg1.SUBPROGRAM_ID is null)))\n        AND ( ( ? =1\n        AND ((OBJECT_NAME LIKE ? ESCAPE '/'\n        AND PROCEDURE_NAME is null)\n        OR PROCEDURE_NAME LIKE ? ESCAPE '/' ))\n        OR (? =2\n AND OBJECT_NAME LIKE ? ESCAPE '/'         AND PROCEDURE_NAME is NULL )\n        OR (? =3\n AND OBJECT_NAME LIKE ? ESCAPE '/'         AND PROCEDURE_NAME LIKE ? ESCAPE '/' ))order by FUNCTION_CAT, FUNCTION_SCHEM, FUNCTION_NAME ";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string4);
        int n = YasDatabaseMetaData.b(string);
        preparedStatement.setString(1, this.c(string2));
        preparedStatement.setInt(2, n);
        preparedStatement.setString(3, this.a(string3, "functionNamePattern"));
        preparedStatement.setString(4, this.a(string3, "functionNamePattern"));
        preparedStatement.setInt(5, n);
        preparedStatement.setString(6, this.a(string3, "functionNamePattern"));
        preparedStatement.setInt(7, n);
        preparedStatement.setString(8, string);
        preparedStatement.setString(9, this.a(string3, "functionNamePattern"));
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isAssignableFrom(this.getClass());
    }

    public Object unwrap(Class clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = " DECODE(length(arg.ARGUMENT_NAME), 0, 5,\nDECODE(arg.in_out, 'IN', 1,\n'OUT', 3,\n'IN OUT', 2,\n0)) ";
        String string6 = YasDatabaseMetaData.d("arg.data_type");
        String string7 = "SELECT DECODE(arg.SUBPROGRAM_NAME,NULL,NULL,arg.object_name) AS FUNCTION_CAT,\n       arg.owner AS FUNCTION_SCHEM,\n       DECODE(arg.SUBPROGRAM_NAME,null,arg.object_name,arg.SUBPROGRAM_NAME) AS FUNCTION_NAME,\n       arg.argument_name AS column_name,\n" + string5 + " AS column_type,\n" + string6 + AS_DATA_TYPE_CLUSE + "       arg.data_type AS type_name,\n       DECODE (arg.data_precision, NULL, arg.data_length,\n                               arg.data_precision) AS precision,\n       arg.data_length AS length,\n       arg.data_scale AS scale,\n       10 AS radix,\n" + 1 + " AS nullable,\n       NULL AS remarks,\n       DECODE(arg.data_type,\n                         'CHAR', 32000,\n                         'NCHAR', 8000,\n                         'VARCHAR', 32000,\n                         'NVARCHAR', 32000,\n                         'RAW', 8000,\n                         NULL) AS char_octet_length,\n       arg.sequence - 1 AS ordinal_position,\n       'YES' AS is_nullable,\n DECODE(arg.SUBPROGRAM_NAME,null,arg.OBJECT_NAME,arg.OBJECT_NAME||'.'||arg.SUBPROGRAM_NAME)  AS specific_name FROM all_arguments arg, all_procedures proc\n WHERE arg.owner LIKE ? ESCAPE '/'\n AND (( ? =1 and ((proc.OBJECT_NAME LIKE ?  ESCAPE '/' and proc.PROCEDURE_NAME is null) or proc.PROCEDURE_NAME LIKE ?  ESCAPE '/' ))  OR (? =2 and proc.OBJECT_NAME LIKE ?  ESCAPE '/' and proc.PROCEDURE_NAME is null ) or (? =3 and proc.OBJECT_NAME LIKE ?  ESCAPE '/' and proc.PROCEDURE_NAME LIKE ?  ESCAPE '/' ))\n AND arg.owner = proc.owner\n AND (arg.SUBPROGRAM_ID = proc.SUBPROGRAM_ID OR arg.SUBPROGRAM_ID is null)\n AND arg.object_id = proc.object_id\n AND EXISTS(select * from all_arguments arg1       where (arg1.ARGUMENT_NAME  is null or length(arg1.ARGUMENT_NAME) = 0)     and arg1.IN_OUT = 'OUT'      and arg1.OBJECT_ID = arg.OBJECT_ID        and (arg1.SUBPROGRAM_ID = arg.SUBPROGRAM_ID or (arg1.SUBPROGRAM_ID is null))) \n  AND (arg.argument_name LIKE ? ESCAPE '/'\n       OR ((arg.ARGUMENT_NAME is null or length(arg.ARGUMENT_NAME) = 0)\n           AND arg.IN_OUT = 'OUT'))\nORDER BY FUNCTION_CAT,FUNCTION_SCHEM, FUNCTION_NAME, SPECIFIC_NAME, ORDINAL_POSITION";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string7);
        int n = YasDatabaseMetaData.b(string);
        preparedStatement.setString(1, this.c(string2));
        preparedStatement.setInt(2, n);
        preparedStatement.setString(3, this.a(string3, "procedureNamePattern"));
        preparedStatement.setString(4, this.a(string3, "procedureNamePattern"));
        preparedStatement.setInt(5, n);
        preparedStatement.setString(6, this.a(string3, "procedureNamePattern"));
        preparedStatement.setInt(7, n);
        preparedStatement.setString(8, string);
        preparedStatement.setString(9, this.a(string3, "procedureNamePattern"));
        preparedStatement.setString(10, this.a(string4, "columnNamePattern"));
        preparedStatement.closeOnCompletion();
        return preparedStatement.executeQuery();
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = " select * from(  select null as TABLE_CAT,\n owner as TABLE_SCHEM,\n  table_name as TABLE_NAME,\n  'ROWID' as COLUMN_NAME,\n  -8 as DATA_TYPE,\n  18 as COLUMN_SIZE,\n  null as DECIMAL_DIGITS,\n  10 as NUM_PREC_RADIX, \n  'NO_USAGE_RESTRICTONS'  as COLUMN_USAGE,\n  null as REMARKS, \n  null as CHAR_OCTET_LENGTH,\n  'NO'  as IS_NULLABLE\nfrom all_tables\n where\n owner  like ? and\n  table_name like ? ESCAPE '/'\n  and 'ROWID' like ? ESCAPE '/'\nunion\n  select null as TABLE_CAT,\n  owner  as TABLE_SCHEM,\n table_name as TABLE_NAME,\n  'ROWNUM' as COLUMN_NAME,\n  2 as DATA_TYPE,\n  10 as COLUMN_SIZE,\n  38 as DECIMAL_DIGITS,\n  10 as NUM_PREC_RADIX,\n 'NO_USAGE_RESTRICTONS' as COLUMN_USAGE,\n  null as  REMARKS,\n   null as CHAR_OCTET_LENGTH,\n  'NO' as IS_NULLABLE\n from all_tables\nwhere\n  owner like ? and \n  table_name like ? ESCAPE '/'and 'ROWNUM' like ? ESCAPE '/'union\n  select null as TABLE_CAT,\n  owner as TABLE_SCHEM,\n  table_name  as TABLE_NAME,\n  'ROWSCN' as COLUMN_NAME,\n  2 as DATA_TYPE,\n  10 as COLUMN_SIZE,\n  38 as DECIMAL_DIGITS,\n  10 as  NUM_PREC_RADIX,\n  'NO_USAGE_RESTRICTONS' as COLUMN_USAGE,\n  null as REMARKS,\n  null as CHAR_OCTET_LENGTH, \n  'NO' as IS_NULLABLE \nfrom  all_tables\nwhere \n  owner like ? and\n  table_name like ? ESCAPE '/'\n  and 'ROWSCN' like ? ESCAPE '/') order by TABLE_CAT,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME \n";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string5);
        preparedStatement.setString(1, this.c(string2));
        preparedStatement.setString(2, this.a(string3, "tableNamePattern"));
        preparedStatement.setString(3, this.a(string4, "columnNamePattern"));
        preparedStatement.setString(4, this.c(string2));
        preparedStatement.setString(5, this.a(string3, "tableNamePattern"));
        preparedStatement.setString(6, this.a(string4, "columnNamePattern"));
        preparedStatement.setString(7, this.c(string2));
        preparedStatement.setString(8, this.a(string3, "tableNamePattern"));
        preparedStatement.setString(9, this.a(string4, "columnNamePattern"));
        return preparedStatement.executeQuery();
    }

    @Override
    public long getMaxLogicalLobSize() {
        return 0L;
    }

    @Override
    public boolean supportsRefCursors() {
        return true;
    }

    ResultSet a() throws SQLException {
        String string = "SELECT NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS CLASS_NAME, 'STRUCT' AS DATA_TYPE, NULL AS REMARKS FROM DUAL WHERE 1=2 ";
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        statement.closeOnCompletion();
        return resultSet;
    }

    protected boolean hasSqlWildcard(String string) {
        Matcher matcher = sqlWildcardPattern.matcher(string);
        return matcher.find();
    }

    protected String stripSqlEscapes(String string) {
        Matcher matcher = sqlEscapePattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    static {
        numberTypeSet.add(8);
        numberTypeSet.add(4);
        numberTypeSet.add(-6);
        numberTypeSet.add(5);
        numberTypeSet.add(7);
        numberTypeSet.add(6);
        numberTypeSet.add(2);
        numberTypeSet.add(3);
        charTypeSet.add(1);
        charTypeSet.add(-15);
        charTypeSet.add(-9);
        charTypeSet.add(12);
        canConvertToNumber.addAll(numberTypeSet);
        canConvertToNumber.addAll(charTypeSet);
        canConvertToNumber.add(16);
        canConvertToNumber.add(-5);
        canConvertToBoolean.addAll(numberTypeSet);
        canConvertToBoolean.addAll(charTypeSet);
        canConvertToBoolean.add(16);
        canConvertToBoolean.add(-5);
        canConvertToBoolean.remove(6);
        canConvertToBoolean.remove(7);
        canConvertToBoolean.remove(8);
        canConvertToBoolean.add(-7);
        canConvertToXML.add(12);
        canConvertToXML.add(2005);
        canConvertToXML.add(1);
        canConvertToBit.addAll(numberTypeSet);
        canConvertToBit.addAll(charTypeSet);
        canConvertToBit.add(16);
        canConvertToBit.add(-7);
        canConvertToBit.add(-5);
        canConvertToBit.remove(6);
        canConvertToBit.remove(7);
        canConvertToBit.remove(8);
        canConvertToLongString.addAll(numberTypeSet);
        canConvertToLongString.addAll(charTypeSet);
        canConvertToLongString.add(2005);
        canConvertToLongString.add(16);
        canConvertToLongString.add(91);
        canConvertToLongString.add(92);
        canConvertToLongString.add(2013);
        canConvertToNString.addAll(canConvertToLongString);
        canConvertToNString.add(2004);
        canConvertToNString.add(2011);
        canConvertToNString.add(-2);
        canConvertToNString.add(-5);
        canConvertToNString.add(3002);
        canConvertToNString.add(3001);
        canConvertToNString.add(93);
        canConvertToNString.add(-7);
        canConvertToNString.add(3009);
        canConvertToNString.add(-8);
        canConvertToString.addAll(canConvertToNString);
        canConvertToString.add(2009);
        canConvertToDate.addAll(charTypeSet);
        canConvertToDate.add(91);
        canConvertToDate.add(92);
        canConvertToDate.add(2013);
        canConvertToDate.add(93);
        canConvertToDate.add(2014);
        canConvertToBlob.add(12);
        canConvertToBlob.add(-9);
        canConvertToBlob.add(-2);
        canConvertToBlob.add(3009);
        canConvertToClob.addAll(numberTypeSet);
        canConvertToClob.addAll(charTypeSet);
        canConvertToClob.add(-2);
        canConvertToClob.add(2011);
        canConvertToClob.add(2005);
        canConvertToClob.add(-5);
        canConvertToClob.add(3009);
        canConvertToRaw.add(-9);
        canConvertToRaw.add(12);
        canConvertToRaw.add(2004);
        canConvertToRaw.add(2005);
        canConvertToRaw.add(3009);
        canConvertToJson.addAll(charTypeSet);
        canConvertToJson.add(2005);
        canConvertToJson.add(2011);
        TABLE_TYPES.add("TABLE");
        TABLE_TYPES.add("VIEW");
        TABLE_TYPES.add("SYNONYM");
        VERSION_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        sqlEscapePattern = Pattern.compile("/");
        sqlWildcardPattern = Pattern.compile("^%|^_|[^/]%|[^/]_");
    }
}

