/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.ParameterList;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.ConnectionImpl;
import com.yashandb.jdbc.DebugBreakpoint;
import com.yashandb.jdbc.DebugBreakpointImpl;
import com.yashandb.jdbc.Debugger;
import com.yashandb.jdbc.YasCallableStatement;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.protocol.debug.DebugOperation;
import com.yashandb.util.Messages;
import com.yashandb.util.YasSQL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class YasDebugCallableStatement
extends YasCallableStatement
implements Debugger {
    private boolean debugOn = false;
    private long runObjectId = -1L;
    private int runSubprogramId = -1;
    private int runLineNum = -1;
    private long debugObjectId = -1L;
    private int debugSubprogramId = -1;
    private int debugVersion = -1;
    private boolean needGetSoInfo = false;
    private boolean mustCheckVersion = false;
    private List breakpointList = new ArrayList();

    YasDebugCallableStatement(ConnectionImpl connectionImpl, String string, int n, int n2, int n3, long l, int n4, int n5) throws SQLException {
        super(connectionImpl, string, n, n2, n3);
        this.debugObjectId = l;
        this.debugSubprogramId = n4;
        this.debugVersion = n5;
        this.needGetSoInfo = false;
        this.mustCheckVersion = true;
    }

    YasDebugCallableStatement(ConnectionImpl connectionImpl, String string, int n, int n2, int n3) throws SQLException {
        super(connectionImpl, string, n, n2, n3);
        if (this.getSession().getConnectVersion().getValue() >= ConnectVersion.VER8.getValue()) {
            return;
        }
        this.mustCheckVersion = true;
        this.needGetSoInfo = true;
        if (this.yasSQL == null) {
            this.yasSQL = new YasSQL(string);
        }
    }

    @Override
    public void pdbgAbort() throws SQLException {
        this.i();
        this.connection.getSession().pdbgAbort(this);
    }

    private void e() {
        if (this.breakpointList.isEmpty()) {
            return;
        }
        for (DebugBreakpoint debugBreakpoint : this.breakpointList) {
            debugBreakpoint.setId(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void f() throws SQLException {
        if (!this.needGetSoInfo) {
            return;
        }
        String string = this.yasSQL.getSoNameForDebugMode();
        if (string == null) {
            throw new YasException("The content to debug was not found.", YasState.DATA_ERROR);
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement("select OBJECT_ID,SUBPROGRAM_ID from dba_procedures where OWNER = ? AND OBJECT_NAME = ? ");
        PreparedStatement preparedStatement2 = this.connection.prepareStatement("select VERSION from DBA_SOURCE where OWNER = ? AND NAME = ? ");
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1) {
            preparedStatement.setString(1, this.getSession().getUser());
            preparedStatement.setString(2, string);
            preparedStatement2.setString(1, this.getSession().getUser());
            preparedStatement2.setString(2, string);
        } else if (stringArray.length == 2) {
            preparedStatement.setString(1, stringArray[0]);
            preparedStatement.setString(2, stringArray[1]);
            preparedStatement2.setString(1, stringArray[0]);
            preparedStatement2.setString(2, stringArray[1]);
        } else {
            preparedStatement.close();
            preparedStatement2.close();
            throw new YasException("Debug: " + string + " name error.", YasState.DATA_ERROR);
        }
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            if (!resultSet.next() || !resultSet2.next()) {
                resultSet.close();
                resultSet2.close();
                throw new YasException("Debug: " + string + " is not find.", YasState.DATA_ERROR);
            }
            this.debugObjectId = resultSet.getLong(1);
            this.debugSubprogramId = resultSet.getInt(2);
            this.debugVersion = resultSet2.getInt(1);
            resultSet.close();
            resultSet2.close();
        }
        finally {
            preparedStatement.close();
            preparedStatement2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pdbgStart() throws SQLException {
        if (this.debugOn) {
            throw new YasException("This DebugMode has been opened", YasState.OBJECT_NOT_IN_STATE);
        }
        this.f();
        ParameterList[] parameterListArray = null;
        if (this.preparedParameters != null) {
            parameterListArray = new ParameterList[]{this.preparedParameters};
        }
        YasDebugCallableStatement yasDebugCallableStatement = this;
        synchronized (yasDebugCallableStatement) {
            this.checkClosed();
            this.closeForNextExecution();
            this.currentResultSet = this.connection.getSession().pdbgExecute(this, parameterListArray);
            if (this.debugOn) {
                if (this.mustCheckVersion) {
                    this.g();
                }
                this.h();
            }
        }
    }

    private void g() throws SQLException {
        this.i();
        this.connection.getSession().pdbgCheckVersion(this, this.debugObjectId, this.debugSubprogramId, this.debugVersion);
    }

    @Override
    public DebugBreakpoint pdbgAddBreakpoint(long l, int n, int n2) throws SQLException {
        if (n2 < 1) {
            throw SQLError.createSQLException("invalid parameter, ''lineNum'' should not be < 1", YasState.INVALID_PARAMETER_VALUE);
        }
        this.checkClosed();
        if (this.a(l, n, n2)) {
            throw new YasException("Break point has already exists.", YasState.DATA_ERROR);
        }
        DebugBreakpointImpl debugBreakpointImpl = new DebugBreakpointImpl(l, n, n2);
        this.breakpointList.add(debugBreakpointImpl);
        if (this.debugOn) {
            this.h();
        }
        return debugBreakpointImpl;
    }

    private void h() throws SQLException {
        this.i();
        ArrayList<DebugBreakpoint> arrayList = new ArrayList<DebugBreakpoint>();
        for (DebugBreakpoint debugBreakpoint : this.breakpointList) {
            if (debugBreakpoint.getId() != -1) continue;
            arrayList.add(debugBreakpoint);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        this.connection.getSession().pdbgAddBreakpoint(this, arrayList);
    }

    private boolean a(long l, int n, int n2) {
        if (this.breakpointList.isEmpty()) {
            return false;
        }
        for (DebugBreakpoint debugBreakpoint : this.breakpointList) {
            if (debugBreakpoint.getObjectId() != l || debugBreakpoint.getSubprogramId() != n || debugBreakpoint.getLineNum() != n2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void pdbgDeleteBreakpoint(DebugBreakpoint debugBreakpoint) throws SQLException {
        if (debugBreakpoint == null) {
            throw SQLError.createSQLException("invalid parameter, ''breakpoint'' should not be null.", YasState.INVALID_PARAMETER_VALUE);
        }
        this.checkClosed();
        DebugBreakpoint debugBreakpoint2 = null;
        for (DebugBreakpoint debugBreakpoint3 : this.breakpointList) {
            if (!debugBreakpoint.equals(debugBreakpoint3)) continue;
            debugBreakpoint2 = debugBreakpoint3;
            break;
        }
        if (debugBreakpoint2 == null) {
            throw new YasException("Break point does not exist.", YasState.DATA_ERROR);
        }
        if (this.debugOn) {
            ArrayList arrayList = new ArrayList();
            arrayList.add(debugBreakpoint2);
            this.connection.getSession().pdbgDeleteBreakpoint(this, arrayList);
        }
        this.breakpointList.remove(debugBreakpoint2);
    }

    @Override
    public List pdbgShowBreakpoints() throws SQLException {
        this.checkClosed();
        return this.breakpointList;
    }

    private void i() throws SQLException {
        this.checkClosed();
        if (!this.debugOn) {
            throw SQLError.createSQLException(Messages.get("This DebugMode has been closed.", new Object[0]), YasState.OBJECT_NOT_IN_STATE);
        }
    }

    @Override
    public void pdbgDeleteAllBreakpoints() throws SQLException {
        this.checkClosed();
        if (this.breakpointList.isEmpty()) {
            return;
        }
        if (this.debugOn) {
            this.connection.getSession().pdbgDeleteBreakpoint(this, this.breakpointList);
        }
        this.breakpointList.clear();
    }

    @Override
    public void pdbgStepInto() throws SQLException {
        this.i();
        this.currentResultSet = this.connection.getSession().pdbgStepDebug(this, DebugOperation.DBG_STEP_INTO);
    }

    @Override
    public void pdbgStepOut() throws SQLException {
        this.i();
        this.currentResultSet = this.connection.getSession().pdbgStepDebug(this, DebugOperation.DBG_STEP_OUT);
    }

    @Override
    public void pdbgContinue() throws SQLException {
        this.i();
        this.currentResultSet = this.connection.getSession().pdbgStepDebug(this, DebugOperation.DBG_CONTINUE);
    }

    @Override
    public void pdbgStepNext() throws SQLException {
        this.i();
        this.currentResultSet = this.connection.getSession().pdbgStepDebug(this, DebugOperation.DBG_STEP_NEXT);
    }

    @Override
    public List pdbgShowFrameVariables() throws SQLException {
        this.i();
        return this.connection.getSession().pdbgShowVars(this);
    }

    @Override
    public List pdbgShowFrames() throws SQLException {
        this.i();
        return this.connection.getSession().pdbgShowFrames(this);
    }

    public void setDebugStatus(int n, long l, int n2, int n3) {
        if (n == 0) {
            this.debugOn = false;
            this.e();
            this.runObjectId = -1L;
            this.runSubprogramId = -1;
            this.runLineNum = -1;
            return;
        }
        this.debugOn = true;
        this.runObjectId = l;
        this.runSubprogramId = n2;
        this.runLineNum = n3;
    }

    @Override
    public long getRunObjectId() throws SQLException {
        this.i();
        return this.runObjectId;
    }

    @Override
    public int getRunSubprogramId() throws SQLException {
        this.i();
        return this.runSubprogramId;
    }

    @Override
    public int getRunLineNum() throws SQLException {
        this.i();
        return this.runLineNum;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (this.debugOn) {
            this.pdbgAbort();
        }
        super.close();
    }

    @Override
    public boolean isDebugOn() {
        return this.debugOn;
    }
}

