/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.YasConstants;
import com.yashandb.conf.ConnectionUrl;
import com.yashandb.conf.YasProperty;
import com.yashandb.jdbc.ConnectionImpl;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class YasDriver
implements Driver {
    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        if (!ConnectionUrl.acceptsUrl(string)) {
            return null;
        }
        ConnectionUrl connectionUrl = ConnectionUrl.getInstance(string, properties);
        return ConnectionImpl.getInstance(connectionUrl);
    }

    @Override
    public boolean acceptsURL(String string) {
        try {
            return ConnectionUrl.acceptsUrl(string);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        Properties properties2 = new Properties(properties);
        Properties properties3 = ConnectionUrl.parseURL(string, properties2);
        if (properties3 != null) {
            properties2 = properties3;
        }
        YasProperty[] yasPropertyArray = YasProperty.values();
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[yasPropertyArray.length];
        for (int i = 0; i < driverPropertyInfoArray.length; ++i) {
            driverPropertyInfoArray[i] = yasPropertyArray[i].toDriverPropertyInfo(properties2);
        }
        return driverPropertyInfoArray;
    }

    @Override
    public int getMajorVersion() {
        return YasConstants.MAJOR_VERSION;
    }

    @Override
    public int getMinorVersion() {
        return YasConstants.MINOR_VERSION;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger");
    }
}

