/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.YasLargeObject;
import com.yashandb.jdbc.exception.SQLError;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class YasLobInputStream
extends InputStream {
    private YasLargeObject largeObject = null;
    private int cachePos = 0;
    private int cacheLen = 0;
    private long steamLobRemainSize = 0L;
    private long lobOffset = 0L;
    private byte[] cacheData = null;
    private boolean isClosed = false;

    public YasLobInputStream(YasLargeObject yasLargeObject) throws SQLException {
        this.largeObject = yasLargeObject;
        this.cachePos = 0;
        int n = yasLargeObject.getStepSize();
        if (n > 0) {
            this.cacheData = new byte[n];
        } else {
            int n2 = (int)yasLargeObject.getLobLength();
            this.cacheData = new byte[n2];
        }
        this.cacheLen = yasLargeObject.getBytes(0L, this.cacheData);
        this.steamLobRemainSize = yasLargeObject.getLobLength();
    }

    public YasLobInputStream(YasLargeObject yasLargeObject, long l, long l2) throws SQLException {
        if (l < 1L || l2 < 0L) {
            throw SQLError.createSQLException("invalid parameter", YasState.INVALID_PARAMETER_VALUE);
        }
        long l3 = l - 1L;
        long l4 = yasLargeObject.getLobLength();
        if (l2 == 0L || l4 == 0L || l3 >= l4) {
            return;
        }
        this.largeObject = yasLargeObject;
        long l5 = Math.min(l2, l4);
        if (l3 + l5 > l4) {
            l5 = l4 - l3;
        }
        this.cachePos = 0;
        this.steamLobRemainSize = l5;
        int n = yasLargeObject.getStepSize();
        if (n > 0) {
            this.cacheData = new byte[n];
        } else {
            int n2 = (int)yasLargeObject.getLobLength();
            this.cacheData = new byte[n2];
        }
        this.lobOffset = l3;
        this.cacheLen = yasLargeObject.getBytes(l3, this.cacheData);
    }

    private void a() throws IOException {
        if (this.isClosed) {
            throw new IOException("stream closed");
        }
    }

    @Override
    public int read() throws IOException {
        this.a();
        if (this.steamLobRemainSize <= 0L) {
            return -1;
        }
        int n = this.cacheData[this.cachePos++] & 0xFF;
        --this.steamLobRemainSize;
        if (this.cachePos >= this.cacheLen) {
            this.lobOffset += (long)this.cacheLen;
            try {
                this.cacheLen = this.largeObject.getBytes(this.lobOffset, this.cacheData);
                this.cachePos = 0;
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        this.a();
        if (this.cacheLen > 0) {
            return this.cacheLen - this.cachePos;
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        super.close();
        this.isClosed = true;
    }

    boolean a(YasConnection yasConnection) {
        return yasConnection.equals(this.largeObject.getConnection());
    }
}

