/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.Session;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.YasBlob;
import com.yashandb.jdbc.YasClob;
import com.yashandb.jdbc.YasLargeObject;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.ByteConverter;
import com.yashandb.util.CharacterSet;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;

public class YasLobProcessor {
    private long lobLength = 0L;
    private long lobCharLength = 0L;
    private long startPos = 0L;
    private long endPos = 0L;
    private int chunkSize = 0;
    private static final int STEP_COUNT = 4;
    private byte[] stepBuffer = null;
    private byte[] lobLocator = null;
    private byte[] cacheData = null;
    private Session session = null;
    private int innerLobType = -1;
    private YasLargeObject yasLob = null;
    public static final int LOB_LOCATOR_KNL = 0;
    public static final int LOB_LOCATOR_TEMP = 1;
    public static final int LOB_LOCATOR_MEM = 2;
    public static final int LOB_LOCATOR_KNL_IN_ROW = 3;
    public static final int LOB_LOCATOR_TEMP_IN_ROW = 4;
    private static final int LOB_WRITE_APPEND_DATA_FLAG = -1;
    private static final int LOB_LOCATOR_LOB_SIZE_POS = 72;
    private int lobType = 0;
    private boolean updated = false;
    private final TreeMap charToBytePosCache = new TreeMap();

    protected boolean needFree() {
        return this.innerLobType != 0 && this.innerLobType != 3 && this.innerLobType != 4;
    }

    public int getInnerLobType() {
        return this.innerLobType;
    }

    public void setInnerLobType(int n) {
        this.innerLobType = n;
    }

    public long getLobLength() {
        return this.lobLength;
    }

    long a() throws SQLException {
        int n;
        if (this.lobLength == 0L) {
            return 0L;
        }
        if (this.lobCharLength > 0L) {
            return this.lobCharLength;
        }
        if (this.session.getConnectVersion().getValue() >= ConnectVersion.VER5.getValue()) {
            if (this.innerLobType == 3 || this.innerLobType == 4) {
                String string = new String(this.cacheData, 0, (int)this.endPos, CharacterSet.getCharSet(this.f()));
                this.lobCharLength = string.length();
                return this.lobCharLength;
            }
            return this.b();
        }
        this.lobCharLength = 0L;
        byte[] byArray = this.d();
        long l = this.lobLength;
        long l2 = 0L;
        while (l > 0L && (n = this.getBytes(l2, byArray)) > 0) {
            String string = new String(byArray, 0, n, CharacterSet.getCharSet(this.f()));
            this.lobCharLength += (long)string.length();
            l -= (long)n;
            l2 += (long)n;
        }
        return this.lobCharLength;
    }

    long b() throws SQLException {
        this.lobCharLength = this.session.getLobCharLength(this);
        if (this.lobType == 33) {
            this.lobCharLength /= 2L;
        }
        return this.lobCharLength;
    }

    public int getStepSize() {
        if (this.chunkSize <= 0) {
            return 0;
        }
        return this.chunkSize * 4;
    }

    private void c() {
        if (this.cacheData == null || this.cacheData.length < this.getStepSize()) {
            this.cacheData = new byte[this.getStepSize()];
        }
    }

    public int getBytes(long l, byte[] byArray) throws SQLException {
        if (byArray == null) {
            return 0;
        }
        if (l >= this.startPos && l < this.endPos) {
            int n = (int)(l - this.startPos);
            int n2 = Math.min(byArray.length, (int)(this.endPos - l));
            System.arraycopy(this.cacheData, n, byArray, 0, n2);
            return n2;
        }
        if (l < this.lobLength) {
            this.c();
            int n = this.getStepSize();
            if ((long)n > this.lobLength - l) {
                n = (int)(this.lobLength - l);
            }
            int n3 = this.session.getLobData(this, n, l, this.cacheData);
            this.startPos = l;
            this.endPos = l + (long)n3;
            int n4 = Math.min(n3, byArray.length);
            System.arraycopy(this.cacheData, 0, byArray, 0, n4);
            return n4;
        }
        return 0;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void initCacheBuffer(int n) {
        this.cacheData = new byte[n];
    }

    public void setEndPos(long l) {
        this.endPos = l;
    }

    public void setCacheData(byte[] byArray, int n, int n2) {
        if (this.cacheData == null || this.cacheData.length < n2) {
            this.cacheData = new byte[n2];
        }
        System.arraycopy(byArray, n, this.cacheData, 0, n2);
    }

    public void setLobLocator(byte[] byArray) {
        this.lobLocator = byArray;
    }

    public byte[] getLobLocator() {
        if (this.lobLocator == null) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.lobLocator.length];
        System.arraycopy(this.lobLocator, 0, byArray, 0, this.lobLocator.length);
        return byArray;
    }

    public void setLobLength(long l) {
        this.lobLength = l;
    }

    public void setChunkSize(int n) {
        this.chunkSize = n;
    }

    private byte[] d() {
        if (this.stepBuffer != null) {
            return this.stepBuffer;
        }
        int n = this.getStepSize();
        this.stepBuffer = this.getStepSize() > 0 ? new byte[n] : new byte[(int)this.lobLength];
        return this.stepBuffer;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        int n2;
        if (l < 1L || n < 0) {
            throw SQLError.createSQLException("invalid parameter", YasState.DATA_ERROR);
        }
        long l2 = l - 1L;
        if (n == 0 || this.lobLength == 0L || l2 >= this.lobLength) {
            return new byte[0];
        }
        int n3 = (int)Math.min((long)n, this.lobLength);
        if (l2 + (long)n3 > this.lobLength) {
            n3 = (int)(this.lobLength - l2);
        }
        if (n3 <= 0) {
            return new byte[0];
        }
        this.e();
        byte[] byArray = this.d();
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        while (n3 > 0 && (n2 = this.getBytes(l2, byArray)) > 0) {
            if (n2 > n3) {
                n2 = n3;
            }
            System.arraycopy(byArray, 0, byArray2, n4, n2);
            l2 += (long)n2;
            n4 += n2;
            n3 -= n2;
        }
        return byArray2;
    }

    private void e() {
        if (this.lobLocator != null && this.startPos != 0L) {
            this.startPos = 0L;
            this.endPos = 0L;
        }
    }

    public String getSubString(long l, int n) throws SQLException {
        StringBuilder stringBuilder = this.getSubStringBuilder(l, n);
        return stringBuilder.length() > n ? stringBuilder.substring(0, n) : stringBuilder.toString();
    }

    public String getSubStringInternal(long l, int n) throws SQLException {
        return this.getSubStringBuilder(l, n).toString();
    }

    public StringBuilder getSubStringBuilder(long l, int n) throws SQLException {
        Map.Entry entry;
        if (l < 1L || n < 0) {
            throw SQLError.createSQLException("invalid parameter", YasState.DATA_ERROR);
        }
        if (this.lobLength > 0L && this.lobCharLength <= 0L) {
            this.a();
        }
        long l2 = l - 1L;
        if (n == 0 || this.lobCharLength == 0L || l2 >= this.lobCharLength) {
            return new StringBuilder("");
        }
        int n2 = (int)Math.min((long)n, this.lobCharLength);
        if (l2 + (long)n2 > this.lobCharLength) {
            n2 = (int)(this.lobCharLength - l2);
        }
        if (n2 <= 0) {
            return new StringBuilder("");
        }
        this.e();
        int n3 = this.getStepSize();
        byte[] byArray = this.getStepSize() > 0 ? new byte[n3] : new byte[(int)this.lobLength];
        long l3 = 0L;
        long l4 = 0L;
        if (this.charToBytePosCache.size() > 0 && (entry = this.charToBytePosCache.floorEntry(l2)) != null) {
            l4 = entry.getKey();
            l3 = (Long)entry.getValue();
        }
        return this.a(n, l2, byArray, l3, l4);
    }

    private StringBuilder a(int n, long l, byte[] byArray, long l2, long l3) throws SQLException {
        int n2;
        long l4 = l - l3;
        StringBuilder stringBuilder = new StringBuilder();
        while (stringBuilder.length() < n && (n2 = this.getBytes(l2, byArray)) != 0) {
            l2 += (long)n2;
            String string = new String(byArray, 0, n2, CharacterSet.getCharSet(this.f()));
            if (!this.charToBytePosCache.containsKey(l3 += (long)string.length())) {
                this.charToBytePosCache.put(l3, l2);
            }
            if (l4 <= 0L) {
                stringBuilder.append(string);
                continue;
            }
            if ((long)string.length() > l4) {
                stringBuilder.append(string.substring((int)l4));
                l4 = 0L;
                continue;
            }
            l4 -= (long)string.length();
        }
        return stringBuilder;
    }

    public int setString(long l, String string) throws SQLException {
        int n = string.length();
        if (n > 40000 && this.h()) {
            return this.b(l, string);
        }
        if (n > 40000 && (this.innerLobType == 0 || this.innerLobType == 3)) {
            return this.a(l, string);
        }
        long l2 = l;
        for (int i = 0; i < n; i += 40000) {
            String string2 = n > i + 40000 ? string.substring(i, i + 40000) : string.substring(i);
            byte[] byArray = string2.getBytes(CharacterSet.getCharSet(this.f()));
            long l3 = l2 - 1L;
            this.lobLength = this.session.writeLob(this, l3, byArray, 0, byArray.length);
            l2 += 40000L;
        }
        this.c(l, string);
        if (this.g()) {
            this.session.addUpdatedKnlLob(this.yasLob);
        }
        return n;
    }

    public int appendString(String string) throws SQLException {
        int n = string.length();
        if (n > 40000 && this.h()) {
            return this.a(string);
        }
        for (int i = 0; i < n; i += 40000) {
            String string2 = n > i + 40000 ? string.substring(i, i + 40000) : string.substring(i);
            byte[] byArray = string2.getBytes(CharacterSet.getCharSet(this.f()));
            this.lobLength = this.session.writeLob(this, -1L, byArray, 0, byArray.length);
        }
        this.innerLobType = this.lobLocator[0] & 0xFF;
        if (this.chunkSize <= 0) {
            this.chunkSize = this.session.getLobChunkSize(this);
        }
        this.lobCharLength += (long)string.length();
        this.setUpdated(true);
        if (this.g()) {
            this.session.addUpdatedKnlLob(this.yasLob);
        }
        return n;
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (n2 > 320000 && this.h()) {
            return this.b(l, byArray, n, n2);
        }
        if (n2 > 320000 && (this.innerLobType == 0 || this.innerLobType == 3)) {
            return this.a(l, byArray, n, n2);
        }
        long l2 = l - 1L;
        this.lobLength = this.session.writeLob(this, l2, byArray, n, n2);
        this.a(l);
        if (this.g()) {
            this.session.addUpdatedKnlLob(this.yasLob);
        }
        return n2;
    }

    public void free() throws SQLException {
        this.session.closeLob(this);
    }

    public void truncate(long l) throws SQLException {
        if (l < 0L || l > this.lobLength) {
            throw SQLError.createSQLException("invalid parameter", YasState.DATA_ERROR);
        }
        this.lobLength = this.session.trimLob(this, l);
        if (this.chunkSize <= 0) {
            this.chunkSize = this.session.getLobChunkSize(this);
        }
        if (this.startPos > this.lobLength) {
            this.e();
        } else if (this.endPos > this.lobLength) {
            this.endPos = this.lobLength;
        }
        if (this.lobCharLength != 0L) {
            this.lobCharLength = l;
        }
        this.setUpdated(true);
        if (this.g()) {
            this.session.addUpdatedKnlLob(this.yasLob);
        }
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean bl) {
        this.updated = bl;
        if (bl) {
            this.charToBytePosCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int a(long l, String string) throws SQLException {
        int n = string.length();
        YasClob yasClob = (YasClob)this.session.getConnection().createClob();
        try {
            yasClob.setString(1L, string);
            byte[] byArray = yasClob.getLobLocator();
            long l2 = l - 1L;
            this.lobLength = this.session.writeLobByLobLocator(this, l2, byArray);
            this.c(l, string);
            if (this.g()) {
                this.session.addUpdatedKnlLob(this.yasLob);
            }
            int n2 = n;
            return n2;
        }
        finally {
            yasClob.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int a(long l, byte[] byArray, int n, int n2) throws SQLException {
        YasBlob yasBlob = (YasBlob)this.session.getConnection().createBlob();
        try {
            yasBlob.setBytes(1L, byArray, n, n2);
            byte[] byArray2 = yasBlob.getLobLocator();
            long l2 = l - 1L;
            this.lobLength = this.session.writeLobByLobLocator(this, l2, byArray2);
            this.a(l);
            if (this.g()) {
                this.session.addUpdatedKnlLob(this.yasLob);
            }
            int n3 = n2;
            return n3;
        }
        finally {
            yasBlob.free();
        }
    }

    public int getLobType() {
        return this.lobType;
    }

    public void setLobType(int n) {
        this.lobType = n;
    }

    public int getCsLobLocatorSize() {
        if (this.lobLocator != null) {
            return this.lobLocator.length;
        }
        if (this.session.getConnectVersion() == ConnectVersion.VER1) {
            return 72;
        }
        return 80;
    }

    private short f() {
        if (this.getLobType() == 33) {
            return this.session.getNCharset();
        }
        return this.session.getCharset();
    }

    public void setYasLob(YasLargeObject yasLargeObject) {
        this.yasLob = yasLargeObject;
    }

    private boolean g() {
        return this.innerLobType == 0 || this.innerLobType == 3;
    }

    public void initLobLength() throws SQLException {
        if (this.session.getConnectVersion().getValue() > ConnectVersion.VER1.getValue()) {
            this.lobLength = ByteConverter.int8(this.lobLocator, 72);
            return;
        }
        this.lobLength = this.session.getLobLength(this);
    }

    private boolean h() {
        return this.session.getConnectVersion().getValue() >= ConnectVersion.VER5.getValue();
    }

    private int b(long l, String string) throws SQLException {
        int n = string.length();
        StringReader stringReader = new StringReader(string);
        long l2 = l - 1L;
        int n2 = string.getBytes(CharacterSet.getCharSet(this.session.getCharset())).length;
        this.lobLength = this.session.writeLobByStream(this, l2, stringReader, n2);
        this.c(l, string);
        if (this.g()) {
            this.session.addUpdatedKnlLob(this.yasLob);
        }
        return n;
    }

    private void c(long l, String string) throws SQLException {
        this.innerLobType = this.lobLocator[0] & 0xFF;
        if (this.chunkSize <= 0) {
            this.chunkSize = this.session.getLobChunkSize(this);
        }
        this.startPos = 0L;
        this.endPos = 0L;
        this.lobCharLength = Math.max(l + (long)string.length() - 1L, this.lobCharLength);
        this.setUpdated(true);
    }

    private int b(long l, byte[] byArray, int n, int n2) throws SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        long l2 = l - 1L;
        this.lobLength = this.session.writeLobByStream(this, l2, byteArrayInputStream, n2);
        this.a(l);
        if (this.g()) {
            this.session.addUpdatedKnlLob(this.yasLob);
        }
        return n2;
    }

    private void a(long l) throws SQLException {
        long l2 = l - 1L;
        this.innerLobType = this.lobLocator[0] & 0xFF;
        if (this.chunkSize <= 0) {
            this.chunkSize = this.session.getLobChunkSize(this);
        }
        if (this.startPos > l2) {
            this.e();
        } else if (this.endPos > l2) {
            this.endPos = l2;
        }
        this.setUpdated(true);
    }

    protected void freeCharToBytePosCache() {
        this.charToBytePosCache.clear();
    }

    private int a(String string) throws SQLException {
        int n = string.length();
        StringReader stringReader = new StringReader(string);
        int n2 = string.getBytes(CharacterSet.getCharSet(this.session.getCharset())).length;
        this.lobLength = this.session.writeLobByStream(this, -1L, stringReader, n2);
        this.innerLobType = this.lobLocator[0] & 0xFF;
        if (this.chunkSize <= 0) {
            this.chunkSize = this.session.getLobChunkSize(this);
        }
        this.lobCharLength += (long)string.length();
        this.setUpdated(true);
        if (this.g()) {
            this.session.addUpdatedKnlLob(this.yasLob);
        }
        return n;
    }
}

