/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.Messages;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class YasParameterMetaData
implements ParameterMetaData {
    private final Field[] fields;
    private boolean throwUnsupportedFeature = true;

    public YasParameterMetaData(Field[] fieldArray) {
        this.fields = fieldArray;
    }

    public void setThrowUnsupported(boolean bl) {
        this.throwUnsupportedFeature = bl;
    }

    @Override
    public String getParameterClassName(int n) throws SQLException {
        this.a(n);
        return "";
    }

    @Override
    public int getParameterCount() {
        if (this.fields == null) {
            return 0;
        }
        return this.fields.length;
    }

    @Override
    public int getParameterType(int n) throws SQLException {
        this.a(n);
        Field field = this.b(n);
        return field.getYasType();
    }

    @Override
    public String getParameterTypeName(int n) throws SQLException {
        this.a(n);
        Field field = this.b(n);
        return field.getTypeName();
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        this.a(n);
        Field field = this.b(n);
        return field.getPrecision();
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.a(n);
        Field field = this.b(n);
        return field.getScale();
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.a(n);
        return 2;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        this.a(n);
        return false;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass());
    }

    private void a(int n) throws SQLException {
        if (this.throwUnsupportedFeature) {
            throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "checkParamIndex");
        }
        if (this.fields == null) {
            throw SQLError.createSQLException("The parameter count is 0", YasState.DATA_ERROR);
        }
        if (n < 1 || n > this.fields.length) {
            throw SQLError.createSQLException(Messages.get("The parameter index is out of range: {0}, number of parameters: {1}.", n, this.fields.length), YasState.INVALID_PARAMETER_VALUE);
        }
    }

    public Object unwrap(Class clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw SQLError.createSQLException("Can not unwrap to " + clazz.getName(), YasState.UNKNOWN_STATE);
    }

    private Field b(int n) throws SQLException {
        this.a(n);
        return this.fields[n - 1];
    }

    @Override
    public int getParameterMode(int n) throws SQLException {
        this.a(n);
        return 1;
    }
}

