/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.ByteConverter;
import java.math.BigInteger;
import java.sql.RowId;
import java.sql.SQLException;
import java.util.Objects;

public class YasRowID
implements RowId {
    private byte[] data;
    private String strValue;
    private static final int ROW_ID_LEN = 16;
    private static final int ROWID_MAX_SPACE = 2048;
    private static final int ROWID_MAX_FILEID = 64;
    private static final int ROWID_MAX_BLOCKID = 0x4000000;
    private static final int ROWID_MAX_DIR = 4096;
    private static final int ROWID_STRING_SEGMENT = 5;

    public YasRowID(byte[] byArray) throws SQLException {
        if (byArray.length != 16) {
            throw SQLError.createSQLException("rowid data size should be 16 bytes", YasState.DATA_ERROR);
        }
        this.data = new byte[16];
        System.arraycopy(byArray, 0, this.data, 0, 16);
        this.a();
    }

    public YasRowID(byte[] byArray, int n, int n2) throws SQLException {
        if (n2 != 16) {
            throw SQLError.createSQLException("rowid data size should be 16 bytes", YasState.DATA_ERROR);
        }
        this.data = new byte[16];
        System.arraycopy(byArray, n, this.data, 0, 16);
        this.a();
    }

    public YasRowID(String string) throws SQLException {
        if (string == null) {
            throw SQLError.createSQLException("The parameter can not be empty", YasState.INVALID_PARAMETER_VALUE);
        }
        this.strValue = string;
        this.data = new byte[16];
        this.b();
    }

    private void a() {
        String string;
        if ((long)this.data[7] < 0L) {
            byte[] byArray = new byte[8];
            System.arraycopy(this.data, 0, byArray, 0, 8);
            BigInteger bigInteger = new BigInteger(1, byArray);
            string = bigInteger.toString();
        } else {
            long l = ((long)this.data[7] & 0xFFL) << 56 | ((long)this.data[6] & 0xFFL) << 48 | ((long)this.data[5] & 0xFFL) << 40 | ((long)this.data[4] & 0xFFL) << 32 | ((long)this.data[3] & 0xFFL) << 24 | ((long)this.data[2] & 0xFFL) << 16 | ((long)this.data[1] & 0xFFL) << 8 | (long)this.data[0] & 0xFFL;
            string = String.valueOf(l);
        }
        int n = this.data[8] & 0x3F;
        int n2 = (this.data[11] & 0xFF) << 18 | (this.data[10] & 0xFF) << 10 | (this.data[9] & 0xFF) << 2 | (this.data[8] & 0xC0) >> 6;
        int n3 = (this.data[13] & 0xFF) << 8 | this.data[12] & 0xFF;
        int n4 = (this.data[15] & 0xFF) << 8 | this.data[14] & 0xFF;
        this.strValue = String.format("%s:%d:%d:%d:%d", string, n4, n, n2, n3);
    }

    private void b() throws SQLException {
        String[] stringArray = this.strValue.split(":");
        if (stringArray.length == 5) {
            int n;
            int n2;
            int n3;
            int n4;
            long l;
            try {
                l = new BigInteger(stringArray[0]).longValue();
                n4 = Integer.parseInt(stringArray[1]);
                n3 = Integer.parseInt(stringArray[2]);
                n2 = Integer.parseInt(stringArray[3]);
                n = Integer.parseInt(stringArray[4]);
            }
            catch (NumberFormatException numberFormatException) {
                throw SQLError.createSQLException("invalid ROWID string", YasState.INVALID_PARAMETER_VALUE);
            }
            if (n4 >= 2048 || n3 >= 64 || n2 >= 0x4000000 || n >= 4096) {
                throw SQLError.createSQLException("invalid ROWID string", YasState.INVALID_PARAMETER_VALUE);
            }
            ByteConverter.int8(this.data, 0, l);
            this.data[8] = (byte)(n3 | n2 << 6);
            this.data[9] = (byte)(n2 >>> 2);
            this.data[10] = (byte)(n2 >>> 10);
            this.data[11] = (byte)(n2 >>> 18);
            ByteConverter.int2(this.data, 12, n);
            ByteConverter.int2(this.data, 14, n4);
            return;
        }
        throw SQLError.createSQLException("invalid ROWID string", YasState.INVALID_PARAMETER_VALUE);
    }

    @Override
    public byte[] getBytes() {
        return this.strValue.getBytes();
    }

    @Override
    public String toString() {
        return this.strValue;
    }

    public byte[] getRowIdBytes() {
        byte[] byArray = new byte[16];
        System.arraycopy(this.data, 0, byArray, 0, 16);
        return byArray;
    }

    @Override
    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.strValue.equals(object.toString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.strValue);
    }
}

