/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

public class YasSQLXML
implements SQLXML {
    private XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private String stringRep;
    private boolean isClosed = false;

    public YasSQLXML(String string) {
        this.stringRep = string;
    }

    public YasSQLXML() {
    }

    @Override
    public synchronized void free() throws SQLException {
        this.stringRep = null;
        this.inputFactory = null;
        this.isClosed = true;
    }

    @Override
    public synchronized String getString() throws SQLException {
        this.a();
        return this.stringRep;
    }

    private synchronized void a() throws SQLException {
        if (this.isClosed) {
            throw SQLError.createSQLException("the xml has been freed", YasState.DATA_ERROR);
        }
    }

    @Override
    public synchronized void setString(String string) throws SQLException {
        this.a();
        this.stringRep = string;
    }

    public synchronized boolean isEmpty() throws SQLException {
        this.a();
        return this.stringRep == null || this.stringRep.length() == 0;
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        this.a();
        return new ByteArrayInputStream(this.stringRep.getBytes());
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        this.a();
        return new StringReader(this.stringRep);
    }

    public Source getSource(Class clazz) throws SQLException {
        try {
            this.a();
            if (clazz != null && !clazz.equals(SAXSource.class)) {
                if (clazz.equals(DOMSource.class)) {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    InputSource inputSource = new InputSource(this.getCharacterStream());
                    return new DOMSource(documentBuilder.parse(inputSource));
                }
                if (clazz.equals(StreamSource.class)) {
                    return new StreamSource(this.getCharacterStream());
                }
                if (clazz.equals(StAXSource.class)) {
                    return new StAXSource(this.inputFactory.createXMLStreamReader(this.getCharacterStream()));
                }
                throw SQLError.createSQLException("Unsupported XML type", YasState.DATA_ERROR);
            }
            return new SAXSource(new InputSource(this.getCharacterStream()));
        }
        catch (Exception exception) {
            throw SQLError.createSQLException(exception.getMessage(), YasState.DATA_ERROR);
        }
    }

    @Override
    public synchronized OutputStream setBinaryStream() throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setBinaryStream");
    }

    @Override
    public synchronized Writer setCharacterStream() throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setCharacterStream");
    }

    public synchronized Result setResult(Class clazz) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException(this.getClass(), "setResult");
    }
}

