/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import java.sql.SQLException;
import java.sql.Savepoint;

public class YasSavepoint
implements Savepoint {
    private SavePointType pointType;
    private int pointId;
    private String pointName;
    private static final int INVALID_ID = -1;
    private static final int MAX_ID = -268435457;
    private static int seedId = 0;

    public YasSavepoint() {
        this.pointType = SavePointType.ID_TYPE;
        this.pointId = this.a();
        this.pointName = null;
    }

    public YasSavepoint(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.isEmpty()) {
            this.pointType = SavePointType.ID_TYPE;
            this.pointId = this.a();
            this.pointName = null;
        } else {
            this.pointType = SavePointType.NAMED_TYPE;
            this.pointName = string;
            this.pointId = -1;
        }
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.pointType == SavePointType.NAMED_TYPE) {
            throw SQLError.createSQLException("wrong savepoint type", YasState.UNEXPECTED_ERROR);
        }
        return this.pointId;
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.pointType == SavePointType.ID_TYPE) {
            throw SQLError.createSQLException("wrong savepoint type", YasState.UNEXPECTED_ERROR);
        }
        return this.pointName;
    }

    private synchronized int a() {
        seedId = (seedId + 1) % -268435457;
        return seedId;
    }

    public String getTypeInsensitiveName() {
        if (this.pointType == SavePointType.ID_TYPE) {
            return "yas_autosvpt_" + this.pointId;
        }
        return this.pointName;
    }

    static enum SavePointType {
        UNKNOWN_TYPE,
        ID_TYPE,
        NAMED_TYPE;

    }
}

