/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.jdbc.exception;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLExceptionType;
import com.yashandb.jdbc.exception.ServerErrorMessage;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.util.Messages;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class SQLError {
    public static final String MSG_STREAM_CLOSED = "stream closed";
    public static final String MSG_CHARACTER_OF_CLOB_CAN_NOT_READ = " character of CLOB data can not be read";
    public static final String MSG_INVALID_ARGS_IN_CALL = "Invalid argument(s) in call.";
    public static final String MSG_INVALID_PARAM = "invalid parameter";
    public static final String MSG_INVALID_ROW_ID_STR = "invalid ROWID string";

    private SQLError() {
    }

    public static YasException createSQLException(String string, YasState yasState) {
        return new YasException(string, yasState);
    }

    public static YasException createSQLException(String string, YasState yasState, Throwable throwable) {
        return new YasException(string, yasState, throwable);
    }

    public static SQLException createSQLException(ServerErrorMessage serverErrorMessage, boolean bl) {
        return SQLError.createSQLException(serverErrorMessage, bl, null);
    }

    public static SQLException createSQLException(ServerErrorMessage serverErrorMessage, boolean bl, Throwable throwable) {
        SQLException sQLException;
        SQLExceptionType sQLExceptionType = SQLExceptionType.findServerSQLExceptionType(serverErrorMessage);
        SQLException sQLException2 = sQLException = sQLExceptionType != null ? sQLExceptionType.newSQLException(serverErrorMessage.toString(), serverErrorMessage.getErrCode()) : new YasException(serverErrorMessage, bl);
        if (throwable != null) {
            sQLException.initCause(throwable);
        }
        return sQLException;
    }

    public static SQLException createSQLFeatureNotSupportedException(Class clazz, String string) {
        return new SQLFeatureNotSupportedException(Messages.get("Method {0} is not yet implemented.", clazz.getName() + "." + string), YasState.NOT_IMPLEMENTED.getState());
    }

    public static YasException overFlowException(String string, String string2) {
        return SQLError.createSQLException(Messages.get("Convert an instance of {0} to type {1} OverFlow", string.toUpperCase(), string2.toUpperCase()), YasState.DATA_ERROR);
    }

    public static YasException transformException(String string, String string2) {
        return SQLError.transformException(string, string2, null);
    }

    public static YasException transformException(String string, String string2, Exception exception) {
        return SQLError.createSQLException(Messages.get("Cannot convert an instance of {0} to type {1}", string.toUpperCase(), string2.toUpperCase()), YasState.INVALID_PARAMETER_TYPE, (Throwable)exception);
    }

    public static YasException convertValueException(String string, String string2, String string3) {
        return SQLError.convertValueException(string, string2, string3, null);
    }

    public static YasException convertValueException(String string, String string2, String string3, Exception exception) {
        return SQLError.createSQLException(Messages.get("Cannot convert {0} value \"{1}\" to type {2}", string.toUpperCase(), string2, string3.toUpperCase()), YasState.INVALID_PARAMETER_TYPE, (Throwable)exception);
    }

    public static YasException streamingResultFetchingException() {
        return SQLError.createSQLException("Streaming result set has not been fetched to end, no more cmd requests are allowed on the current connection. Please close the streaming result set.", YasState.PROTOCOL_VIOLATION);
    }
}

